/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCallerAccessGrantsRequest extends S3ControlRequest implements
        ToCopyableBuilder<ListCallerAccessGrantsRequest.Builder, ListCallerAccessGrantsRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountId")
            .getter(getter(ListCallerAccessGrantsRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id")
                    .unmarshallLocationName("x-amz-account-id").build()).build();

    private static final SdkField<String> GRANT_SCOPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GrantScope")
            .getter(getter(ListCallerAccessGrantsRequest::grantScope))
            .setter(setter(Builder::grantScope))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("grantscope")
                    .unmarshallLocationName("grantscope").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(ListCallerAccessGrantsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(ListCallerAccessGrantsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults")
                    .unmarshallLocationName("maxResults").build()).build();

    private static final SdkField<Boolean> ALLOWED_BY_APPLICATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowedByApplication")
            .getter(getter(ListCallerAccessGrantsRequest::allowedByApplication))
            .setter(setter(Builder::allowedByApplication))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("allowedByApplication")
                    .unmarshallLocationName("allowedByApplication").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            GRANT_SCOPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, ALLOWED_BY_APPLICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountId;

    private final String grantScope;

    private final String nextToken;

    private final Integer maxResults;

    private final Boolean allowedByApplication;

    private ListCallerAccessGrantsRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.grantScope = builder.grantScope;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.allowedByApplication = builder.allowedByApplication;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the S3 Access Grants instance.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the S3 Access Grants instance.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The S3 path of the data that you would like to access. Must start with <code>s3://</code>. You can optionally
     * pass only the beginning characters of a path, and S3 Access Grants will search for all applicable grants for the
     * path fragment.
     * </p>
     * 
     * @return The S3 path of the data that you would like to access. Must start with <code>s3://</code>. You can
     *         optionally pass only the beginning characters of a path, and S3 Access Grants will search for all
     *         applicable grants for the path fragment.
     */
    public final String grantScope() {
        return grantScope;
    }

    /**
     * <p>
     * A pagination token to request the next page of results. Pass this value into a subsequent
     * <code>List Caller Access Grants</code> request in order to retrieve the next page of results.
     * </p>
     * 
     * @return A pagination token to request the next page of results. Pass this value into a subsequent
     *         <code>List Caller Access Grants</code> request in order to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of access grants that you would like returned in the <code>List Caller Access Grants</code>
     * response. If the results include the pagination token <code>NextToken</code>, make another call using the
     * <code>NextToken</code> to determine if there are more results.
     * </p>
     * 
     * @return The maximum number of access grants that you would like returned in the
     *         <code>List Caller Access Grants</code> response. If the results include the pagination token
     *         <code>NextToken</code>, make another call using the <code>NextToken</code> to determine if there are more
     *         results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If this optional parameter is passed in the request, a filter is applied to the results. The results will include
     * only the access grants for the caller's Identity Center application or for any other applications (
     * <code>ALL</code>).
     * </p>
     * 
     * @return If this optional parameter is passed in the request, a filter is applied to the results. The results will
     *         include only the access grants for the caller's Identity Center application or for any other applications
     *         (<code>ALL</code>).
     */
    public final Boolean allowedByApplication() {
        return allowedByApplication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(grantScope());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(allowedByApplication());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCallerAccessGrantsRequest)) {
            return false;
        }
        ListCallerAccessGrantsRequest other = (ListCallerAccessGrantsRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(grantScope(), other.grantScope())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(allowedByApplication(), other.allowedByApplication());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCallerAccessGrantsRequest").add("AccountId", accountId()).add("GrantScope", grantScope())
                .add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("AllowedByApplication", allowedByApplication()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "GrantScope":
            return Optional.ofNullable(clazz.cast(grantScope()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "AllowedByApplication":
            return Optional.ofNullable(clazz.cast(allowedByApplication()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("x-amz-account-id", ACCOUNT_ID_FIELD);
        map.put("grantscope", GRANT_SCOPE_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("allowedByApplication", ALLOWED_BY_APPLICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCallerAccessGrantsRequest, T> g) {
        return obj -> g.apply((ListCallerAccessGrantsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListCallerAccessGrantsRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID of the S3 Access Grants instance.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID of the S3 Access Grants instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The S3 path of the data that you would like to access. Must start with <code>s3://</code>. You can optionally
         * pass only the beginning characters of a path, and S3 Access Grants will search for all applicable grants for
         * the path fragment.
         * </p>
         * 
         * @param grantScope
         *        The S3 path of the data that you would like to access. Must start with <code>s3://</code>. You can
         *        optionally pass only the beginning characters of a path, and S3 Access Grants will search for all
         *        applicable grants for the path fragment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantScope(String grantScope);

        /**
         * <p>
         * A pagination token to request the next page of results. Pass this value into a subsequent
         * <code>List Caller Access Grants</code> request in order to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A pagination token to request the next page of results. Pass this value into a subsequent
         *        <code>List Caller Access Grants</code> request in order to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of access grants that you would like returned in the
         * <code>List Caller Access Grants</code> response. If the results include the pagination token
         * <code>NextToken</code>, make another call using the <code>NextToken</code> to determine if there are more
         * results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of access grants that you would like returned in the
         *        <code>List Caller Access Grants</code> response. If the results include the pagination token
         *        <code>NextToken</code>, make another call using the <code>NextToken</code> to determine if there are
         *        more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If this optional parameter is passed in the request, a filter is applied to the results. The results will
         * include only the access grants for the caller's Identity Center application or for any other applications (
         * <code>ALL</code>).
         * </p>
         * 
         * @param allowedByApplication
         *        If this optional parameter is passed in the request, a filter is applied to the results. The results
         *        will include only the access grants for the caller's Identity Center application or for any other
         *        applications (<code>ALL</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedByApplication(Boolean allowedByApplication);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3ControlRequest.BuilderImpl implements Builder {
        private String accountId;

        private String grantScope;

        private String nextToken;

        private Integer maxResults;

        private Boolean allowedByApplication;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCallerAccessGrantsRequest model) {
            super(model);
            accountId(model.accountId);
            grantScope(model.grantScope);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            allowedByApplication(model.allowedByApplication);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getGrantScope() {
            return grantScope;
        }

        public final void setGrantScope(String grantScope) {
            this.grantScope = grantScope;
        }

        @Override
        public final Builder grantScope(String grantScope) {
            this.grantScope = grantScope;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Boolean getAllowedByApplication() {
            return allowedByApplication;
        }

        public final void setAllowedByApplication(Boolean allowedByApplication) {
            this.allowedByApplication = allowedByApplication;
        }

        @Override
        public final Builder allowedByApplication(Boolean allowedByApplication) {
            this.allowedByApplication = allowedByApplication;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCallerAccessGrantsRequest build() {
            return new ListCallerAccessGrantsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
