/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The alias of an Object Lambda Access Point. For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/olap-use.html#ol-access-points-alias">How to use a
 * bucket-style alias for your S3 bucket Object Lambda Access Point</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ObjectLambdaAccessPointAlias implements SdkPojo, Serializable,
        ToCopyableBuilder<ObjectLambdaAccessPointAlias.Builder, ObjectLambdaAccessPointAlias> {
    private static final SdkField<String> VALUE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Value")
            .getter(getter(ObjectLambdaAccessPointAlias::value))
            .setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value")
                    .unmarshallLocationName("Value").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(ObjectLambdaAccessPointAlias::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String value;

    private final String status;

    private ObjectLambdaAccessPointAlias(BuilderImpl builder) {
        this.value = builder.value;
        this.status = builder.status;
    }

    /**
     * <p>
     * The alias value of the Object Lambda Access Point.
     * </p>
     * 
     * @return The alias value of the Object Lambda Access Point.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The status of the Object Lambda Access Point alias. If the status is <code>PROVISIONING</code>, the Object Lambda
     * Access Point is provisioning the alias and the alias is not ready for use yet. If the status is
     * <code>READY</code>, the Object Lambda Access Point alias is successfully provisioned and ready for use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ObjectLambdaAccessPointAliasStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Object Lambda Access Point alias. If the status is <code>PROVISIONING</code>, the
     *         Object Lambda Access Point is provisioning the alias and the alias is not ready for use yet. If the
     *         status is <code>READY</code>, the Object Lambda Access Point alias is successfully provisioned and ready
     *         for use.
     * @see ObjectLambdaAccessPointAliasStatus
     */
    public final ObjectLambdaAccessPointAliasStatus status() {
        return ObjectLambdaAccessPointAliasStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Object Lambda Access Point alias. If the status is <code>PROVISIONING</code>, the Object Lambda
     * Access Point is provisioning the alias and the alias is not ready for use yet. If the status is
     * <code>READY</code>, the Object Lambda Access Point alias is successfully provisioned and ready for use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ObjectLambdaAccessPointAliasStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Object Lambda Access Point alias. If the status is <code>PROVISIONING</code>, the
     *         Object Lambda Access Point is provisioning the alias and the alias is not ready for use yet. If the
     *         status is <code>READY</code>, the Object Lambda Access Point alias is successfully provisioned and ready
     *         for use.
     * @see ObjectLambdaAccessPointAliasStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectLambdaAccessPointAlias)) {
            return false;
        }
        ObjectLambdaAccessPointAlias other = (ObjectLambdaAccessPointAlias) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ObjectLambdaAccessPointAlias").add("Value", value()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Value", VALUE_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ObjectLambdaAccessPointAlias, T> g) {
        return obj -> g.apply((ObjectLambdaAccessPointAlias) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ObjectLambdaAccessPointAlias> {
        /**
         * <p>
         * The alias value of the Object Lambda Access Point.
         * </p>
         * 
         * @param value
         *        The alias value of the Object Lambda Access Point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The status of the Object Lambda Access Point alias. If the status is <code>PROVISIONING</code>, the Object
         * Lambda Access Point is provisioning the alias and the alias is not ready for use yet. If the status is
         * <code>READY</code>, the Object Lambda Access Point alias is successfully provisioned and ready for use.
         * </p>
         * 
         * @param status
         *        The status of the Object Lambda Access Point alias. If the status is <code>PROVISIONING</code>, the
         *        Object Lambda Access Point is provisioning the alias and the alias is not ready for use yet. If the
         *        status is <code>READY</code>, the Object Lambda Access Point alias is successfully provisioned and
         *        ready for use.
         * @see ObjectLambdaAccessPointAliasStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectLambdaAccessPointAliasStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Object Lambda Access Point alias. If the status is <code>PROVISIONING</code>, the Object
         * Lambda Access Point is provisioning the alias and the alias is not ready for use yet. If the status is
         * <code>READY</code>, the Object Lambda Access Point alias is successfully provisioned and ready for use.
         * </p>
         * 
         * @param status
         *        The status of the Object Lambda Access Point alias. If the status is <code>PROVISIONING</code>, the
         *        Object Lambda Access Point is provisioning the alias and the alias is not ready for use yet. If the
         *        status is <code>READY</code>, the Object Lambda Access Point alias is successfully provisioned and
         *        ready for use.
         * @see ObjectLambdaAccessPointAliasStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectLambdaAccessPointAliasStatus
         */
        Builder status(ObjectLambdaAccessPointAliasStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String value;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectLambdaAccessPointAlias model) {
            value(model.value);
            status(model.status);
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ObjectLambdaAccessPointAliasStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ObjectLambdaAccessPointAlias build() {
            return new ObjectLambdaAccessPointAlias(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
