/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStorageLensConfigurationResponse extends S3ControlResponse implements
        ToCopyableBuilder<GetStorageLensConfigurationResponse.Builder, GetStorageLensConfigurationResponse> {
    private static final SdkField<StorageLensConfiguration> STORAGE_LENS_CONFIGURATION_FIELD = SdkField
            .<StorageLensConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("StorageLensConfiguration")
            .getter(getter(GetStorageLensConfigurationResponse::storageLensConfiguration))
            .setter(setter(Builder::storageLensConfiguration))
            .constructor(StorageLensConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLensConfiguration")
                    .unmarshallLocationName("StorageLensConfiguration").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(STORAGE_LENS_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final StorageLensConfiguration storageLensConfiguration;

    private GetStorageLensConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.storageLensConfiguration = builder.storageLensConfiguration;
    }

    /**
     * <p>
     * The S3 Storage Lens configuration requested.
     * </p>
     * 
     * @return The S3 Storage Lens configuration requested.
     */
    public final StorageLensConfiguration storageLensConfiguration() {
        return storageLensConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(storageLensConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStorageLensConfigurationResponse)) {
            return false;
        }
        GetStorageLensConfigurationResponse other = (GetStorageLensConfigurationResponse) obj;
        return Objects.equals(storageLensConfiguration(), other.storageLensConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetStorageLensConfigurationResponse")
                .add("StorageLensConfiguration", storageLensConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageLensConfiguration":
            return Optional.ofNullable(clazz.cast(storageLensConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StorageLensConfiguration", STORAGE_LENS_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetStorageLensConfigurationResponse, T> g) {
        return obj -> g.apply((GetStorageLensConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends S3ControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetStorageLensConfigurationResponse> {
        /**
         * <p>
         * The S3 Storage Lens configuration requested.
         * </p>
         * 
         * @param storageLensConfiguration
         *        The S3 Storage Lens configuration requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageLensConfiguration(StorageLensConfiguration storageLensConfiguration);

        /**
         * <p>
         * The S3 Storage Lens configuration requested.
         * </p>
         * This is a convenience method that creates an instance of the {@link StorageLensConfiguration.Builder}
         * avoiding the need to create one manually via {@link StorageLensConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageLensConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #storageLensConfiguration(StorageLensConfiguration)}.
         * 
         * @param storageLensConfiguration
         *        a consumer that will call methods on {@link StorageLensConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageLensConfiguration(StorageLensConfiguration)
         */
        default Builder storageLensConfiguration(Consumer<StorageLensConfiguration.Builder> storageLensConfiguration) {
            return storageLensConfiguration(StorageLensConfiguration.builder().applyMutation(storageLensConfiguration).build());
        }
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private StorageLensConfiguration storageLensConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStorageLensConfigurationResponse model) {
            super(model);
            storageLensConfiguration(model.storageLensConfiguration);
        }

        public final StorageLensConfiguration.Builder getStorageLensConfiguration() {
            return storageLensConfiguration != null ? storageLensConfiguration.toBuilder() : null;
        }

        public final void setStorageLensConfiguration(StorageLensConfiguration.BuilderImpl storageLensConfiguration) {
            this.storageLensConfiguration = storageLensConfiguration != null ? storageLensConfiguration.build() : null;
        }

        @Override
        public final Builder storageLensConfiguration(StorageLensConfiguration storageLensConfiguration) {
            this.storageLensConfiguration = storageLensConfiguration;
            return this;
        }

        @Override
        public GetStorageLensConfigurationResponse build() {
            return new GetStorageLensConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
