/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccessGrantsInstancesResponse extends S3ControlResponse implements
        ToCopyableBuilder<ListAccessGrantsInstancesResponse.Builder, ListAccessGrantsInstancesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(ListAccessGrantsInstancesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<List<ListAccessGrantsInstanceEntry>> ACCESS_GRANTS_INSTANCES_LIST_FIELD = SdkField
            .<List<ListAccessGrantsInstanceEntry>> builder(MarshallingType.LIST)
            .memberName("AccessGrantsInstancesList")
            .getter(getter(ListAccessGrantsInstancesResponse::accessGrantsInstancesList))
            .setter(setter(Builder::accessGrantsInstancesList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsInstancesList")
                    .unmarshallLocationName("AccessGrantsInstancesList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AccessGrantsInstance")
                            .memberFieldInfo(
                                    SdkField.<ListAccessGrantsInstanceEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListAccessGrantsInstanceEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AccessGrantsInstance")
                                                    .unmarshallLocationName("AccessGrantsInstance").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            ACCESS_GRANTS_INSTANCES_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ListAccessGrantsInstanceEntry> accessGrantsInstancesList;

    private ListAccessGrantsInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.accessGrantsInstancesList = builder.accessGrantsInstancesList;
    }

    /**
     * <p>
     * A pagination token to request the next page of results. Pass this value into a subsequent
     * <code>List Access Grants Instances</code> request in order to retrieve the next page of results.
     * </p>
     * 
     * @return A pagination token to request the next page of results. Pass this value into a subsequent
     *         <code>List Access Grants Instances</code> request in order to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccessGrantsInstancesList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAccessGrantsInstancesList() {
        return accessGrantsInstancesList != null && !(accessGrantsInstancesList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A container for a list of S3 Access Grants instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessGrantsInstancesList} method.
     * </p>
     * 
     * @return A container for a list of S3 Access Grants instances.
     */
    public final List<ListAccessGrantsInstanceEntry> accessGrantsInstancesList() {
        return accessGrantsInstancesList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessGrantsInstancesList() ? accessGrantsInstancesList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessGrantsInstancesResponse)) {
            return false;
        }
        ListAccessGrantsInstancesResponse other = (ListAccessGrantsInstancesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasAccessGrantsInstancesList() == other.hasAccessGrantsInstancesList()
                && Objects.equals(accessGrantsInstancesList(), other.accessGrantsInstancesList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAccessGrantsInstancesResponse").add("NextToken", nextToken())
                .add("AccessGrantsInstancesList", hasAccessGrantsInstancesList() ? accessGrantsInstancesList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "AccessGrantsInstancesList":
            return Optional.ofNullable(clazz.cast(accessGrantsInstancesList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("AccessGrantsInstancesList", ACCESS_GRANTS_INSTANCES_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAccessGrantsInstancesResponse, T> g) {
        return obj -> g.apply((ListAccessGrantsInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends S3ControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAccessGrantsInstancesResponse> {
        /**
         * <p>
         * A pagination token to request the next page of results. Pass this value into a subsequent
         * <code>List Access Grants Instances</code> request in order to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A pagination token to request the next page of results. Pass this value into a subsequent
         *        <code>List Access Grants Instances</code> request in order to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A container for a list of S3 Access Grants instances.
         * </p>
         * 
         * @param accessGrantsInstancesList
         *        A container for a list of S3 Access Grants instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessGrantsInstancesList(Collection<ListAccessGrantsInstanceEntry> accessGrantsInstancesList);

        /**
         * <p>
         * A container for a list of S3 Access Grants instances.
         * </p>
         * 
         * @param accessGrantsInstancesList
         *        A container for a list of S3 Access Grants instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessGrantsInstancesList(ListAccessGrantsInstanceEntry... accessGrantsInstancesList);

        /**
         * <p>
         * A container for a list of S3 Access Grants instances.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.s3control.model.ListAccessGrantsInstanceEntry.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.s3control.model.ListAccessGrantsInstanceEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.s3control.model.ListAccessGrantsInstanceEntry.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #accessGrantsInstancesList(List<ListAccessGrantsInstanceEntry>)}.
         * 
         * @param accessGrantsInstancesList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.s3control.model.ListAccessGrantsInstanceEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessGrantsInstancesList(java.util.Collection<ListAccessGrantsInstanceEntry>)
         */
        Builder accessGrantsInstancesList(Consumer<ListAccessGrantsInstanceEntry.Builder>... accessGrantsInstancesList);
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ListAccessGrantsInstanceEntry> accessGrantsInstancesList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessGrantsInstancesResponse model) {
            super(model);
            nextToken(model.nextToken);
            accessGrantsInstancesList(model.accessGrantsInstancesList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListAccessGrantsInstanceEntry.Builder> getAccessGrantsInstancesList() {
            List<ListAccessGrantsInstanceEntry.Builder> result = AccessGrantsInstancesListCopier
                    .copyToBuilder(this.accessGrantsInstancesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessGrantsInstancesList(
                Collection<ListAccessGrantsInstanceEntry.BuilderImpl> accessGrantsInstancesList) {
            this.accessGrantsInstancesList = AccessGrantsInstancesListCopier.copyFromBuilder(accessGrantsInstancesList);
        }

        @Override
        public final Builder accessGrantsInstancesList(Collection<ListAccessGrantsInstanceEntry> accessGrantsInstancesList) {
            this.accessGrantsInstancesList = AccessGrantsInstancesListCopier.copy(accessGrantsInstancesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessGrantsInstancesList(ListAccessGrantsInstanceEntry... accessGrantsInstancesList) {
            accessGrantsInstancesList(Arrays.asList(accessGrantsInstancesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessGrantsInstancesList(
                Consumer<ListAccessGrantsInstanceEntry.Builder>... accessGrantsInstancesList) {
            accessGrantsInstancesList(Stream.of(accessGrantsInstancesList)
                    .map(c -> ListAccessGrantsInstanceEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAccessGrantsInstancesResponse build() {
            return new ListAccessGrantsInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
