/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for information about the registered location.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccessGrantsLocationsEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<ListAccessGrantsLocationsEntry.Builder, ListAccessGrantsLocationsEntry> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(ListAccessGrantsLocationsEntry::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt")
                    .unmarshallLocationName("CreatedAt").build()).build();

    private static final SdkField<String> ACCESS_GRANTS_LOCATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccessGrantsLocationId")
            .getter(getter(ListAccessGrantsLocationsEntry::accessGrantsLocationId))
            .setter(setter(Builder::accessGrantsLocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsLocationId")
                    .unmarshallLocationName("AccessGrantsLocationId").build()).build();

    private static final SdkField<String> ACCESS_GRANTS_LOCATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccessGrantsLocationArn")
            .getter(getter(ListAccessGrantsLocationsEntry::accessGrantsLocationArn))
            .setter(setter(Builder::accessGrantsLocationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsLocationArn")
                    .unmarshallLocationName("AccessGrantsLocationArn").build()).build();

    private static final SdkField<String> LOCATION_SCOPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocationScope")
            .getter(getter(ListAccessGrantsLocationsEntry::locationScope))
            .setter(setter(Builder::locationScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationScope")
                    .unmarshallLocationName("LocationScope").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IAMRoleArn")
            .getter(getter(ListAccessGrantsLocationsEntry::iamRoleArn))
            .setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMRoleArn")
                    .unmarshallLocationName("IAMRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            ACCESS_GRANTS_LOCATION_ID_FIELD, ACCESS_GRANTS_LOCATION_ARN_FIELD, LOCATION_SCOPE_FIELD, IAM_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String accessGrantsLocationId;

    private final String accessGrantsLocationArn;

    private final String locationScope;

    private final String iamRoleArn;

    private ListAccessGrantsLocationsEntry(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.accessGrantsLocationId = builder.accessGrantsLocationId;
        this.accessGrantsLocationArn = builder.accessGrantsLocationArn;
        this.locationScope = builder.locationScope;
        this.iamRoleArn = builder.iamRoleArn;
    }

    /**
     * <p>
     * The date and time when you registered the location.
     * </p>
     * 
     * @return The date and time when you registered the location.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The ID of the registered location to which you are granting access. S3 Access Grants assigns this ID when you
     * register the location. S3 Access Grants assigns the ID <code>default</code> to the default location
     * <code>s3://</code> and assigns an auto-generated ID to other locations that you register.
     * </p>
     * 
     * @return The ID of the registered location to which you are granting access. S3 Access Grants assigns this ID when
     *         you register the location. S3 Access Grants assigns the ID <code>default</code> to the default location
     *         <code>s3://</code> and assigns an auto-generated ID to other locations that you register.
     */
    public final String accessGrantsLocationId() {
        return accessGrantsLocationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the registered location.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the registered location.
     */
    public final String accessGrantsLocationArn() {
        return accessGrantsLocationArn;
    }

    /**
     * <p>
     * The S3 path to the location that you are registering. The location scope can be the default S3 location
     * <code>s3://</code>, the S3 path to a bucket <code>s3://&lt;bucket&gt;</code>, or the S3 path to a bucket and
     * prefix <code>s3://&lt;bucket&gt;/&lt;prefix&gt;</code>. A prefix in S3 is a string of characters at the beginning
     * of an object key name used to organize the objects that you store in your S3 buckets. For example, object key
     * names that start with the <code>engineering/</code> prefix or object key names that start with the
     * <code>marketing/campaigns/</code> prefix.
     * </p>
     * 
     * @return The S3 path to the location that you are registering. The location scope can be the default S3 location
     *         <code>s3://</code>, the S3 path to a bucket <code>s3://&lt;bucket&gt;</code>, or the S3 path to a bucket
     *         and prefix <code>s3://&lt;bucket&gt;/&lt;prefix&gt;</code>. A prefix in S3 is a string of characters at
     *         the beginning of an object key name used to organize the objects that you store in your S3 buckets. For
     *         example, object key names that start with the <code>engineering/</code> prefix or object key names that
     *         start with the <code>marketing/campaigns/</code> prefix.
     */
    public final String locationScope() {
        return locationScope;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role for the registered location. S3 Access Grants assumes this role to
     * manage access to the registered location.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role for the registered location. S3 Access Grants assumes this
     *         role to manage access to the registered location.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(accessGrantsLocationId());
        hashCode = 31 * hashCode + Objects.hashCode(accessGrantsLocationArn());
        hashCode = 31 * hashCode + Objects.hashCode(locationScope());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessGrantsLocationsEntry)) {
            return false;
        }
        ListAccessGrantsLocationsEntry other = (ListAccessGrantsLocationsEntry) obj;
        return Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(accessGrantsLocationId(), other.accessGrantsLocationId())
                && Objects.equals(accessGrantsLocationArn(), other.accessGrantsLocationArn())
                && Objects.equals(locationScope(), other.locationScope()) && Objects.equals(iamRoleArn(), other.iamRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAccessGrantsLocationsEntry").add("CreatedAt", createdAt())
                .add("AccessGrantsLocationId", accessGrantsLocationId())
                .add("AccessGrantsLocationArn", accessGrantsLocationArn()).add("LocationScope", locationScope())
                .add("IAMRoleArn", iamRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "AccessGrantsLocationId":
            return Optional.ofNullable(clazz.cast(accessGrantsLocationId()));
        case "AccessGrantsLocationArn":
            return Optional.ofNullable(clazz.cast(accessGrantsLocationArn()));
        case "LocationScope":
            return Optional.ofNullable(clazz.cast(locationScope()));
        case "IAMRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("AccessGrantsLocationId", ACCESS_GRANTS_LOCATION_ID_FIELD);
        map.put("AccessGrantsLocationArn", ACCESS_GRANTS_LOCATION_ARN_FIELD);
        map.put("LocationScope", LOCATION_SCOPE_FIELD);
        map.put("IAMRoleArn", IAM_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAccessGrantsLocationsEntry, T> g) {
        return obj -> g.apply((ListAccessGrantsLocationsEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListAccessGrantsLocationsEntry> {
        /**
         * <p>
         * The date and time when you registered the location.
         * </p>
         * 
         * @param createdAt
         *        The date and time when you registered the location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The ID of the registered location to which you are granting access. S3 Access Grants assigns this ID when you
         * register the location. S3 Access Grants assigns the ID <code>default</code> to the default location
         * <code>s3://</code> and assigns an auto-generated ID to other locations that you register.
         * </p>
         * 
         * @param accessGrantsLocationId
         *        The ID of the registered location to which you are granting access. S3 Access Grants assigns this ID
         *        when you register the location. S3 Access Grants assigns the ID <code>default</code> to the default
         *        location <code>s3://</code> and assigns an auto-generated ID to other locations that you register.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessGrantsLocationId(String accessGrantsLocationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the registered location.
         * </p>
         * 
         * @param accessGrantsLocationArn
         *        The Amazon Resource Name (ARN) of the registered location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessGrantsLocationArn(String accessGrantsLocationArn);

        /**
         * <p>
         * The S3 path to the location that you are registering. The location scope can be the default S3 location
         * <code>s3://</code>, the S3 path to a bucket <code>s3://&lt;bucket&gt;</code>, or the S3 path to a bucket and
         * prefix <code>s3://&lt;bucket&gt;/&lt;prefix&gt;</code>. A prefix in S3 is a string of characters at the
         * beginning of an object key name used to organize the objects that you store in your S3 buckets. For example,
         * object key names that start with the <code>engineering/</code> prefix or object key names that start with the
         * <code>marketing/campaigns/</code> prefix.
         * </p>
         * 
         * @param locationScope
         *        The S3 path to the location that you are registering. The location scope can be the default S3
         *        location <code>s3://</code>, the S3 path to a bucket <code>s3://&lt;bucket&gt;</code>, or the S3 path
         *        to a bucket and prefix <code>s3://&lt;bucket&gt;/&lt;prefix&gt;</code>. A prefix in S3 is a string of
         *        characters at the beginning of an object key name used to organize the objects that you store in your
         *        S3 buckets. For example, object key names that start with the <code>engineering/</code> prefix or
         *        object key names that start with the <code>marketing/campaigns/</code> prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationScope(String locationScope);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role for the registered location. S3 Access Grants assumes this
         * role to manage access to the registered location.
         * </p>
         * 
         * @param iamRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role for the registered location. S3 Access Grants assumes
         *        this role to manage access to the registered location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String accessGrantsLocationId;

        private String accessGrantsLocationArn;

        private String locationScope;

        private String iamRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessGrantsLocationsEntry model) {
            createdAt(model.createdAt);
            accessGrantsLocationId(model.accessGrantsLocationId);
            accessGrantsLocationArn(model.accessGrantsLocationArn);
            locationScope(model.locationScope);
            iamRoleArn(model.iamRoleArn);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getAccessGrantsLocationId() {
            return accessGrantsLocationId;
        }

        public final void setAccessGrantsLocationId(String accessGrantsLocationId) {
            this.accessGrantsLocationId = accessGrantsLocationId;
        }

        @Override
        public final Builder accessGrantsLocationId(String accessGrantsLocationId) {
            this.accessGrantsLocationId = accessGrantsLocationId;
            return this;
        }

        public final String getAccessGrantsLocationArn() {
            return accessGrantsLocationArn;
        }

        public final void setAccessGrantsLocationArn(String accessGrantsLocationArn) {
            this.accessGrantsLocationArn = accessGrantsLocationArn;
        }

        @Override
        public final Builder accessGrantsLocationArn(String accessGrantsLocationArn) {
            this.accessGrantsLocationArn = accessGrantsLocationArn;
            return this;
        }

        public final String getLocationScope() {
            return locationScope;
        }

        public final void setLocationScope(String locationScope) {
            this.locationScope = locationScope;
        }

        @Override
        public final Builder locationScope(String locationScope) {
            this.locationScope = locationScope;
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        @Override
        public ListAccessGrantsLocationsEntry build() {
            return new ListAccessGrantsLocationsEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
