/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccessPointsForDirectoryBucketsRequest extends S3ControlRequest implements
        ToCopyableBuilder<ListAccessPointsForDirectoryBucketsRequest.Builder, ListAccessPointsForDirectoryBucketsRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountId")
            .getter(getter(ListAccessPointsForDirectoryBucketsRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id")
                    .unmarshallLocationName("x-amz-account-id").build()).build();

    private static final SdkField<String> DIRECTORY_BUCKET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DirectoryBucket")
            .getter(getter(ListAccessPointsForDirectoryBucketsRequest::directoryBucket))
            .setter(setter(Builder::directoryBucket))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("directoryBucket")
                    .unmarshallLocationName("directoryBucket").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(ListAccessPointsForDirectoryBucketsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(ListAccessPointsForDirectoryBucketsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults")
                    .unmarshallLocationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            DIRECTORY_BUCKET_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountId;

    private final String directoryBucket;

    private final String nextToken;

    private final Integer maxResults;

    private ListAccessPointsForDirectoryBucketsRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.directoryBucket = builder.directoryBucket;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that owns the access points.
     * </p>
     * 
     * @return The Amazon Web Services account ID that owns the access points.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The name of the directory bucket associated with the access points you want to list.
     * </p>
     * 
     * @return The name of the directory bucket associated with the access points you want to list.
     */
    public final String directoryBucket() {
        return directoryBucket;
    }

    /**
     * <p>
     * If <code>NextToken</code> is returned, there are more access points available than requested in the
     * <code>maxResults</code> value. The value of <code>NextToken</code> is a unique pagination token for each page.
     * Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each
     * pagination token expires after 24 hours.
     * </p>
     * 
     * @return If <code>NextToken</code> is returned, there are more access points available than requested in the
     *         <code>maxResults</code> value. The value of <code>NextToken</code> is a unique pagination token for each
     *         page. Make the call again using the returned token to retrieve the next page. Keep all other arguments
     *         unchanged. Each pagination token expires after 24 hours.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of access points that you would like returned in the
     * <code>ListAccessPointsForDirectoryBuckets</code> response. If the directory bucket is associated with more than
     * this number of access points, the results include the pagination token <code>NextToken</code>. Make another call
     * using the <code>NextToken</code> to retrieve more results.
     * </p>
     * 
     * @return The maximum number of access points that you would like returned in the
     *         <code>ListAccessPointsForDirectoryBuckets</code> response. If the directory bucket is associated with
     *         more than this number of access points, the results include the pagination token <code>NextToken</code>.
     *         Make another call using the <code>NextToken</code> to retrieve more results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(directoryBucket());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessPointsForDirectoryBucketsRequest)) {
            return false;
        }
        ListAccessPointsForDirectoryBucketsRequest other = (ListAccessPointsForDirectoryBucketsRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(directoryBucket(), other.directoryBucket())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAccessPointsForDirectoryBucketsRequest").add("AccountId", accountId())
                .add("DirectoryBucket", directoryBucket()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "DirectoryBucket":
            return Optional.ofNullable(clazz.cast(directoryBucket()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("x-amz-account-id", ACCOUNT_ID_FIELD);
        map.put("directoryBucket", DIRECTORY_BUCKET_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAccessPointsForDirectoryBucketsRequest, T> g) {
        return obj -> g.apply((ListAccessPointsForDirectoryBucketsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends S3ControlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAccessPointsForDirectoryBucketsRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID that owns the access points.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID that owns the access points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The name of the directory bucket associated with the access points you want to list.
         * </p>
         * 
         * @param directoryBucket
         *        The name of the directory bucket associated with the access points you want to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryBucket(String directoryBucket);

        /**
         * <p>
         * If <code>NextToken</code> is returned, there are more access points available than requested in the
         * <code>maxResults</code> value. The value of <code>NextToken</code> is a unique pagination token for each
         * page. Make the call again using the returned token to retrieve the next page. Keep all other arguments
         * unchanged. Each pagination token expires after 24 hours.
         * </p>
         * 
         * @param nextToken
         *        If <code>NextToken</code> is returned, there are more access points available than requested in the
         *        <code>maxResults</code> value. The value of <code>NextToken</code> is a unique pagination token for
         *        each page. Make the call again using the returned token to retrieve the next page. Keep all other
         *        arguments unchanged. Each pagination token expires after 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of access points that you would like returned in the
         * <code>ListAccessPointsForDirectoryBuckets</code> response. If the directory bucket is associated with more
         * than this number of access points, the results include the pagination token <code>NextToken</code>. Make
         * another call using the <code>NextToken</code> to retrieve more results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of access points that you would like returned in the
         *        <code>ListAccessPointsForDirectoryBuckets</code> response. If the directory bucket is associated with
         *        more than this number of access points, the results include the pagination token
         *        <code>NextToken</code>. Make another call using the <code>NextToken</code> to retrieve more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3ControlRequest.BuilderImpl implements Builder {
        private String accountId;

        private String directoryBucket;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessPointsForDirectoryBucketsRequest model) {
            super(model);
            accountId(model.accountId);
            directoryBucket(model.directoryBucket);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getDirectoryBucket() {
            return directoryBucket;
        }

        public final void setDirectoryBucket(String directoryBucket) {
            this.directoryBucket = directoryBucket;
        }

        @Override
        public final Builder directoryBucket(String directoryBucket) {
            this.directoryBucket = directoryBucket;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAccessPointsForDirectoryBucketsRequest build() {
            return new ListAccessPointsForDirectoryBucketsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
