/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Part of <code>ListStorageLensConfigurationResult</code>. Each entry includes the description of the S3 Storage Lens
 * configuration, its home Region, whether it is enabled, its Amazon Resource Name (ARN), and config ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStorageLensConfigurationEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<ListStorageLensConfigurationEntry.Builder, ListStorageLensConfigurationEntry> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(ListStorageLensConfigurationEntry::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> STORAGE_LENS_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StorageLensArn")
            .getter(getter(ListStorageLensConfigurationEntry::storageLensArn))
            .setter(setter(Builder::storageLensArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLensArn")
                    .unmarshallLocationName("StorageLensArn").build()).build();

    private static final SdkField<String> HOME_REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HomeRegion")
            .getter(getter(ListStorageLensConfigurationEntry::homeRegion))
            .setter(setter(Builder::homeRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegion")
                    .unmarshallLocationName("HomeRegion").build()).build();

    private static final SdkField<Boolean> IS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsEnabled")
            .getter(getter(ListStorageLensConfigurationEntry::isEnabled))
            .setter(setter(Builder::isEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsEnabled")
                    .unmarshallLocationName("IsEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            STORAGE_LENS_ARN_FIELD, HOME_REGION_FIELD, IS_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String storageLensArn;

    private final String homeRegion;

    private final Boolean isEnabled;

    private ListStorageLensConfigurationEntry(BuilderImpl builder) {
        this.id = builder.id;
        this.storageLensArn = builder.storageLensArn;
        this.homeRegion = builder.homeRegion;
        this.isEnabled = builder.isEnabled;
    }

    /**
     * <p>
     * A container for the S3 Storage Lens configuration ID.
     * </p>
     * 
     * @return A container for the S3 Storage Lens configuration ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN of the S3 Storage Lens configuration. This property is read-only.
     * </p>
     * 
     * @return The ARN of the S3 Storage Lens configuration. This property is read-only.
     */
    public final String storageLensArn() {
        return storageLensArn;
    }

    /**
     * <p>
     * A container for the S3 Storage Lens home Region. Your metrics data is stored and retained in your designated S3
     * Storage Lens home Region.
     * </p>
     * 
     * @return A container for the S3 Storage Lens home Region. Your metrics data is stored and retained in your
     *         designated S3 Storage Lens home Region.
     */
    public final String homeRegion() {
        return homeRegion;
    }

    /**
     * <p>
     * A container for whether the S3 Storage Lens configuration is enabled. This property is required.
     * </p>
     * 
     * @return A container for whether the S3 Storage Lens configuration is enabled. This property is required.
     */
    public final Boolean isEnabled() {
        return isEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(storageLensArn());
        hashCode = 31 * hashCode + Objects.hashCode(homeRegion());
        hashCode = 31 * hashCode + Objects.hashCode(isEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStorageLensConfigurationEntry)) {
            return false;
        }
        ListStorageLensConfigurationEntry other = (ListStorageLensConfigurationEntry) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(storageLensArn(), other.storageLensArn())
                && Objects.equals(homeRegion(), other.homeRegion()) && Objects.equals(isEnabled(), other.isEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStorageLensConfigurationEntry").add("Id", id()).add("StorageLensArn", storageLensArn())
                .add("HomeRegion", homeRegion()).add("IsEnabled", isEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "StorageLensArn":
            return Optional.ofNullable(clazz.cast(storageLensArn()));
        case "HomeRegion":
            return Optional.ofNullable(clazz.cast(homeRegion()));
        case "IsEnabled":
            return Optional.ofNullable(clazz.cast(isEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("StorageLensArn", STORAGE_LENS_ARN_FIELD);
        map.put("HomeRegion", HOME_REGION_FIELD);
        map.put("IsEnabled", IS_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListStorageLensConfigurationEntry, T> g) {
        return obj -> g.apply((ListStorageLensConfigurationEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListStorageLensConfigurationEntry> {
        /**
         * <p>
         * A container for the S3 Storage Lens configuration ID.
         * </p>
         * 
         * @param id
         *        A container for the S3 Storage Lens configuration ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN of the S3 Storage Lens configuration. This property is read-only.
         * </p>
         * 
         * @param storageLensArn
         *        The ARN of the S3 Storage Lens configuration. This property is read-only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageLensArn(String storageLensArn);

        /**
         * <p>
         * A container for the S3 Storage Lens home Region. Your metrics data is stored and retained in your designated
         * S3 Storage Lens home Region.
         * </p>
         * 
         * @param homeRegion
         *        A container for the S3 Storage Lens home Region. Your metrics data is stored and retained in your
         *        designated S3 Storage Lens home Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeRegion(String homeRegion);

        /**
         * <p>
         * A container for whether the S3 Storage Lens configuration is enabled. This property is required.
         * </p>
         * 
         * @param isEnabled
         *        A container for whether the S3 Storage Lens configuration is enabled. This property is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isEnabled(Boolean isEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String storageLensArn;

        private String homeRegion;

        private Boolean isEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStorageLensConfigurationEntry model) {
            id(model.id);
            storageLensArn(model.storageLensArn);
            homeRegion(model.homeRegion);
            isEnabled(model.isEnabled);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStorageLensArn() {
            return storageLensArn;
        }

        public final void setStorageLensArn(String storageLensArn) {
            this.storageLensArn = storageLensArn;
        }

        @Override
        public final Builder storageLensArn(String storageLensArn) {
            this.storageLensArn = storageLensArn;
            return this;
        }

        public final String getHomeRegion() {
            return homeRegion;
        }

        public final void setHomeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
        }

        @Override
        public final Builder homeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
            return this;
        }

        public final Boolean getIsEnabled() {
            return isEnabled;
        }

        public final void setIsEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        @Override
        public final Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        @Override
        public ListStorageLensConfigurationEntry build() {
            return new ListStorageLensConfigurationEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
