/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for AwsLambdaTransformation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ObjectLambdaContentTransformation implements SdkPojo, Serializable,
        ToCopyableBuilder<ObjectLambdaContentTransformation.Builder, ObjectLambdaContentTransformation> {
    private static final SdkField<AwsLambdaTransformation> AWS_LAMBDA_FIELD = SdkField
            .<AwsLambdaTransformation> builder(MarshallingType.SDK_POJO)
            .memberName("AwsLambda")
            .getter(getter(ObjectLambdaContentTransformation::awsLambda))
            .setter(setter(Builder::awsLambda))
            .constructor(AwsLambdaTransformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsLambda")
                    .unmarshallLocationName("AwsLambda").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_LAMBDA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsLambdaTransformation awsLambda;

    private final Type type;

    private ObjectLambdaContentTransformation(BuilderImpl builder) {
        this.awsLambda = builder.awsLambda;
        this.type = builder.type;
    }

    /**
     * <p>
     * A container for an Lambda function.
     * </p>
     * 
     * @return A container for an Lambda function.
     */
    public final AwsLambdaTransformation awsLambda() {
        return awsLambda;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsLambda());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectLambdaContentTransformation)) {
            return false;
        }
        ObjectLambdaContentTransformation other = (ObjectLambdaContentTransformation) obj;
        return Objects.equals(awsLambda(), other.awsLambda());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ObjectLambdaContentTransformation").add("AwsLambda", awsLambda()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsLambda":
            return Optional.ofNullable(clazz.cast(awsLambda()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #awsLambda()} initialized to the given value.
     *
     * <p>
     * A container for an Lambda function.
     * </p>
     * 
     * @param awsLambda
     *        A container for an Lambda function.
     */
    public static ObjectLambdaContentTransformation fromAwsLambda(AwsLambdaTransformation awsLambda) {
        return builder().awsLambda(awsLambda).build();
    }

    /**
     * Create an instance of this class with {@link #awsLambda()} initialized to the given value.
     *
     * <p>
     * A container for an Lambda function.
     * </p>
     * 
     * @param awsLambda
     *        A container for an Lambda function.
     */
    public static ObjectLambdaContentTransformation fromAwsLambda(Consumer<AwsLambdaTransformation.Builder> awsLambda) {
        AwsLambdaTransformation.Builder builder = AwsLambdaTransformation.builder();
        awsLambda.accept(builder);
        return fromAwsLambda(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsLambda", AWS_LAMBDA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ObjectLambdaContentTransformation, T> g) {
        return obj -> g.apply((ObjectLambdaContentTransformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ObjectLambdaContentTransformation> {
        /**
         * <p>
         * A container for an Lambda function.
         * </p>
         * 
         * @param awsLambda
         *        A container for an Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsLambda(AwsLambdaTransformation awsLambda);

        /**
         * <p>
         * A container for an Lambda function.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsLambdaTransformation.Builder} avoiding
         * the need to create one manually via {@link AwsLambdaTransformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsLambdaTransformation.Builder#build()} is called immediately
         * and its result is passed to {@link #awsLambda(AwsLambdaTransformation)}.
         * 
         * @param awsLambda
         *        a consumer that will call methods on {@link AwsLambdaTransformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsLambda(AwsLambdaTransformation)
         */
        default Builder awsLambda(Consumer<AwsLambdaTransformation.Builder> awsLambda) {
            return awsLambda(AwsLambdaTransformation.builder().applyMutation(awsLambda).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsLambdaTransformation awsLambda;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectLambdaContentTransformation model) {
            awsLambda(model.awsLambda);
        }

        public final AwsLambdaTransformation.Builder getAwsLambda() {
            return awsLambda != null ? awsLambda.toBuilder() : null;
        }

        public final void setAwsLambda(AwsLambdaTransformation.BuilderImpl awsLambda) {
            Object oldValue = this.awsLambda;
            this.awsLambda = awsLambda != null ? awsLambda.build() : null;
            handleUnionValueChange(Type.AWS_LAMBDA, oldValue, this.awsLambda);
        }

        @Override
        public final Builder awsLambda(AwsLambdaTransformation awsLambda) {
            Object oldValue = this.awsLambda;
            this.awsLambda = awsLambda;
            handleUnionValueChange(Type.AWS_LAMBDA, oldValue, this.awsLambda);
            return this;
        }

        @Override
        public ObjectLambdaContentTransformation build() {
            return new ObjectLambdaContentTransformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ObjectLambdaContentTransformation#type()
     */
    public enum Type {
        AWS_LAMBDA,

        UNKNOWN_TO_SDK_VERSION
    }
}
