/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAccessPointScopeRequest extends S3ControlRequest implements
        ToCopyableBuilder<PutAccessPointScopeRequest.Builder, PutAccessPointScopeRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountId")
            .getter(getter(PutAccessPointScopeRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id")
                    .unmarshallLocationName("x-amz-account-id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(PutAccessPointScopeRequest::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").unmarshallLocationName("name")
                    .build()).build();

    private static final SdkField<Scope> SCOPE_FIELD = SdkField
            .<Scope> builder(MarshallingType.SDK_POJO)
            .memberName("Scope")
            .getter(getter(PutAccessPointScopeRequest::scope))
            .setter(setter(Builder::scope))
            .constructor(Scope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope")
                    .unmarshallLocationName("Scope").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, NAME_FIELD,
            SCOPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountId;

    private final String name;

    private final Scope scope;

    private PutAccessPointScopeRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.name = builder.name;
        this.scope = builder.scope;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that owns the access point with scope that you want to create or replace.
     * </p>
     * 
     * @return The Amazon Web Services account ID that owns the access point with scope that you want to create or
     *         replace.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The name of the access point with the scope that you want to create or replace.
     * </p>
     * 
     * @return The name of the access point with the scope that you want to create or replace.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Object prefixes, API operations, or a combination of both.
     * </p>
     * 
     * @return Object prefixes, API operations, or a combination of both.
     */
    public final Scope scope() {
        return scope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(scope());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAccessPointScopeRequest)) {
            return false;
        }
        PutAccessPointScopeRequest other = (PutAccessPointScopeRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(name(), other.name())
                && Objects.equals(scope(), other.scope());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutAccessPointScopeRequest").add("AccountId", accountId()).add("Name", name())
                .add("Scope", scope()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scope()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("x-amz-account-id", ACCOUNT_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("Scope", SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutAccessPointScopeRequest, T> g) {
        return obj -> g.apply((PutAccessPointScopeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends S3ControlRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutAccessPointScopeRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID that owns the access point with scope that you want to create or replace.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID that owns the access point with scope that you want to create or
         *        replace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The name of the access point with the scope that you want to create or replace.
         * </p>
         * 
         * @param name
         *        The name of the access point with the scope that you want to create or replace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Object prefixes, API operations, or a combination of both.
         * </p>
         * 
         * @param scope
         *        Object prefixes, API operations, or a combination of both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(Scope scope);

        /**
         * <p>
         * Object prefixes, API operations, or a combination of both.
         * </p>
         * This is a convenience method that creates an instance of the {@link Scope.Builder} avoiding the need to
         * create one manually via {@link Scope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Scope.Builder#build()} is called immediately and its result is
         * passed to {@link #scope(Scope)}.
         * 
         * @param scope
         *        a consumer that will call methods on {@link Scope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scope(Scope)
         */
        default Builder scope(Consumer<Scope.Builder> scope) {
            return scope(Scope.builder().applyMutation(scope).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3ControlRequest.BuilderImpl implements Builder {
        private String accountId;

        private String name;

        private Scope scope;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAccessPointScopeRequest model) {
            super(model);
            accountId(model.accountId);
            name(model.name);
            scope(model.scope);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Scope.Builder getScope() {
            return scope != null ? scope.toBuilder() : null;
        }

        public final void setScope(Scope.BuilderImpl scope) {
            this.scope = scope != null ? scope.build() : null;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAccessPointScopeRequest build() {
            return new PutAccessPointScopeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
