/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutBucketLifecycleConfigurationRequest extends S3ControlRequest implements
        ToCopyableBuilder<PutBucketLifecycleConfigurationRequest.Builder, PutBucketLifecycleConfigurationRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountId")
            .getter(getter(PutBucketLifecycleConfigurationRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id")
                    .unmarshallLocationName("x-amz-account-id").build()).build();

    private static final SdkField<String> BUCKET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Bucket")
            .getter(getter(PutBucketLifecycleConfigurationRequest::bucket))
            .setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").unmarshallLocationName("name")
                    .build()).build();

    private static final SdkField<LifecycleConfiguration> LIFECYCLE_CONFIGURATION_FIELD = SdkField
            .<LifecycleConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("LifecycleConfiguration")
            .getter(getter(PutBucketLifecycleConfigurationRequest::lifecycleConfiguration))
            .setter(setter(Builder::lifecycleConfiguration))
            .constructor(LifecycleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleConfiguration")
                    .unmarshallLocationName("LifecycleConfiguration").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            BUCKET_FIELD, LIFECYCLE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountId;

    private final String bucket;

    private final LifecycleConfiguration lifecycleConfiguration;

    private PutBucketLifecycleConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.bucket = builder.bucket;
        this.lifecycleConfiguration = builder.lifecycleConfiguration;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the Outposts bucket.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the Outposts bucket.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The name of the bucket for which to set the configuration.
     * </p>
     * 
     * @return The name of the bucket for which to set the configuration.
     */
    public final String bucket() {
        return bucket;
    }

    /**
     * <p>
     * Container for lifecycle rules. You can add as many as 1,000 rules.
     * </p>
     * 
     * @return Container for lifecycle rules. You can add as many as 1,000 rules.
     */
    public final LifecycleConfiguration lifecycleConfiguration() {
        return lifecycleConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketLifecycleConfigurationRequest)) {
            return false;
        }
        PutBucketLifecycleConfigurationRequest other = (PutBucketLifecycleConfigurationRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(bucket(), other.bucket())
                && Objects.equals(lifecycleConfiguration(), other.lifecycleConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutBucketLifecycleConfigurationRequest").add("AccountId", accountId()).add("Bucket", bucket())
                .add("LifecycleConfiguration", lifecycleConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "LifecycleConfiguration":
            return Optional.ofNullable(clazz.cast(lifecycleConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("x-amz-account-id", ACCOUNT_ID_FIELD);
        map.put("name", BUCKET_FIELD);
        map.put("LifecycleConfiguration", LIFECYCLE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutBucketLifecycleConfigurationRequest, T> g) {
        return obj -> g.apply((PutBucketLifecycleConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends S3ControlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutBucketLifecycleConfigurationRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID of the Outposts bucket.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID of the Outposts bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The name of the bucket for which to set the configuration.
         * </p>
         * 
         * @param bucket
         *        The name of the bucket for which to set the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * Container for lifecycle rules. You can add as many as 1,000 rules.
         * </p>
         * 
         * @param lifecycleConfiguration
         *        Container for lifecycle rules. You can add as many as 1,000 rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleConfiguration(LifecycleConfiguration lifecycleConfiguration);

        /**
         * <p>
         * Container for lifecycle rules. You can add as many as 1,000 rules.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifecycleConfiguration.Builder} avoiding
         * the need to create one manually via {@link LifecycleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifecycleConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #lifecycleConfiguration(LifecycleConfiguration)}.
         * 
         * @param lifecycleConfiguration
         *        a consumer that will call methods on {@link LifecycleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycleConfiguration(LifecycleConfiguration)
         */
        default Builder lifecycleConfiguration(Consumer<LifecycleConfiguration.Builder> lifecycleConfiguration) {
            return lifecycleConfiguration(LifecycleConfiguration.builder().applyMutation(lifecycleConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3ControlRequest.BuilderImpl implements Builder {
        private String accountId;

        private String bucket;

        private LifecycleConfiguration lifecycleConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketLifecycleConfigurationRequest model) {
            super(model);
            accountId(model.accountId);
            bucket(model.bucket);
            lifecycleConfiguration(model.lifecycleConfiguration);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getBucket() {
            return bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final LifecycleConfiguration.Builder getLifecycleConfiguration() {
            return lifecycleConfiguration != null ? lifecycleConfiguration.toBuilder() : null;
        }

        public final void setLifecycleConfiguration(LifecycleConfiguration.BuilderImpl lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration != null ? lifecycleConfiguration.build() : null;
        }

        @Override
        public final Builder lifecycleConfiguration(LifecycleConfiguration lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutBucketLifecycleConfigurationRequest build() {
            return new PutBucketLifecycleConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
