/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Grantee implements SdkPojo, Serializable, ToCopyableBuilder<S3Grantee.Builder, S3Grantee> {
    private static final SdkField<String> TYPE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TypeIdentifier")
            .getter(getter(S3Grantee::typeIdentifierAsString))
            .setter(setter(Builder::typeIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeIdentifier")
                    .unmarshallLocationName("TypeIdentifier").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Identifier")
            .getter(getter(S3Grantee::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier")
                    .unmarshallLocationName("Identifier").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DisplayName")
            .getter(getter(S3Grantee::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName")
                    .unmarshallLocationName("DisplayName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_IDENTIFIER_FIELD,
            IDENTIFIER_FIELD, DISPLAY_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String typeIdentifier;

    private final String identifier;

    private final String displayName;

    private S3Grantee(BuilderImpl builder) {
        this.typeIdentifier = builder.typeIdentifier;
        this.identifier = builder.identifier;
        this.displayName = builder.displayName;
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #typeIdentifier}
     * will return {@link S3GranteeTypeIdentifier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeIdentifierAsString}.
     * </p>
     * 
     * @return
     * @see S3GranteeTypeIdentifier
     */
    public final S3GranteeTypeIdentifier typeIdentifier() {
        return S3GranteeTypeIdentifier.fromValue(typeIdentifier);
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #typeIdentifier}
     * will return {@link S3GranteeTypeIdentifier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeIdentifierAsString}.
     * </p>
     * 
     * @return
     * @see S3GranteeTypeIdentifier
     */
    public final String typeIdentifierAsString() {
        return typeIdentifier;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String displayName() {
        return displayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeIdentifierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Grantee)) {
            return false;
        }
        S3Grantee other = (S3Grantee) obj;
        return Objects.equals(typeIdentifierAsString(), other.typeIdentifierAsString())
                && Objects.equals(identifier(), other.identifier()) && Objects.equals(displayName(), other.displayName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3Grantee").add("TypeIdentifier", typeIdentifierAsString()).add("Identifier", identifier())
                .add("DisplayName", displayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TypeIdentifier":
            return Optional.ofNullable(clazz.cast(typeIdentifierAsString()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TypeIdentifier", TYPE_IDENTIFIER_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3Grantee, T> g) {
        return obj -> g.apply((S3Grantee) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Grantee> {
        /**
         * <p/>
         * 
         * @param typeIdentifier
         * @see S3GranteeTypeIdentifier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3GranteeTypeIdentifier
         */
        Builder typeIdentifier(String typeIdentifier);

        /**
         * <p/>
         * 
         * @param typeIdentifier
         * @see S3GranteeTypeIdentifier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3GranteeTypeIdentifier
         */
        Builder typeIdentifier(S3GranteeTypeIdentifier typeIdentifier);

        /**
         * <p/>
         * 
         * @param identifier
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p/>
         * 
         * @param displayName
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);
    }

    static final class BuilderImpl implements Builder {
        private String typeIdentifier;

        private String identifier;

        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Grantee model) {
            typeIdentifier(model.typeIdentifier);
            identifier(model.identifier);
            displayName(model.displayName);
        }

        public final String getTypeIdentifier() {
            return typeIdentifier;
        }

        public final void setTypeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
        }

        @Override
        public final Builder typeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
            return this;
        }

        @Override
        public final Builder typeIdentifier(S3GranteeTypeIdentifier typeIdentifier) {
            this.typeIdentifier(typeIdentifier == null ? null : typeIdentifier.toString());
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public S3Grantee build() {
            return new S3Grantee(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
