/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SelectionCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<SelectionCriteria.Builder, SelectionCriteria> {
    private static final SdkField<String> DELIMITER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Delimiter")
            .getter(getter(SelectionCriteria::delimiter))
            .setter(setter(Builder::delimiter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delimiter")
                    .unmarshallLocationName("Delimiter").build()).build();

    private static final SdkField<Integer> MAX_DEPTH_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxDepth")
            .getter(getter(SelectionCriteria::maxDepth))
            .setter(setter(Builder::maxDepth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxDepth")
                    .unmarshallLocationName("MaxDepth").build()).build();

    private static final SdkField<Double> MIN_STORAGE_BYTES_PERCENTAGE_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("MinStorageBytesPercentage")
            .getter(getter(SelectionCriteria::minStorageBytesPercentage))
            .setter(setter(Builder::minStorageBytesPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinStorageBytesPercentage")
                    .unmarshallLocationName("MinStorageBytesPercentage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIMITER_FIELD,
            MAX_DEPTH_FIELD, MIN_STORAGE_BYTES_PERCENTAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String delimiter;

    private final Integer maxDepth;

    private final Double minStorageBytesPercentage;

    private SelectionCriteria(BuilderImpl builder) {
        this.delimiter = builder.delimiter;
        this.maxDepth = builder.maxDepth;
        this.minStorageBytesPercentage = builder.minStorageBytesPercentage;
    }

    /**
     * <p>
     * A container for the delimiter of the selection criteria being used.
     * </p>
     * 
     * @return A container for the delimiter of the selection criteria being used.
     */
    public final String delimiter() {
        return delimiter;
    }

    /**
     * <p>
     * The max depth of the selection criteria
     * </p>
     * 
     * @return The max depth of the selection criteria
     */
    public final Integer maxDepth() {
        return maxDepth;
    }

    /**
     * <p>
     * The minimum number of storage bytes percentage whose metrics will be selected.
     * </p>
     * <note>
     * <p>
     * You must choose a value greater than or equal to <code>1.0</code>.
     * </p>
     * </note>
     * 
     * @return The minimum number of storage bytes percentage whose metrics will be selected.</p> <note>
     *         <p>
     *         You must choose a value greater than or equal to <code>1.0</code>.
     *         </p>
     */
    public final Double minStorageBytesPercentage() {
        return minStorageBytesPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(delimiter());
        hashCode = 31 * hashCode + Objects.hashCode(maxDepth());
        hashCode = 31 * hashCode + Objects.hashCode(minStorageBytesPercentage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelectionCriteria)) {
            return false;
        }
        SelectionCriteria other = (SelectionCriteria) obj;
        return Objects.equals(delimiter(), other.delimiter()) && Objects.equals(maxDepth(), other.maxDepth())
                && Objects.equals(minStorageBytesPercentage(), other.minStorageBytesPercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SelectionCriteria").add("Delimiter", delimiter()).add("MaxDepth", maxDepth())
                .add("MinStorageBytesPercentage", minStorageBytesPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Delimiter":
            return Optional.ofNullable(clazz.cast(delimiter()));
        case "MaxDepth":
            return Optional.ofNullable(clazz.cast(maxDepth()));
        case "MinStorageBytesPercentage":
            return Optional.ofNullable(clazz.cast(minStorageBytesPercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Delimiter", DELIMITER_FIELD);
        map.put("MaxDepth", MAX_DEPTH_FIELD);
        map.put("MinStorageBytesPercentage", MIN_STORAGE_BYTES_PERCENTAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SelectionCriteria, T> g) {
        return obj -> g.apply((SelectionCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SelectionCriteria> {
        /**
         * <p>
         * A container for the delimiter of the selection criteria being used.
         * </p>
         * 
         * @param delimiter
         *        A container for the delimiter of the selection criteria being used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delimiter(String delimiter);

        /**
         * <p>
         * The max depth of the selection criteria
         * </p>
         * 
         * @param maxDepth
         *        The max depth of the selection criteria
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxDepth(Integer maxDepth);

        /**
         * <p>
         * The minimum number of storage bytes percentage whose metrics will be selected.
         * </p>
         * <note>
         * <p>
         * You must choose a value greater than or equal to <code>1.0</code>.
         * </p>
         * </note>
         * 
         * @param minStorageBytesPercentage
         *        The minimum number of storage bytes percentage whose metrics will be selected.</p> <note>
         *        <p>
         *        You must choose a value greater than or equal to <code>1.0</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minStorageBytesPercentage(Double minStorageBytesPercentage);
    }

    static final class BuilderImpl implements Builder {
        private String delimiter;

        private Integer maxDepth;

        private Double minStorageBytesPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(SelectionCriteria model) {
            delimiter(model.delimiter);
            maxDepth(model.maxDepth);
            minStorageBytesPercentage(model.minStorageBytesPercentage);
        }

        public final String getDelimiter() {
            return delimiter;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final Integer getMaxDepth() {
            return maxDepth;
        }

        public final void setMaxDepth(Integer maxDepth) {
            this.maxDepth = maxDepth;
        }

        @Override
        public final Builder maxDepth(Integer maxDepth) {
            this.maxDepth = maxDepth;
            return this;
        }

        public final Double getMinStorageBytesPercentage() {
            return minStorageBytesPercentage;
        }

        public final void setMinStorageBytesPercentage(Double minStorageBytesPercentage) {
            this.minStorageBytesPercentage = minStorageBytesPercentage;
        }

        @Override
        public final Builder minStorageBytesPercentage(Double minStorageBytesPercentage) {
            this.minStorageBytesPercentage = minStorageBytesPercentage;
            return this;
        }

        @Override
        public SelectionCriteria build() {
            return new SelectionCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
