/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The filter element sets the criteria for the Storage Lens group data that is displayed. For multiple filter
 * conditions, the <code>AND</code> or <code>OR</code> logical operator is used.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StorageLensGroupFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<StorageLensGroupFilter.Builder, StorageLensGroupFilter> {
    private static final SdkField<List<String>> MATCH_ANY_PREFIX_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MatchAnyPrefix")
            .getter(getter(StorageLensGroupFilter::matchAnyPrefix))
            .setter(setter(Builder::matchAnyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchAnyPrefix")
                    .unmarshallLocationName("MatchAnyPrefix").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Prefix")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Prefix").unmarshallLocationName("Prefix").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> MATCH_ANY_SUFFIX_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MatchAnySuffix")
            .getter(getter(StorageLensGroupFilter::matchAnySuffix))
            .setter(setter(Builder::matchAnySuffix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchAnySuffix")
                    .unmarshallLocationName("MatchAnySuffix").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Suffix")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Suffix").unmarshallLocationName("Suffix").build()).build())
                            .build()).build();

    private static final SdkField<List<S3Tag>> MATCH_ANY_TAG_FIELD = SdkField
            .<List<S3Tag>> builder(MarshallingType.LIST)
            .memberName("MatchAnyTag")
            .getter(getter(StorageLensGroupFilter::matchAnyTag))
            .setter(setter(Builder::matchAnyTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchAnyTag")
                    .unmarshallLocationName("MatchAnyTag").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<S3Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(S3Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").unmarshallLocationName("Tag").build()).build()).build())
            .build();

    private static final SdkField<MatchObjectAge> MATCH_OBJECT_AGE_FIELD = SdkField
            .<MatchObjectAge> builder(MarshallingType.SDK_POJO)
            .memberName("MatchObjectAge")
            .getter(getter(StorageLensGroupFilter::matchObjectAge))
            .setter(setter(Builder::matchObjectAge))
            .constructor(MatchObjectAge::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchObjectAge")
                    .unmarshallLocationName("MatchObjectAge").build()).build();

    private static final SdkField<MatchObjectSize> MATCH_OBJECT_SIZE_FIELD = SdkField
            .<MatchObjectSize> builder(MarshallingType.SDK_POJO)
            .memberName("MatchObjectSize")
            .getter(getter(StorageLensGroupFilter::matchObjectSize))
            .setter(setter(Builder::matchObjectSize))
            .constructor(MatchObjectSize::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchObjectSize")
                    .unmarshallLocationName("MatchObjectSize").build()).build();

    private static final SdkField<StorageLensGroupAndOperator> AND_FIELD = SdkField
            .<StorageLensGroupAndOperator> builder(MarshallingType.SDK_POJO)
            .memberName("And")
            .getter(getter(StorageLensGroupFilter::and))
            .setter(setter(Builder::and))
            .constructor(StorageLensGroupAndOperator::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("And").unmarshallLocationName("And")
                    .build()).build();

    private static final SdkField<StorageLensGroupOrOperator> OR_FIELD = SdkField
            .<StorageLensGroupOrOperator> builder(MarshallingType.SDK_POJO)
            .memberName("Or")
            .getter(getter(StorageLensGroupFilter::or))
            .setter(setter(Builder::or))
            .constructor(StorageLensGroupOrOperator::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Or").unmarshallLocationName("Or")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_ANY_PREFIX_FIELD,
            MATCH_ANY_SUFFIX_FIELD, MATCH_ANY_TAG_FIELD, MATCH_OBJECT_AGE_FIELD, MATCH_OBJECT_SIZE_FIELD, AND_FIELD, OR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> matchAnyPrefix;

    private final List<String> matchAnySuffix;

    private final List<S3Tag> matchAnyTag;

    private final MatchObjectAge matchObjectAge;

    private final MatchObjectSize matchObjectSize;

    private final StorageLensGroupAndOperator and;

    private final StorageLensGroupOrOperator or;

    private StorageLensGroupFilter(BuilderImpl builder) {
        this.matchAnyPrefix = builder.matchAnyPrefix;
        this.matchAnySuffix = builder.matchAnySuffix;
        this.matchAnyTag = builder.matchAnyTag;
        this.matchObjectAge = builder.matchObjectAge;
        this.matchObjectSize = builder.matchObjectSize;
        this.and = builder.and;
        this.or = builder.or;
    }

    /**
     * For responses, this returns true if the service returned a value for the MatchAnyPrefix property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMatchAnyPrefix() {
        return matchAnyPrefix != null && !(matchAnyPrefix instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a list of prefixes. At least one prefix must be specified. Up to 10 prefixes are allowed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMatchAnyPrefix} method.
     * </p>
     * 
     * @return Contains a list of prefixes. At least one prefix must be specified. Up to 10 prefixes are allowed.
     */
    public final List<String> matchAnyPrefix() {
        return matchAnyPrefix;
    }

    /**
     * For responses, this returns true if the service returned a value for the MatchAnySuffix property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMatchAnySuffix() {
        return matchAnySuffix != null && !(matchAnySuffix instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a list of suffixes. At least one suffix must be specified. Up to 10 suffixes are allowed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMatchAnySuffix} method.
     * </p>
     * 
     * @return Contains a list of suffixes. At least one suffix must be specified. Up to 10 suffixes are allowed.
     */
    public final List<String> matchAnySuffix() {
        return matchAnySuffix;
    }

    /**
     * For responses, this returns true if the service returned a value for the MatchAnyTag property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMatchAnyTag() {
        return matchAnyTag != null && !(matchAnyTag instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the list of S3 object tags. At least one object tag must be specified. Up to 10 object tags are allowed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMatchAnyTag} method.
     * </p>
     * 
     * @return Contains the list of S3 object tags. At least one object tag must be specified. Up to 10 object tags are
     *         allowed.
     */
    public final List<S3Tag> matchAnyTag() {
        return matchAnyTag;
    }

    /**
     * <p>
     * Contains <code>DaysGreaterThan</code> and <code>DaysLessThan</code> to define the object age range (minimum and
     * maximum number of days).
     * </p>
     * 
     * @return Contains <code>DaysGreaterThan</code> and <code>DaysLessThan</code> to define the object age range
     *         (minimum and maximum number of days).
     */
    public final MatchObjectAge matchObjectAge() {
        return matchObjectAge;
    }

    /**
     * <p>
     * Contains <code>BytesGreaterThan</code> and <code>BytesLessThan</code> to define the object size range (minimum
     * and maximum number of Bytes).
     * </p>
     * 
     * @return Contains <code>BytesGreaterThan</code> and <code>BytesLessThan</code> to define the object size range
     *         (minimum and maximum number of Bytes).
     */
    public final MatchObjectSize matchObjectSize() {
        return matchObjectSize;
    }

    /**
     * <p>
     * A logical operator that allows multiple filter conditions to be joined for more complex comparisons of Storage
     * Lens group data. Objects must match all of the listed filter conditions that are joined by the <code>And</code>
     * logical operator. Only one of each filter condition is allowed.
     * </p>
     * 
     * @return A logical operator that allows multiple filter conditions to be joined for more complex comparisons of
     *         Storage Lens group data. Objects must match all of the listed filter conditions that are joined by the
     *         <code>And</code> logical operator. Only one of each filter condition is allowed.
     */
    public final StorageLensGroupAndOperator and() {
        return and;
    }

    /**
     * <p>
     * A single logical operator that allows multiple filter conditions to be joined. Objects can match any of the
     * listed filter conditions, which are joined by the <code>Or</code> logical operator. Only one of each filter
     * condition is allowed.
     * </p>
     * 
     * @return A single logical operator that allows multiple filter conditions to be joined. Objects can match any of
     *         the listed filter conditions, which are joined by the <code>Or</code> logical operator. Only one of each
     *         filter condition is allowed.
     */
    public final StorageLensGroupOrOperator or() {
        return or;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchAnyPrefix() ? matchAnyPrefix() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchAnySuffix() ? matchAnySuffix() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchAnyTag() ? matchAnyTag() : null);
        hashCode = 31 * hashCode + Objects.hashCode(matchObjectAge());
        hashCode = 31 * hashCode + Objects.hashCode(matchObjectSize());
        hashCode = 31 * hashCode + Objects.hashCode(and());
        hashCode = 31 * hashCode + Objects.hashCode(or());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageLensGroupFilter)) {
            return false;
        }
        StorageLensGroupFilter other = (StorageLensGroupFilter) obj;
        return hasMatchAnyPrefix() == other.hasMatchAnyPrefix() && Objects.equals(matchAnyPrefix(), other.matchAnyPrefix())
                && hasMatchAnySuffix() == other.hasMatchAnySuffix() && Objects.equals(matchAnySuffix(), other.matchAnySuffix())
                && hasMatchAnyTag() == other.hasMatchAnyTag() && Objects.equals(matchAnyTag(), other.matchAnyTag())
                && Objects.equals(matchObjectAge(), other.matchObjectAge())
                && Objects.equals(matchObjectSize(), other.matchObjectSize()) && Objects.equals(and(), other.and())
                && Objects.equals(or(), other.or());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StorageLensGroupFilter").add("MatchAnyPrefix", hasMatchAnyPrefix() ? matchAnyPrefix() : null)
                .add("MatchAnySuffix", hasMatchAnySuffix() ? matchAnySuffix() : null)
                .add("MatchAnyTag", hasMatchAnyTag() ? matchAnyTag() : null).add("MatchObjectAge", matchObjectAge())
                .add("MatchObjectSize", matchObjectSize()).add("And", and()).add("Or", or()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MatchAnyPrefix":
            return Optional.ofNullable(clazz.cast(matchAnyPrefix()));
        case "MatchAnySuffix":
            return Optional.ofNullable(clazz.cast(matchAnySuffix()));
        case "MatchAnyTag":
            return Optional.ofNullable(clazz.cast(matchAnyTag()));
        case "MatchObjectAge":
            return Optional.ofNullable(clazz.cast(matchObjectAge()));
        case "MatchObjectSize":
            return Optional.ofNullable(clazz.cast(matchObjectSize()));
        case "And":
            return Optional.ofNullable(clazz.cast(and()));
        case "Or":
            return Optional.ofNullable(clazz.cast(or()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MatchAnyPrefix", MATCH_ANY_PREFIX_FIELD);
        map.put("MatchAnySuffix", MATCH_ANY_SUFFIX_FIELD);
        map.put("MatchAnyTag", MATCH_ANY_TAG_FIELD);
        map.put("MatchObjectAge", MATCH_OBJECT_AGE_FIELD);
        map.put("MatchObjectSize", MATCH_OBJECT_SIZE_FIELD);
        map.put("And", AND_FIELD);
        map.put("Or", OR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StorageLensGroupFilter, T> g) {
        return obj -> g.apply((StorageLensGroupFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StorageLensGroupFilter> {
        /**
         * <p>
         * Contains a list of prefixes. At least one prefix must be specified. Up to 10 prefixes are allowed.
         * </p>
         * 
         * @param matchAnyPrefix
         *        Contains a list of prefixes. At least one prefix must be specified. Up to 10 prefixes are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchAnyPrefix(Collection<String> matchAnyPrefix);

        /**
         * <p>
         * Contains a list of prefixes. At least one prefix must be specified. Up to 10 prefixes are allowed.
         * </p>
         * 
         * @param matchAnyPrefix
         *        Contains a list of prefixes. At least one prefix must be specified. Up to 10 prefixes are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchAnyPrefix(String... matchAnyPrefix);

        /**
         * <p>
         * Contains a list of suffixes. At least one suffix must be specified. Up to 10 suffixes are allowed.
         * </p>
         * 
         * @param matchAnySuffix
         *        Contains a list of suffixes. At least one suffix must be specified. Up to 10 suffixes are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchAnySuffix(Collection<String> matchAnySuffix);

        /**
         * <p>
         * Contains a list of suffixes. At least one suffix must be specified. Up to 10 suffixes are allowed.
         * </p>
         * 
         * @param matchAnySuffix
         *        Contains a list of suffixes. At least one suffix must be specified. Up to 10 suffixes are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchAnySuffix(String... matchAnySuffix);

        /**
         * <p>
         * Contains the list of S3 object tags. At least one object tag must be specified. Up to 10 object tags are
         * allowed.
         * </p>
         * 
         * @param matchAnyTag
         *        Contains the list of S3 object tags. At least one object tag must be specified. Up to 10 object tags
         *        are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchAnyTag(Collection<S3Tag> matchAnyTag);

        /**
         * <p>
         * Contains the list of S3 object tags. At least one object tag must be specified. Up to 10 object tags are
         * allowed.
         * </p>
         * 
         * @param matchAnyTag
         *        Contains the list of S3 object tags. At least one object tag must be specified. Up to 10 object tags
         *        are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchAnyTag(S3Tag... matchAnyTag);

        /**
         * <p>
         * Contains the list of S3 object tags. At least one object tag must be specified. Up to 10 object tags are
         * allowed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.s3control.model.S3Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.s3control.model.S3Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.s3control.model.S3Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #matchAnyTag(List<S3Tag>)}.
         * 
         * @param matchAnyTag
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.s3control.model.S3Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matchAnyTag(java.util.Collection<S3Tag>)
         */
        Builder matchAnyTag(Consumer<S3Tag.Builder>... matchAnyTag);

        /**
         * <p>
         * Contains <code>DaysGreaterThan</code> and <code>DaysLessThan</code> to define the object age range (minimum
         * and maximum number of days).
         * </p>
         * 
         * @param matchObjectAge
         *        Contains <code>DaysGreaterThan</code> and <code>DaysLessThan</code> to define the object age range
         *        (minimum and maximum number of days).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchObjectAge(MatchObjectAge matchObjectAge);

        /**
         * <p>
         * Contains <code>DaysGreaterThan</code> and <code>DaysLessThan</code> to define the object age range (minimum
         * and maximum number of days).
         * </p>
         * This is a convenience method that creates an instance of the {@link MatchObjectAge.Builder} avoiding the need
         * to create one manually via {@link MatchObjectAge#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MatchObjectAge.Builder#build()} is called immediately and its
         * result is passed to {@link #matchObjectAge(MatchObjectAge)}.
         * 
         * @param matchObjectAge
         *        a consumer that will call methods on {@link MatchObjectAge.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matchObjectAge(MatchObjectAge)
         */
        default Builder matchObjectAge(Consumer<MatchObjectAge.Builder> matchObjectAge) {
            return matchObjectAge(MatchObjectAge.builder().applyMutation(matchObjectAge).build());
        }

        /**
         * <p>
         * Contains <code>BytesGreaterThan</code> and <code>BytesLessThan</code> to define the object size range
         * (minimum and maximum number of Bytes).
         * </p>
         * 
         * @param matchObjectSize
         *        Contains <code>BytesGreaterThan</code> and <code>BytesLessThan</code> to define the object size range
         *        (minimum and maximum number of Bytes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchObjectSize(MatchObjectSize matchObjectSize);

        /**
         * <p>
         * Contains <code>BytesGreaterThan</code> and <code>BytesLessThan</code> to define the object size range
         * (minimum and maximum number of Bytes).
         * </p>
         * This is a convenience method that creates an instance of the {@link MatchObjectSize.Builder} avoiding the
         * need to create one manually via {@link MatchObjectSize#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MatchObjectSize.Builder#build()} is called immediately and its
         * result is passed to {@link #matchObjectSize(MatchObjectSize)}.
         * 
         * @param matchObjectSize
         *        a consumer that will call methods on {@link MatchObjectSize.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matchObjectSize(MatchObjectSize)
         */
        default Builder matchObjectSize(Consumer<MatchObjectSize.Builder> matchObjectSize) {
            return matchObjectSize(MatchObjectSize.builder().applyMutation(matchObjectSize).build());
        }

        /**
         * <p>
         * A logical operator that allows multiple filter conditions to be joined for more complex comparisons of
         * Storage Lens group data. Objects must match all of the listed filter conditions that are joined by the
         * <code>And</code> logical operator. Only one of each filter condition is allowed.
         * </p>
         * 
         * @param and
         *        A logical operator that allows multiple filter conditions to be joined for more complex comparisons of
         *        Storage Lens group data. Objects must match all of the listed filter conditions that are joined by the
         *        <code>And</code> logical operator. Only one of each filter condition is allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder and(StorageLensGroupAndOperator and);

        /**
         * <p>
         * A logical operator that allows multiple filter conditions to be joined for more complex comparisons of
         * Storage Lens group data. Objects must match all of the listed filter conditions that are joined by the
         * <code>And</code> logical operator. Only one of each filter condition is allowed.
         * </p>
         * This is a convenience method that creates an instance of the {@link StorageLensGroupAndOperator.Builder}
         * avoiding the need to create one manually via {@link StorageLensGroupAndOperator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageLensGroupAndOperator.Builder#build()} is called
         * immediately and its result is passed to {@link #and(StorageLensGroupAndOperator)}.
         * 
         * @param and
         *        a consumer that will call methods on {@link StorageLensGroupAndOperator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #and(StorageLensGroupAndOperator)
         */
        default Builder and(Consumer<StorageLensGroupAndOperator.Builder> and) {
            return and(StorageLensGroupAndOperator.builder().applyMutation(and).build());
        }

        /**
         * <p>
         * A single logical operator that allows multiple filter conditions to be joined. Objects can match any of the
         * listed filter conditions, which are joined by the <code>Or</code> logical operator. Only one of each filter
         * condition is allowed.
         * </p>
         * 
         * @param or
         *        A single logical operator that allows multiple filter conditions to be joined. Objects can match any
         *        of the listed filter conditions, which are joined by the <code>Or</code> logical operator. Only one of
         *        each filter condition is allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder or(StorageLensGroupOrOperator or);

        /**
         * <p>
         * A single logical operator that allows multiple filter conditions to be joined. Objects can match any of the
         * listed filter conditions, which are joined by the <code>Or</code> logical operator. Only one of each filter
         * condition is allowed.
         * </p>
         * This is a convenience method that creates an instance of the {@link StorageLensGroupOrOperator.Builder}
         * avoiding the need to create one manually via {@link StorageLensGroupOrOperator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageLensGroupOrOperator.Builder#build()} is called immediately
         * and its result is passed to {@link #or(StorageLensGroupOrOperator)}.
         * 
         * @param or
         *        a consumer that will call methods on {@link StorageLensGroupOrOperator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #or(StorageLensGroupOrOperator)
         */
        default Builder or(Consumer<StorageLensGroupOrOperator.Builder> or) {
            return or(StorageLensGroupOrOperator.builder().applyMutation(or).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> matchAnyPrefix = DefaultSdkAutoConstructList.getInstance();

        private List<String> matchAnySuffix = DefaultSdkAutoConstructList.getInstance();

        private List<S3Tag> matchAnyTag = DefaultSdkAutoConstructList.getInstance();

        private MatchObjectAge matchObjectAge;

        private MatchObjectSize matchObjectSize;

        private StorageLensGroupAndOperator and;

        private StorageLensGroupOrOperator or;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageLensGroupFilter model) {
            matchAnyPrefix(model.matchAnyPrefix);
            matchAnySuffix(model.matchAnySuffix);
            matchAnyTag(model.matchAnyTag);
            matchObjectAge(model.matchObjectAge);
            matchObjectSize(model.matchObjectSize);
            and(model.and);
            or(model.or);
        }

        public final Collection<String> getMatchAnyPrefix() {
            if (matchAnyPrefix instanceof SdkAutoConstructList) {
                return null;
            }
            return matchAnyPrefix;
        }

        public final void setMatchAnyPrefix(Collection<String> matchAnyPrefix) {
            this.matchAnyPrefix = MatchAnyPrefixCopier.copy(matchAnyPrefix);
        }

        @Override
        public final Builder matchAnyPrefix(Collection<String> matchAnyPrefix) {
            this.matchAnyPrefix = MatchAnyPrefixCopier.copy(matchAnyPrefix);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchAnyPrefix(String... matchAnyPrefix) {
            matchAnyPrefix(Arrays.asList(matchAnyPrefix));
            return this;
        }

        public final Collection<String> getMatchAnySuffix() {
            if (matchAnySuffix instanceof SdkAutoConstructList) {
                return null;
            }
            return matchAnySuffix;
        }

        public final void setMatchAnySuffix(Collection<String> matchAnySuffix) {
            this.matchAnySuffix = MatchAnySuffixCopier.copy(matchAnySuffix);
        }

        @Override
        public final Builder matchAnySuffix(Collection<String> matchAnySuffix) {
            this.matchAnySuffix = MatchAnySuffixCopier.copy(matchAnySuffix);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchAnySuffix(String... matchAnySuffix) {
            matchAnySuffix(Arrays.asList(matchAnySuffix));
            return this;
        }

        public final List<S3Tag.Builder> getMatchAnyTag() {
            List<S3Tag.Builder> result = MatchAnyTagCopier.copyToBuilder(this.matchAnyTag);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMatchAnyTag(Collection<S3Tag.BuilderImpl> matchAnyTag) {
            this.matchAnyTag = MatchAnyTagCopier.copyFromBuilder(matchAnyTag);
        }

        @Override
        public final Builder matchAnyTag(Collection<S3Tag> matchAnyTag) {
            this.matchAnyTag = MatchAnyTagCopier.copy(matchAnyTag);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchAnyTag(S3Tag... matchAnyTag) {
            matchAnyTag(Arrays.asList(matchAnyTag));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchAnyTag(Consumer<S3Tag.Builder>... matchAnyTag) {
            matchAnyTag(Stream.of(matchAnyTag).map(c -> S3Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final MatchObjectAge.Builder getMatchObjectAge() {
            return matchObjectAge != null ? matchObjectAge.toBuilder() : null;
        }

        public final void setMatchObjectAge(MatchObjectAge.BuilderImpl matchObjectAge) {
            this.matchObjectAge = matchObjectAge != null ? matchObjectAge.build() : null;
        }

        @Override
        public final Builder matchObjectAge(MatchObjectAge matchObjectAge) {
            this.matchObjectAge = matchObjectAge;
            return this;
        }

        public final MatchObjectSize.Builder getMatchObjectSize() {
            return matchObjectSize != null ? matchObjectSize.toBuilder() : null;
        }

        public final void setMatchObjectSize(MatchObjectSize.BuilderImpl matchObjectSize) {
            this.matchObjectSize = matchObjectSize != null ? matchObjectSize.build() : null;
        }

        @Override
        public final Builder matchObjectSize(MatchObjectSize matchObjectSize) {
            this.matchObjectSize = matchObjectSize;
            return this;
        }

        public final StorageLensGroupAndOperator.Builder getAnd() {
            return and != null ? and.toBuilder() : null;
        }

        public final void setAnd(StorageLensGroupAndOperator.BuilderImpl and) {
            this.and = and != null ? and.build() : null;
        }

        @Override
        public final Builder and(StorageLensGroupAndOperator and) {
            this.and = and;
            return this;
        }

        public final StorageLensGroupOrOperator.Builder getOr() {
            return or != null ? or.toBuilder() : null;
        }

        public final void setOr(StorageLensGroupOrOperator.BuilderImpl or) {
            this.or = or != null ? or.build() : null;
        }

        @Override
        public final Builder or(StorageLensGroupOrOperator or) {
            this.or = or;
            return this;
        }

        @Override
        public StorageLensGroupFilter build() {
            return new StorageLensGroupFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
