/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates which Storage Lens group ARNs to include or exclude in the Storage Lens group aggregation. You can only
 * attach Storage Lens groups to your Storage Lens dashboard if they're included in your Storage Lens group aggregation.
 * If this value is left null, then all Storage Lens groups are selected.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StorageLensGroupLevelSelectionCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<StorageLensGroupLevelSelectionCriteria.Builder, StorageLensGroupLevelSelectionCriteria> {
    private static final SdkField<List<String>> INCLUDE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Include")
            .getter(getter(StorageLensGroupLevelSelectionCriteria::include))
            .setter(setter(Builder::include))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Include")
                    .unmarshallLocationName("Include").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Arn")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Arn").unmarshallLocationName("Arn").build()).build()).build())
            .build();

    private static final SdkField<List<String>> EXCLUDE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Exclude")
            .getter(getter(StorageLensGroupLevelSelectionCriteria::exclude))
            .setter(setter(Builder::exclude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exclude")
                    .unmarshallLocationName("Exclude").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Arn")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Arn").unmarshallLocationName("Arn").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDE_FIELD, EXCLUDE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> include;

    private final List<String> exclude;

    private StorageLensGroupLevelSelectionCriteria(BuilderImpl builder) {
        this.include = builder.include;
        this.exclude = builder.exclude;
    }

    /**
     * For responses, this returns true if the service returned a value for the Include property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInclude() {
        return include != null && !(include instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates which Storage Lens group ARNs to include in the Storage Lens group aggregation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclude} method.
     * </p>
     * 
     * @return Indicates which Storage Lens group ARNs to include in the Storage Lens group aggregation.
     */
    public final List<String> include() {
        return include;
    }

    /**
     * For responses, this returns true if the service returned a value for the Exclude property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExclude() {
        return exclude != null && !(exclude instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates which Storage Lens group ARNs to exclude from the Storage Lens group aggregation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExclude} method.
     * </p>
     * 
     * @return Indicates which Storage Lens group ARNs to exclude from the Storage Lens group aggregation.
     */
    public final List<String> exclude() {
        return exclude;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInclude() ? include() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExclude() ? exclude() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageLensGroupLevelSelectionCriteria)) {
            return false;
        }
        StorageLensGroupLevelSelectionCriteria other = (StorageLensGroupLevelSelectionCriteria) obj;
        return hasInclude() == other.hasInclude() && Objects.equals(include(), other.include())
                && hasExclude() == other.hasExclude() && Objects.equals(exclude(), other.exclude());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StorageLensGroupLevelSelectionCriteria").add("Include", hasInclude() ? include() : null)
                .add("Exclude", hasExclude() ? exclude() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Include":
            return Optional.ofNullable(clazz.cast(include()));
        case "Exclude":
            return Optional.ofNullable(clazz.cast(exclude()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Include", INCLUDE_FIELD);
        map.put("Exclude", EXCLUDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StorageLensGroupLevelSelectionCriteria, T> g) {
        return obj -> g.apply((StorageLensGroupLevelSelectionCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StorageLensGroupLevelSelectionCriteria> {
        /**
         * <p>
         * Indicates which Storage Lens group ARNs to include in the Storage Lens group aggregation.
         * </p>
         * 
         * @param include
         *        Indicates which Storage Lens group ARNs to include in the Storage Lens group aggregation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(Collection<String> include);

        /**
         * <p>
         * Indicates which Storage Lens group ARNs to include in the Storage Lens group aggregation.
         * </p>
         * 
         * @param include
         *        Indicates which Storage Lens group ARNs to include in the Storage Lens group aggregation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(String... include);

        /**
         * <p>
         * Indicates which Storage Lens group ARNs to exclude from the Storage Lens group aggregation.
         * </p>
         * 
         * @param exclude
         *        Indicates which Storage Lens group ARNs to exclude from the Storage Lens group aggregation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclude(Collection<String> exclude);

        /**
         * <p>
         * Indicates which Storage Lens group ARNs to exclude from the Storage Lens group aggregation.
         * </p>
         * 
         * @param exclude
         *        Indicates which Storage Lens group ARNs to exclude from the Storage Lens group aggregation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclude(String... exclude);
    }

    static final class BuilderImpl implements Builder {
        private List<String> include = DefaultSdkAutoConstructList.getInstance();

        private List<String> exclude = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StorageLensGroupLevelSelectionCriteria model) {
            include(model.include);
            exclude(model.exclude);
        }

        public final Collection<String> getInclude() {
            if (include instanceof SdkAutoConstructList) {
                return null;
            }
            return include;
        }

        public final void setInclude(Collection<String> include) {
            this.include = StorageLensGroupLevelIncludeCopier.copy(include);
        }

        @Override
        public final Builder include(Collection<String> include) {
            this.include = StorageLensGroupLevelIncludeCopier.copy(include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder include(String... include) {
            include(Arrays.asList(include));
            return this;
        }

        public final Collection<String> getExclude() {
            if (exclude instanceof SdkAutoConstructList) {
                return null;
            }
            return exclude;
        }

        public final void setExclude(Collection<String> exclude) {
            this.exclude = StorageLensGroupLevelExcludeCopier.copy(exclude);
        }

        @Override
        public final Builder exclude(Collection<String> exclude) {
            this.exclude = StorageLensGroupLevelExcludeCopier.copy(exclude);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclude(String... exclude) {
            exclude(Arrays.asList(exclude));
            return this;
        }

        @Override
        public StorageLensGroupLevelSelectionCriteria build() {
            return new StorageLensGroupLevelSelectionCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
