/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAccessGrantsInstanceRequest extends S3ControlRequest implements
        ToCopyableBuilder<CreateAccessGrantsInstanceRequest.Builder, CreateAccessGrantsInstanceRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountId")
            .getter(getter(CreateAccessGrantsInstanceRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id")
                    .unmarshallLocationName("x-amz-account-id").build()).build();

    private static final SdkField<String> IDENTITY_CENTER_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdentityCenterArn")
            .getter(getter(CreateAccessGrantsInstanceRequest::identityCenterArn))
            .setter(setter(Builder::identityCenterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityCenterArn")
                    .unmarshallLocationName("IdentityCenterArn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateAccessGrantsInstanceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags")
                    .unmarshallLocationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").unmarshallLocationName("Tag").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            IDENTITY_CENTER_ARN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountId;

    private final String identityCenterArn;

    private final List<Tag> tags;

    private CreateAccessGrantsInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.identityCenterArn = builder.identityCenterArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the S3 Access Grants instance.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the S3 Access Grants instance.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * If you would like to associate your S3 Access Grants instance with an Amazon Web Services IAM Identity Center
     * instance, use this field to pass the Amazon Resource Name (ARN) of the Amazon Web Services IAM Identity Center
     * instance that you are associating with your S3 Access Grants instance. An IAM Identity Center instance is your
     * corporate identity directory that you added to the IAM Identity Center. You can use the <a
     * href="https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ListInstances.html">ListInstances</a> API
     * operation to retrieve a list of your Identity Center instances and their ARNs.
     * </p>
     * 
     * @return If you would like to associate your S3 Access Grants instance with an Amazon Web Services IAM Identity
     *         Center instance, use this field to pass the Amazon Resource Name (ARN) of the Amazon Web Services IAM
     *         Identity Center instance that you are associating with your S3 Access Grants instance. An IAM Identity
     *         Center instance is your corporate identity directory that you added to the IAM Identity Center. You can
     *         use the <a href="https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ListInstances.html">
     *         ListInstances</a> API operation to retrieve a list of your Identity Center instances and their ARNs.
     */
    public final String identityCenterArn() {
        return identityCenterArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services resource tags that you are adding to the S3 Access Grants instance. Each tag is a label
     * consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter
     * resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The Amazon Web Services resource tags that you are adding to the S3 Access Grants instance. Each tag is a
     *         label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search
     *         for, and filter resources.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(identityCenterArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessGrantsInstanceRequest)) {
            return false;
        }
        CreateAccessGrantsInstanceRequest other = (CreateAccessGrantsInstanceRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(identityCenterArn(), other.identityCenterArn())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAccessGrantsInstanceRequest").add("AccountId", accountId())
                .add("IdentityCenterArn", identityCenterArn()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "IdentityCenterArn":
            return Optional.ofNullable(clazz.cast(identityCenterArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("x-amz-account-id", ACCOUNT_ID_FIELD);
        map.put("IdentityCenterArn", IDENTITY_CENTER_ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessGrantsInstanceRequest, T> g) {
        return obj -> g.apply((CreateAccessGrantsInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends S3ControlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAccessGrantsInstanceRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID of the S3 Access Grants instance.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID of the S3 Access Grants instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * If you would like to associate your S3 Access Grants instance with an Amazon Web Services IAM Identity Center
         * instance, use this field to pass the Amazon Resource Name (ARN) of the Amazon Web Services IAM Identity
         * Center instance that you are associating with your S3 Access Grants instance. An IAM Identity Center instance
         * is your corporate identity directory that you added to the IAM Identity Center. You can use the <a
         * href="https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ListInstances.html">ListInstances</a>
         * API operation to retrieve a list of your Identity Center instances and their ARNs.
         * </p>
         * 
         * @param identityCenterArn
         *        If you would like to associate your S3 Access Grants instance with an Amazon Web Services IAM Identity
         *        Center instance, use this field to pass the Amazon Resource Name (ARN) of the Amazon Web Services IAM
         *        Identity Center instance that you are associating with your S3 Access Grants instance. An IAM Identity
         *        Center instance is your corporate identity directory that you added to the IAM Identity Center. You
         *        can use the <a
         *        href="https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ListInstances.html"
         *        >ListInstances</a> API operation to retrieve a list of your Identity Center instances and their ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityCenterArn(String identityCenterArn);

        /**
         * <p>
         * The Amazon Web Services resource tags that you are adding to the S3 Access Grants instance. Each tag is a
         * label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for,
         * and filter resources.
         * </p>
         * 
         * @param tags
         *        The Amazon Web Services resource tags that you are adding to the S3 Access Grants instance. Each tag
         *        is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize,
         *        search for, and filter resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The Amazon Web Services resource tags that you are adding to the S3 Access Grants instance. Each tag is a
         * label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for,
         * and filter resources.
         * </p>
         * 
         * @param tags
         *        The Amazon Web Services resource tags that you are adding to the S3 Access Grants instance. Each tag
         *        is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize,
         *        search for, and filter resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The Amazon Web Services resource tags that you are adding to the S3 Access Grants instance. Each tag is a
         * label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for,
         * and filter resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.s3control.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.s3control.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.s3control.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.s3control.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3ControlRequest.BuilderImpl implements Builder {
        private String accountId;

        private String identityCenterArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessGrantsInstanceRequest model) {
            super(model);
            accountId(model.accountId);
            identityCenterArn(model.identityCenterArn);
            tags(model.tags);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getIdentityCenterArn() {
            return identityCenterArn;
        }

        public final void setIdentityCenterArn(String identityCenterArn) {
            this.identityCenterArn = identityCenterArn;
        }

        @Override
        public final Builder identityCenterArn(String identityCenterArn) {
            this.identityCenterArn = identityCenterArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAccessGrantsInstanceRequest build() {
            return new CreateAccessGrantsInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
