/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter that returns objects that are encrypted by dual-layer server-side encryption with Amazon Web Services Key
 * Management Service (KMS) keys (DSSE-KMS). You can further refine your filtering by optionally providing a KMS Key ARN
 * to create an object list of DSSE-KMS objects with that specific KMS Key ARN.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DSSEKMSFilter implements SdkPojo, Serializable, ToCopyableBuilder<DSSEKMSFilter.Builder, DSSEKMSFilter> {
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn")
            .getter(getter(DSSEKMSFilter::kmsKeyArn))
            .setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn")
                    .unmarshallLocationName("KmsKeyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String kmsKeyArn;

    private DSSEKMSFilter(BuilderImpl builder) {
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the customer managed KMS key to use for the filter to return objects that are
     * encrypted by the specified key. For best performance, we recommend using the <code>KMSKeyArn</code> filter in
     * conjunction with other object metadata filters, like <code>MatchAnyPrefix</code>, <code>CreatedAfter</code>, or
     * <code>MatchAnyStorageClass</code>.
     * </p>
     * <note>
     * <p>
     * You must provide the full KMS Key ARN. You can't use an alias name or alias ARN. For more information, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN"> KMS keys</a> in the
     * <i>Amazon Web Services Key Management Service Developer Guide</i>.
     * </p>
     * </note>
     * 
     * @return The Amazon Resource Name (ARN) of the customer managed KMS key to use for the filter to return objects
     *         that are encrypted by the specified key. For best performance, we recommend using the
     *         <code>KMSKeyArn</code> filter in conjunction with other object metadata filters, like
     *         <code>MatchAnyPrefix</code>, <code>CreatedAfter</code>, or <code>MatchAnyStorageClass</code>.</p> <note>
     *         <p>
     *         You must provide the full KMS Key ARN. You can't use an alias name or alias ARN. For more information,
     *         see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN"> KMS
     *         keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.
     *         </p>
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DSSEKMSFilter)) {
            return false;
        }
        DSSEKMSFilter other = (DSSEKMSFilter) obj;
        return Objects.equals(kmsKeyArn(), other.kmsKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DSSEKMSFilter").add("KmsKeyArn", kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DSSEKMSFilter, T> g) {
        return obj -> g.apply((DSSEKMSFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DSSEKMSFilter> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the customer managed KMS key to use for the filter to return objects that
         * are encrypted by the specified key. For best performance, we recommend using the <code>KMSKeyArn</code>
         * filter in conjunction with other object metadata filters, like <code>MatchAnyPrefix</code>,
         * <code>CreatedAfter</code>, or <code>MatchAnyStorageClass</code>.
         * </p>
         * <note>
         * <p>
         * You must provide the full KMS Key ARN. You can't use an alias name or alias ARN. For more information, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN"> KMS keys</a> in
         * the <i>Amazon Web Services Key Management Service Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the customer managed KMS key to use for the filter to return objects
         *        that are encrypted by the specified key. For best performance, we recommend using the
         *        <code>KMSKeyArn</code> filter in conjunction with other object metadata filters, like
         *        <code>MatchAnyPrefix</code>, <code>CreatedAfter</code>, or <code>MatchAnyStorageClass</code>.</p>
         *        <note>
         *        <p>
         *        You must provide the full KMS Key ARN. You can't use an alias name or alias ARN. For more information,
         *        see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN"> KMS
         *        keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);
    }

    static final class BuilderImpl implements Builder {
        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DSSEKMSFilter model) {
            kmsKeyArn(model.kmsKeyArn);
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public DSSEKMSFilter build() {
            return new DSSEKMSFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
