/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccessGrantsInstanceForPrefixResponse extends S3ControlResponse implements
        ToCopyableBuilder<GetAccessGrantsInstanceForPrefixResponse.Builder, GetAccessGrantsInstanceForPrefixResponse> {
    private static final SdkField<String> ACCESS_GRANTS_INSTANCE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccessGrantsInstanceArn")
            .getter(getter(GetAccessGrantsInstanceForPrefixResponse::accessGrantsInstanceArn))
            .setter(setter(Builder::accessGrantsInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsInstanceArn")
                    .unmarshallLocationName("AccessGrantsInstanceArn").build()).build();

    private static final SdkField<String> ACCESS_GRANTS_INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccessGrantsInstanceId")
            .getter(getter(GetAccessGrantsInstanceForPrefixResponse::accessGrantsInstanceId))
            .setter(setter(Builder::accessGrantsInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsInstanceId")
                    .unmarshallLocationName("AccessGrantsInstanceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ACCESS_GRANTS_INSTANCE_ARN_FIELD, ACCESS_GRANTS_INSTANCE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accessGrantsInstanceArn;

    private final String accessGrantsInstanceId;

    private GetAccessGrantsInstanceForPrefixResponse(BuilderImpl builder) {
        super(builder);
        this.accessGrantsInstanceArn = builder.accessGrantsInstanceArn;
        this.accessGrantsInstanceId = builder.accessGrantsInstanceId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the S3 Access Grants instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the S3 Access Grants instance.
     */
    public final String accessGrantsInstanceArn() {
        return accessGrantsInstanceArn;
    }

    /**
     * <p>
     * The ID of the S3 Access Grants instance. The ID is <code>default</code>. You can have one S3 Access Grants
     * instance per Region per account.
     * </p>
     * 
     * @return The ID of the S3 Access Grants instance. The ID is <code>default</code>. You can have one S3 Access
     *         Grants instance per Region per account.
     */
    public final String accessGrantsInstanceId() {
        return accessGrantsInstanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessGrantsInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(accessGrantsInstanceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccessGrantsInstanceForPrefixResponse)) {
            return false;
        }
        GetAccessGrantsInstanceForPrefixResponse other = (GetAccessGrantsInstanceForPrefixResponse) obj;
        return Objects.equals(accessGrantsInstanceArn(), other.accessGrantsInstanceArn())
                && Objects.equals(accessGrantsInstanceId(), other.accessGrantsInstanceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAccessGrantsInstanceForPrefixResponse")
                .add("AccessGrantsInstanceArn", accessGrantsInstanceArn())
                .add("AccessGrantsInstanceId", accessGrantsInstanceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessGrantsInstanceArn":
            return Optional.ofNullable(clazz.cast(accessGrantsInstanceArn()));
        case "AccessGrantsInstanceId":
            return Optional.ofNullable(clazz.cast(accessGrantsInstanceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccessGrantsInstanceArn", ACCESS_GRANTS_INSTANCE_ARN_FIELD);
        map.put("AccessGrantsInstanceId", ACCESS_GRANTS_INSTANCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAccessGrantsInstanceForPrefixResponse, T> g) {
        return obj -> g.apply((GetAccessGrantsInstanceForPrefixResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends S3ControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAccessGrantsInstanceForPrefixResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the S3 Access Grants instance.
         * </p>
         * 
         * @param accessGrantsInstanceArn
         *        The Amazon Resource Name (ARN) of the S3 Access Grants instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessGrantsInstanceArn(String accessGrantsInstanceArn);

        /**
         * <p>
         * The ID of the S3 Access Grants instance. The ID is <code>default</code>. You can have one S3 Access Grants
         * instance per Region per account.
         * </p>
         * 
         * @param accessGrantsInstanceId
         *        The ID of the S3 Access Grants instance. The ID is <code>default</code>. You can have one S3 Access
         *        Grants instance per Region per account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessGrantsInstanceId(String accessGrantsInstanceId);
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private String accessGrantsInstanceArn;

        private String accessGrantsInstanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccessGrantsInstanceForPrefixResponse model) {
            super(model);
            accessGrantsInstanceArn(model.accessGrantsInstanceArn);
            accessGrantsInstanceId(model.accessGrantsInstanceId);
        }

        public final String getAccessGrantsInstanceArn() {
            return accessGrantsInstanceArn;
        }

        public final void setAccessGrantsInstanceArn(String accessGrantsInstanceArn) {
            this.accessGrantsInstanceArn = accessGrantsInstanceArn;
        }

        @Override
        public final Builder accessGrantsInstanceArn(String accessGrantsInstanceArn) {
            this.accessGrantsInstanceArn = accessGrantsInstanceArn;
            return this;
        }

        public final String getAccessGrantsInstanceId() {
            return accessGrantsInstanceId;
        }

        public final void setAccessGrantsInstanceId(String accessGrantsInstanceId) {
            this.accessGrantsInstanceId = accessGrantsInstanceId;
        }

        @Override
        public final Builder accessGrantsInstanceId(String accessGrantsInstanceId) {
            this.accessGrantsInstanceId = accessGrantsInstanceId;
            return this;
        }

        @Override
        public GetAccessGrantsInstanceForPrefixResponse build() {
            return new GetAccessGrantsInstanceForPrefixResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
