/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataAccessResponse extends S3ControlResponse implements
        ToCopyableBuilder<GetDataAccessResponse.Builder, GetDataAccessResponse> {
    private static final SdkField<Credentials> CREDENTIALS_FIELD = SdkField
            .<Credentials> builder(MarshallingType.SDK_POJO)
            .memberName("Credentials")
            .getter(getter(GetDataAccessResponse::credentials))
            .setter(setter(Builder::credentials))
            .constructor(Credentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials")
                    .unmarshallLocationName("Credentials").build()).build();

    private static final SdkField<String> MATCHED_GRANT_TARGET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MatchedGrantTarget")
            .getter(getter(GetDataAccessResponse::matchedGrantTarget))
            .setter(setter(Builder::matchedGrantTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchedGrantTarget")
                    .unmarshallLocationName("MatchedGrantTarget").build()).build();

    private static final SdkField<Grantee> GRANTEE_FIELD = SdkField
            .<Grantee> builder(MarshallingType.SDK_POJO)
            .memberName("Grantee")
            .getter(getter(GetDataAccessResponse::grantee))
            .setter(setter(Builder::grantee))
            .constructor(Grantee::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Grantee")
                    .unmarshallLocationName("Grantee").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_FIELD,
            MATCHED_GRANT_TARGET_FIELD, GRANTEE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Credentials credentials;

    private final String matchedGrantTarget;

    private final Grantee grantee;

    private GetDataAccessResponse(BuilderImpl builder) {
        super(builder);
        this.credentials = builder.credentials;
        this.matchedGrantTarget = builder.matchedGrantTarget;
        this.grantee = builder.grantee;
    }

    /**
     * <p>
     * The temporary credential token that S3 Access Grants vends.
     * </p>
     * 
     * @return The temporary credential token that S3 Access Grants vends.
     */
    public final Credentials credentials() {
        return credentials;
    }

    /**
     * <p>
     * The S3 URI path of the data to which you are being granted temporary access credentials.
     * </p>
     * 
     * @return The S3 URI path of the data to which you are being granted temporary access credentials.
     */
    public final String matchedGrantTarget() {
        return matchedGrantTarget;
    }

    /**
     * <p>
     * The user, group, or role that was granted access to the S3 location scope. For directory identities, this API
     * also returns the grants of the IAM role used for the identity-aware request. For more information on
     * identity-aware sessions, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_sts-setcontext.html"
     * >Granting permissions to use identity-aware console sessions</a>.
     * </p>
     * 
     * @return The user, group, or role that was granted access to the S3 location scope. For directory identities, this
     *         API also returns the grants of the IAM role used for the identity-aware request. For more information on
     *         identity-aware sessions, see <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_sts-setcontext.html"
     *         >Granting permissions to use identity-aware console sessions</a>.
     */
    public final Grantee grantee() {
        return grantee;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(credentials());
        hashCode = 31 * hashCode + Objects.hashCode(matchedGrantTarget());
        hashCode = 31 * hashCode + Objects.hashCode(grantee());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataAccessResponse)) {
            return false;
        }
        GetDataAccessResponse other = (GetDataAccessResponse) obj;
        return Objects.equals(credentials(), other.credentials())
                && Objects.equals(matchedGrantTarget(), other.matchedGrantTarget()) && Objects.equals(grantee(), other.grantee());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataAccessResponse")
                .add("Credentials", credentials() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MatchedGrantTarget", matchedGrantTarget()).add("Grantee", grantee()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        case "MatchedGrantTarget":
            return Optional.ofNullable(clazz.cast(matchedGrantTarget()));
        case "Grantee":
            return Optional.ofNullable(clazz.cast(grantee()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Credentials", CREDENTIALS_FIELD);
        map.put("MatchedGrantTarget", MATCHED_GRANT_TARGET_FIELD);
        map.put("Grantee", GRANTEE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataAccessResponse, T> g) {
        return obj -> g.apply((GetDataAccessResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends S3ControlResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDataAccessResponse> {
        /**
         * <p>
         * The temporary credential token that S3 Access Grants vends.
         * </p>
         * 
         * @param credentials
         *        The temporary credential token that S3 Access Grants vends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(Credentials credentials);

        /**
         * <p>
         * The temporary credential token that S3 Access Grants vends.
         * </p>
         * This is a convenience method that creates an instance of the {@link Credentials.Builder} avoiding the need to
         * create one manually via {@link Credentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Credentials.Builder#build()} is called immediately and its result
         * is passed to {@link #credentials(Credentials)}.
         * 
         * @param credentials
         *        a consumer that will call methods on {@link Credentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(Credentials)
         */
        default Builder credentials(Consumer<Credentials.Builder> credentials) {
            return credentials(Credentials.builder().applyMutation(credentials).build());
        }

        /**
         * <p>
         * The S3 URI path of the data to which you are being granted temporary access credentials.
         * </p>
         * 
         * @param matchedGrantTarget
         *        The S3 URI path of the data to which you are being granted temporary access credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchedGrantTarget(String matchedGrantTarget);

        /**
         * <p>
         * The user, group, or role that was granted access to the S3 location scope. For directory identities, this API
         * also returns the grants of the IAM role used for the identity-aware request. For more information on
         * identity-aware sessions, see <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_sts-setcontext.html"
         * >Granting permissions to use identity-aware console sessions</a>.
         * </p>
         * 
         * @param grantee
         *        The user, group, or role that was granted access to the S3 location scope. For directory identities,
         *        this API also returns the grants of the IAM role used for the identity-aware request. For more
         *        information on identity-aware sessions, see <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_sts-setcontext.html"
         *        >Granting permissions to use identity-aware console sessions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantee(Grantee grantee);

        /**
         * <p>
         * The user, group, or role that was granted access to the S3 location scope. For directory identities, this API
         * also returns the grants of the IAM role used for the identity-aware request. For more information on
         * identity-aware sessions, see <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_sts-setcontext.html"
         * >Granting permissions to use identity-aware console sessions</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Grantee.Builder} avoiding the need to
         * create one manually via {@link Grantee#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Grantee.Builder#build()} is called immediately and its result is
         * passed to {@link #grantee(Grantee)}.
         * 
         * @param grantee
         *        a consumer that will call methods on {@link Grantee.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grantee(Grantee)
         */
        default Builder grantee(Consumer<Grantee.Builder> grantee) {
            return grantee(Grantee.builder().applyMutation(grantee).build());
        }
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private Credentials credentials;

        private String matchedGrantTarget;

        private Grantee grantee;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataAccessResponse model) {
            super(model);
            credentials(model.credentials);
            matchedGrantTarget(model.matchedGrantTarget);
            grantee(model.grantee);
        }

        public final Credentials.Builder getCredentials() {
            return credentials != null ? credentials.toBuilder() : null;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final String getMatchedGrantTarget() {
            return matchedGrantTarget;
        }

        public final void setMatchedGrantTarget(String matchedGrantTarget) {
            this.matchedGrantTarget = matchedGrantTarget;
        }

        @Override
        public final Builder matchedGrantTarget(String matchedGrantTarget) {
            this.matchedGrantTarget = matchedGrantTarget;
            return this;
        }

        public final Grantee.Builder getGrantee() {
            return grantee != null ? grantee.toBuilder() : null;
        }

        public final void setGrantee(Grantee.BuilderImpl grantee) {
            this.grantee = grantee != null ? grantee.build() : null;
        }

        @Override
        public final Builder grantee(Grantee grantee) {
            this.grantee = grantee;
            return this;
        }

        @Override
        public GetDataAccessResponse build() {
            return new GetDataAccessResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
