/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMultiRegionAccessPointRoutesResponse extends S3ControlResponse implements
        ToCopyableBuilder<GetMultiRegionAccessPointRoutesResponse.Builder, GetMultiRegionAccessPointRoutesResponse> {
    private static final SdkField<String> MRAP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Mrap")
            .getter(getter(GetMultiRegionAccessPointRoutesResponse::mrap))
            .setter(setter(Builder::mrap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mrap")
                    .unmarshallLocationName("Mrap").build()).build();

    private static final SdkField<List<MultiRegionAccessPointRoute>> ROUTES_FIELD = SdkField
            .<List<MultiRegionAccessPointRoute>> builder(MarshallingType.LIST)
            .memberName("Routes")
            .getter(getter(GetMultiRegionAccessPointRoutesResponse::routes))
            .setter(setter(Builder::routes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Routes")
                    .unmarshallLocationName("Routes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Route")
                            .memberFieldInfo(
                                    SdkField.<MultiRegionAccessPointRoute> builder(MarshallingType.SDK_POJO)
                                            .constructor(MultiRegionAccessPointRoute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Route").unmarshallLocationName("Route").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MRAP_FIELD, ROUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String mrap;

    private final List<MultiRegionAccessPointRoute> routes;

    private GetMultiRegionAccessPointRoutesResponse(BuilderImpl builder) {
        super(builder);
        this.mrap = builder.mrap;
        this.routes = builder.routes;
    }

    /**
     * <p>
     * The Multi-Region Access Point ARN.
     * </p>
     * 
     * @return The Multi-Region Access Point ARN.
     */
    public final String mrap() {
        return mrap;
    }

    /**
     * For responses, this returns true if the service returned a value for the Routes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRoutes() {
        return routes != null && !(routes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The different routes that make up the route configuration. Active routes return a value of <code>100</code>, and
     * passive routes return a value of <code>0</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoutes} method.
     * </p>
     * 
     * @return The different routes that make up the route configuration. Active routes return a value of
     *         <code>100</code>, and passive routes return a value of <code>0</code>.
     */
    public final List<MultiRegionAccessPointRoute> routes() {
        return routes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mrap());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutes() ? routes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMultiRegionAccessPointRoutesResponse)) {
            return false;
        }
        GetMultiRegionAccessPointRoutesResponse other = (GetMultiRegionAccessPointRoutesResponse) obj;
        return Objects.equals(mrap(), other.mrap()) && hasRoutes() == other.hasRoutes()
                && Objects.equals(routes(), other.routes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMultiRegionAccessPointRoutesResponse").add("Mrap", mrap())
                .add("Routes", hasRoutes() ? routes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mrap":
            return Optional.ofNullable(clazz.cast(mrap()));
        case "Routes":
            return Optional.ofNullable(clazz.cast(routes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Mrap", MRAP_FIELD);
        map.put("Routes", ROUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMultiRegionAccessPointRoutesResponse, T> g) {
        return obj -> g.apply((GetMultiRegionAccessPointRoutesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends S3ControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetMultiRegionAccessPointRoutesResponse> {
        /**
         * <p>
         * The Multi-Region Access Point ARN.
         * </p>
         * 
         * @param mrap
         *        The Multi-Region Access Point ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mrap(String mrap);

        /**
         * <p>
         * The different routes that make up the route configuration. Active routes return a value of <code>100</code>,
         * and passive routes return a value of <code>0</code>.
         * </p>
         * 
         * @param routes
         *        The different routes that make up the route configuration. Active routes return a value of
         *        <code>100</code>, and passive routes return a value of <code>0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(Collection<MultiRegionAccessPointRoute> routes);

        /**
         * <p>
         * The different routes that make up the route configuration. Active routes return a value of <code>100</code>,
         * and passive routes return a value of <code>0</code>.
         * </p>
         * 
         * @param routes
         *        The different routes that make up the route configuration. Active routes return a value of
         *        <code>100</code>, and passive routes return a value of <code>0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(MultiRegionAccessPointRoute... routes);

        /**
         * <p>
         * The different routes that make up the route configuration. Active routes return a value of <code>100</code>,
         * and passive routes return a value of <code>0</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointRoute.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointRoute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointRoute.Builder#build()} is called
         * immediately and its result is passed to {@link #routes(List<MultiRegionAccessPointRoute>)}.
         * 
         * @param routes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routes(java.util.Collection<MultiRegionAccessPointRoute>)
         */
        Builder routes(Consumer<MultiRegionAccessPointRoute.Builder>... routes);
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private String mrap;

        private List<MultiRegionAccessPointRoute> routes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMultiRegionAccessPointRoutesResponse model) {
            super(model);
            mrap(model.mrap);
            routes(model.routes);
        }

        public final String getMrap() {
            return mrap;
        }

        public final void setMrap(String mrap) {
            this.mrap = mrap;
        }

        @Override
        public final Builder mrap(String mrap) {
            this.mrap = mrap;
            return this;
        }

        public final List<MultiRegionAccessPointRoute.Builder> getRoutes() {
            List<MultiRegionAccessPointRoute.Builder> result = RouteListCopier.copyToBuilder(this.routes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutes(Collection<MultiRegionAccessPointRoute.BuilderImpl> routes) {
            this.routes = RouteListCopier.copyFromBuilder(routes);
        }

        @Override
        public final Builder routes(Collection<MultiRegionAccessPointRoute> routes) {
            this.routes = RouteListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(MultiRegionAccessPointRoute... routes) {
            routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<MultiRegionAccessPointRoute.Builder>... routes) {
            routes(Stream.of(routes).map(c -> MultiRegionAccessPointRoute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetMultiRegionAccessPointRoutesResponse build() {
            return new GetMultiRegionAccessPointRoutesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
