/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration and status information for a single job retrieved as part of a job list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobListDescriptor implements SdkPojo, Serializable,
        ToCopyableBuilder<JobListDescriptor.Builder, JobListDescriptor> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("JobId")
            .getter(getter(JobListDescriptor::jobId))
            .setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId")
                    .unmarshallLocationName("JobId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(JobListDescriptor::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<String> OPERATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Operation")
            .getter(getter(JobListDescriptor::operationAsString))
            .setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation")
                    .unmarshallLocationName("Operation").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority")
            .getter(getter(JobListDescriptor::priority))
            .setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority")
                    .unmarshallLocationName("Priority").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(JobListDescriptor::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(JobListDescriptor::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime")
                    .unmarshallLocationName("CreationTime").build()).build();

    private static final SdkField<Instant> TERMINATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("TerminationDate")
            .getter(getter(JobListDescriptor::terminationDate))
            .setter(setter(Builder::terminationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationDate")
                    .unmarshallLocationName("TerminationDate").build()).build();

    private static final SdkField<JobProgressSummary> PROGRESS_SUMMARY_FIELD = SdkField
            .<JobProgressSummary> builder(MarshallingType.SDK_POJO)
            .memberName("ProgressSummary")
            .getter(getter(JobListDescriptor::progressSummary))
            .setter(setter(Builder::progressSummary))
            .constructor(JobProgressSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressSummary")
                    .unmarshallLocationName("ProgressSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            DESCRIPTION_FIELD, OPERATION_FIELD, PRIORITY_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, TERMINATION_DATE_FIELD,
            PROGRESS_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String jobId;

    private final String description;

    private final String operation;

    private final Integer priority;

    private final String status;

    private final Instant creationTime;

    private final Instant terminationDate;

    private final JobProgressSummary progressSummary;

    private JobListDescriptor(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.description = builder.description;
        this.operation = builder.operation;
        this.priority = builder.priority;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.terminationDate = builder.terminationDate;
        this.progressSummary = builder.progressSummary;
    }

    /**
     * <p>
     * The ID for the specified job.
     * </p>
     * 
     * @return The ID for the specified job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The user-specified description that was included in the specified job's <code>Create Job</code> request.
     * </p>
     * 
     * @return The user-specified description that was included in the specified job's <code>Create Job</code> request.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The operation that the specified job is configured to run on every object listed in the manifest.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operation} will
     * return {@link OperationName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationAsString}.
     * </p>
     * 
     * @return The operation that the specified job is configured to run on every object listed in the manifest.
     * @see OperationName
     */
    public final OperationName operation() {
        return OperationName.fromValue(operation);
    }

    /**
     * <p>
     * The operation that the specified job is configured to run on every object listed in the manifest.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operation} will
     * return {@link OperationName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationAsString}.
     * </p>
     * 
     * @return The operation that the specified job is configured to run on every object listed in the manifest.
     * @see OperationName
     */
    public final String operationAsString() {
        return operation;
    }

    /**
     * <p>
     * The current priority for the specified job.
     * </p>
     * 
     * @return The current priority for the specified job.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The specified job's current status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The specified job's current status.
     * @see JobStatus
     */
    public final JobStatus status() {
        return JobStatus.fromValue(status);
    }

    /**
     * <p>
     * The specified job's current status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The specified job's current status.
     * @see JobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A timestamp indicating when the specified job was created.
     * </p>
     * 
     * @return A timestamp indicating when the specified job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * A timestamp indicating when the specified job terminated. A job's termination date is the date and time when it
     * succeeded, failed, or was canceled.
     * </p>
     * 
     * @return A timestamp indicating when the specified job terminated. A job's termination date is the date and time
     *         when it succeeded, failed, or was canceled.
     */
    public final Instant terminationDate() {
        return terminationDate;
    }

    /**
     * <p>
     * Describes the total number of tasks that the specified job has run, the number of tasks that succeeded, and the
     * number of tasks that failed.
     * </p>
     * 
     * @return Describes the total number of tasks that the specified job has run, the number of tasks that succeeded,
     *         and the number of tasks that failed.
     */
    public final JobProgressSummary progressSummary() {
        return progressSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(operationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(terminationDate());
        hashCode = 31 * hashCode + Objects.hashCode(progressSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobListDescriptor)) {
            return false;
        }
        JobListDescriptor other = (JobListDescriptor) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(description(), other.description())
                && Objects.equals(operationAsString(), other.operationAsString()) && Objects.equals(priority(), other.priority())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(terminationDate(), other.terminationDate())
                && Objects.equals(progressSummary(), other.progressSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobListDescriptor").add("JobId", jobId()).add("Description", description())
                .add("Operation", operationAsString()).add("Priority", priority()).add("Status", statusAsString())
                .add("CreationTime", creationTime()).add("TerminationDate", terminationDate())
                .add("ProgressSummary", progressSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Operation":
            return Optional.ofNullable(clazz.cast(operationAsString()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "TerminationDate":
            return Optional.ofNullable(clazz.cast(terminationDate()));
        case "ProgressSummary":
            return Optional.ofNullable(clazz.cast(progressSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JobId", JOB_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Operation", OPERATION_FIELD);
        map.put("Priority", PRIORITY_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("TerminationDate", TERMINATION_DATE_FIELD);
        map.put("ProgressSummary", PROGRESS_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobListDescriptor, T> g) {
        return obj -> g.apply((JobListDescriptor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobListDescriptor> {
        /**
         * <p>
         * The ID for the specified job.
         * </p>
         * 
         * @param jobId
         *        The ID for the specified job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The user-specified description that was included in the specified job's <code>Create Job</code> request.
         * </p>
         * 
         * @param description
         *        The user-specified description that was included in the specified job's <code>Create Job</code>
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The operation that the specified job is configured to run on every object listed in the manifest.
         * </p>
         * 
         * @param operation
         *        The operation that the specified job is configured to run on every object listed in the manifest.
         * @see OperationName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationName
         */
        Builder operation(String operation);

        /**
         * <p>
         * The operation that the specified job is configured to run on every object listed in the manifest.
         * </p>
         * 
         * @param operation
         *        The operation that the specified job is configured to run on every object listed in the manifest.
         * @see OperationName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationName
         */
        Builder operation(OperationName operation);

        /**
         * <p>
         * The current priority for the specified job.
         * </p>
         * 
         * @param priority
         *        The current priority for the specified job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The specified job's current status.
         * </p>
         * 
         * @param status
         *        The specified job's current status.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The specified job's current status.
         * </p>
         * 
         * @param status
         *        The specified job's current status.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(JobStatus status);

        /**
         * <p>
         * A timestamp indicating when the specified job was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp indicating when the specified job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * A timestamp indicating when the specified job terminated. A job's termination date is the date and time when
         * it succeeded, failed, or was canceled.
         * </p>
         * 
         * @param terminationDate
         *        A timestamp indicating when the specified job terminated. A job's termination date is the date and
         *        time when it succeeded, failed, or was canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationDate(Instant terminationDate);

        /**
         * <p>
         * Describes the total number of tasks that the specified job has run, the number of tasks that succeeded, and
         * the number of tasks that failed.
         * </p>
         * 
         * @param progressSummary
         *        Describes the total number of tasks that the specified job has run, the number of tasks that
         *        succeeded, and the number of tasks that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressSummary(JobProgressSummary progressSummary);

        /**
         * <p>
         * Describes the total number of tasks that the specified job has run, the number of tasks that succeeded, and
         * the number of tasks that failed.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobProgressSummary.Builder} avoiding the
         * need to create one manually via {@link JobProgressSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobProgressSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #progressSummary(JobProgressSummary)}.
         * 
         * @param progressSummary
         *        a consumer that will call methods on {@link JobProgressSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #progressSummary(JobProgressSummary)
         */
        default Builder progressSummary(Consumer<JobProgressSummary.Builder> progressSummary) {
            return progressSummary(JobProgressSummary.builder().applyMutation(progressSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private String description;

        private String operation;

        private Integer priority;

        private String status;

        private Instant creationTime;

        private Instant terminationDate;

        private JobProgressSummary progressSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(JobListDescriptor model) {
            jobId(model.jobId);
            description(model.description);
            operation(model.operation);
            priority(model.priority);
            status(model.status);
            creationTime(model.creationTime);
            terminationDate(model.terminationDate);
            progressSummary(model.progressSummary);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(OperationName operation) {
            this.operation(operation == null ? null : operation.toString());
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getTerminationDate() {
            return terminationDate;
        }

        public final void setTerminationDate(Instant terminationDate) {
            this.terminationDate = terminationDate;
        }

        @Override
        public final Builder terminationDate(Instant terminationDate) {
            this.terminationDate = terminationDate;
            return this;
        }

        public final JobProgressSummary.Builder getProgressSummary() {
            return progressSummary != null ? progressSummary.toBuilder() : null;
        }

        public final void setProgressSummary(JobProgressSummary.BuilderImpl progressSummary) {
            this.progressSummary = progressSummary != null ? progressSummary.build() : null;
        }

        @Override
        public final Builder progressSummary(JobProgressSummary progressSummary) {
            this.progressSummary = progressSummary;
            return this;
        }

        @Override
        public JobListDescriptor build() {
            return new JobListDescriptor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
