/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Part of <code>ListCallerAccessGrantsResult</code>. Each entry includes the permission level (READ, WRITE, or
 * READWRITE) and the grant scope of the access grant. If the grant also includes an application ARN, the grantee can
 * only access the S3 data through this application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCallerAccessGrantsEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<ListCallerAccessGrantsEntry.Builder, ListCallerAccessGrantsEntry> {
    private static final SdkField<String> PERMISSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Permission")
            .getter(getter(ListCallerAccessGrantsEntry::permissionAsString))
            .setter(setter(Builder::permission))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permission")
                    .unmarshallLocationName("Permission").build()).build();

    private static final SdkField<String> GRANT_SCOPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GrantScope")
            .getter(getter(ListCallerAccessGrantsEntry::grantScope))
            .setter(setter(Builder::grantScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantScope")
                    .unmarshallLocationName("GrantScope").build()).build();

    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ApplicationArn")
            .getter(getter(ListCallerAccessGrantsEntry::applicationArn))
            .setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn")
                    .unmarshallLocationName("ApplicationArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSION_FIELD,
            GRANT_SCOPE_FIELD, APPLICATION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String permission;

    private final String grantScope;

    private final String applicationArn;

    private ListCallerAccessGrantsEntry(BuilderImpl builder) {
        this.permission = builder.permission;
        this.grantScope = builder.grantScope;
        this.applicationArn = builder.applicationArn;
    }

    /**
     * <p>
     * The type of permission granted, which can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>READ</code> - Grants read-only access to the S3 data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WRITE</code> - Grants write-only access to the S3 data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READWRITE</code> - Grants both read and write access to the S3 data.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link Permission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #permissionAsString}.
     * </p>
     * 
     * @return The type of permission granted, which can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>READ</code> - Grants read-only access to the S3 data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WRITE</code> - Grants write-only access to the S3 data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READWRITE</code> - Grants both read and write access to the S3 data.
     *         </p>
     *         </li>
     * @see Permission
     */
    public final Permission permission() {
        return Permission.fromValue(permission);
    }

    /**
     * <p>
     * The type of permission granted, which can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>READ</code> - Grants read-only access to the S3 data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WRITE</code> - Grants write-only access to the S3 data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READWRITE</code> - Grants both read and write access to the S3 data.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link Permission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #permissionAsString}.
     * </p>
     * 
     * @return The type of permission granted, which can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>READ</code> - Grants read-only access to the S3 data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WRITE</code> - Grants write-only access to the S3 data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READWRITE</code> - Grants both read and write access to the S3 data.
     *         </p>
     *         </li>
     * @see Permission
     */
    public final String permissionAsString() {
        return permission;
    }

    /**
     * <p>
     * The S3 path of the data to which you have been granted access.
     * </p>
     * 
     * @return The S3 path of the data to which you have been granted access.
     */
    public final String grantScope() {
        return grantScope;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center application associated with your
     * Identity Center instance. If the grant includes an application ARN, the grantee can only access the S3 data
     * through this application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center application associated with
     *         your Identity Center instance. If the grant includes an application ARN, the grantee can only access the
     *         S3 data through this application.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(permissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(grantScope());
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCallerAccessGrantsEntry)) {
            return false;
        }
        ListCallerAccessGrantsEntry other = (ListCallerAccessGrantsEntry) obj;
        return Objects.equals(permissionAsString(), other.permissionAsString())
                && Objects.equals(grantScope(), other.grantScope()) && Objects.equals(applicationArn(), other.applicationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCallerAccessGrantsEntry").add("Permission", permissionAsString())
                .add("GrantScope", grantScope()).add("ApplicationArn", applicationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Permission":
            return Optional.ofNullable(clazz.cast(permissionAsString()));
        case "GrantScope":
            return Optional.ofNullable(clazz.cast(grantScope()));
        case "ApplicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Permission", PERMISSION_FIELD);
        map.put("GrantScope", GRANT_SCOPE_FIELD);
        map.put("ApplicationArn", APPLICATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCallerAccessGrantsEntry, T> g) {
        return obj -> g.apply((ListCallerAccessGrantsEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListCallerAccessGrantsEntry> {
        /**
         * <p>
         * The type of permission granted, which can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READ</code> - Grants read-only access to the S3 data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WRITE</code> - Grants write-only access to the S3 data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READWRITE</code> - Grants both read and write access to the S3 data.
         * </p>
         * </li>
         * </ul>
         * 
         * @param permission
         *        The type of permission granted, which can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>READ</code> - Grants read-only access to the S3 data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WRITE</code> - Grants write-only access to the S3 data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READWRITE</code> - Grants both read and write access to the S3 data.
         *        </p>
         *        </li>
         * @see Permission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Permission
         */
        Builder permission(String permission);

        /**
         * <p>
         * The type of permission granted, which can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READ</code> - Grants read-only access to the S3 data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WRITE</code> - Grants write-only access to the S3 data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READWRITE</code> - Grants both read and write access to the S3 data.
         * </p>
         * </li>
         * </ul>
         * 
         * @param permission
         *        The type of permission granted, which can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>READ</code> - Grants read-only access to the S3 data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WRITE</code> - Grants write-only access to the S3 data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READWRITE</code> - Grants both read and write access to the S3 data.
         *        </p>
         *        </li>
         * @see Permission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Permission
         */
        Builder permission(Permission permission);

        /**
         * <p>
         * The S3 path of the data to which you have been granted access.
         * </p>
         * 
         * @param grantScope
         *        The S3 path of the data to which you have been granted access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantScope(String grantScope);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center application associated with your
         * Identity Center instance. If the grant includes an application ARN, the grantee can only access the S3 data
         * through this application.
         * </p>
         * 
         * @param applicationArn
         *        The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center application associated
         *        with your Identity Center instance. If the grant includes an application ARN, the grantee can only
         *        access the S3 data through this application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);
    }

    static final class BuilderImpl implements Builder {
        private String permission;

        private String grantScope;

        private String applicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCallerAccessGrantsEntry model) {
            permission(model.permission);
            grantScope(model.grantScope);
            applicationArn(model.applicationArn);
        }

        public final String getPermission() {
            return permission;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(Permission permission) {
            this.permission(permission == null ? null : permission.toString());
            return this;
        }

        public final String getGrantScope() {
            return grantScope;
        }

        public final void setGrantScope(String grantScope) {
            this.grantScope = grantScope;
        }

        @Override
        public final Builder grantScope(String grantScope) {
            this.grantScope = grantScope;
            return this;
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        @Override
        public ListCallerAccessGrantsEntry build() {
            return new ListCallerAccessGrantsEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
