/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An optional filter for the <code>S3JobManifestGenerator</code> that identifies the subset of objects by encryption
 * type. This filter is used to create an object list for S3 Batch Operations jobs. If provided, this filter will
 * generate an object list that only includes objects with the specified encryption type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ObjectEncryptionFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ObjectEncryptionFilter.Builder, ObjectEncryptionFilter> {
    private static final SdkField<SSES3Filter> SSES3_FIELD = SdkField
            .<SSES3Filter> builder(MarshallingType.SDK_POJO)
            .memberName("SSES3")
            .getter(getter(ObjectEncryptionFilter::sses3))
            .setter(setter(Builder::sses3))
            .constructor(SSES3Filter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSE-S3")
                    .unmarshallLocationName("SSE-S3").build()).build();

    private static final SdkField<SSEKMSFilter> SSEKMS_FIELD = SdkField
            .<SSEKMSFilter> builder(MarshallingType.SDK_POJO)
            .memberName("SSEKMS")
            .getter(getter(ObjectEncryptionFilter::ssekms))
            .setter(setter(Builder::ssekms))
            .constructor(SSEKMSFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSE-KMS")
                    .unmarshallLocationName("SSE-KMS").build()).build();

    private static final SdkField<DSSEKMSFilter> DSSEKMS_FIELD = SdkField
            .<DSSEKMSFilter> builder(MarshallingType.SDK_POJO)
            .memberName("DSSEKMS")
            .getter(getter(ObjectEncryptionFilter::dssekms))
            .setter(setter(Builder::dssekms))
            .constructor(DSSEKMSFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DSSE-KMS")
                    .unmarshallLocationName("DSSE-KMS").build()).build();

    private static final SdkField<SSECFilter> SSEC_FIELD = SdkField
            .<SSECFilter> builder(MarshallingType.SDK_POJO)
            .memberName("SSEC")
            .getter(getter(ObjectEncryptionFilter::ssec))
            .setter(setter(Builder::ssec))
            .constructor(SSECFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSE-C")
                    .unmarshallLocationName("SSE-C").build()).build();

    private static final SdkField<NotSSEFilter> NOTSSE_FIELD = SdkField
            .<NotSSEFilter> builder(MarshallingType.SDK_POJO)
            .memberName("NOTSSE")
            .getter(getter(ObjectEncryptionFilter::notsse))
            .setter(setter(Builder::notsse))
            .constructor(NotSSEFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NOT-SSE")
                    .unmarshallLocationName("NOT-SSE").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SSES3_FIELD, SSEKMS_FIELD,
            DSSEKMS_FIELD, SSEC_FIELD, NOTSSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SSES3Filter sses3;

    private final SSEKMSFilter ssekms;

    private final DSSEKMSFilter dssekms;

    private final SSECFilter ssec;

    private final NotSSEFilter notsse;

    private final Type type;

    private ObjectEncryptionFilter(BuilderImpl builder) {
        this.sses3 = builder.sses3;
        this.ssekms = builder.ssekms;
        this.dssekms = builder.dssekms;
        this.ssec = builder.ssec;
        this.notsse = builder.notsse;
        this.type = builder.type;
    }

    /**
     * <p>
     * Filters for objects that are encrypted by server-side encryption with Amazon S3 managed keys (SSE-S3).
     * </p>
     * 
     * @return Filters for objects that are encrypted by server-side encryption with Amazon S3 managed keys (SSE-S3).
     */
    public final SSES3Filter sses3() {
        return sses3;
    }

    /**
     * <p>
     * Filters for objects that are encrypted by server-side encryption with Amazon Web Services Key Management Service
     * (KMS) keys (SSE-KMS).
     * </p>
     * 
     * @return Filters for objects that are encrypted by server-side encryption with Amazon Web Services Key Management
     *         Service (KMS) keys (SSE-KMS).
     */
    public final SSEKMSFilter ssekms() {
        return ssekms;
    }

    /**
     * <p>
     * Filters for objects that are encrypted by dual-layer server-side encryption with Amazon Web Services Key
     * Management Service (KMS) keys (DSSE-KMS).
     * </p>
     * 
     * @return Filters for objects that are encrypted by dual-layer server-side encryption with Amazon Web Services Key
     *         Management Service (KMS) keys (DSSE-KMS).
     */
    public final DSSEKMSFilter dssekms() {
        return dssekms;
    }

    /**
     * <p>
     * Filters for objects that are encrypted by server-side encryption with customer-provided keys (SSE-C).
     * </p>
     * 
     * @return Filters for objects that are encrypted by server-side encryption with customer-provided keys (SSE-C).
     */
    public final SSECFilter ssec() {
        return ssec;
    }

    /**
     * <p>
     * Filters for objects that are not encrypted by server-side encryption.
     * </p>
     * 
     * @return Filters for objects that are not encrypted by server-side encryption.
     */
    public final NotSSEFilter notsse() {
        return notsse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sses3());
        hashCode = 31 * hashCode + Objects.hashCode(ssekms());
        hashCode = 31 * hashCode + Objects.hashCode(dssekms());
        hashCode = 31 * hashCode + Objects.hashCode(ssec());
        hashCode = 31 * hashCode + Objects.hashCode(notsse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectEncryptionFilter)) {
            return false;
        }
        ObjectEncryptionFilter other = (ObjectEncryptionFilter) obj;
        return Objects.equals(sses3(), other.sses3()) && Objects.equals(ssekms(), other.ssekms())
                && Objects.equals(dssekms(), other.dssekms()) && Objects.equals(ssec(), other.ssec())
                && Objects.equals(notsse(), other.notsse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ObjectEncryptionFilter").add("SSES3", sses3()).add("SSEKMS", ssekms()).add("DSSEKMS", dssekms())
                .add("SSEC", ssec()).add("NOTSSE", notsse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SSES3":
            return Optional.ofNullable(clazz.cast(sses3()));
        case "SSEKMS":
            return Optional.ofNullable(clazz.cast(ssekms()));
        case "DSSEKMS":
            return Optional.ofNullable(clazz.cast(dssekms()));
        case "SSEC":
            return Optional.ofNullable(clazz.cast(ssec()));
        case "NOTSSE":
            return Optional.ofNullable(clazz.cast(notsse()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #sses3()} initialized to the given value.
     *
     * <p>
     * Filters for objects that are encrypted by server-side encryption with Amazon S3 managed keys (SSE-S3).
     * </p>
     * 
     * @param sses3
     *        Filters for objects that are encrypted by server-side encryption with Amazon S3 managed keys (SSE-S3).
     */
    public static ObjectEncryptionFilter fromSses3(SSES3Filter sses3) {
        return builder().sses3(sses3).build();
    }

    /**
     * Create an instance of this class with {@link #sses3()} initialized to the given value.
     *
     * <p>
     * Filters for objects that are encrypted by server-side encryption with Amazon S3 managed keys (SSE-S3).
     * </p>
     * 
     * @param sses3
     *        Filters for objects that are encrypted by server-side encryption with Amazon S3 managed keys (SSE-S3).
     */
    public static ObjectEncryptionFilter fromSses3(Consumer<SSES3Filter.Builder> sses3) {
        SSES3Filter.Builder builder = SSES3Filter.builder();
        sses3.accept(builder);
        return fromSses3(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ssekms()} initialized to the given value.
     *
     * <p>
     * Filters for objects that are encrypted by server-side encryption with Amazon Web Services Key Management Service
     * (KMS) keys (SSE-KMS).
     * </p>
     * 
     * @param ssekms
     *        Filters for objects that are encrypted by server-side encryption with Amazon Web Services Key Management
     *        Service (KMS) keys (SSE-KMS).
     */
    public static ObjectEncryptionFilter fromSsekms(SSEKMSFilter ssekms) {
        return builder().ssekms(ssekms).build();
    }

    /**
     * Create an instance of this class with {@link #ssekms()} initialized to the given value.
     *
     * <p>
     * Filters for objects that are encrypted by server-side encryption with Amazon Web Services Key Management Service
     * (KMS) keys (SSE-KMS).
     * </p>
     * 
     * @param ssekms
     *        Filters for objects that are encrypted by server-side encryption with Amazon Web Services Key Management
     *        Service (KMS) keys (SSE-KMS).
     */
    public static ObjectEncryptionFilter fromSsekms(Consumer<SSEKMSFilter.Builder> ssekms) {
        SSEKMSFilter.Builder builder = SSEKMSFilter.builder();
        ssekms.accept(builder);
        return fromSsekms(builder.build());
    }

    /**
     * Create an instance of this class with {@link #dssekms()} initialized to the given value.
     *
     * <p>
     * Filters for objects that are encrypted by dual-layer server-side encryption with Amazon Web Services Key
     * Management Service (KMS) keys (DSSE-KMS).
     * </p>
     * 
     * @param dssekms
     *        Filters for objects that are encrypted by dual-layer server-side encryption with Amazon Web Services Key
     *        Management Service (KMS) keys (DSSE-KMS).
     */
    public static ObjectEncryptionFilter fromDssekms(DSSEKMSFilter dssekms) {
        return builder().dssekms(dssekms).build();
    }

    /**
     * Create an instance of this class with {@link #dssekms()} initialized to the given value.
     *
     * <p>
     * Filters for objects that are encrypted by dual-layer server-side encryption with Amazon Web Services Key
     * Management Service (KMS) keys (DSSE-KMS).
     * </p>
     * 
     * @param dssekms
     *        Filters for objects that are encrypted by dual-layer server-side encryption with Amazon Web Services Key
     *        Management Service (KMS) keys (DSSE-KMS).
     */
    public static ObjectEncryptionFilter fromDssekms(Consumer<DSSEKMSFilter.Builder> dssekms) {
        DSSEKMSFilter.Builder builder = DSSEKMSFilter.builder();
        dssekms.accept(builder);
        return fromDssekms(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ssec()} initialized to the given value.
     *
     * <p>
     * Filters for objects that are encrypted by server-side encryption with customer-provided keys (SSE-C).
     * </p>
     * 
     * @param ssec
     *        Filters for objects that are encrypted by server-side encryption with customer-provided keys (SSE-C).
     */
    public static ObjectEncryptionFilter fromSsec(SSECFilter ssec) {
        return builder().ssec(ssec).build();
    }

    /**
     * Create an instance of this class with {@link #ssec()} initialized to the given value.
     *
     * <p>
     * Filters for objects that are encrypted by server-side encryption with customer-provided keys (SSE-C).
     * </p>
     * 
     * @param ssec
     *        Filters for objects that are encrypted by server-side encryption with customer-provided keys (SSE-C).
     */
    public static ObjectEncryptionFilter fromSsec(Consumer<SSECFilter.Builder> ssec) {
        SSECFilter.Builder builder = SSECFilter.builder();
        ssec.accept(builder);
        return fromSsec(builder.build());
    }

    /**
     * Create an instance of this class with {@link #notsse()} initialized to the given value.
     *
     * <p>
     * Filters for objects that are not encrypted by server-side encryption.
     * </p>
     * 
     * @param notsse
     *        Filters for objects that are not encrypted by server-side encryption.
     */
    public static ObjectEncryptionFilter fromNotsse(NotSSEFilter notsse) {
        return builder().notsse(notsse).build();
    }

    /**
     * Create an instance of this class with {@link #notsse()} initialized to the given value.
     *
     * <p>
     * Filters for objects that are not encrypted by server-side encryption.
     * </p>
     * 
     * @param notsse
     *        Filters for objects that are not encrypted by server-side encryption.
     */
    public static ObjectEncryptionFilter fromNotsse(Consumer<NotSSEFilter.Builder> notsse) {
        NotSSEFilter.Builder builder = NotSSEFilter.builder();
        notsse.accept(builder);
        return fromNotsse(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SSE-S3", SSES3_FIELD);
        map.put("SSE-KMS", SSEKMS_FIELD);
        map.put("DSSE-KMS", DSSEKMS_FIELD);
        map.put("SSE-C", SSEC_FIELD);
        map.put("NOT-SSE", NOTSSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ObjectEncryptionFilter, T> g) {
        return obj -> g.apply((ObjectEncryptionFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ObjectEncryptionFilter> {
        /**
         * <p>
         * Filters for objects that are encrypted by server-side encryption with Amazon S3 managed keys (SSE-S3).
         * </p>
         * 
         * @param sses3
         *        Filters for objects that are encrypted by server-side encryption with Amazon S3 managed keys (SSE-S3).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sses3(SSES3Filter sses3);

        /**
         * <p>
         * Filters for objects that are encrypted by server-side encryption with Amazon S3 managed keys (SSE-S3).
         * </p>
         * This is a convenience method that creates an instance of the {@link SSES3Filter.Builder} avoiding the need to
         * create one manually via {@link SSES3Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SSES3Filter.Builder#build()} is called immediately and its result
         * is passed to {@link #sses3(SSES3Filter)}.
         * 
         * @param sses3
         *        a consumer that will call methods on {@link SSES3Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sses3(SSES3Filter)
         */
        default Builder sses3(Consumer<SSES3Filter.Builder> sses3) {
            return sses3(SSES3Filter.builder().applyMutation(sses3).build());
        }

        /**
         * <p>
         * Filters for objects that are encrypted by server-side encryption with Amazon Web Services Key Management
         * Service (KMS) keys (SSE-KMS).
         * </p>
         * 
         * @param ssekms
         *        Filters for objects that are encrypted by server-side encryption with Amazon Web Services Key
         *        Management Service (KMS) keys (SSE-KMS).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssekms(SSEKMSFilter ssekms);

        /**
         * <p>
         * Filters for objects that are encrypted by server-side encryption with Amazon Web Services Key Management
         * Service (KMS) keys (SSE-KMS).
         * </p>
         * This is a convenience method that creates an instance of the {@link SSEKMSFilter.Builder} avoiding the need
         * to create one manually via {@link SSEKMSFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SSEKMSFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #ssekms(SSEKMSFilter)}.
         * 
         * @param ssekms
         *        a consumer that will call methods on {@link SSEKMSFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ssekms(SSEKMSFilter)
         */
        default Builder ssekms(Consumer<SSEKMSFilter.Builder> ssekms) {
            return ssekms(SSEKMSFilter.builder().applyMutation(ssekms).build());
        }

        /**
         * <p>
         * Filters for objects that are encrypted by dual-layer server-side encryption with Amazon Web Services Key
         * Management Service (KMS) keys (DSSE-KMS).
         * </p>
         * 
         * @param dssekms
         *        Filters for objects that are encrypted by dual-layer server-side encryption with Amazon Web Services
         *        Key Management Service (KMS) keys (DSSE-KMS).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dssekms(DSSEKMSFilter dssekms);

        /**
         * <p>
         * Filters for objects that are encrypted by dual-layer server-side encryption with Amazon Web Services Key
         * Management Service (KMS) keys (DSSE-KMS).
         * </p>
         * This is a convenience method that creates an instance of the {@link DSSEKMSFilter.Builder} avoiding the need
         * to create one manually via {@link DSSEKMSFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DSSEKMSFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #dssekms(DSSEKMSFilter)}.
         * 
         * @param dssekms
         *        a consumer that will call methods on {@link DSSEKMSFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dssekms(DSSEKMSFilter)
         */
        default Builder dssekms(Consumer<DSSEKMSFilter.Builder> dssekms) {
            return dssekms(DSSEKMSFilter.builder().applyMutation(dssekms).build());
        }

        /**
         * <p>
         * Filters for objects that are encrypted by server-side encryption with customer-provided keys (SSE-C).
         * </p>
         * 
         * @param ssec
         *        Filters for objects that are encrypted by server-side encryption with customer-provided keys (SSE-C).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssec(SSECFilter ssec);

        /**
         * <p>
         * Filters for objects that are encrypted by server-side encryption with customer-provided keys (SSE-C).
         * </p>
         * This is a convenience method that creates an instance of the {@link SSECFilter.Builder} avoiding the need to
         * create one manually via {@link SSECFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SSECFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #ssec(SSECFilter)}.
         * 
         * @param ssec
         *        a consumer that will call methods on {@link SSECFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ssec(SSECFilter)
         */
        default Builder ssec(Consumer<SSECFilter.Builder> ssec) {
            return ssec(SSECFilter.builder().applyMutation(ssec).build());
        }

        /**
         * <p>
         * Filters for objects that are not encrypted by server-side encryption.
         * </p>
         * 
         * @param notsse
         *        Filters for objects that are not encrypted by server-side encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notsse(NotSSEFilter notsse);

        /**
         * <p>
         * Filters for objects that are not encrypted by server-side encryption.
         * </p>
         * This is a convenience method that creates an instance of the {@link NotSSEFilter.Builder} avoiding the need
         * to create one manually via {@link NotSSEFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotSSEFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #notsse(NotSSEFilter)}.
         * 
         * @param notsse
         *        a consumer that will call methods on {@link NotSSEFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notsse(NotSSEFilter)
         */
        default Builder notsse(Consumer<NotSSEFilter.Builder> notsse) {
            return notsse(NotSSEFilter.builder().applyMutation(notsse).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SSES3Filter sses3;

        private SSEKMSFilter ssekms;

        private DSSEKMSFilter dssekms;

        private SSECFilter ssec;

        private NotSSEFilter notsse;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectEncryptionFilter model) {
            sses3(model.sses3);
            ssekms(model.ssekms);
            dssekms(model.dssekms);
            ssec(model.ssec);
            notsse(model.notsse);
        }

        public final SSES3Filter.Builder getSses3() {
            return sses3 != null ? sses3.toBuilder() : null;
        }

        public final void setSses3(SSES3Filter.BuilderImpl sses3) {
            Object oldValue = this.sses3;
            this.sses3 = sses3 != null ? sses3.build() : null;
            handleUnionValueChange(Type.SSES3, oldValue, this.sses3);
        }

        @Override
        public final Builder sses3(SSES3Filter sses3) {
            Object oldValue = this.sses3;
            this.sses3 = sses3;
            handleUnionValueChange(Type.SSES3, oldValue, this.sses3);
            return this;
        }

        public final SSEKMSFilter.Builder getSsekms() {
            return ssekms != null ? ssekms.toBuilder() : null;
        }

        public final void setSsekms(SSEKMSFilter.BuilderImpl ssekms) {
            Object oldValue = this.ssekms;
            this.ssekms = ssekms != null ? ssekms.build() : null;
            handleUnionValueChange(Type.SSEKMS, oldValue, this.ssekms);
        }

        @Override
        public final Builder ssekms(SSEKMSFilter ssekms) {
            Object oldValue = this.ssekms;
            this.ssekms = ssekms;
            handleUnionValueChange(Type.SSEKMS, oldValue, this.ssekms);
            return this;
        }

        public final DSSEKMSFilter.Builder getDssekms() {
            return dssekms != null ? dssekms.toBuilder() : null;
        }

        public final void setDssekms(DSSEKMSFilter.BuilderImpl dssekms) {
            Object oldValue = this.dssekms;
            this.dssekms = dssekms != null ? dssekms.build() : null;
            handleUnionValueChange(Type.DSSEKMS, oldValue, this.dssekms);
        }

        @Override
        public final Builder dssekms(DSSEKMSFilter dssekms) {
            Object oldValue = this.dssekms;
            this.dssekms = dssekms;
            handleUnionValueChange(Type.DSSEKMS, oldValue, this.dssekms);
            return this;
        }

        public final SSECFilter.Builder getSsec() {
            return ssec != null ? ssec.toBuilder() : null;
        }

        public final void setSsec(SSECFilter.BuilderImpl ssec) {
            Object oldValue = this.ssec;
            this.ssec = ssec != null ? ssec.build() : null;
            handleUnionValueChange(Type.SSEC, oldValue, this.ssec);
        }

        @Override
        public final Builder ssec(SSECFilter ssec) {
            Object oldValue = this.ssec;
            this.ssec = ssec;
            handleUnionValueChange(Type.SSEC, oldValue, this.ssec);
            return this;
        }

        public final NotSSEFilter.Builder getNotsse() {
            return notsse != null ? notsse.toBuilder() : null;
        }

        public final void setNotsse(NotSSEFilter.BuilderImpl notsse) {
            Object oldValue = this.notsse;
            this.notsse = notsse != null ? notsse.build() : null;
            handleUnionValueChange(Type.NOTSSE, oldValue, this.notsse);
        }

        @Override
        public final Builder notsse(NotSSEFilter notsse) {
            Object oldValue = this.notsse;
            this.notsse = notsse;
            handleUnionValueChange(Type.NOTSSE, oldValue, this.notsse);
            return this;
        }

        @Override
        public ObjectEncryptionFilter build() {
            return new ObjectEncryptionFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ObjectEncryptionFilter#type()
     */
    public enum Type {
        SSES3,

        SSEKMS,

        DSSEKMS,

        SSEC,

        NOTSSE,

        UNKNOWN_TO_SDK_VERSION
    }
}
