/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutStorageLensConfigurationTaggingRequest extends S3ControlRequest implements
        ToCopyableBuilder<PutStorageLensConfigurationTaggingRequest.Builder, PutStorageLensConfigurationTaggingRequest> {
    private static final SdkField<String> CONFIG_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConfigId")
            .getter(getter(PutStorageLensConfigurationTaggingRequest::configId))
            .setter(setter(Builder::configId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("storagelensid")
                    .unmarshallLocationName("storagelensid").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountId")
            .getter(getter(PutStorageLensConfigurationTaggingRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id")
                    .unmarshallLocationName("x-amz-account-id").build()).build();

    private static final SdkField<List<StorageLensTag>> TAGS_FIELD = SdkField
            .<List<StorageLensTag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(PutStorageLensConfigurationTaggingRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags")
                    .unmarshallLocationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<StorageLensTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(StorageLensTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").unmarshallLocationName("Tag").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_ID_FIELD,
            ACCOUNT_ID_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String configId;

    private final String accountId;

    private final List<StorageLensTag> tags;

    private PutStorageLensConfigurationTaggingRequest(BuilderImpl builder) {
        super(builder);
        this.configId = builder.configId;
        this.accountId = builder.accountId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the S3 Storage Lens configuration.
     * </p>
     * 
     * @return The ID of the S3 Storage Lens configuration.
     */
    public final String configId() {
        return configId;
    }

    /**
     * <p>
     * The account ID of the requester.
     * </p>
     * 
     * @return The account ID of the requester.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag set of the S3 Storage Lens configuration.
     * </p>
     * <note>
     * <p>
     * You can set up to a maximum of 50 tags.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tag set of the S3 Storage Lens configuration.</p> <note>
     *         <p>
     *         You can set up to a maximum of 50 tags.
     *         </p>
     */
    public final List<StorageLensTag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configId());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutStorageLensConfigurationTaggingRequest)) {
            return false;
        }
        PutStorageLensConfigurationTaggingRequest other = (PutStorageLensConfigurationTaggingRequest) obj;
        return Objects.equals(configId(), other.configId()) && Objects.equals(accountId(), other.accountId())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutStorageLensConfigurationTaggingRequest").add("ConfigId", configId())
                .add("AccountId", accountId()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigId":
            return Optional.ofNullable(clazz.cast(configId()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("storagelensid", CONFIG_ID_FIELD);
        map.put("x-amz-account-id", ACCOUNT_ID_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutStorageLensConfigurationTaggingRequest, T> g) {
        return obj -> g.apply((PutStorageLensConfigurationTaggingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends S3ControlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutStorageLensConfigurationTaggingRequest> {
        /**
         * <p>
         * The ID of the S3 Storage Lens configuration.
         * </p>
         * 
         * @param configId
         *        The ID of the S3 Storage Lens configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configId(String configId);

        /**
         * <p>
         * The account ID of the requester.
         * </p>
         * 
         * @param accountId
         *        The account ID of the requester.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The tag set of the S3 Storage Lens configuration.
         * </p>
         * <note>
         * <p>
         * You can set up to a maximum of 50 tags.
         * </p>
         * </note>
         * 
         * @param tags
         *        The tag set of the S3 Storage Lens configuration.</p> <note>
         *        <p>
         *        You can set up to a maximum of 50 tags.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<StorageLensTag> tags);

        /**
         * <p>
         * The tag set of the S3 Storage Lens configuration.
         * </p>
         * <note>
         * <p>
         * You can set up to a maximum of 50 tags.
         * </p>
         * </note>
         * 
         * @param tags
         *        The tag set of the S3 Storage Lens configuration.</p> <note>
         *        <p>
         *        You can set up to a maximum of 50 tags.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(StorageLensTag... tags);

        /**
         * <p>
         * The tag set of the S3 Storage Lens configuration.
         * </p>
         * <note>
         * <p>
         * You can set up to a maximum of 50 tags.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.s3control.model.StorageLensTag.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.s3control.model.StorageLensTag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.s3control.model.StorageLensTag.Builder#build()} is called immediately
         * and its result is passed to {@link #tags(List<StorageLensTag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.s3control.model.StorageLensTag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<StorageLensTag>)
         */
        Builder tags(Consumer<StorageLensTag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3ControlRequest.BuilderImpl implements Builder {
        private String configId;

        private String accountId;

        private List<StorageLensTag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutStorageLensConfigurationTaggingRequest model) {
            super(model);
            configId(model.configId);
            accountId(model.accountId);
            tags(model.tags);
        }

        public final String getConfigId() {
            return configId;
        }

        public final void setConfigId(String configId) {
            this.configId = configId;
        }

        @Override
        public final Builder configId(String configId) {
            this.configId = configId;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final List<StorageLensTag.Builder> getTags() {
            List<StorageLensTag.Builder> result = StorageLensTagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<StorageLensTag.BuilderImpl> tags) {
            this.tags = StorageLensTagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<StorageLensTag> tags) {
            this.tags = StorageLensTagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(StorageLensTag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<StorageLensTag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> StorageLensTag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutStorageLensConfigurationTaggingRequest build() {
            return new PutStorageLensConfigurationTaggingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
