/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The container for the regional bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegionalBucket implements SdkPojo, Serializable, ToCopyableBuilder<RegionalBucket.Builder, RegionalBucket> {
    private static final SdkField<String> BUCKET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Bucket")
            .getter(getter(RegionalBucket::bucket))
            .setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket")
                    .unmarshallLocationName("Bucket").build()).build();

    private static final SdkField<String> BUCKET_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BucketArn")
            .getter(getter(RegionalBucket::bucketArn))
            .setter(setter(Builder::bucketArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketArn")
                    .unmarshallLocationName("BucketArn").build()).build();

    private static final SdkField<Boolean> PUBLIC_ACCESS_BLOCK_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PublicAccessBlockEnabled")
            .getter(getter(RegionalBucket::publicAccessBlockEnabled))
            .setter(setter(Builder::publicAccessBlockEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicAccessBlockEnabled")
                    .unmarshallLocationName("PublicAccessBlockEnabled").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate")
            .getter(getter(RegionalBucket::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate")
                    .unmarshallLocationName("CreationDate").build()).build();

    private static final SdkField<String> OUTPOST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutpostId")
            .getter(getter(RegionalBucket::outpostId))
            .setter(setter(Builder::outpostId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostId")
                    .unmarshallLocationName("OutpostId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD,
            BUCKET_ARN_FIELD, PUBLIC_ACCESS_BLOCK_ENABLED_FIELD, CREATION_DATE_FIELD, OUTPOST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bucket;

    private final String bucketArn;

    private final Boolean publicAccessBlockEnabled;

    private final Instant creationDate;

    private final String outpostId;

    private RegionalBucket(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.bucketArn = builder.bucketArn;
        this.publicAccessBlockEnabled = builder.publicAccessBlockEnabled;
        this.creationDate = builder.creationDate;
        this.outpostId = builder.outpostId;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the regional bucket.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the regional bucket.
     */
    public final String bucketArn() {
        return bucketArn;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Boolean publicAccessBlockEnabled() {
        return publicAccessBlockEnabled;
    }

    /**
     * <p>
     * The creation date of the regional bucket
     * </p>
     * 
     * @return The creation date of the regional bucket
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The Outposts ID of the regional bucket.
     * </p>
     * 
     * @return The Outposts ID of the regional bucket.
     */
    public final String outpostId() {
        return outpostId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(bucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(publicAccessBlockEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(outpostId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegionalBucket)) {
            return false;
        }
        RegionalBucket other = (RegionalBucket) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(bucketArn(), other.bucketArn())
                && Objects.equals(publicAccessBlockEnabled(), other.publicAccessBlockEnabled())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(outpostId(), other.outpostId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegionalBucket").add("Bucket", bucket()).add("BucketArn", bucketArn())
                .add("PublicAccessBlockEnabled", publicAccessBlockEnabled()).add("CreationDate", creationDate())
                .add("OutpostId", outpostId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "BucketArn":
            return Optional.ofNullable(clazz.cast(bucketArn()));
        case "PublicAccessBlockEnabled":
            return Optional.ofNullable(clazz.cast(publicAccessBlockEnabled()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "OutpostId":
            return Optional.ofNullable(clazz.cast(outpostId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Bucket", BUCKET_FIELD);
        map.put("BucketArn", BUCKET_ARN_FIELD);
        map.put("PublicAccessBlockEnabled", PUBLIC_ACCESS_BLOCK_ENABLED_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("OutpostId", OUTPOST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegionalBucket, T> g) {
        return obj -> g.apply((RegionalBucket) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegionalBucket> {
        /**
         * <p/>
         * 
         * @param bucket
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the regional bucket.
         * </p>
         * 
         * @param bucketArn
         *        The Amazon Resource Name (ARN) for the regional bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketArn(String bucketArn);

        /**
         * <p/>
         * 
         * @param publicAccessBlockEnabled
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicAccessBlockEnabled(Boolean publicAccessBlockEnabled);

        /**
         * <p>
         * The creation date of the regional bucket
         * </p>
         * 
         * @param creationDate
         *        The creation date of the regional bucket
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The Outposts ID of the regional bucket.
         * </p>
         * 
         * @param outpostId
         *        The Outposts ID of the regional bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostId(String outpostId);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private String bucketArn;

        private Boolean publicAccessBlockEnabled;

        private Instant creationDate;

        private String outpostId;

        private BuilderImpl() {
        }

        private BuilderImpl(RegionalBucket model) {
            bucket(model.bucket);
            bucketArn(model.bucketArn);
            publicAccessBlockEnabled(model.publicAccessBlockEnabled);
            creationDate(model.creationDate);
            outpostId(model.outpostId);
        }

        public final String getBucket() {
            return bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getBucketArn() {
            return bucketArn;
        }

        public final void setBucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
        }

        @Override
        public final Builder bucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
            return this;
        }

        public final Boolean getPublicAccessBlockEnabled() {
            return publicAccessBlockEnabled;
        }

        public final void setPublicAccessBlockEnabled(Boolean publicAccessBlockEnabled) {
            this.publicAccessBlockEnabled = publicAccessBlockEnabled;
        }

        @Override
        public final Builder publicAccessBlockEnabled(Boolean publicAccessBlockEnabled) {
            this.publicAccessBlockEnabled = publicAccessBlockEnabled;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getOutpostId() {
            return outpostId;
        }

        public final void setOutpostId(String outpostId) {
            this.outpostId = outpostId;
        }

        @Override
        public final Builder outpostId(String outpostId) {
            this.outpostId = outpostId;
            return this;
        }

        @Override
        public RegionalBucket build() {
            return new RegionalBucket(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
