/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3outposts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEndpointRequest extends S3OutpostsRequest implements
        ToCopyableBuilder<CreateEndpointRequest.Builder, CreateEndpointRequest> {
    private static final SdkField<String> OUTPOST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutpostId").getter(getter(CreateEndpointRequest::outpostId)).setter(setter(Builder::outpostId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostId").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(CreateEndpointRequest::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> SECURITY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityGroupId").getter(getter(CreateEndpointRequest::securityGroupId))
            .setter(setter(Builder::securityGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").build()).build();

    private static final SdkField<String> ACCESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessType").getter(getter(CreateEndpointRequest::accessTypeAsString))
            .setter(setter(Builder::accessType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessType").build()).build();

    private static final SdkField<String> CUSTOMER_OWNED_IPV4_POOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomerOwnedIpv4Pool").getter(getter(CreateEndpointRequest::customerOwnedIpv4Pool))
            .setter(setter(Builder::customerOwnedIpv4Pool))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerOwnedIpv4Pool").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_ID_FIELD,
            SUBNET_ID_FIELD, SECURITY_GROUP_ID_FIELD, ACCESS_TYPE_FIELD, CUSTOMER_OWNED_IPV4_POOL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String outpostId;

    private final String subnetId;

    private final String securityGroupId;

    private final String accessType;

    private final String customerOwnedIpv4Pool;

    private CreateEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.outpostId = builder.outpostId;
        this.subnetId = builder.subnetId;
        this.securityGroupId = builder.securityGroupId;
        this.accessType = builder.accessType;
        this.customerOwnedIpv4Pool = builder.customerOwnedIpv4Pool;
    }

    /**
     * <p>
     * The ID of the Outposts.
     * </p>
     * 
     * @return The ID of the Outposts.
     */
    public final String outpostId() {
        return outpostId;
    }

    /**
     * <p>
     * The ID of the subnet in the selected VPC. The endpoint subnet must belong to the Outpost that has Amazon S3 on
     * Outposts provisioned.
     * </p>
     * 
     * @return The ID of the subnet in the selected VPC. The endpoint subnet must belong to the Outpost that has Amazon
     *         S3 on Outposts provisioned.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The ID of the security group to use with the endpoint.
     * </p>
     * 
     * @return The ID of the security group to use with the endpoint.
     */
    public final String securityGroupId() {
        return securityGroupId;
    }

    /**
     * <p>
     * The type of access for the network connectivity for the Amazon S3 on Outposts endpoint. To use the Amazon Web
     * Services VPC, choose <code>Private</code>. To use the endpoint with an on-premises network, choose
     * <code>CustomerOwnedIp</code>. If you choose <code>CustomerOwnedIp</code>, you must also provide the
     * customer-owned IP address pool (CoIP pool).
     * </p>
     * <note>
     * <p>
     * <code>Private</code> is the default access type value.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessType} will
     * return {@link EndpointAccessType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accessTypeAsString}.
     * </p>
     * 
     * @return The type of access for the network connectivity for the Amazon S3 on Outposts endpoint. To use the Amazon
     *         Web Services VPC, choose <code>Private</code>. To use the endpoint with an on-premises network, choose
     *         <code>CustomerOwnedIp</code>. If you choose <code>CustomerOwnedIp</code>, you must also provide the
     *         customer-owned IP address pool (CoIP pool).</p> <note>
     *         <p>
     *         <code>Private</code> is the default access type value.
     *         </p>
     * @see EndpointAccessType
     */
    public final EndpointAccessType accessType() {
        return EndpointAccessType.fromValue(accessType);
    }

    /**
     * <p>
     * The type of access for the network connectivity for the Amazon S3 on Outposts endpoint. To use the Amazon Web
     * Services VPC, choose <code>Private</code>. To use the endpoint with an on-premises network, choose
     * <code>CustomerOwnedIp</code>. If you choose <code>CustomerOwnedIp</code>, you must also provide the
     * customer-owned IP address pool (CoIP pool).
     * </p>
     * <note>
     * <p>
     * <code>Private</code> is the default access type value.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessType} will
     * return {@link EndpointAccessType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accessTypeAsString}.
     * </p>
     * 
     * @return The type of access for the network connectivity for the Amazon S3 on Outposts endpoint. To use the Amazon
     *         Web Services VPC, choose <code>Private</code>. To use the endpoint with an on-premises network, choose
     *         <code>CustomerOwnedIp</code>. If you choose <code>CustomerOwnedIp</code>, you must also provide the
     *         customer-owned IP address pool (CoIP pool).</p> <note>
     *         <p>
     *         <code>Private</code> is the default access type value.
     *         </p>
     * @see EndpointAccessType
     */
    public final String accessTypeAsString() {
        return accessType;
    }

    /**
     * <p>
     * The ID of the customer-owned IPv4 address pool (CoIP pool) for the endpoint. IP addresses are allocated from this
     * pool for the endpoint.
     * </p>
     * 
     * @return The ID of the customer-owned IPv4 address pool (CoIP pool) for the endpoint. IP addresses are allocated
     *         from this pool for the endpoint.
     */
    public final String customerOwnedIpv4Pool() {
        return customerOwnedIpv4Pool;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(outpostId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(accessTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customerOwnedIpv4Pool());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEndpointRequest)) {
            return false;
        }
        CreateEndpointRequest other = (CreateEndpointRequest) obj;
        return Objects.equals(outpostId(), other.outpostId()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(securityGroupId(), other.securityGroupId())
                && Objects.equals(accessTypeAsString(), other.accessTypeAsString())
                && Objects.equals(customerOwnedIpv4Pool(), other.customerOwnedIpv4Pool());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEndpointRequest").add("OutpostId", outpostId()).add("SubnetId", subnetId())
                .add("SecurityGroupId", securityGroupId()).add("AccessType", accessTypeAsString())
                .add("CustomerOwnedIpv4Pool", customerOwnedIpv4Pool()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutpostId":
            return Optional.ofNullable(clazz.cast(outpostId()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "SecurityGroupId":
            return Optional.ofNullable(clazz.cast(securityGroupId()));
        case "AccessType":
            return Optional.ofNullable(clazz.cast(accessTypeAsString()));
        case "CustomerOwnedIpv4Pool":
            return Optional.ofNullable(clazz.cast(customerOwnedIpv4Pool()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OutpostId", OUTPOST_ID_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("SecurityGroupId", SECURITY_GROUP_ID_FIELD);
        map.put("AccessType", ACCESS_TYPE_FIELD);
        map.put("CustomerOwnedIpv4Pool", CUSTOMER_OWNED_IPV4_POOL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEndpointRequest, T> g) {
        return obj -> g.apply((CreateEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3OutpostsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateEndpointRequest> {
        /**
         * <p>
         * The ID of the Outposts.
         * </p>
         * 
         * @param outpostId
         *        The ID of the Outposts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostId(String outpostId);

        /**
         * <p>
         * The ID of the subnet in the selected VPC. The endpoint subnet must belong to the Outpost that has Amazon S3
         * on Outposts provisioned.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet in the selected VPC. The endpoint subnet must belong to the Outpost that has
         *        Amazon S3 on Outposts provisioned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The ID of the security group to use with the endpoint.
         * </p>
         * 
         * @param securityGroupId
         *        The ID of the security group to use with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupId(String securityGroupId);

        /**
         * <p>
         * The type of access for the network connectivity for the Amazon S3 on Outposts endpoint. To use the Amazon Web
         * Services VPC, choose <code>Private</code>. To use the endpoint with an on-premises network, choose
         * <code>CustomerOwnedIp</code>. If you choose <code>CustomerOwnedIp</code>, you must also provide the
         * customer-owned IP address pool (CoIP pool).
         * </p>
         * <note>
         * <p>
         * <code>Private</code> is the default access type value.
         * </p>
         * </note>
         * 
         * @param accessType
         *        The type of access for the network connectivity for the Amazon S3 on Outposts endpoint. To use the
         *        Amazon Web Services VPC, choose <code>Private</code>. To use the endpoint with an on-premises network,
         *        choose <code>CustomerOwnedIp</code>. If you choose <code>CustomerOwnedIp</code>, you must also provide
         *        the customer-owned IP address pool (CoIP pool).</p> <note>
         *        <p>
         *        <code>Private</code> is the default access type value.
         *        </p>
         * @see EndpointAccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointAccessType
         */
        Builder accessType(String accessType);

        /**
         * <p>
         * The type of access for the network connectivity for the Amazon S3 on Outposts endpoint. To use the Amazon Web
         * Services VPC, choose <code>Private</code>. To use the endpoint with an on-premises network, choose
         * <code>CustomerOwnedIp</code>. If you choose <code>CustomerOwnedIp</code>, you must also provide the
         * customer-owned IP address pool (CoIP pool).
         * </p>
         * <note>
         * <p>
         * <code>Private</code> is the default access type value.
         * </p>
         * </note>
         * 
         * @param accessType
         *        The type of access for the network connectivity for the Amazon S3 on Outposts endpoint. To use the
         *        Amazon Web Services VPC, choose <code>Private</code>. To use the endpoint with an on-premises network,
         *        choose <code>CustomerOwnedIp</code>. If you choose <code>CustomerOwnedIp</code>, you must also provide
         *        the customer-owned IP address pool (CoIP pool).</p> <note>
         *        <p>
         *        <code>Private</code> is the default access type value.
         *        </p>
         * @see EndpointAccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointAccessType
         */
        Builder accessType(EndpointAccessType accessType);

        /**
         * <p>
         * The ID of the customer-owned IPv4 address pool (CoIP pool) for the endpoint. IP addresses are allocated from
         * this pool for the endpoint.
         * </p>
         * 
         * @param customerOwnedIpv4Pool
         *        The ID of the customer-owned IPv4 address pool (CoIP pool) for the endpoint. IP addresses are
         *        allocated from this pool for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerOwnedIpv4Pool(String customerOwnedIpv4Pool);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3OutpostsRequest.BuilderImpl implements Builder {
        private String outpostId;

        private String subnetId;

        private String securityGroupId;

        private String accessType;

        private String customerOwnedIpv4Pool;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEndpointRequest model) {
            super(model);
            outpostId(model.outpostId);
            subnetId(model.subnetId);
            securityGroupId(model.securityGroupId);
            accessType(model.accessType);
            customerOwnedIpv4Pool(model.customerOwnedIpv4Pool);
        }

        public final String getOutpostId() {
            return outpostId;
        }

        public final void setOutpostId(String outpostId) {
            this.outpostId = outpostId;
        }

        @Override
        public final Builder outpostId(String outpostId) {
            this.outpostId = outpostId;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getSecurityGroupId() {
            return securityGroupId;
        }

        public final void setSecurityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
        }

        @Override
        public final Builder securityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
            return this;
        }

        public final String getAccessType() {
            return accessType;
        }

        public final void setAccessType(String accessType) {
            this.accessType = accessType;
        }

        @Override
        public final Builder accessType(String accessType) {
            this.accessType = accessType;
            return this;
        }

        @Override
        public final Builder accessType(EndpointAccessType accessType) {
            this.accessType(accessType == null ? null : accessType.toString());
            return this;
        }

        public final String getCustomerOwnedIpv4Pool() {
            return customerOwnedIpv4Pool;
        }

        public final void setCustomerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
        }

        @Override
        public final Builder customerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEndpointRequest build() {
            return new CreateEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
