/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3outposts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSharedEndpointsRequest extends S3OutpostsRequest implements
        ToCopyableBuilder<ListSharedEndpointsRequest.Builder, ListSharedEndpointsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSharedEndpointsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListSharedEndpointsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> OUTPOST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutpostId").getter(getter(ListSharedEndpointsRequest::outpostId)).setter(setter(Builder::outpostId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("outpostId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, OUTPOST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final Integer maxResults;

    private final String outpostId;

    private ListSharedEndpointsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.outpostId = builder.outpostId;
    }

    /**
     * <p>
     * If a previous response from this operation included a <code>NextToken</code> value, you can provide that value
     * here to retrieve the next page of results.
     * </p>
     * 
     * @return If a previous response from this operation included a <code>NextToken</code> value, you can provide that
     *         value here to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of endpoints that will be returned in the response.
     * </p>
     * 
     * @return The maximum number of endpoints that will be returned in the response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services Outpost.
     * </p>
     * 
     * @return The ID of the Amazon Web Services Outpost.
     */
    public final String outpostId() {
        return outpostId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(outpostId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSharedEndpointsRequest)) {
            return false;
        }
        ListSharedEndpointsRequest other = (ListSharedEndpointsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(outpostId(), other.outpostId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSharedEndpointsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("OutpostId", outpostId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "OutpostId":
            return Optional.ofNullable(clazz.cast(outpostId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("outpostId", OUTPOST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSharedEndpointsRequest, T> g) {
        return obj -> g.apply((ListSharedEndpointsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends S3OutpostsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSharedEndpointsRequest> {
        /**
         * <p>
         * If a previous response from this operation included a <code>NextToken</code> value, you can provide that
         * value here to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        If a previous response from this operation included a <code>NextToken</code> value, you can provide
         *        that value here to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of endpoints that will be returned in the response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of endpoints that will be returned in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The ID of the Amazon Web Services Outpost.
         * </p>
         * 
         * @param outpostId
         *        The ID of the Amazon Web Services Outpost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostId(String outpostId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3OutpostsRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String outpostId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSharedEndpointsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            outpostId(model.outpostId);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getOutpostId() {
            return outpostId;
        }

        public final void setOutpostId(String outpostId) {
            this.outpostId = outpostId;
        }

        @Override
        public final Builder outpostId(String outpostId) {
            this.outpostId = outpostId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSharedEndpointsRequest build() {
            return new ListSharedEndpointsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
