/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3tables.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the compaction settings for an Iceberg table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IcebergCompactionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<IcebergCompactionSettings.Builder, IcebergCompactionSettings> {
    private static final SdkField<Integer> TARGET_FILE_SIZE_MB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("targetFileSizeMB").getter(getter(IcebergCompactionSettings::targetFileSizeMB))
            .setter(setter(Builder::targetFileSizeMB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetFileSizeMB").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_FILE_SIZE_MB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer targetFileSizeMB;

    private IcebergCompactionSettings(BuilderImpl builder) {
        this.targetFileSizeMB = builder.targetFileSizeMB;
    }

    /**
     * <p>
     * The target file size for the table in MB.
     * </p>
     * 
     * @return The target file size for the table in MB.
     */
    public final Integer targetFileSizeMB() {
        return targetFileSizeMB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetFileSizeMB());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergCompactionSettings)) {
            return false;
        }
        IcebergCompactionSettings other = (IcebergCompactionSettings) obj;
        return Objects.equals(targetFileSizeMB(), other.targetFileSizeMB());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IcebergCompactionSettings").add("TargetFileSizeMB", targetFileSizeMB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetFileSizeMB":
            return Optional.ofNullable(clazz.cast(targetFileSizeMB()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("targetFileSizeMB", TARGET_FILE_SIZE_MB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IcebergCompactionSettings, T> g) {
        return obj -> g.apply((IcebergCompactionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IcebergCompactionSettings> {
        /**
         * <p>
         * The target file size for the table in MB.
         * </p>
         * 
         * @param targetFileSizeMB
         *        The target file size for the table in MB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetFileSizeMB(Integer targetFileSizeMB);
    }

    static final class BuilderImpl implements Builder {
        private Integer targetFileSizeMB;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergCompactionSettings model) {
            targetFileSizeMB(model.targetFileSizeMB);
        }

        public final Integer getTargetFileSizeMB() {
            return targetFileSizeMB;
        }

        public final void setTargetFileSizeMB(Integer targetFileSizeMB) {
            this.targetFileSizeMB = targetFileSizeMB;
        }

        @Override
        public final Builder targetFileSizeMB(Integer targetFileSizeMB) {
            this.targetFileSizeMB = targetFileSizeMB;
            return this;
        }

        @Override
        public IcebergCompactionSettings build() {
            return new IcebergCompactionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
