/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTablesRequest extends S3TablesRequest implements
        ToCopyableBuilder<ListTablesRequest.Builder, ListTablesRequest> {
    private static final SdkField<String> TABLE_BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableBucketARN").getter(getter(ListTablesRequest::tableBucketARN))
            .setter(setter(Builder::tableBucketARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("tableBucketARN").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(ListTablesRequest::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("namespace").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("prefix")
            .getter(getter(ListTablesRequest::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("prefix").build()).build();

    private static final SdkField<String> CONTINUATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("continuationToken").getter(getter(ListTablesRequest::continuationToken))
            .setter(setter(Builder::continuationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("continuationToken").build())
            .build();

    private static final SdkField<Integer> MAX_TABLES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxTables").getter(getter(ListTablesRequest::maxTables)).setter(setter(Builder::maxTables))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxTables").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_BUCKET_ARN_FIELD,
            NAMESPACE_FIELD, PREFIX_FIELD, CONTINUATION_TOKEN_FIELD, MAX_TABLES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String tableBucketARN;

    private final String namespace;

    private final String prefix;

    private final String continuationToken;

    private final Integer maxTables;

    private ListTablesRequest(BuilderImpl builder) {
        super(builder);
        this.tableBucketARN = builder.tableBucketARN;
        this.namespace = builder.namespace;
        this.prefix = builder.prefix;
        this.continuationToken = builder.continuationToken;
        this.maxTables = builder.maxTables;
    }

    /**
     * <p>
     * The Amazon resource Number (ARN) of the table bucket.
     * </p>
     * 
     * @return The Amazon resource Number (ARN) of the table bucket.
     */
    public final String tableBucketARN() {
        return tableBucketARN;
    }

    /**
     * <p>
     * The namespace of the tables.
     * </p>
     * 
     * @return The namespace of the tables.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The prefix of the tables.
     * </p>
     * 
     * @return The prefix of the tables.
     */
    public final String prefix() {
        return prefix;
    }

    /**
     * <p>
     * <code>ContinuationToken</code> indicates to Amazon S3 that the list is being continued on this bucket with a
     * token. <code>ContinuationToken</code> is obfuscated and is not a real key. You can use this
     * <code>ContinuationToken</code> for pagination of the list results.
     * </p>
     * 
     * @return <code>ContinuationToken</code> indicates to Amazon S3 that the list is being continued on this bucket
     *         with a token. <code>ContinuationToken</code> is obfuscated and is not a real key. You can use this
     *         <code>ContinuationToken</code> for pagination of the list results.
     */
    public final String continuationToken() {
        return continuationToken;
    }

    /**
     * <p>
     * The maximum number of tables to return.
     * </p>
     * 
     * @return The maximum number of tables to return.
     */
    public final Integer maxTables() {
        return maxTables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableBucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(continuationToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxTables());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTablesRequest)) {
            return false;
        }
        ListTablesRequest other = (ListTablesRequest) obj;
        return Objects.equals(tableBucketARN(), other.tableBucketARN()) && Objects.equals(namespace(), other.namespace())
                && Objects.equals(prefix(), other.prefix()) && Objects.equals(continuationToken(), other.continuationToken())
                && Objects.equals(maxTables(), other.maxTables());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTablesRequest").add("TableBucketARN", tableBucketARN()).add("Namespace", namespace())
                .add("Prefix", prefix()).add("ContinuationToken", continuationToken()).add("MaxTables", maxTables()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tableBucketARN":
            return Optional.ofNullable(clazz.cast(tableBucketARN()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "continuationToken":
            return Optional.ofNullable(clazz.cast(continuationToken()));
        case "maxTables":
            return Optional.ofNullable(clazz.cast(maxTables()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tableBucketARN", TABLE_BUCKET_ARN_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("prefix", PREFIX_FIELD);
        map.put("continuationToken", CONTINUATION_TOKEN_FIELD);
        map.put("maxTables", MAX_TABLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTablesRequest, T> g) {
        return obj -> g.apply((ListTablesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3TablesRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTablesRequest> {
        /**
         * <p>
         * The Amazon resource Number (ARN) of the table bucket.
         * </p>
         * 
         * @param tableBucketARN
         *        The Amazon resource Number (ARN) of the table bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableBucketARN(String tableBucketARN);

        /**
         * <p>
         * The namespace of the tables.
         * </p>
         * 
         * @param namespace
         *        The namespace of the tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The prefix of the tables.
         * </p>
         * 
         * @param prefix
         *        The prefix of the tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * <code>ContinuationToken</code> indicates to Amazon S3 that the list is being continued on this bucket with a
         * token. <code>ContinuationToken</code> is obfuscated and is not a real key. You can use this
         * <code>ContinuationToken</code> for pagination of the list results.
         * </p>
         * 
         * @param continuationToken
         *        <code>ContinuationToken</code> indicates to Amazon S3 that the list is being continued on this bucket
         *        with a token. <code>ContinuationToken</code> is obfuscated and is not a real key. You can use this
         *        <code>ContinuationToken</code> for pagination of the list results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuationToken(String continuationToken);

        /**
         * <p>
         * The maximum number of tables to return.
         * </p>
         * 
         * @param maxTables
         *        The maximum number of tables to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxTables(Integer maxTables);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3TablesRequest.BuilderImpl implements Builder {
        private String tableBucketARN;

        private String namespace;

        private String prefix;

        private String continuationToken;

        private Integer maxTables;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTablesRequest model) {
            super(model);
            tableBucketARN(model.tableBucketARN);
            namespace(model.namespace);
            prefix(model.prefix);
            continuationToken(model.continuationToken);
            maxTables(model.maxTables);
        }

        public final String getTableBucketARN() {
            return tableBucketARN;
        }

        public final void setTableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
        }

        @Override
        public final Builder tableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getContinuationToken() {
            return continuationToken;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final Integer getMaxTables() {
            return maxTables;
        }

        public final void setMaxTables(Integer maxTables) {
            this.maxTables = maxTables;
        }

        @Override
        public final Builder maxTables(Integer maxTables) {
            this.maxTables = maxTables;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTablesRequest build() {
            return new ListTablesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
