/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RenameTableRequest extends S3TablesRequest implements
        ToCopyableBuilder<RenameTableRequest.Builder, RenameTableRequest> {
    private static final SdkField<String> TABLE_BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableBucketARN").getter(getter(RenameTableRequest::tableBucketARN))
            .setter(setter(Builder::tableBucketARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("tableBucketARN").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(RenameTableRequest::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("namespace").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(RenameTableRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> NEW_NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("newNamespaceName").getter(getter(RenameTableRequest::newNamespaceName))
            .setter(setter(Builder::newNamespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newNamespaceName").build()).build();

    private static final SdkField<String> NEW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("newName").getter(getter(RenameTableRequest::newName)).setter(setter(Builder::newName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newName").build()).build();

    private static final SdkField<String> VERSION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionToken").getter(getter(RenameTableRequest::versionToken)).setter(setter(Builder::versionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_BUCKET_ARN_FIELD,
            NAMESPACE_FIELD, NAME_FIELD, NEW_NAMESPACE_NAME_FIELD, NEW_NAME_FIELD, VERSION_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String tableBucketARN;

    private final String namespace;

    private final String name;

    private final String newNamespaceName;

    private final String newName;

    private final String versionToken;

    private RenameTableRequest(BuilderImpl builder) {
        super(builder);
        this.tableBucketARN = builder.tableBucketARN;
        this.namespace = builder.namespace;
        this.name = builder.name;
        this.newNamespaceName = builder.newNamespaceName;
        this.newName = builder.newName;
        this.versionToken = builder.versionToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the table bucket.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the table bucket.
     */
    public final String tableBucketARN() {
        return tableBucketARN;
    }

    /**
     * <p>
     * The namespace associated with the table.
     * </p>
     * 
     * @return The namespace associated with the table.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The current name of the table.
     * </p>
     * 
     * @return The current name of the table.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The new name for the namespace.
     * </p>
     * 
     * @return The new name for the namespace.
     */
    public final String newNamespaceName() {
        return newNamespaceName;
    }

    /**
     * <p>
     * The new name for the table.
     * </p>
     * 
     * @return The new name for the table.
     */
    public final String newName() {
        return newName;
    }

    /**
     * <p>
     * The version token of the table.
     * </p>
     * 
     * @return The version token of the table.
     */
    public final String versionToken() {
        return versionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableBucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(newNamespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(newName());
        hashCode = 31 * hashCode + Objects.hashCode(versionToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenameTableRequest)) {
            return false;
        }
        RenameTableRequest other = (RenameTableRequest) obj;
        return Objects.equals(tableBucketARN(), other.tableBucketARN()) && Objects.equals(namespace(), other.namespace())
                && Objects.equals(name(), other.name()) && Objects.equals(newNamespaceName(), other.newNamespaceName())
                && Objects.equals(newName(), other.newName()) && Objects.equals(versionToken(), other.versionToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RenameTableRequest").add("TableBucketARN", tableBucketARN()).add("Namespace", namespace())
                .add("Name", name()).add("NewNamespaceName", newNamespaceName()).add("NewName", newName())
                .add("VersionToken", versionToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tableBucketARN":
            return Optional.ofNullable(clazz.cast(tableBucketARN()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "newNamespaceName":
            return Optional.ofNullable(clazz.cast(newNamespaceName()));
        case "newName":
            return Optional.ofNullable(clazz.cast(newName()));
        case "versionToken":
            return Optional.ofNullable(clazz.cast(versionToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tableBucketARN", TABLE_BUCKET_ARN_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("newNamespaceName", NEW_NAMESPACE_NAME_FIELD);
        map.put("newName", NEW_NAME_FIELD);
        map.put("versionToken", VERSION_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RenameTableRequest, T> g) {
        return obj -> g.apply((RenameTableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3TablesRequest.Builder, SdkPojo, CopyableBuilder<Builder, RenameTableRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the table bucket.
         * </p>
         * 
         * @param tableBucketARN
         *        The Amazon Resource Name (ARN) of the table bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableBucketARN(String tableBucketARN);

        /**
         * <p>
         * The namespace associated with the table.
         * </p>
         * 
         * @param namespace
         *        The namespace associated with the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The current name of the table.
         * </p>
         * 
         * @param name
         *        The current name of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The new name for the namespace.
         * </p>
         * 
         * @param newNamespaceName
         *        The new name for the namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newNamespaceName(String newNamespaceName);

        /**
         * <p>
         * The new name for the table.
         * </p>
         * 
         * @param newName
         *        The new name for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newName(String newName);

        /**
         * <p>
         * The version token of the table.
         * </p>
         * 
         * @param versionToken
         *        The version token of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionToken(String versionToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3TablesRequest.BuilderImpl implements Builder {
        private String tableBucketARN;

        private String namespace;

        private String name;

        private String newNamespaceName;

        private String newName;

        private String versionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(RenameTableRequest model) {
            super(model);
            tableBucketARN(model.tableBucketARN);
            namespace(model.namespace);
            name(model.name);
            newNamespaceName(model.newNamespaceName);
            newName(model.newName);
            versionToken(model.versionToken);
        }

        public final String getTableBucketARN() {
            return tableBucketARN;
        }

        public final void setTableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
        }

        @Override
        public final Builder tableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNewNamespaceName() {
            return newNamespaceName;
        }

        public final void setNewNamespaceName(String newNamespaceName) {
            this.newNamespaceName = newNamespaceName;
        }

        @Override
        public final Builder newNamespaceName(String newNamespaceName) {
            this.newNamespaceName = newNamespaceName;
            return this;
        }

        public final String getNewName() {
            return newName;
        }

        public final void setNewName(String newName) {
            this.newName = newName;
        }

        @Override
        public final Builder newName(String newName) {
            this.newName = newName;
            return this;
        }

        public final String getVersionToken() {
            return versionToken;
        }

        public final void setVersionToken(String versionToken) {
            this.versionToken = versionToken;
        }

        @Override
        public final Builder versionToken(String versionToken) {
            this.versionToken = versionToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RenameTableRequest build() {
            return new RenameTableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
