/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3tables.model.S3TablesRequest;
import software.amazon.awssdk.services.s3tables.model.TableBucketMaintenanceConfigurationValue;
import software.amazon.awssdk.services.s3tables.model.TableBucketMaintenanceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutTableBucketMaintenanceConfigurationRequest
extends S3TablesRequest
implements ToCopyableBuilder<Builder, PutTableBucketMaintenanceConfigurationRequest> {
    private static final SdkField<String> TABLE_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableBucketARN").getter(PutTableBucketMaintenanceConfigurationRequest.getter(PutTableBucketMaintenanceConfigurationRequest::tableBucketARN)).setter(PutTableBucketMaintenanceConfigurationRequest.setter(Builder::tableBucketARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("tableBucketARN").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(PutTableBucketMaintenanceConfigurationRequest.getter(PutTableBucketMaintenanceConfigurationRequest::typeAsString)).setter(PutTableBucketMaintenanceConfigurationRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("type").build()}).build();
    private static final SdkField<TableBucketMaintenanceConfigurationValue> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("value").getter(PutTableBucketMaintenanceConfigurationRequest.getter(PutTableBucketMaintenanceConfigurationRequest::value)).setter(PutTableBucketMaintenanceConfigurationRequest.setter(Builder::value)).constructor(TableBucketMaintenanceConfigurationValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_BUCKET_ARN_FIELD, TYPE_FIELD, VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutTableBucketMaintenanceConfigurationRequest.memberNameToFieldInitializer();
    private final String tableBucketARN;
    private final String type;
    private final TableBucketMaintenanceConfigurationValue value;

    private PutTableBucketMaintenanceConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.tableBucketARN = builder.tableBucketARN;
        this.type = builder.type;
        this.value = builder.value;
    }

    public final String tableBucketARN() {
        return this.tableBucketARN;
    }

    public final TableBucketMaintenanceType type() {
        return TableBucketMaintenanceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final TableBucketMaintenanceConfigurationValue value() {
        return this.value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tableBucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTableBucketMaintenanceConfigurationRequest)) {
            return false;
        }
        PutTableBucketMaintenanceConfigurationRequest other = (PutTableBucketMaintenanceConfigurationRequest)((Object)obj);
        return Objects.equals(this.tableBucketARN(), other.tableBucketARN()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"PutTableBucketMaintenanceConfigurationRequest").add("TableBucketARN", (Object)this.tableBucketARN()).add("Type", (Object)this.typeAsString()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tableBucketARN": {
                return Optional.ofNullable(clazz.cast(this.tableBucketARN()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tableBucketARN", TABLE_BUCKET_ARN_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutTableBucketMaintenanceConfigurationRequest, T> g) {
        return obj -> g.apply((PutTableBucketMaintenanceConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3TablesRequest.BuilderImpl
    implements Builder {
        private String tableBucketARN;
        private String type;
        private TableBucketMaintenanceConfigurationValue value;

        private BuilderImpl() {
        }

        private BuilderImpl(PutTableBucketMaintenanceConfigurationRequest model) {
            super(model);
            this.tableBucketARN(model.tableBucketARN);
            this.type(model.type);
            this.value(model.value);
        }

        public final String getTableBucketARN() {
            return this.tableBucketARN;
        }

        public final void setTableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
        }

        @Override
        public final Builder tableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TableBucketMaintenanceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final TableBucketMaintenanceConfigurationValue.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        public final void setValue(TableBucketMaintenanceConfigurationValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(TableBucketMaintenanceConfigurationValue value) {
            this.value = value;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutTableBucketMaintenanceConfigurationRequest build() {
            return new PutTableBucketMaintenanceConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3TablesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutTableBucketMaintenanceConfigurationRequest> {
        public Builder tableBucketARN(String var1);

        public Builder type(String var1);

        public Builder type(TableBucketMaintenanceType var1);

        public Builder value(TableBucketMaintenanceConfigurationValue var1);

        default public Builder value(Consumer<TableBucketMaintenanceConfigurationValue.Builder> value) {
            return this.value((TableBucketMaintenanceConfigurationValue)((TableBucketMaintenanceConfigurationValue.Builder)TableBucketMaintenanceConfigurationValue.builder().applyMutation(value)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

