/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3tables.model.S3TablesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetNamespaceRequest
extends S3TablesRequest
implements ToCopyableBuilder<Builder, GetNamespaceRequest> {
    private static final SdkField<String> TABLE_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableBucketARN").getter(GetNamespaceRequest.getter(GetNamespaceRequest::tableBucketARN)).setter(GetNamespaceRequest.setter(Builder::tableBucketARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("tableBucketARN").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(GetNamespaceRequest.getter(GetNamespaceRequest::namespace)).setter(GetNamespaceRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("namespace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_BUCKET_ARN_FIELD, NAMESPACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetNamespaceRequest.memberNameToFieldInitializer();
    private final String tableBucketARN;
    private final String namespace;

    private GetNamespaceRequest(BuilderImpl builder) {
        super(builder);
        this.tableBucketARN = builder.tableBucketARN;
        this.namespace = builder.namespace;
    }

    public final String tableBucketARN() {
        return this.tableBucketARN;
    }

    public final String namespace() {
        return this.namespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tableBucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNamespaceRequest)) {
            return false;
        }
        GetNamespaceRequest other = (GetNamespaceRequest)((Object)obj);
        return Objects.equals(this.tableBucketARN(), other.tableBucketARN()) && Objects.equals(this.namespace(), other.namespace());
    }

    public final String toString() {
        return ToString.builder((String)"GetNamespaceRequest").add("TableBucketARN", (Object)this.tableBucketARN()).add("Namespace", (Object)this.namespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tableBucketARN": {
                return Optional.ofNullable(clazz.cast(this.tableBucketARN()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("tableBucketARN", TABLE_BUCKET_ARN_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetNamespaceRequest, T> g) {
        return obj -> g.apply((GetNamespaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3TablesRequest.BuilderImpl
    implements Builder {
        private String tableBucketARN;
        private String namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNamespaceRequest model) {
            super(model);
            this.tableBucketARN(model.tableBucketARN);
            this.namespace(model.namespace);
        }

        public final String getTableBucketARN() {
            return this.tableBucketARN;
        }

        public final void setTableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
        }

        @Override
        public final Builder tableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetNamespaceRequest build() {
            return new GetNamespaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3TablesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetNamespaceRequest> {
        public Builder tableBucketARN(String var1);

        public Builder namespace(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

