/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3tables;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.s3tables.model.AccessDeniedException;
import software.amazon.awssdk.services.s3tables.model.BadRequestException;
import software.amazon.awssdk.services.s3tables.model.ConflictException;
import software.amazon.awssdk.services.s3tables.model.CreateNamespaceRequest;
import software.amazon.awssdk.services.s3tables.model.CreateNamespaceResponse;
import software.amazon.awssdk.services.s3tables.model.CreateTableBucketRequest;
import software.amazon.awssdk.services.s3tables.model.CreateTableBucketResponse;
import software.amazon.awssdk.services.s3tables.model.CreateTableRequest;
import software.amazon.awssdk.services.s3tables.model.CreateTableResponse;
import software.amazon.awssdk.services.s3tables.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.s3tables.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.s3tables.model.DeleteTableBucketEncryptionRequest;
import software.amazon.awssdk.services.s3tables.model.DeleteTableBucketEncryptionResponse;
import software.amazon.awssdk.services.s3tables.model.DeleteTableBucketPolicyRequest;
import software.amazon.awssdk.services.s3tables.model.DeleteTableBucketPolicyResponse;
import software.amazon.awssdk.services.s3tables.model.DeleteTableBucketRequest;
import software.amazon.awssdk.services.s3tables.model.DeleteTableBucketResponse;
import software.amazon.awssdk.services.s3tables.model.DeleteTablePolicyRequest;
import software.amazon.awssdk.services.s3tables.model.DeleteTablePolicyResponse;
import software.amazon.awssdk.services.s3tables.model.DeleteTableRequest;
import software.amazon.awssdk.services.s3tables.model.DeleteTableResponse;
import software.amazon.awssdk.services.s3tables.model.ForbiddenException;
import software.amazon.awssdk.services.s3tables.model.GetNamespaceRequest;
import software.amazon.awssdk.services.s3tables.model.GetNamespaceResponse;
import software.amazon.awssdk.services.s3tables.model.GetTableBucketEncryptionRequest;
import software.amazon.awssdk.services.s3tables.model.GetTableBucketEncryptionResponse;
import software.amazon.awssdk.services.s3tables.model.GetTableBucketMaintenanceConfigurationRequest;
import software.amazon.awssdk.services.s3tables.model.GetTableBucketMaintenanceConfigurationResponse;
import software.amazon.awssdk.services.s3tables.model.GetTableBucketPolicyRequest;
import software.amazon.awssdk.services.s3tables.model.GetTableBucketPolicyResponse;
import software.amazon.awssdk.services.s3tables.model.GetTableBucketRequest;
import software.amazon.awssdk.services.s3tables.model.GetTableBucketResponse;
import software.amazon.awssdk.services.s3tables.model.GetTableEncryptionRequest;
import software.amazon.awssdk.services.s3tables.model.GetTableEncryptionResponse;
import software.amazon.awssdk.services.s3tables.model.GetTableMaintenanceConfigurationRequest;
import software.amazon.awssdk.services.s3tables.model.GetTableMaintenanceConfigurationResponse;
import software.amazon.awssdk.services.s3tables.model.GetTableMaintenanceJobStatusRequest;
import software.amazon.awssdk.services.s3tables.model.GetTableMaintenanceJobStatusResponse;
import software.amazon.awssdk.services.s3tables.model.GetTableMetadataLocationRequest;
import software.amazon.awssdk.services.s3tables.model.GetTableMetadataLocationResponse;
import software.amazon.awssdk.services.s3tables.model.GetTablePolicyRequest;
import software.amazon.awssdk.services.s3tables.model.GetTablePolicyResponse;
import software.amazon.awssdk.services.s3tables.model.GetTableRequest;
import software.amazon.awssdk.services.s3tables.model.GetTableResponse;
import software.amazon.awssdk.services.s3tables.model.InternalServerErrorException;
import software.amazon.awssdk.services.s3tables.model.ListNamespacesRequest;
import software.amazon.awssdk.services.s3tables.model.ListNamespacesResponse;
import software.amazon.awssdk.services.s3tables.model.ListTableBucketsRequest;
import software.amazon.awssdk.services.s3tables.model.ListTableBucketsResponse;
import software.amazon.awssdk.services.s3tables.model.ListTablesRequest;
import software.amazon.awssdk.services.s3tables.model.ListTablesResponse;
import software.amazon.awssdk.services.s3tables.model.NotFoundException;
import software.amazon.awssdk.services.s3tables.model.PutTableBucketEncryptionRequest;
import software.amazon.awssdk.services.s3tables.model.PutTableBucketEncryptionResponse;
import software.amazon.awssdk.services.s3tables.model.PutTableBucketMaintenanceConfigurationRequest;
import software.amazon.awssdk.services.s3tables.model.PutTableBucketMaintenanceConfigurationResponse;
import software.amazon.awssdk.services.s3tables.model.PutTableBucketPolicyRequest;
import software.amazon.awssdk.services.s3tables.model.PutTableBucketPolicyResponse;
import software.amazon.awssdk.services.s3tables.model.PutTableMaintenanceConfigurationRequest;
import software.amazon.awssdk.services.s3tables.model.PutTableMaintenanceConfigurationResponse;
import software.amazon.awssdk.services.s3tables.model.PutTablePolicyRequest;
import software.amazon.awssdk.services.s3tables.model.PutTablePolicyResponse;
import software.amazon.awssdk.services.s3tables.model.RenameTableRequest;
import software.amazon.awssdk.services.s3tables.model.RenameTableResponse;
import software.amazon.awssdk.services.s3tables.model.S3TablesException;
import software.amazon.awssdk.services.s3tables.model.TooManyRequestsException;
import software.amazon.awssdk.services.s3tables.model.UpdateTableMetadataLocationRequest;
import software.amazon.awssdk.services.s3tables.model.UpdateTableMetadataLocationResponse;
import software.amazon.awssdk.services.s3tables.paginators.ListNamespacesIterable;
import software.amazon.awssdk.services.s3tables.paginators.ListTableBucketsIterable;
import software.amazon.awssdk.services.s3tables.paginators.ListTablesIterable;

/**
 * Service client for accessing Amazon S3 Tables. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * An Amazon S3 table represents a structured dataset consisting of tabular data in <a
 * href="https://parquet.apache.org/docs/">Apache Parquet</a> format and related metadata. This data is stored inside an
 * S3 table as a subresource. All tables in a table bucket are stored in the <a
 * href="https://iceberg.apache.org/docs/latest/">Apache Iceberg</a> table format. Through integration with the <a
 * href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/glue/latest/dg/catalog-and-crawler.html">Amazon Web
 * Services Glue Data Catalog</a> you can interact with your tables using Amazon Web Services analytics services, such
 * as <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/athena/">Amazon Athena</a> and <a
 * href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/redshift/">Amazon Redshift</a>. Amazon S3 manages
 * maintenance of your tables through automatic file compaction and snapshot management. For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-buckets.html">Amazon S3 table buckets</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface S3TablesClient extends AwsClient {
    String SERVICE_NAME = "s3tables";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "s3tables";

    /**
     * <p>
     * Creates a namespace. A namespace is a logical grouping of tables within your table bucket, which you can use to
     * organize tables. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-namespace-create.html">Create a
     * namespace</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:CreateNamespace</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param createNamespaceRequest
     * @return Result of the CreateNamespace operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.CreateNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/CreateNamespace" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateNamespaceResponse createNamespace(CreateNamespaceRequest createNamespaceRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a namespace. A namespace is a logical grouping of tables within your table bucket, which you can use to
     * organize tables. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-namespace-create.html">Create a
     * namespace</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:CreateNamespace</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNamespaceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateNamespaceRequest#builder()}
     * </p>
     *
     * @param createNamespaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.CreateNamespaceRequest.Builder} to create a request.
     * @return Result of the CreateNamespace operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.CreateNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/CreateNamespace" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateNamespaceResponse createNamespace(Consumer<CreateNamespaceRequest.Builder> createNamespaceRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        return createNamespace(CreateNamespaceRequest.builder().applyMutation(createNamespaceRequest).build());
    }

    /**
     * <p>
     * Creates a new table associated with the given namespace in a table bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-create.html">Creating an Amazon S3
     * table</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * You must have the <code>s3tables:CreateTable</code> permission to use this operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you use this operation with the optional <code>metadata</code> request parameter you must have the
     * <code>s3tables:PutTableData</code> permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you use this operation with the optional <code>encryptionConfiguration</code> request parameter you must have
     * the <code>s3tables:PutTableEncryption</code> permission.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Additionally, If you choose SSE-KMS encryption you must grant the S3 Tables maintenance principal access to your
     * KMS key. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-kms-permissions.html">Permissions
     * requirements for S3 Tables SSE-KMS encryption</a>.
     * </p>
     * </note></dd>
     * </dl>
     *
     * @param createTableRequest
     * @return Result of the CreateTable operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.CreateTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/CreateTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTableResponse createTable(CreateTableRequest createTableRequest) throws InternalServerErrorException,
            ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, BadRequestException,
            AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new table associated with the given namespace in a table bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-create.html">Creating an Amazon S3
     * table</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * You must have the <code>s3tables:CreateTable</code> permission to use this operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you use this operation with the optional <code>metadata</code> request parameter you must have the
     * <code>s3tables:PutTableData</code> permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you use this operation with the optional <code>encryptionConfiguration</code> request parameter you must have
     * the <code>s3tables:PutTableEncryption</code> permission.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Additionally, If you choose SSE-KMS encryption you must grant the S3 Tables maintenance principal access to your
     * KMS key. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-kms-permissions.html">Permissions
     * requirements for S3 Tables SSE-KMS encryption</a>.
     * </p>
     * </note></dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTableRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTableRequest#builder()}
     * </p>
     *
     * @param createTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.CreateTableRequest.Builder} to create a request.
     * @return Result of the CreateTable operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.CreateTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/CreateTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTableResponse createTable(Consumer<CreateTableRequest.Builder> createTableRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        return createTable(CreateTableRequest.builder().applyMutation(createTableRequest).build());
    }

    /**
     * <p>
     * Creates a table bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-buckets-create.html">Creating a table
     * bucket</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * You must have the <code>s3tables:CreateTableBucket</code> permission to use this operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you use this operation with the optional <code>encryptionConfiguration</code> parameter you must have the
     * <code>s3tables:PutTableBucketEncryption</code> permission.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     *
     * @param createTableBucketRequest
     * @return Result of the CreateTableBucket operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.CreateTableBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/CreateTableBucket" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTableBucketResponse createTableBucket(CreateTableBucketRequest createTableBucketRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a table bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-buckets-create.html">Creating a table
     * bucket</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <ul>
     * <li>
     * <p>
     * You must have the <code>s3tables:CreateTableBucket</code> permission to use this operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you use this operation with the optional <code>encryptionConfiguration</code> parameter you must have the
     * <code>s3tables:PutTableBucketEncryption</code> permission.
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTableBucketRequest.Builder} avoiding the need
     * to create one manually via {@link CreateTableBucketRequest#builder()}
     * </p>
     *
     * @param createTableBucketRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.CreateTableBucketRequest.Builder} to create a
     *        request.
     * @return Result of the CreateTableBucket operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.CreateTableBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/CreateTableBucket" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTableBucketResponse createTableBucket(Consumer<CreateTableBucketRequest.Builder> createTableBucketRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        return createTableBucket(CreateTableBucketRequest.builder().applyMutation(createTableBucketRequest).build());
    }

    /**
     * <p>
     * Deletes a namespace. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-namespace-delete.html">Delete a
     * namespace</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:DeleteNamespace</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param deleteNamespaceRequest
     * @return Result of the DeleteNamespace operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.DeleteNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/DeleteNamespace" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteNamespaceResponse deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a namespace. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-namespace-delete.html">Delete a
     * namespace</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:DeleteNamespace</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNamespaceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteNamespaceRequest#builder()}
     * </p>
     *
     * @param deleteNamespaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.DeleteNamespaceRequest.Builder} to create a request.
     * @return Result of the DeleteNamespace operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.DeleteNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/DeleteNamespace" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteNamespaceResponse deleteNamespace(Consumer<DeleteNamespaceRequest.Builder> deleteNamespaceRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        return deleteNamespace(DeleteNamespaceRequest.builder().applyMutation(deleteNamespaceRequest).build());
    }

    /**
     * <p>
     * Deletes a table. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-delete.html">Deleting an Amazon S3
     * table</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:DeleteTable</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param deleteTableRequest
     * @return Result of the DeleteTable operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.DeleteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/DeleteTable" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTableResponse deleteTable(DeleteTableRequest deleteTableRequest) throws InternalServerErrorException,
            ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, BadRequestException,
            AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a table. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-delete.html">Deleting an Amazon S3
     * table</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:DeleteTable</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTableRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTableRequest#builder()}
     * </p>
     *
     * @param deleteTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.DeleteTableRequest.Builder} to create a request.
     * @return Result of the DeleteTable operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.DeleteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/DeleteTable" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTableResponse deleteTable(Consumer<DeleteTableRequest.Builder> deleteTableRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        return deleteTable(DeleteTableRequest.builder().applyMutation(deleteTableRequest).build());
    }

    /**
     * <p>
     * Deletes a table bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-buckets-delete.html">Deleting a table
     * bucket</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:DeleteTableBucket</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param deleteTableBucketRequest
     * @return Result of the DeleteTableBucket operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.DeleteTableBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/DeleteTableBucket" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTableBucketResponse deleteTableBucket(DeleteTableBucketRequest deleteTableBucketRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a table bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-buckets-delete.html">Deleting a table
     * bucket</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:DeleteTableBucket</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTableBucketRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteTableBucketRequest#builder()}
     * </p>
     *
     * @param deleteTableBucketRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.DeleteTableBucketRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteTableBucket operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.DeleteTableBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/DeleteTableBucket" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTableBucketResponse deleteTableBucket(Consumer<DeleteTableBucketRequest.Builder> deleteTableBucketRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        return deleteTableBucket(DeleteTableBucketRequest.builder().applyMutation(deleteTableBucketRequest).build());
    }

    /**
     * <p>
     * Deletes the encryption configuration for a table bucket.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:DeleteTableBucketEncryption</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param deleteTableBucketEncryptionRequest
     * @return Result of the DeleteTableBucketEncryption operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.DeleteTableBucketEncryption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/DeleteTableBucketEncryption"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTableBucketEncryptionResponse deleteTableBucketEncryption(
            DeleteTableBucketEncryptionRequest deleteTableBucketEncryptionRequest) throws InternalServerErrorException,
            ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, BadRequestException,
            AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the encryption configuration for a table bucket.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:DeleteTableBucketEncryption</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTableBucketEncryptionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteTableBucketEncryptionRequest#builder()}
     * </p>
     *
     * @param deleteTableBucketEncryptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.DeleteTableBucketEncryptionRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteTableBucketEncryption operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.DeleteTableBucketEncryption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/DeleteTableBucketEncryption"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTableBucketEncryptionResponse deleteTableBucketEncryption(
            Consumer<DeleteTableBucketEncryptionRequest.Builder> deleteTableBucketEncryptionRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        return deleteTableBucketEncryption(DeleteTableBucketEncryptionRequest.builder()
                .applyMutation(deleteTableBucketEncryptionRequest).build());
    }

    /**
     * <p>
     * Deletes a table bucket policy. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-bucket-policy.html#table-bucket-policy-delete"
     * >Deleting a table bucket policy</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:DeleteTableBucketPolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param deleteTableBucketPolicyRequest
     * @return Result of the DeleteTableBucketPolicy operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.DeleteTableBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/DeleteTableBucketPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTableBucketPolicyResponse deleteTableBucketPolicy(DeleteTableBucketPolicyRequest deleteTableBucketPolicyRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a table bucket policy. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-bucket-policy.html#table-bucket-policy-delete"
     * >Deleting a table bucket policy</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:DeleteTableBucketPolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTableBucketPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteTableBucketPolicyRequest#builder()}
     * </p>
     *
     * @param deleteTableBucketPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.DeleteTableBucketPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteTableBucketPolicy operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.DeleteTableBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/DeleteTableBucketPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTableBucketPolicyResponse deleteTableBucketPolicy(
            Consumer<DeleteTableBucketPolicyRequest.Builder> deleteTableBucketPolicyRequest) throws InternalServerErrorException,
            ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, BadRequestException,
            AwsServiceException, SdkClientException, S3TablesException {
        return deleteTableBucketPolicy(DeleteTableBucketPolicyRequest.builder().applyMutation(deleteTableBucketPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a table policy. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-table-policy.html#table-policy-delete"
     * >Deleting a table policy</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:DeleteTablePolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param deleteTablePolicyRequest
     * @return Result of the DeleteTablePolicy operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.DeleteTablePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/DeleteTablePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTablePolicyResponse deleteTablePolicy(DeleteTablePolicyRequest deleteTablePolicyRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a table policy. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-table-policy.html#table-policy-delete"
     * >Deleting a table policy</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:DeleteTablePolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTablePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteTablePolicyRequest#builder()}
     * </p>
     *
     * @param deleteTablePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.DeleteTablePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteTablePolicy operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.DeleteTablePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/DeleteTablePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTablePolicyResponse deleteTablePolicy(Consumer<DeleteTablePolicyRequest.Builder> deleteTablePolicyRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        return deleteTablePolicy(DeleteTablePolicyRequest.builder().applyMutation(deleteTablePolicyRequest).build());
    }

    /**
     * <p>
     * Gets details about a namespace. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-namespace.html">Table namespaces</a> in the
     * <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:GetNamespace</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param getNamespaceRequest
     * @return Result of the GetNamespace operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws AccessDeniedException
     *         The action cannot be performed because you do not have the required permission.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.GetNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetNamespace" target="_top">AWS API
     *      Documentation</a>
     */
    default GetNamespaceResponse getNamespace(GetNamespaceRequest getNamespaceRequest) throws InternalServerErrorException,
            ForbiddenException, NotFoundException, AccessDeniedException, TooManyRequestsException, ConflictException,
            BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a namespace. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-namespace.html">Table namespaces</a> in the
     * <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:GetNamespace</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNamespaceRequest.Builder} avoiding the need to
     * create one manually via {@link GetNamespaceRequest#builder()}
     * </p>
     *
     * @param getNamespaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.GetNamespaceRequest.Builder} to create a request.
     * @return Result of the GetNamespace operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws AccessDeniedException
     *         The action cannot be performed because you do not have the required permission.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.GetNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetNamespace" target="_top">AWS API
     *      Documentation</a>
     */
    default GetNamespaceResponse getNamespace(Consumer<GetNamespaceRequest.Builder> getNamespaceRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, AccessDeniedException,
            TooManyRequestsException, ConflictException, BadRequestException, AwsServiceException, SdkClientException,
            S3TablesException {
        return getNamespace(GetNamespaceRequest.builder().applyMutation(getNamespaceRequest).build());
    }

    /**
     * <p>
     * Gets details about a table. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-tables.html">S3 Tables</a> in the <i>Amazon
     * Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:GetTable</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param getTableRequest
     * @return Result of the GetTable operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws AccessDeniedException
     *         The action cannot be performed because you do not have the required permission.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.GetTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTable" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTableResponse getTable(GetTableRequest getTableRequest) throws InternalServerErrorException, ForbiddenException,
            NotFoundException, AccessDeniedException, TooManyRequestsException, ConflictException, BadRequestException,
            AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a table. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-tables.html">S3 Tables</a> in the <i>Amazon
     * Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:GetTable</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableRequest.Builder} avoiding the need to
     * create one manually via {@link GetTableRequest#builder()}
     * </p>
     *
     * @param getTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.GetTableRequest.Builder} to create a request.
     * @return Result of the GetTable operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws AccessDeniedException
     *         The action cannot be performed because you do not have the required permission.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.GetTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTable" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTableResponse getTable(Consumer<GetTableRequest.Builder> getTableRequest) throws InternalServerErrorException,
            ForbiddenException, NotFoundException, AccessDeniedException, TooManyRequestsException, ConflictException,
            BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        return getTable(GetTableRequest.builder().applyMutation(getTableRequest).build());
    }

    /**
     * <p>
     * Gets details on a table bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-buckets-details.html">Viewing details about
     * an Amazon S3 table bucket</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:GetTableBucket</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param getTableBucketRequest
     * @return Result of the GetTableBucket operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws AccessDeniedException
     *         The action cannot be performed because you do not have the required permission.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.GetTableBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableBucket" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTableBucketResponse getTableBucket(GetTableBucketRequest getTableBucketRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, AccessDeniedException,
            TooManyRequestsException, ConflictException, BadRequestException, AwsServiceException, SdkClientException,
            S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details on a table bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-buckets-details.html">Viewing details about
     * an Amazon S3 table bucket</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:GetTableBucket</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableBucketRequest.Builder} avoiding the need to
     * create one manually via {@link GetTableBucketRequest#builder()}
     * </p>
     *
     * @param getTableBucketRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.GetTableBucketRequest.Builder} to create a request.
     * @return Result of the GetTableBucket operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws AccessDeniedException
     *         The action cannot be performed because you do not have the required permission.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.GetTableBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableBucket" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTableBucketResponse getTableBucket(Consumer<GetTableBucketRequest.Builder> getTableBucketRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, AccessDeniedException,
            TooManyRequestsException, ConflictException, BadRequestException, AwsServiceException, SdkClientException,
            S3TablesException {
        return getTableBucket(GetTableBucketRequest.builder().applyMutation(getTableBucketRequest).build());
    }

    /**
     * <p>
     * Gets the encryption configuration for a table bucket.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:GetTableBucketEncryption</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param getTableBucketEncryptionRequest
     * @return Result of the GetTableBucketEncryption operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws AccessDeniedException
     *         The action cannot be performed because you do not have the required permission.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.GetTableBucketEncryption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableBucketEncryption"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTableBucketEncryptionResponse getTableBucketEncryption(
            GetTableBucketEncryptionRequest getTableBucketEncryptionRequest) throws InternalServerErrorException,
            ForbiddenException, NotFoundException, AccessDeniedException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the encryption configuration for a table bucket.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:GetTableBucketEncryption</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableBucketEncryptionRequest.Builder} avoiding
     * the need to create one manually via {@link GetTableBucketEncryptionRequest#builder()}
     * </p>
     *
     * @param getTableBucketEncryptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.GetTableBucketEncryptionRequest.Builder} to create a
     *        request.
     * @return Result of the GetTableBucketEncryption operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws AccessDeniedException
     *         The action cannot be performed because you do not have the required permission.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.GetTableBucketEncryption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableBucketEncryption"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTableBucketEncryptionResponse getTableBucketEncryption(
            Consumer<GetTableBucketEncryptionRequest.Builder> getTableBucketEncryptionRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, AccessDeniedException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        return getTableBucketEncryption(GetTableBucketEncryptionRequest.builder().applyMutation(getTableBucketEncryptionRequest)
                .build());
    }

    /**
     * <p>
     * Gets details about a maintenance configuration for a given table bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-table-buckets-maintenance.html">Amazon S3 table
     * bucket maintenance</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:GetTableBucketMaintenanceConfiguration</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param getTableBucketMaintenanceConfigurationRequest
     * @return Result of the GetTableBucketMaintenanceConfiguration operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.GetTableBucketMaintenanceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableBucketMaintenanceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTableBucketMaintenanceConfigurationResponse getTableBucketMaintenanceConfiguration(
            GetTableBucketMaintenanceConfigurationRequest getTableBucketMaintenanceConfigurationRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a maintenance configuration for a given table bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-table-buckets-maintenance.html">Amazon S3 table
     * bucket maintenance</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:GetTableBucketMaintenanceConfiguration</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetTableBucketMaintenanceConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link GetTableBucketMaintenanceConfigurationRequest#builder()}
     * </p>
     *
     * @param getTableBucketMaintenanceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.GetTableBucketMaintenanceConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the GetTableBucketMaintenanceConfiguration operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.GetTableBucketMaintenanceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableBucketMaintenanceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTableBucketMaintenanceConfigurationResponse getTableBucketMaintenanceConfiguration(
            Consumer<GetTableBucketMaintenanceConfigurationRequest.Builder> getTableBucketMaintenanceConfigurationRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        return getTableBucketMaintenanceConfiguration(GetTableBucketMaintenanceConfigurationRequest.builder()
                .applyMutation(getTableBucketMaintenanceConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets details about a table bucket policy. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-bucket-policy.html#table-bucket-policy-get"
     * >Viewing a table bucket policy</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:GetTableBucketPolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param getTableBucketPolicyRequest
     * @return Result of the GetTableBucketPolicy operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.GetTableBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableBucketPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetTableBucketPolicyResponse getTableBucketPolicy(GetTableBucketPolicyRequest getTableBucketPolicyRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a table bucket policy. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-bucket-policy.html#table-bucket-policy-get"
     * >Viewing a table bucket policy</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:GetTableBucketPolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableBucketPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetTableBucketPolicyRequest#builder()}
     * </p>
     *
     * @param getTableBucketPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.GetTableBucketPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetTableBucketPolicy operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.GetTableBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableBucketPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetTableBucketPolicyResponse getTableBucketPolicy(
            Consumer<GetTableBucketPolicyRequest.Builder> getTableBucketPolicyRequest) throws InternalServerErrorException,
            ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, BadRequestException,
            AwsServiceException, SdkClientException, S3TablesException {
        return getTableBucketPolicy(GetTableBucketPolicyRequest.builder().applyMutation(getTableBucketPolicyRequest).build());
    }

    /**
     * <p>
     * Gets the encryption configuration for a table.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:GetTableEncryption</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param getTableEncryptionRequest
     * @return Result of the GetTableEncryption operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws AccessDeniedException
     *         The action cannot be performed because you do not have the required permission.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.GetTableEncryption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableEncryption" target="_top">AWS
     *      API Documentation</a>
     */
    default GetTableEncryptionResponse getTableEncryption(GetTableEncryptionRequest getTableEncryptionRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, AccessDeniedException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the encryption configuration for a table.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:GetTableEncryption</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableEncryptionRequest.Builder} avoiding the
     * need to create one manually via {@link GetTableEncryptionRequest#builder()}
     * </p>
     *
     * @param getTableEncryptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.GetTableEncryptionRequest.Builder} to create a
     *        request.
     * @return Result of the GetTableEncryption operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws AccessDeniedException
     *         The action cannot be performed because you do not have the required permission.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.GetTableEncryption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableEncryption" target="_top">AWS
     *      API Documentation</a>
     */
    default GetTableEncryptionResponse getTableEncryption(Consumer<GetTableEncryptionRequest.Builder> getTableEncryptionRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, AccessDeniedException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        return getTableEncryption(GetTableEncryptionRequest.builder().applyMutation(getTableEncryptionRequest).build());
    }

    /**
     * <p>
     * Gets details about the maintenance configuration of a table. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-maintenance.html">S3 Tables maintenance</a>
     * in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:GetTableMaintenanceConfiguration</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param getTableMaintenanceConfigurationRequest
     * @return Result of the GetTableMaintenanceConfiguration operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.GetTableMaintenanceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableMaintenanceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTableMaintenanceConfigurationResponse getTableMaintenanceConfiguration(
            GetTableMaintenanceConfigurationRequest getTableMaintenanceConfigurationRequest) throws InternalServerErrorException,
            ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, BadRequestException,
            AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about the maintenance configuration of a table. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-maintenance.html">S3 Tables maintenance</a>
     * in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:GetTableMaintenanceConfiguration</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableMaintenanceConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetTableMaintenanceConfigurationRequest#builder()}
     * </p>
     *
     * @param getTableMaintenanceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.GetTableMaintenanceConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the GetTableMaintenanceConfiguration operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.GetTableMaintenanceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableMaintenanceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTableMaintenanceConfigurationResponse getTableMaintenanceConfiguration(
            Consumer<GetTableMaintenanceConfigurationRequest.Builder> getTableMaintenanceConfigurationRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        return getTableMaintenanceConfiguration(GetTableMaintenanceConfigurationRequest.builder()
                .applyMutation(getTableMaintenanceConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets the status of a maintenance job for a table. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-maintenance.html">S3 Tables maintenance</a>
     * in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:GetTableMaintenanceJobStatus</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param getTableMaintenanceJobStatusRequest
     * @return Result of the GetTableMaintenanceJobStatus operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.GetTableMaintenanceJobStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableMaintenanceJobStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTableMaintenanceJobStatusResponse getTableMaintenanceJobStatus(
            GetTableMaintenanceJobStatusRequest getTableMaintenanceJobStatusRequest) throws InternalServerErrorException,
            ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, BadRequestException,
            AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status of a maintenance job for a table. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-maintenance.html">S3 Tables maintenance</a>
     * in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:GetTableMaintenanceJobStatus</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableMaintenanceJobStatusRequest.Builder}
     * avoiding the need to create one manually via {@link GetTableMaintenanceJobStatusRequest#builder()}
     * </p>
     *
     * @param getTableMaintenanceJobStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.GetTableMaintenanceJobStatusRequest.Builder} to
     *        create a request.
     * @return Result of the GetTableMaintenanceJobStatus operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.GetTableMaintenanceJobStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableMaintenanceJobStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTableMaintenanceJobStatusResponse getTableMaintenanceJobStatus(
            Consumer<GetTableMaintenanceJobStatusRequest.Builder> getTableMaintenanceJobStatusRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        return getTableMaintenanceJobStatus(GetTableMaintenanceJobStatusRequest.builder()
                .applyMutation(getTableMaintenanceJobStatusRequest).build());
    }

    /**
     * <p>
     * Gets the location of the table metadata.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:GetTableMetadataLocation</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param getTableMetadataLocationRequest
     * @return Result of the GetTableMetadataLocation operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.GetTableMetadataLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableMetadataLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTableMetadataLocationResponse getTableMetadataLocation(
            GetTableMetadataLocationRequest getTableMetadataLocationRequest) throws InternalServerErrorException,
            ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, BadRequestException,
            AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the location of the table metadata.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:GetTableMetadataLocation</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableMetadataLocationRequest.Builder} avoiding
     * the need to create one manually via {@link GetTableMetadataLocationRequest#builder()}
     * </p>
     *
     * @param getTableMetadataLocationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.GetTableMetadataLocationRequest.Builder} to create a
     *        request.
     * @return Result of the GetTableMetadataLocation operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.GetTableMetadataLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTableMetadataLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTableMetadataLocationResponse getTableMetadataLocation(
            Consumer<GetTableMetadataLocationRequest.Builder> getTableMetadataLocationRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        return getTableMetadataLocation(GetTableMetadataLocationRequest.builder().applyMutation(getTableMetadataLocationRequest)
                .build());
    }

    /**
     * <p>
     * Gets details about a table policy. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-table-policy.html#table-policy-get">Viewing
     * a table policy</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:GetTablePolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param getTablePolicyRequest
     * @return Result of the GetTablePolicy operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.GetTablePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTablePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTablePolicyResponse getTablePolicy(GetTablePolicyRequest getTablePolicyRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a table policy. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-table-policy.html#table-policy-get">Viewing
     * a table policy</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:GetTablePolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTablePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetTablePolicyRequest#builder()}
     * </p>
     *
     * @param getTablePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.GetTablePolicyRequest.Builder} to create a request.
     * @return Result of the GetTablePolicy operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.GetTablePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/GetTablePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTablePolicyResponse getTablePolicy(Consumer<GetTablePolicyRequest.Builder> getTablePolicyRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        return getTablePolicy(GetTablePolicyRequest.builder().applyMutation(getTablePolicyRequest).build());
    }

    /**
     * <p>
     * Lists the namespaces within a table bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-namespace.html">Table namespaces</a> in the
     * <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:ListNamespaces</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param listNamespacesRequest
     * @return Result of the ListNamespaces operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws AccessDeniedException
     *         The action cannot be performed because you do not have the required permission.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.ListNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/ListNamespaces" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNamespacesResponse listNamespaces(ListNamespacesRequest listNamespacesRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, AccessDeniedException,
            TooManyRequestsException, ConflictException, BadRequestException, AwsServiceException, SdkClientException,
            S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the namespaces within a table bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-namespace.html">Table namespaces</a> in the
     * <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:ListNamespaces</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNamespacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNamespacesRequest#builder()}
     * </p>
     *
     * @param listNamespacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.ListNamespacesRequest.Builder} to create a request.
     * @return Result of the ListNamespaces operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws AccessDeniedException
     *         The action cannot be performed because you do not have the required permission.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.ListNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/ListNamespaces" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNamespacesResponse listNamespaces(Consumer<ListNamespacesRequest.Builder> listNamespacesRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, AccessDeniedException,
            TooManyRequestsException, ConflictException, BadRequestException, AwsServiceException, SdkClientException,
            S3TablesException {
        return listNamespaces(ListNamespacesRequest.builder().applyMutation(listNamespacesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNamespaces(software.amazon.awssdk.services.s3tables.model.ListNamespacesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3tables.paginators.ListNamespacesIterable responses = client.listNamespacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3tables.paginators.ListNamespacesIterable responses = client
     *             .listNamespacesPaginator(request);
     *     for (software.amazon.awssdk.services.s3tables.model.ListNamespacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3tables.paginators.ListNamespacesIterable responses = client.listNamespacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxNamespaces won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNamespaces(software.amazon.awssdk.services.s3tables.model.ListNamespacesRequest)} operation.</b>
     * </p>
     *
     * @param listNamespacesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws AccessDeniedException
     *         The action cannot be performed because you do not have the required permission.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.ListNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/ListNamespaces" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNamespacesIterable listNamespacesPaginator(ListNamespacesRequest listNamespacesRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, AccessDeniedException,
            TooManyRequestsException, ConflictException, BadRequestException, AwsServiceException, SdkClientException,
            S3TablesException {
        return new ListNamespacesIterable(this, listNamespacesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNamespaces(software.amazon.awssdk.services.s3tables.model.ListNamespacesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3tables.paginators.ListNamespacesIterable responses = client.listNamespacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3tables.paginators.ListNamespacesIterable responses = client
     *             .listNamespacesPaginator(request);
     *     for (software.amazon.awssdk.services.s3tables.model.ListNamespacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3tables.paginators.ListNamespacesIterable responses = client.listNamespacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxNamespaces won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNamespaces(software.amazon.awssdk.services.s3tables.model.ListNamespacesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNamespacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNamespacesRequest#builder()}
     * </p>
     *
     * @param listNamespacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.ListNamespacesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws AccessDeniedException
     *         The action cannot be performed because you do not have the required permission.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.ListNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/ListNamespaces" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNamespacesIterable listNamespacesPaginator(Consumer<ListNamespacesRequest.Builder> listNamespacesRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, AccessDeniedException,
            TooManyRequestsException, ConflictException, BadRequestException, AwsServiceException, SdkClientException,
            S3TablesException {
        return listNamespacesPaginator(ListNamespacesRequest.builder().applyMutation(listNamespacesRequest).build());
    }

    /**
     * <p>
     * Lists table buckets for your account. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-buckets.html">S3 Table buckets</a> in the
     * <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:ListTableBuckets</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param listTableBucketsRequest
     * @return Result of the ListTableBuckets operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws AccessDeniedException
     *         The action cannot be performed because you do not have the required permission.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.ListTableBuckets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/ListTableBuckets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTableBucketsResponse listTableBuckets(ListTableBucketsRequest listTableBucketsRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, AccessDeniedException,
            TooManyRequestsException, ConflictException, BadRequestException, AwsServiceException, SdkClientException,
            S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists table buckets for your account. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-buckets.html">S3 Table buckets</a> in the
     * <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:ListTableBuckets</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTableBucketsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTableBucketsRequest#builder()}
     * </p>
     *
     * @param listTableBucketsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.ListTableBucketsRequest.Builder} to create a
     *        request.
     * @return Result of the ListTableBuckets operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws AccessDeniedException
     *         The action cannot be performed because you do not have the required permission.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.ListTableBuckets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/ListTableBuckets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTableBucketsResponse listTableBuckets(Consumer<ListTableBucketsRequest.Builder> listTableBucketsRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, AccessDeniedException,
            TooManyRequestsException, ConflictException, BadRequestException, AwsServiceException, SdkClientException,
            S3TablesException {
        return listTableBuckets(ListTableBucketsRequest.builder().applyMutation(listTableBucketsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTableBuckets(software.amazon.awssdk.services.s3tables.model.ListTableBucketsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3tables.paginators.ListTableBucketsIterable responses = client.listTableBucketsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3tables.paginators.ListTableBucketsIterable responses = client
     *             .listTableBucketsPaginator(request);
     *     for (software.amazon.awssdk.services.s3tables.model.ListTableBucketsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3tables.paginators.ListTableBucketsIterable responses = client.listTableBucketsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxBuckets won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTableBuckets(software.amazon.awssdk.services.s3tables.model.ListTableBucketsRequest)} operation.</b>
     * </p>
     *
     * @param listTableBucketsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws AccessDeniedException
     *         The action cannot be performed because you do not have the required permission.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.ListTableBuckets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/ListTableBuckets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTableBucketsIterable listTableBucketsPaginator(ListTableBucketsRequest listTableBucketsRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, AccessDeniedException,
            TooManyRequestsException, ConflictException, BadRequestException, AwsServiceException, SdkClientException,
            S3TablesException {
        return new ListTableBucketsIterable(this, listTableBucketsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTableBuckets(software.amazon.awssdk.services.s3tables.model.ListTableBucketsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3tables.paginators.ListTableBucketsIterable responses = client.listTableBucketsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3tables.paginators.ListTableBucketsIterable responses = client
     *             .listTableBucketsPaginator(request);
     *     for (software.amazon.awssdk.services.s3tables.model.ListTableBucketsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3tables.paginators.ListTableBucketsIterable responses = client.listTableBucketsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxBuckets won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTableBuckets(software.amazon.awssdk.services.s3tables.model.ListTableBucketsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTableBucketsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTableBucketsRequest#builder()}
     * </p>
     *
     * @param listTableBucketsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.ListTableBucketsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws AccessDeniedException
     *         The action cannot be performed because you do not have the required permission.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.ListTableBuckets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/ListTableBuckets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTableBucketsIterable listTableBucketsPaginator(Consumer<ListTableBucketsRequest.Builder> listTableBucketsRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, AccessDeniedException,
            TooManyRequestsException, ConflictException, BadRequestException, AwsServiceException, SdkClientException,
            S3TablesException {
        return listTableBucketsPaginator(ListTableBucketsRequest.builder().applyMutation(listTableBucketsRequest).build());
    }

    /**
     * <p>
     * List tables in the given table bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-tables.html">S3 Tables</a> in the <i>Amazon
     * Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:ListTables</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param listTablesRequest
     * @return Result of the ListTables operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.ListTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/ListTables" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTablesResponse listTables(ListTablesRequest listTablesRequest) throws InternalServerErrorException,
            ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, BadRequestException,
            AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List tables in the given table bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-tables.html">S3 Tables</a> in the <i>Amazon
     * Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:ListTables</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTablesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTablesRequest#builder()}
     * </p>
     *
     * @param listTablesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.ListTablesRequest.Builder} to create a request.
     * @return Result of the ListTables operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.ListTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/ListTables" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTablesResponse listTables(Consumer<ListTablesRequest.Builder> listTablesRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        return listTables(ListTablesRequest.builder().applyMutation(listTablesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTables(software.amazon.awssdk.services.s3tables.model.ListTablesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3tables.paginators.ListTablesIterable responses = client.listTablesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3tables.paginators.ListTablesIterable responses = client.listTablesPaginator(request);
     *     for (software.amazon.awssdk.services.s3tables.model.ListTablesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3tables.paginators.ListTablesIterable responses = client.listTablesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxTables won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTables(software.amazon.awssdk.services.s3tables.model.ListTablesRequest)} operation.</b>
     * </p>
     *
     * @param listTablesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.ListTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/ListTables" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTablesIterable listTablesPaginator(ListTablesRequest listTablesRequest) throws InternalServerErrorException,
            ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, BadRequestException,
            AwsServiceException, SdkClientException, S3TablesException {
        return new ListTablesIterable(this, listTablesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listTables(software.amazon.awssdk.services.s3tables.model.ListTablesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3tables.paginators.ListTablesIterable responses = client.listTablesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3tables.paginators.ListTablesIterable responses = client.listTablesPaginator(request);
     *     for (software.amazon.awssdk.services.s3tables.model.ListTablesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3tables.paginators.ListTablesIterable responses = client.listTablesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxTables won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTables(software.amazon.awssdk.services.s3tables.model.ListTablesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTablesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTablesRequest#builder()}
     * </p>
     *
     * @param listTablesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.ListTablesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.ListTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/ListTables" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTablesIterable listTablesPaginator(Consumer<ListTablesRequest.Builder> listTablesRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        return listTablesPaginator(ListTablesRequest.builder().applyMutation(listTablesRequest).build());
    }

    /**
     * <p>
     * Sets the encryption configuration for a table bucket.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:PutTableBucketEncryption</code> permission to use this operation.
     * </p>
     * <note>
     * <p>
     * If you choose SSE-KMS encryption you must grant the S3 Tables maintenance principal access to your KMS key. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-kms-permissions.html">Permissions
     * requirements for S3 Tables SSE-KMS encryption</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * </note></dd>
     * </dl>
     *
     * @param putTableBucketEncryptionRequest
     * @return Result of the PutTableBucketEncryption operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.PutTableBucketEncryption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/PutTableBucketEncryption"
     *      target="_top">AWS API Documentation</a>
     */
    default PutTableBucketEncryptionResponse putTableBucketEncryption(
            PutTableBucketEncryptionRequest putTableBucketEncryptionRequest) throws InternalServerErrorException,
            ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, BadRequestException,
            AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the encryption configuration for a table bucket.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:PutTableBucketEncryption</code> permission to use this operation.
     * </p>
     * <note>
     * <p>
     * If you choose SSE-KMS encryption you must grant the S3 Tables maintenance principal access to your KMS key. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-kms-permissions.html">Permissions
     * requirements for S3 Tables SSE-KMS encryption</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * </note></dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutTableBucketEncryptionRequest.Builder} avoiding
     * the need to create one manually via {@link PutTableBucketEncryptionRequest#builder()}
     * </p>
     *
     * @param putTableBucketEncryptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.PutTableBucketEncryptionRequest.Builder} to create a
     *        request.
     * @return Result of the PutTableBucketEncryption operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.PutTableBucketEncryption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/PutTableBucketEncryption"
     *      target="_top">AWS API Documentation</a>
     */
    default PutTableBucketEncryptionResponse putTableBucketEncryption(
            Consumer<PutTableBucketEncryptionRequest.Builder> putTableBucketEncryptionRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        return putTableBucketEncryption(PutTableBucketEncryptionRequest.builder().applyMutation(putTableBucketEncryptionRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new maintenance configuration or replaces an existing maintenance configuration for a table bucket. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-table-buckets-maintenance.html">Amazon S3 table
     * bucket maintenance</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:PutTableBucketMaintenanceConfiguration</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param putTableBucketMaintenanceConfigurationRequest
     * @return Result of the PutTableBucketMaintenanceConfiguration operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.PutTableBucketMaintenanceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/PutTableBucketMaintenanceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutTableBucketMaintenanceConfigurationResponse putTableBucketMaintenanceConfiguration(
            PutTableBucketMaintenanceConfigurationRequest putTableBucketMaintenanceConfigurationRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new maintenance configuration or replaces an existing maintenance configuration for a table bucket. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-table-buckets-maintenance.html">Amazon S3 table
     * bucket maintenance</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:PutTableBucketMaintenanceConfiguration</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutTableBucketMaintenanceConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link PutTableBucketMaintenanceConfigurationRequest#builder()}
     * </p>
     *
     * @param putTableBucketMaintenanceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.PutTableBucketMaintenanceConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the PutTableBucketMaintenanceConfiguration operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.PutTableBucketMaintenanceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/PutTableBucketMaintenanceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutTableBucketMaintenanceConfigurationResponse putTableBucketMaintenanceConfiguration(
            Consumer<PutTableBucketMaintenanceConfigurationRequest.Builder> putTableBucketMaintenanceConfigurationRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        return putTableBucketMaintenanceConfiguration(PutTableBucketMaintenanceConfigurationRequest.builder()
                .applyMutation(putTableBucketMaintenanceConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a new maintenance configuration or replaces an existing table bucket policy for a table bucket. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-bucket-policy.html#table-bucket-policy-add"
     * >Adding a table bucket policy</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:PutTableBucketPolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param putTableBucketPolicyRequest
     * @return Result of the PutTableBucketPolicy operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.PutTableBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/PutTableBucketPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default PutTableBucketPolicyResponse putTableBucketPolicy(PutTableBucketPolicyRequest putTableBucketPolicyRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new maintenance configuration or replaces an existing table bucket policy for a table bucket. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-bucket-policy.html#table-bucket-policy-add"
     * >Adding a table bucket policy</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:PutTableBucketPolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutTableBucketPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutTableBucketPolicyRequest#builder()}
     * </p>
     *
     * @param putTableBucketPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.PutTableBucketPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the PutTableBucketPolicy operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.PutTableBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/PutTableBucketPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default PutTableBucketPolicyResponse putTableBucketPolicy(
            Consumer<PutTableBucketPolicyRequest.Builder> putTableBucketPolicyRequest) throws InternalServerErrorException,
            ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, BadRequestException,
            AwsServiceException, SdkClientException, S3TablesException {
        return putTableBucketPolicy(PutTableBucketPolicyRequest.builder().applyMutation(putTableBucketPolicyRequest).build());
    }

    /**
     * <p>
     * Creates a new maintenance configuration or replaces an existing maintenance configuration for a table. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-maintenance.html">S3
     * Tables maintenance</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:PutTableMaintenanceConfiguration</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param putTableMaintenanceConfigurationRequest
     * @return Result of the PutTableMaintenanceConfiguration operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.PutTableMaintenanceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/PutTableMaintenanceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutTableMaintenanceConfigurationResponse putTableMaintenanceConfiguration(
            PutTableMaintenanceConfigurationRequest putTableMaintenanceConfigurationRequest) throws InternalServerErrorException,
            ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, BadRequestException,
            AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new maintenance configuration or replaces an existing maintenance configuration for a table. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-maintenance.html">S3
     * Tables maintenance</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:PutTableMaintenanceConfiguration</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutTableMaintenanceConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutTableMaintenanceConfigurationRequest#builder()}
     * </p>
     *
     * @param putTableMaintenanceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.PutTableMaintenanceConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the PutTableMaintenanceConfiguration operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.PutTableMaintenanceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/PutTableMaintenanceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutTableMaintenanceConfigurationResponse putTableMaintenanceConfiguration(
            Consumer<PutTableMaintenanceConfigurationRequest.Builder> putTableMaintenanceConfigurationRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        return putTableMaintenanceConfiguration(PutTableMaintenanceConfigurationRequest.builder()
                .applyMutation(putTableMaintenanceConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a new maintenance configuration or replaces an existing table policy for a table. For more information,
     * see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-table-policy.html#table-policy-add">
     * Adding a table policy</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:PutTablePolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param putTablePolicyRequest
     * @return Result of the PutTablePolicy operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.PutTablePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/PutTablePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutTablePolicyResponse putTablePolicy(PutTablePolicyRequest putTablePolicyRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new maintenance configuration or replaces an existing table policy for a table. For more information,
     * see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-table-policy.html#table-policy-add">
     * Adding a table policy</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:PutTablePolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutTablePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link PutTablePolicyRequest#builder()}
     * </p>
     *
     * @param putTablePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.PutTablePolicyRequest.Builder} to create a request.
     * @return Result of the PutTablePolicy operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.PutTablePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/PutTablePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutTablePolicyResponse putTablePolicy(Consumer<PutTablePolicyRequest.Builder> putTablePolicyRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        return putTablePolicy(PutTablePolicyRequest.builder().applyMutation(putTablePolicyRequest).build());
    }

    /**
     * <p>
     * Renames a table or a namespace. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-tables.html">S3 Tables</a> in the <i>Amazon
     * Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:RenameTable</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param renameTableRequest
     * @return Result of the RenameTable operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.RenameTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/RenameTable" target="_top">AWS API
     *      Documentation</a>
     */
    default RenameTableResponse renameTable(RenameTableRequest renameTableRequest) throws InternalServerErrorException,
            ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, BadRequestException,
            AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Renames a table or a namespace. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-tables.html">S3 Tables</a> in the <i>Amazon
     * Simple Storage Service User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:RenameTable</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RenameTableRequest.Builder} avoiding the need to
     * create one manually via {@link RenameTableRequest#builder()}
     * </p>
     *
     * @param renameTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.RenameTableRequest.Builder} to create a request.
     * @return Result of the RenameTable operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.RenameTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/RenameTable" target="_top">AWS API
     *      Documentation</a>
     */
    default RenameTableResponse renameTable(Consumer<RenameTableRequest.Builder> renameTableRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        return renameTable(RenameTableRequest.builder().applyMutation(renameTableRequest).build());
    }

    /**
     * <p>
     * Updates the metadata location for a table. The metadata location of a table must be an S3 URI that begins with
     * the table's warehouse location. The metadata location for an Apache Iceberg table must end with
     * <code>.metadata.json</code>, or if the metadata file is Gzip-compressed, <code>.metadata.json.gz</code>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:UpdateTableMetadataLocation</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param updateTableMetadataLocationRequest
     * @return Result of the UpdateTableMetadataLocation operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.UpdateTableMetadataLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/UpdateTableMetadataLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTableMetadataLocationResponse updateTableMetadataLocation(
            UpdateTableMetadataLocationRequest updateTableMetadataLocationRequest) throws InternalServerErrorException,
            ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, BadRequestException,
            AwsServiceException, SdkClientException, S3TablesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the metadata location for a table. The metadata location of a table must be an S3 URI that begins with
     * the table's warehouse location. The metadata location for an Apache Iceberg table must end with
     * <code>.metadata.json</code>, or if the metadata file is Gzip-compressed, <code>.metadata.json.gz</code>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3tables:UpdateTableMetadataLocation</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTableMetadataLocationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateTableMetadataLocationRequest#builder()}
     * </p>
     *
     * @param updateTableMetadataLocationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.s3tables.model.UpdateTableMetadataLocationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateTableMetadataLocation operation returned by the service.
     * @throws InternalServerErrorException
     *         The request failed due to an internal server error.
     * @throws ForbiddenException
     *         The caller isn't authorized to make the request.
     * @throws NotFoundException
     *         The request was rejected because the specified resource could not be found.
     * @throws TooManyRequestsException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request failed because there is a conflict with a previous write. You can retry the request.
     * @throws BadRequestException
     *         The request is invalid or malformed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3TablesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3TablesClient.UpdateTableMetadataLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3tables-2018-05-10/UpdateTableMetadataLocation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTableMetadataLocationResponse updateTableMetadataLocation(
            Consumer<UpdateTableMetadataLocationRequest.Builder> updateTableMetadataLocationRequest)
            throws InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException,
            ConflictException, BadRequestException, AwsServiceException, SdkClientException, S3TablesException {
        return updateTableMetadataLocation(UpdateTableMetadataLocationRequest.builder()
                .applyMutation(updateTableMetadataLocationRequest).build());
    }

    /**
     * Create a {@link S3TablesClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static S3TablesClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link S3TablesClient}.
     */
    static S3TablesClientBuilder builder() {
        return new DefaultS3TablesClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default S3TablesServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
