/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3tables.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the metadata for an Iceberg table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IcebergMetadata implements SdkPojo, Serializable, ToCopyableBuilder<IcebergMetadata.Builder, IcebergMetadata> {
    private static final SdkField<IcebergSchema> SCHEMA_FIELD = SdkField.<IcebergSchema> builder(MarshallingType.SDK_POJO)
            .memberName("schema").getter(getter(IcebergMetadata::schema)).setter(setter(Builder::schema))
            .constructor(IcebergSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final IcebergSchema schema;

    private IcebergMetadata(BuilderImpl builder) {
        this.schema = builder.schema;
    }

    /**
     * <p>
     * The schema for an Iceberg table.
     * </p>
     * 
     * @return The schema for an Iceberg table.
     */
    public final IcebergSchema schema() {
        return schema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergMetadata)) {
            return false;
        }
        IcebergMetadata other = (IcebergMetadata) obj;
        return Objects.equals(schema(), other.schema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IcebergMetadata").add("Schema", schema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "schema":
            return Optional.ofNullable(clazz.cast(schema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("schema", SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IcebergMetadata, T> g) {
        return obj -> g.apply((IcebergMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IcebergMetadata> {
        /**
         * <p>
         * The schema for an Iceberg table.
         * </p>
         * 
         * @param schema
         *        The schema for an Iceberg table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(IcebergSchema schema);

        /**
         * <p>
         * The schema for an Iceberg table.
         * </p>
         * This is a convenience method that creates an instance of the {@link IcebergSchema.Builder} avoiding the need
         * to create one manually via {@link IcebergSchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IcebergSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #schema(IcebergSchema)}.
         * 
         * @param schema
         *        a consumer that will call methods on {@link IcebergSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schema(IcebergSchema)
         */
        default Builder schema(Consumer<IcebergSchema.Builder> schema) {
            return schema(IcebergSchema.builder().applyMutation(schema).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IcebergSchema schema;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergMetadata model) {
            schema(model.schema);
        }

        public final IcebergSchema.Builder getSchema() {
            return schema != null ? schema.toBuilder() : null;
        }

        public final void setSchema(IcebergSchema.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        @Override
        public final Builder schema(IcebergSchema schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public IcebergMetadata build() {
            return new IcebergMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
