/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutTableMaintenanceConfigurationRequest extends S3TablesRequest implements
        ToCopyableBuilder<PutTableMaintenanceConfigurationRequest.Builder, PutTableMaintenanceConfigurationRequest> {
    private static final SdkField<String> TABLE_BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableBucketARN").getter(getter(PutTableMaintenanceConfigurationRequest::tableBucketARN))
            .setter(setter(Builder::tableBucketARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("tableBucketARN").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(PutTableMaintenanceConfigurationRequest::namespace))
            .setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("namespace").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(PutTableMaintenanceConfigurationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(PutTableMaintenanceConfigurationRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("type").build()).build();

    private static final SdkField<TableMaintenanceConfigurationValue> VALUE_FIELD = SdkField
            .<TableMaintenanceConfigurationValue> builder(MarshallingType.SDK_POJO).memberName("value")
            .getter(getter(PutTableMaintenanceConfigurationRequest::value)).setter(setter(Builder::value))
            .constructor(TableMaintenanceConfigurationValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_BUCKET_ARN_FIELD,
            NAMESPACE_FIELD, NAME_FIELD, TYPE_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String tableBucketARN;

    private final String namespace;

    private final String name;

    private final String type;

    private final TableMaintenanceConfigurationValue value;

    private PutTableMaintenanceConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.tableBucketARN = builder.tableBucketARN;
        this.namespace = builder.namespace;
        this.name = builder.name;
        this.type = builder.type;
        this.value = builder.value;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the table associated with the maintenance configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the table associated with the maintenance configuration.
     */
    public final String tableBucketARN() {
        return tableBucketARN;
    }

    /**
     * <p>
     * The namespace of the table.
     * </p>
     * 
     * @return The namespace of the table.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the maintenance configuration.
     * </p>
     * 
     * @return The name of the maintenance configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of the maintenance configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TableMaintenanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the maintenance configuration.
     * @see TableMaintenanceType
     */
    public final TableMaintenanceType type() {
        return TableMaintenanceType.fromValue(type);
    }

    /**
     * <p>
     * The type of the maintenance configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TableMaintenanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the maintenance configuration.
     * @see TableMaintenanceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Defines the values of the maintenance configuration for the table.
     * </p>
     * 
     * @return Defines the values of the maintenance configuration for the table.
     */
    public final TableMaintenanceConfigurationValue value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableBucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTableMaintenanceConfigurationRequest)) {
            return false;
        }
        PutTableMaintenanceConfigurationRequest other = (PutTableMaintenanceConfigurationRequest) obj;
        return Objects.equals(tableBucketARN(), other.tableBucketARN()) && Objects.equals(namespace(), other.namespace())
                && Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutTableMaintenanceConfigurationRequest").add("TableBucketARN", tableBucketARN())
                .add("Namespace", namespace()).add("Name", name()).add("Type", typeAsString()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tableBucketARN":
            return Optional.ofNullable(clazz.cast(tableBucketARN()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tableBucketARN", TABLE_BUCKET_ARN_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutTableMaintenanceConfigurationRequest, T> g) {
        return obj -> g.apply((PutTableMaintenanceConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends S3TablesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutTableMaintenanceConfigurationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the table associated with the maintenance configuration.
         * </p>
         * 
         * @param tableBucketARN
         *        The Amazon Resource Name (ARN) of the table associated with the maintenance configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableBucketARN(String tableBucketARN);

        /**
         * <p>
         * The namespace of the table.
         * </p>
         * 
         * @param namespace
         *        The namespace of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the maintenance configuration.
         * </p>
         * 
         * @param name
         *        The name of the maintenance configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the maintenance configuration.
         * </p>
         * 
         * @param type
         *        The type of the maintenance configuration.
         * @see TableMaintenanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableMaintenanceType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the maintenance configuration.
         * </p>
         * 
         * @param type
         *        The type of the maintenance configuration.
         * @see TableMaintenanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableMaintenanceType
         */
        Builder type(TableMaintenanceType type);

        /**
         * <p>
         * Defines the values of the maintenance configuration for the table.
         * </p>
         * 
         * @param value
         *        Defines the values of the maintenance configuration for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(TableMaintenanceConfigurationValue value);

        /**
         * <p>
         * Defines the values of the maintenance configuration for the table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TableMaintenanceConfigurationValue.Builder} avoiding the need to create one manually via
         * {@link TableMaintenanceConfigurationValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableMaintenanceConfigurationValue.Builder#build()} is called
         * immediately and its result is passed to {@link #value(TableMaintenanceConfigurationValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link TableMaintenanceConfigurationValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(TableMaintenanceConfigurationValue)
         */
        default Builder value(Consumer<TableMaintenanceConfigurationValue.Builder> value) {
            return value(TableMaintenanceConfigurationValue.builder().applyMutation(value).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3TablesRequest.BuilderImpl implements Builder {
        private String tableBucketARN;

        private String namespace;

        private String name;

        private String type;

        private TableMaintenanceConfigurationValue value;

        private BuilderImpl() {
        }

        private BuilderImpl(PutTableMaintenanceConfigurationRequest model) {
            super(model);
            tableBucketARN(model.tableBucketARN);
            namespace(model.namespace);
            name(model.name);
            type(model.type);
            value(model.value);
        }

        public final String getTableBucketARN() {
            return tableBucketARN;
        }

        public final void setTableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
        }

        @Override
        public final Builder tableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TableMaintenanceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final TableMaintenanceConfigurationValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(TableMaintenanceConfigurationValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(TableMaintenanceConfigurationValue value) {
            this.value = value;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutTableMaintenanceConfigurationRequest build() {
            return new PutTableMaintenanceConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
