/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3tables.model.MaintenanceStatus;
import software.amazon.awssdk.services.s3tables.model.TableMaintenanceSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableMaintenanceConfigurationValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableMaintenanceConfigurationValue> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(TableMaintenanceConfigurationValue.getter(TableMaintenanceConfigurationValue::statusAsString)).setter(TableMaintenanceConfigurationValue.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<TableMaintenanceSettings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("settings").getter(TableMaintenanceConfigurationValue.getter(TableMaintenanceConfigurationValue::settings)).setter(TableMaintenanceConfigurationValue.setter(Builder::settings)).constructor(TableMaintenanceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TableMaintenanceConfigurationValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final TableMaintenanceSettings settings;

    private TableMaintenanceConfigurationValue(BuilderImpl builder) {
        this.status = builder.status;
        this.settings = builder.settings;
    }

    public final MaintenanceStatus status() {
        return MaintenanceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final TableMaintenanceSettings settings() {
        return this.settings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableMaintenanceConfigurationValue)) {
            return false;
        }
        TableMaintenanceConfigurationValue other = (TableMaintenanceConfigurationValue)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.settings(), other.settings());
    }

    public final String toString() {
        return ToString.builder((String)"TableMaintenanceConfigurationValue").add("Status", (Object)this.statusAsString()).add("Settings", (Object)this.settings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", STATUS_FIELD);
        map.put("settings", SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableMaintenanceConfigurationValue, T> g) {
        return obj -> g.apply((TableMaintenanceConfigurationValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private TableMaintenanceSettings settings;

        private BuilderImpl() {
        }

        private BuilderImpl(TableMaintenanceConfigurationValue model) {
            this.status(model.status);
            this.settings(model.settings);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MaintenanceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final TableMaintenanceSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        public final void setSettings(TableMaintenanceSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(TableMaintenanceSettings settings) {
            this.settings = settings;
            return this;
        }

        public TableMaintenanceConfigurationValue build() {
            return new TableMaintenanceConfigurationValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableMaintenanceConfigurationValue> {
        public Builder status(String var1);

        public Builder status(MaintenanceStatus var1);

        public Builder settings(TableMaintenanceSettings var1);

        default public Builder settings(Consumer<TableMaintenanceSettings.Builder> settings) {
            return this.settings((TableMaintenanceSettings)((TableMaintenanceSettings.Builder)TableMaintenanceSettings.builder().applyMutation(settings)).build());
        }
    }
}

