/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3tables.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a table bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableBucketSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TableBucketSummary.Builder, TableBucketSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(TableBucketSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(TableBucketSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerAccountId").getter(getter(TableBucketSummary::ownerAccountId))
            .setter(setter(Builder::ownerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccountId").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(TableBucketSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> TABLE_BUCKET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableBucketId").getter(getter(TableBucketSummary::tableBucketId)).setter(setter(Builder::tableBucketId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableBucketId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(TableBucketSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            OWNER_ACCOUNT_ID_FIELD, CREATED_AT_FIELD, TABLE_BUCKET_ID_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String ownerAccountId;

    private final Instant createdAt;

    private final String tableBucketId;

    private final String type;

    private TableBucketSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.ownerAccountId = builder.ownerAccountId;
        this.createdAt = builder.createdAt;
        this.tableBucketId = builder.tableBucketId;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the table bucket.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the table bucket.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the table bucket.
     * </p>
     * 
     * @return The name of the table bucket.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the account that owns the table bucket.
     * </p>
     * 
     * @return The ID of the account that owns the table bucket.
     */
    public final String ownerAccountId() {
        return ownerAccountId;
    }

    /**
     * <p>
     * The date and time the table bucket was created at.
     * </p>
     * 
     * @return The date and time the table bucket was created at.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The system-assigned unique identifier for the table bucket.
     * </p>
     * 
     * @return The system-assigned unique identifier for the table bucket.
     */
    public final String tableBucketId() {
        return tableBucketId;
    }

    /**
     * <p>
     * The type of the table bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TableBucketType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the table bucket.
     * @see TableBucketType
     */
    public final TableBucketType type() {
        return TableBucketType.fromValue(type);
    }

    /**
     * <p>
     * The type of the table bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TableBucketType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the table bucket.
     * @see TableBucketType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(tableBucketId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableBucketSummary)) {
            return false;
        }
        TableBucketSummary other = (TableBucketSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(ownerAccountId(), other.ownerAccountId()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(tableBucketId(), other.tableBucketId()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableBucketSummary").add("Arn", arn()).add("Name", name())
                .add("OwnerAccountId", ownerAccountId()).add("CreatedAt", createdAt()).add("TableBucketId", tableBucketId())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ownerAccountId":
            return Optional.ofNullable(clazz.cast(ownerAccountId()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "tableBucketId":
            return Optional.ofNullable(clazz.cast(tableBucketId()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("ownerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("tableBucketId", TABLE_BUCKET_ID_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableBucketSummary, T> g) {
        return obj -> g.apply((TableBucketSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableBucketSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the table bucket.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the table bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the table bucket.
         * </p>
         * 
         * @param name
         *        The name of the table bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the account that owns the table bucket.
         * </p>
         * 
         * @param ownerAccountId
         *        The ID of the account that owns the table bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccountId(String ownerAccountId);

        /**
         * <p>
         * The date and time the table bucket was created at.
         * </p>
         * 
         * @param createdAt
         *        The date and time the table bucket was created at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The system-assigned unique identifier for the table bucket.
         * </p>
         * 
         * @param tableBucketId
         *        The system-assigned unique identifier for the table bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableBucketId(String tableBucketId);

        /**
         * <p>
         * The type of the table bucket.
         * </p>
         * 
         * @param type
         *        The type of the table bucket.
         * @see TableBucketType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableBucketType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the table bucket.
         * </p>
         * 
         * @param type
         *        The type of the table bucket.
         * @see TableBucketType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableBucketType
         */
        Builder type(TableBucketType type);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String ownerAccountId;

        private Instant createdAt;

        private String tableBucketId;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(TableBucketSummary model) {
            arn(model.arn);
            name(model.name);
            ownerAccountId(model.ownerAccountId);
            createdAt(model.createdAt);
            tableBucketId(model.tableBucketId);
            type(model.type);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwnerAccountId() {
            return ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getTableBucketId() {
            return tableBucketId;
        }

        public final void setTableBucketId(String tableBucketId) {
            this.tableBucketId = tableBucketId;
        }

        @Override
        public final Builder tableBucketId(String tableBucketId) {
            this.tableBucketId = tableBucketId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TableBucketType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public TableBucketSummary build() {
            return new TableBucketSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
