/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * An Amazon S3 table represents a structured dataset consisting of tabular data in <a
 * href="https://parquet.apache.org/docs/">Apache Parquet</a> format and related metadata. This data is stored inside an
 * S3 table as a subresource. All tables in a table bucket are stored in the <a
 * href="https://iceberg.apache.org/docs/latest/">Apache Iceberg</a> table format. Through integration with the <a
 * href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/glue/latest/dg/catalog-and-crawler.html">Amazon Web
 * Services Glue Data Catalog</a> you can interact with your tables using Amazon Web Services analytics services, such
 * as <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/athena/">Amazon Athena</a> and <a
 * href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/redshift/">Amazon Redshift</a>. Amazon S3 manages
 * maintenance of your tables through automatic file compaction and snapshot management. For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-buckets.html">Amazon S3 table buckets</a>.
 * </p>
 */
package software.amazon.awssdk.services.s3tables;