/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTablesResponse extends S3TablesResponse implements
        ToCopyableBuilder<ListTablesResponse.Builder, ListTablesResponse> {
    private static final SdkField<List<TableSummary>> TABLES_FIELD = SdkField
            .<List<TableSummary>> builder(MarshallingType.LIST)
            .memberName("tables")
            .getter(getter(ListTablesResponse::tables))
            .setter(setter(Builder::tables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tables").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TableSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TableSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONTINUATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("continuationToken").getter(getter(ListTablesResponse::continuationToken))
            .setter(setter(Builder::continuationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continuationToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLES_FIELD,
            CONTINUATION_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<TableSummary> tables;

    private final String continuationToken;

    private ListTablesResponse(BuilderImpl builder) {
        super(builder);
        this.tables = builder.tables;
        this.continuationToken = builder.continuationToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tables property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTables() {
        return tables != null && !(tables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTables} method.
     * </p>
     * 
     * @return A list of tables.
     */
    public final List<TableSummary> tables() {
        return tables;
    }

    /**
     * <p>
     * You can use this <code>ContinuationToken</code> for pagination of the list results.
     * </p>
     * 
     * @return You can use this <code>ContinuationToken</code> for pagination of the list results.
     */
    public final String continuationToken() {
        return continuationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTables() ? tables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(continuationToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTablesResponse)) {
            return false;
        }
        ListTablesResponse other = (ListTablesResponse) obj;
        return hasTables() == other.hasTables() && Objects.equals(tables(), other.tables())
                && Objects.equals(continuationToken(), other.continuationToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTablesResponse").add("Tables", hasTables() ? tables() : null)
                .add("ContinuationToken", continuationToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tables":
            return Optional.ofNullable(clazz.cast(tables()));
        case "continuationToken":
            return Optional.ofNullable(clazz.cast(continuationToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tables", TABLES_FIELD);
        map.put("continuationToken", CONTINUATION_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTablesResponse, T> g) {
        return obj -> g.apply((ListTablesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends S3TablesResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTablesResponse> {
        /**
         * <p>
         * A list of tables.
         * </p>
         * 
         * @param tables
         *        A list of tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tables(Collection<TableSummary> tables);

        /**
         * <p>
         * A list of tables.
         * </p>
         * 
         * @param tables
         *        A list of tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tables(TableSummary... tables);

        /**
         * <p>
         * A list of tables.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.s3tables.model.TableSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.s3tables.model.TableSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.s3tables.model.TableSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #tables(List<TableSummary>)}.
         * 
         * @param tables
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.s3tables.model.TableSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tables(java.util.Collection<TableSummary>)
         */
        Builder tables(Consumer<TableSummary.Builder>... tables);

        /**
         * <p>
         * You can use this <code>ContinuationToken</code> for pagination of the list results.
         * </p>
         * 
         * @param continuationToken
         *        You can use this <code>ContinuationToken</code> for pagination of the list results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuationToken(String continuationToken);
    }

    static final class BuilderImpl extends S3TablesResponse.BuilderImpl implements Builder {
        private List<TableSummary> tables = DefaultSdkAutoConstructList.getInstance();

        private String continuationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTablesResponse model) {
            super(model);
            tables(model.tables);
            continuationToken(model.continuationToken);
        }

        public final List<TableSummary.Builder> getTables() {
            List<TableSummary.Builder> result = TableSummaryListCopier.copyToBuilder(this.tables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTables(Collection<TableSummary.BuilderImpl> tables) {
            this.tables = TableSummaryListCopier.copyFromBuilder(tables);
        }

        @Override
        public final Builder tables(Collection<TableSummary> tables) {
            this.tables = TableSummaryListCopier.copy(tables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tables(TableSummary... tables) {
            tables(Arrays.asList(tables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tables(Consumer<TableSummary.Builder>... tables) {
            tables(Stream.of(tables).map(c -> TableSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getContinuationToken() {
            return continuationToken;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        @Override
        public ListTablesResponse build() {
            return new ListTablesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
