/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3tables.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the table metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableMetadata implements SdkPojo, Serializable, ToCopyableBuilder<TableMetadata.Builder, TableMetadata> {
    private static final SdkField<IcebergMetadata> ICEBERG_FIELD = SdkField.<IcebergMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("iceberg").getter(getter(TableMetadata::iceberg)).setter(setter(Builder::iceberg))
            .constructor(IcebergMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iceberg").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ICEBERG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final IcebergMetadata iceberg;

    private final Type type;

    private TableMetadata(BuilderImpl builder) {
        this.iceberg = builder.iceberg;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains details about the metadata of an Iceberg table.
     * </p>
     * 
     * @return Contains details about the metadata of an Iceberg table.
     */
    public final IcebergMetadata iceberg() {
        return iceberg;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iceberg());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableMetadata)) {
            return false;
        }
        TableMetadata other = (TableMetadata) obj;
        return Objects.equals(iceberg(), other.iceberg());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableMetadata").add("Iceberg", iceberg()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "iceberg":
            return Optional.ofNullable(clazz.cast(iceberg()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #iceberg()} initialized to the given value.
     *
     * <p>
     * Contains details about the metadata of an Iceberg table.
     * </p>
     * 
     * @param iceberg
     *        Contains details about the metadata of an Iceberg table.
     */
    public static TableMetadata fromIceberg(IcebergMetadata iceberg) {
        return builder().iceberg(iceberg).build();
    }

    /**
     * Create an instance of this class with {@link #iceberg()} initialized to the given value.
     *
     * <p>
     * Contains details about the metadata of an Iceberg table.
     * </p>
     * 
     * @param iceberg
     *        Contains details about the metadata of an Iceberg table.
     */
    public static TableMetadata fromIceberg(Consumer<IcebergMetadata.Builder> iceberg) {
        IcebergMetadata.Builder builder = IcebergMetadata.builder();
        iceberg.accept(builder);
        return fromIceberg(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("iceberg", ICEBERG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableMetadata, T> g) {
        return obj -> g.apply((TableMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableMetadata> {
        /**
         * <p>
         * Contains details about the metadata of an Iceberg table.
         * </p>
         * 
         * @param iceberg
         *        Contains details about the metadata of an Iceberg table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iceberg(IcebergMetadata iceberg);

        /**
         * <p>
         * Contains details about the metadata of an Iceberg table.
         * </p>
         * This is a convenience method that creates an instance of the {@link IcebergMetadata.Builder} avoiding the
         * need to create one manually via {@link IcebergMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IcebergMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #iceberg(IcebergMetadata)}.
         * 
         * @param iceberg
         *        a consumer that will call methods on {@link IcebergMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iceberg(IcebergMetadata)
         */
        default Builder iceberg(Consumer<IcebergMetadata.Builder> iceberg) {
            return iceberg(IcebergMetadata.builder().applyMutation(iceberg).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IcebergMetadata iceberg;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TableMetadata model) {
            iceberg(model.iceberg);
        }

        public final IcebergMetadata.Builder getIceberg() {
            return iceberg != null ? iceberg.toBuilder() : null;
        }

        public final void setIceberg(IcebergMetadata.BuilderImpl iceberg) {
            Object oldValue = this.iceberg;
            this.iceberg = iceberg != null ? iceberg.build() : null;
            handleUnionValueChange(Type.ICEBERG, oldValue, this.iceberg);
        }

        @Override
        public final Builder iceberg(IcebergMetadata iceberg) {
            Object oldValue = this.iceberg;
            this.iceberg = iceberg;
            handleUnionValueChange(Type.ICEBERG, oldValue, this.iceberg);
            return this;
        }

        @Override
        public TableMetadata build() {
            return new TableMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see TableMetadata#type()
     */
    public enum Type {
        ICEBERG,

        UNKNOWN_TO_SDK_VERSION
    }
}
