/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3vectors.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3vectors.model.DataType;
import software.amazon.awssdk.services.s3vectors.model.DistanceMetric;
import software.amazon.awssdk.services.s3vectors.model.MetadataConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Index
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Index> {
    private static final SdkField<String> VECTOR_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vectorBucketName").getter(Index.getter(Index::vectorBucketName)).setter(Index.setter(Builder::vectorBucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorBucketName").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexName").getter(Index.getter(Index::indexName)).setter(Index.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()}).build();
    private static final SdkField<String> INDEX_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexArn").getter(Index.getter(Index::indexArn)).setter(Index.setter(Builder::indexArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(Index.getter(Index::creationTime)).setter(Index.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataType").getter(Index.getter(Index::dataTypeAsString)).setter(Index.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()}).build();
    private static final SdkField<Integer> DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("dimension").getter(Index.getter(Index::dimension)).setter(Index.setter(Builder::dimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimension").build()}).build();
    private static final SdkField<String> DISTANCE_METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("distanceMetric").getter(Index.getter(Index::distanceMetricAsString)).setter(Index.setter(Builder::distanceMetric)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distanceMetric").build()}).build();
    private static final SdkField<MetadataConfiguration> METADATA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadataConfiguration").getter(Index.getter(Index::metadataConfiguration)).setter(Index.setter(Builder::metadataConfiguration)).constructor(MetadataConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VECTOR_BUCKET_NAME_FIELD, INDEX_NAME_FIELD, INDEX_ARN_FIELD, CREATION_TIME_FIELD, DATA_TYPE_FIELD, DIMENSION_FIELD, DISTANCE_METRIC_FIELD, METADATA_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Index.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String vectorBucketName;
    private final String indexName;
    private final String indexArn;
    private final Instant creationTime;
    private final String dataType;
    private final Integer dimension;
    private final String distanceMetric;
    private final MetadataConfiguration metadataConfiguration;

    private Index(BuilderImpl builder) {
        this.vectorBucketName = builder.vectorBucketName;
        this.indexName = builder.indexName;
        this.indexArn = builder.indexArn;
        this.creationTime = builder.creationTime;
        this.dataType = builder.dataType;
        this.dimension = builder.dimension;
        this.distanceMetric = builder.distanceMetric;
        this.metadataConfiguration = builder.metadataConfiguration;
    }

    public final String vectorBucketName() {
        return this.vectorBucketName;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final String indexArn() {
        return this.indexArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final DataType dataType() {
        return DataType.fromValue(this.dataType);
    }

    public final String dataTypeAsString() {
        return this.dataType;
    }

    public final Integer dimension() {
        return this.dimension;
    }

    public final DistanceMetric distanceMetric() {
        return DistanceMetric.fromValue(this.distanceMetric);
    }

    public final String distanceMetricAsString() {
        return this.distanceMetric;
    }

    public final MetadataConfiguration metadataConfiguration() {
        return this.metadataConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vectorBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimension());
        hashCode = 31 * hashCode + Objects.hashCode(this.distanceMetricAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Index)) {
            return false;
        }
        Index other = (Index)obj;
        return Objects.equals(this.vectorBucketName(), other.vectorBucketName()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.indexArn(), other.indexArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.dataTypeAsString(), other.dataTypeAsString()) && Objects.equals(this.dimension(), other.dimension()) && Objects.equals(this.distanceMetricAsString(), other.distanceMetricAsString()) && Objects.equals(this.metadataConfiguration(), other.metadataConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"Index").add("VectorBucketName", (Object)this.vectorBucketName()).add("IndexName", (Object)this.indexName()).add("IndexArn", (Object)this.indexArn()).add("CreationTime", (Object)this.creationTime()).add("DataType", (Object)this.dataTypeAsString()).add("Dimension", (Object)this.dimension()).add("DistanceMetric", (Object)this.distanceMetricAsString()).add("MetadataConfiguration", (Object)this.metadataConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vectorBucketName": {
                return Optional.ofNullable(clazz.cast(this.vectorBucketName()));
            }
            case "indexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "indexArn": {
                return Optional.ofNullable(clazz.cast(this.indexArn()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "dataType": {
                return Optional.ofNullable(clazz.cast(this.dataTypeAsString()));
            }
            case "dimension": {
                return Optional.ofNullable(clazz.cast(this.dimension()));
            }
            case "distanceMetric": {
                return Optional.ofNullable(clazz.cast(this.distanceMetricAsString()));
            }
            case "metadataConfiguration": {
                return Optional.ofNullable(clazz.cast(this.metadataConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vectorBucketName", VECTOR_BUCKET_NAME_FIELD);
        map.put("indexName", INDEX_NAME_FIELD);
        map.put("indexArn", INDEX_ARN_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("dataType", DATA_TYPE_FIELD);
        map.put("dimension", DIMENSION_FIELD);
        map.put("distanceMetric", DISTANCE_METRIC_FIELD);
        map.put("metadataConfiguration", METADATA_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Index, T> g) {
        return obj -> g.apply((Index)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vectorBucketName;
        private String indexName;
        private String indexArn;
        private Instant creationTime;
        private String dataType;
        private Integer dimension;
        private String distanceMetric;
        private MetadataConfiguration metadataConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Index model) {
            this.vectorBucketName(model.vectorBucketName);
            this.indexName(model.indexName);
            this.indexArn(model.indexArn);
            this.creationTime(model.creationTime);
            this.dataType(model.dataType);
            this.dimension(model.dimension);
            this.distanceMetric(model.distanceMetric);
            this.metadataConfiguration(model.metadataConfiguration);
        }

        public final String getVectorBucketName() {
            return this.vectorBucketName;
        }

        public final void setVectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
        }

        @Override
        public final Builder vectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
            return this;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getIndexArn() {
            return this.indexArn;
        }

        public final void setIndexArn(String indexArn) {
            this.indexArn = indexArn;
        }

        @Override
        public final Builder indexArn(String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDataType() {
            return this.dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(DataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final Integer getDimension() {
            return this.dimension;
        }

        public final void setDimension(Integer dimension) {
            this.dimension = dimension;
        }

        @Override
        public final Builder dimension(Integer dimension) {
            this.dimension = dimension;
            return this;
        }

        public final String getDistanceMetric() {
            return this.distanceMetric;
        }

        public final void setDistanceMetric(String distanceMetric) {
            this.distanceMetric = distanceMetric;
        }

        @Override
        public final Builder distanceMetric(String distanceMetric) {
            this.distanceMetric = distanceMetric;
            return this;
        }

        @Override
        public final Builder distanceMetric(DistanceMetric distanceMetric) {
            this.distanceMetric(distanceMetric == null ? null : distanceMetric.toString());
            return this;
        }

        public final MetadataConfiguration.Builder getMetadataConfiguration() {
            return this.metadataConfiguration != null ? this.metadataConfiguration.toBuilder() : null;
        }

        public final void setMetadataConfiguration(MetadataConfiguration.BuilderImpl metadataConfiguration) {
            this.metadataConfiguration = metadataConfiguration != null ? metadataConfiguration.build() : null;
        }

        @Override
        public final Builder metadataConfiguration(MetadataConfiguration metadataConfiguration) {
            this.metadataConfiguration = metadataConfiguration;
            return this;
        }

        public Index build() {
            return new Index(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Index> {
        public Builder vectorBucketName(String var1);

        public Builder indexName(String var1);

        public Builder indexArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder dataType(String var1);

        public Builder dataType(DataType var1);

        public Builder dimension(Integer var1);

        public Builder distanceMetric(String var1);

        public Builder distanceMetric(DistanceMetric var1);

        public Builder metadataConfiguration(MetadataConfiguration var1);

        default public Builder metadataConfiguration(Consumer<MetadataConfiguration.Builder> metadataConfiguration) {
            return this.metadataConfiguration((MetadataConfiguration)((MetadataConfiguration.Builder)MetadataConfiguration.builder().applyMutation(metadataConfiguration)).build());
        }
    }
}

