/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3vectors.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVectorsRequest extends S3VectorsRequest implements
        ToCopyableBuilder<ListVectorsRequest.Builder, ListVectorsRequest> {
    private static final SdkField<String> VECTOR_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vectorBucketName").getter(getter(ListVectorsRequest::vectorBucketName))
            .setter(setter(Builder::vectorBucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorBucketName").build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexName").getter(getter(ListVectorsRequest::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()).build();

    private static final SdkField<String> INDEX_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexArn").getter(getter(ListVectorsRequest::indexArn)).setter(setter(Builder::indexArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexArn").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListVectorsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListVectorsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> SEGMENT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("segmentCount").getter(getter(ListVectorsRequest::segmentCount)).setter(setter(Builder::segmentCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentCount").build()).build();

    private static final SdkField<Integer> SEGMENT_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("segmentIndex").getter(getter(ListVectorsRequest::segmentIndex)).setter(setter(Builder::segmentIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentIndex").build()).build();

    private static final SdkField<Boolean> RETURN_DATA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("returnData").getter(getter(ListVectorsRequest::returnData)).setter(setter(Builder::returnData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnData").build()).build();

    private static final SdkField<Boolean> RETURN_METADATA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("returnMetadata").getter(getter(ListVectorsRequest::returnMetadata))
            .setter(setter(Builder::returnMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VECTOR_BUCKET_NAME_FIELD,
            INDEX_NAME_FIELD, INDEX_ARN_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SEGMENT_COUNT_FIELD, SEGMENT_INDEX_FIELD,
            RETURN_DATA_FIELD, RETURN_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String vectorBucketName;

    private final String indexName;

    private final String indexArn;

    private final Integer maxResults;

    private final String nextToken;

    private final Integer segmentCount;

    private final Integer segmentIndex;

    private final Boolean returnData;

    private final Boolean returnMetadata;

    private ListVectorsRequest(BuilderImpl builder) {
        super(builder);
        this.vectorBucketName = builder.vectorBucketName;
        this.indexName = builder.indexName;
        this.indexArn = builder.indexArn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.segmentCount = builder.segmentCount;
        this.segmentIndex = builder.segmentIndex;
        this.returnData = builder.returnData;
        this.returnMetadata = builder.returnMetadata;
    }

    /**
     * <p>
     * The name of the vector bucket.
     * </p>
     * 
     * @return The name of the vector bucket.
     */
    public final String vectorBucketName() {
        return vectorBucketName;
    }

    /**
     * <p>
     * The name of the vector index.
     * </p>
     * 
     * @return The name of the vector index.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The Amazon resource Name (ARN) of the vector index.
     * </p>
     * 
     * @return The Amazon resource Name (ARN) of the vector index.
     */
    public final String indexArn() {
        return indexArn;
    }

    /**
     * <p>
     * The maximum number of vectors to return on a page.
     * </p>
     * <p>
     * If you don't specify <code>maxResults</code>, the <code>ListVectors</code> operation uses a default value of 500.
     * </p>
     * <p>
     * If the processed dataset size exceeds 1 MB before reaching the <code>maxResults</code> value, the operation stops
     * and returns the vectors that are retrieved up to that point, along with a <code>nextToken</code> that you can use
     * in a subsequent request to retrieve the next set of results.
     * </p>
     * 
     * @return The maximum number of vectors to return on a page.</p>
     *         <p>
     *         If you don't specify <code>maxResults</code>, the <code>ListVectors</code> operation uses a default value
     *         of 500.
     *         </p>
     *         <p>
     *         If the processed dataset size exceeds 1 MB before reaching the <code>maxResults</code> value, the
     *         operation stops and returns the vectors that are retrieved up to that point, along with a
     *         <code>nextToken</code> that you can use in a subsequent request to retrieve the next set of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Pagination token from a previous request. The value of this field is empty for an initial request.
     * </p>
     * 
     * @return Pagination token from a previous request. The value of this field is empty for an initial request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * For a parallel <code>ListVectors</code> request, <code>segmentCount</code> represents the total number of vector
     * segments into which the <code>ListVectors</code> operation will be divided. The value of
     * <code>segmentCount</code> corresponds to the number of application workers that will perform the parallel
     * <code>ListVectors</code> operation. For example, if you want to use four application threads to list vectors in a
     * vector index, specify a <code>segmentCount</code> value of 4.
     * </p>
     * <p>
     * If you specify a <code>segmentCount</code> value of 1, the <code>ListVectors</code> operation will be sequential
     * rather than parallel.
     * </p>
     * <p>
     * If you specify <code>segmentCount</code>, you must also specify <code>segmentIndex</code>.
     * </p>
     * 
     * @return For a parallel <code>ListVectors</code> request, <code>segmentCount</code> represents the total number of
     *         vector segments into which the <code>ListVectors</code> operation will be divided. The value of
     *         <code>segmentCount</code> corresponds to the number of application workers that will perform the parallel
     *         <code>ListVectors</code> operation. For example, if you want to use four application threads to list
     *         vectors in a vector index, specify a <code>segmentCount</code> value of 4. </p>
     *         <p>
     *         If you specify a <code>segmentCount</code> value of 1, the <code>ListVectors</code> operation will be
     *         sequential rather than parallel.
     *         </p>
     *         <p>
     *         If you specify <code>segmentCount</code>, you must also specify <code>segmentIndex</code>.
     */
    public final Integer segmentCount() {
        return segmentCount;
    }

    /**
     * <p>
     * For a parallel <code>ListVectors</code> request, <code>segmentIndex</code> is the index of the segment from which
     * to list vectors in the current request. It identifies an individual segment to be listed by an application
     * worker.
     * </p>
     * <p>
     * Segment IDs are zero-based, so the first segment is always 0. For example, if you want to use four application
     * threads to list vectors in a vector index, then the first thread specifies a <code>segmentIndex</code> value of
     * 0, the second thread specifies 1, and so on.
     * </p>
     * <p>
     * The value of <code>segmentIndex</code> must be less than the value provided for <code>segmentCount</code>.
     * </p>
     * <p>
     * If you provide <code>segmentIndex</code>, you must also provide <code>segmentCount</code>.
     * </p>
     * 
     * @return For a parallel <code>ListVectors</code> request, <code>segmentIndex</code> is the index of the segment
     *         from which to list vectors in the current request. It identifies an individual segment to be listed by an
     *         application worker. </p>
     *         <p>
     *         Segment IDs are zero-based, so the first segment is always 0. For example, if you want to use four
     *         application threads to list vectors in a vector index, then the first thread specifies a
     *         <code>segmentIndex</code> value of 0, the second thread specifies 1, and so on.
     *         </p>
     *         <p>
     *         The value of <code>segmentIndex</code> must be less than the value provided for <code>segmentCount</code>
     *         .
     *         </p>
     *         <p>
     *         If you provide <code>segmentIndex</code>, you must also provide <code>segmentCount</code>.
     */
    public final Integer segmentIndex() {
        return segmentIndex;
    }

    /**
     * <p>
     * If true, the vector data of each vector will be included in the response. The default value is <code>false</code>
     * .
     * </p>
     * 
     * @return If true, the vector data of each vector will be included in the response. The default value is
     *         <code>false</code>.
     */
    public final Boolean returnData() {
        return returnData;
    }

    /**
     * <p>
     * If true, the metadata associated with each vector will be included in the response. The default value is
     * <code>false</code>.
     * </p>
     * 
     * @return If true, the metadata associated with each vector will be included in the response. The default value is
     *         <code>false</code>.
     */
    public final Boolean returnMetadata() {
        return returnMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vectorBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(indexArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(segmentCount());
        hashCode = 31 * hashCode + Objects.hashCode(segmentIndex());
        hashCode = 31 * hashCode + Objects.hashCode(returnData());
        hashCode = 31 * hashCode + Objects.hashCode(returnMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVectorsRequest)) {
            return false;
        }
        ListVectorsRequest other = (ListVectorsRequest) obj;
        return Objects.equals(vectorBucketName(), other.vectorBucketName()) && Objects.equals(indexName(), other.indexName())
                && Objects.equals(indexArn(), other.indexArn()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(segmentCount(), other.segmentCount())
                && Objects.equals(segmentIndex(), other.segmentIndex()) && Objects.equals(returnData(), other.returnData())
                && Objects.equals(returnMetadata(), other.returnMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVectorsRequest").add("VectorBucketName", vectorBucketName()).add("IndexName", indexName())
                .add("IndexArn", indexArn()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("SegmentCount", segmentCount()).add("SegmentIndex", segmentIndex()).add("ReturnData", returnData())
                .add("ReturnMetadata", returnMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vectorBucketName":
            return Optional.ofNullable(clazz.cast(vectorBucketName()));
        case "indexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "indexArn":
            return Optional.ofNullable(clazz.cast(indexArn()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "segmentCount":
            return Optional.ofNullable(clazz.cast(segmentCount()));
        case "segmentIndex":
            return Optional.ofNullable(clazz.cast(segmentIndex()));
        case "returnData":
            return Optional.ofNullable(clazz.cast(returnData()));
        case "returnMetadata":
            return Optional.ofNullable(clazz.cast(returnMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vectorBucketName", VECTOR_BUCKET_NAME_FIELD);
        map.put("indexName", INDEX_NAME_FIELD);
        map.put("indexArn", INDEX_ARN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("segmentCount", SEGMENT_COUNT_FIELD);
        map.put("segmentIndex", SEGMENT_INDEX_FIELD);
        map.put("returnData", RETURN_DATA_FIELD);
        map.put("returnMetadata", RETURN_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVectorsRequest, T> g) {
        return obj -> g.apply((ListVectorsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends S3VectorsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListVectorsRequest> {
        /**
         * <p>
         * The name of the vector bucket.
         * </p>
         * 
         * @param vectorBucketName
         *        The name of the vector bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorBucketName(String vectorBucketName);

        /**
         * <p>
         * The name of the vector index.
         * </p>
         * 
         * @param indexName
         *        The name of the vector index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The Amazon resource Name (ARN) of the vector index.
         * </p>
         * 
         * @param indexArn
         *        The Amazon resource Name (ARN) of the vector index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexArn(String indexArn);

        /**
         * <p>
         * The maximum number of vectors to return on a page.
         * </p>
         * <p>
         * If you don't specify <code>maxResults</code>, the <code>ListVectors</code> operation uses a default value of
         * 500.
         * </p>
         * <p>
         * If the processed dataset size exceeds 1 MB before reaching the <code>maxResults</code> value, the operation
         * stops and returns the vectors that are retrieved up to that point, along with a <code>nextToken</code> that
         * you can use in a subsequent request to retrieve the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of vectors to return on a page.</p>
         *        <p>
         *        If you don't specify <code>maxResults</code>, the <code>ListVectors</code> operation uses a default
         *        value of 500.
         *        </p>
         *        <p>
         *        If the processed dataset size exceeds 1 MB before reaching the <code>maxResults</code> value, the
         *        operation stops and returns the vectors that are retrieved up to that point, along with a
         *        <code>nextToken</code> that you can use in a subsequent request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Pagination token from a previous request. The value of this field is empty for an initial request.
         * </p>
         * 
         * @param nextToken
         *        Pagination token from a previous request. The value of this field is empty for an initial request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * For a parallel <code>ListVectors</code> request, <code>segmentCount</code> represents the total number of
         * vector segments into which the <code>ListVectors</code> operation will be divided. The value of
         * <code>segmentCount</code> corresponds to the number of application workers that will perform the parallel
         * <code>ListVectors</code> operation. For example, if you want to use four application threads to list vectors
         * in a vector index, specify a <code>segmentCount</code> value of 4.
         * </p>
         * <p>
         * If you specify a <code>segmentCount</code> value of 1, the <code>ListVectors</code> operation will be
         * sequential rather than parallel.
         * </p>
         * <p>
         * If you specify <code>segmentCount</code>, you must also specify <code>segmentIndex</code>.
         * </p>
         * 
         * @param segmentCount
         *        For a parallel <code>ListVectors</code> request, <code>segmentCount</code> represents the total number
         *        of vector segments into which the <code>ListVectors</code> operation will be divided. The value of
         *        <code>segmentCount</code> corresponds to the number of application workers that will perform the
         *        parallel <code>ListVectors</code> operation. For example, if you want to use four application threads
         *        to list vectors in a vector index, specify a <code>segmentCount</code> value of 4. </p>
         *        <p>
         *        If you specify a <code>segmentCount</code> value of 1, the <code>ListVectors</code> operation will be
         *        sequential rather than parallel.
         *        </p>
         *        <p>
         *        If you specify <code>segmentCount</code>, you must also specify <code>segmentIndex</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentCount(Integer segmentCount);

        /**
         * <p>
         * For a parallel <code>ListVectors</code> request, <code>segmentIndex</code> is the index of the segment from
         * which to list vectors in the current request. It identifies an individual segment to be listed by an
         * application worker.
         * </p>
         * <p>
         * Segment IDs are zero-based, so the first segment is always 0. For example, if you want to use four
         * application threads to list vectors in a vector index, then the first thread specifies a
         * <code>segmentIndex</code> value of 0, the second thread specifies 1, and so on.
         * </p>
         * <p>
         * The value of <code>segmentIndex</code> must be less than the value provided for <code>segmentCount</code>.
         * </p>
         * <p>
         * If you provide <code>segmentIndex</code>, you must also provide <code>segmentCount</code>.
         * </p>
         * 
         * @param segmentIndex
         *        For a parallel <code>ListVectors</code> request, <code>segmentIndex</code> is the index of the segment
         *        from which to list vectors in the current request. It identifies an individual segment to be listed by
         *        an application worker. </p>
         *        <p>
         *        Segment IDs are zero-based, so the first segment is always 0. For example, if you want to use four
         *        application threads to list vectors in a vector index, then the first thread specifies a
         *        <code>segmentIndex</code> value of 0, the second thread specifies 1, and so on.
         *        </p>
         *        <p>
         *        The value of <code>segmentIndex</code> must be less than the value provided for
         *        <code>segmentCount</code>.
         *        </p>
         *        <p>
         *        If you provide <code>segmentIndex</code>, you must also provide <code>segmentCount</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentIndex(Integer segmentIndex);

        /**
         * <p>
         * If true, the vector data of each vector will be included in the response. The default value is
         * <code>false</code>.
         * </p>
         * 
         * @param returnData
         *        If true, the vector data of each vector will be included in the response. The default value is
         *        <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnData(Boolean returnData);

        /**
         * <p>
         * If true, the metadata associated with each vector will be included in the response. The default value is
         * <code>false</code>.
         * </p>
         * 
         * @param returnMetadata
         *        If true, the metadata associated with each vector will be included in the response. The default value
         *        is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnMetadata(Boolean returnMetadata);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3VectorsRequest.BuilderImpl implements Builder {
        private String vectorBucketName;

        private String indexName;

        private String indexArn;

        private Integer maxResults;

        private String nextToken;

        private Integer segmentCount;

        private Integer segmentIndex;

        private Boolean returnData;

        private Boolean returnMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVectorsRequest model) {
            super(model);
            vectorBucketName(model.vectorBucketName);
            indexName(model.indexName);
            indexArn(model.indexArn);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            segmentCount(model.segmentCount);
            segmentIndex(model.segmentIndex);
            returnData(model.returnData);
            returnMetadata(model.returnMetadata);
        }

        public final String getVectorBucketName() {
            return vectorBucketName;
        }

        public final void setVectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
        }

        @Override
        public final Builder vectorBucketName(String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
            return this;
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getIndexArn() {
            return indexArn;
        }

        public final void setIndexArn(String indexArn) {
            this.indexArn = indexArn;
        }

        @Override
        public final Builder indexArn(String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getSegmentCount() {
            return segmentCount;
        }

        public final void setSegmentCount(Integer segmentCount) {
            this.segmentCount = segmentCount;
        }

        @Override
        public final Builder segmentCount(Integer segmentCount) {
            this.segmentCount = segmentCount;
            return this;
        }

        public final Integer getSegmentIndex() {
            return segmentIndex;
        }

        public final void setSegmentIndex(Integer segmentIndex) {
            this.segmentIndex = segmentIndex;
        }

        @Override
        public final Builder segmentIndex(Integer segmentIndex) {
            this.segmentIndex = segmentIndex;
            return this;
        }

        public final Boolean getReturnData() {
            return returnData;
        }

        public final void setReturnData(Boolean returnData) {
            this.returnData = returnData;
        }

        @Override
        public final Builder returnData(Boolean returnData) {
            this.returnData = returnData;
            return this;
        }

        public final Boolean getReturnMetadata() {
            return returnMetadata;
        }

        public final void setReturnMetadata(Boolean returnMetadata) {
            this.returnMetadata = returnMetadata;
        }

        @Override
        public final Builder returnMetadata(Boolean returnMetadata) {
            this.returnMetadata = returnMetadata;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListVectorsRequest build() {
            return new ListVectorsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
