/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3vectors.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <note>
 * <p>
 * Amazon S3 Vectors is in preview release for Amazon S3 and is subject to change.
 * </p>
 * </note>
 * <p>
 * The metadata configuration for a vector index.
 * </p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetadataConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MetadataConfiguration.Builder, MetadataConfiguration> {
    private static final SdkField<List<String>> NON_FILTERABLE_METADATA_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("nonFilterableMetadataKeys")
            .getter(getter(MetadataConfiguration::nonFilterableMetadataKeys))
            .setter(setter(Builder::nonFilterableMetadataKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nonFilterableMetadataKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NON_FILTERABLE_METADATA_KEYS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> nonFilterableMetadataKeys;

    private MetadataConfiguration(BuilderImpl builder) {
        this.nonFilterableMetadataKeys = builder.nonFilterableMetadataKeys;
    }

    /**
     * For responses, this returns true if the service returned a value for the NonFilterableMetadataKeys property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNonFilterableMetadataKeys() {
        return nonFilterableMetadataKeys != null && !(nonFilterableMetadataKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Non-filterable metadata keys allow you to enrich vectors with additional context during storage and retrieval.
     * Unlike default metadata keys, these keys can’t be used as query filters. Non-filterable metadata keys can be
     * retrieved but can’t be searched, queried, or filtered. You can access non-filterable metadata keys of your
     * vectors after finding the vectors. For more information about non-filterable metadata keys, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-vectors.html">Vectors</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-limitations.html">Limitations and
     * restrictions</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNonFilterableMetadataKeys} method.
     * </p>
     * 
     * @return Non-filterable metadata keys allow you to enrich vectors with additional context during storage and
     *         retrieval. Unlike default metadata keys, these keys can’t be used as query filters. Non-filterable
     *         metadata keys can be retrieved but can’t be searched, queried, or filtered. You can access non-filterable
     *         metadata keys of your vectors after finding the vectors. For more information about non-filterable
     *         metadata keys, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-vectors.html">Vectors</a> and <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-limitations.html">Limitations and
     *         restrictions</a> in the <i>Amazon S3 User Guide</i>.
     */
    public final List<String> nonFilterableMetadataKeys() {
        return nonFilterableMetadataKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasNonFilterableMetadataKeys() ? nonFilterableMetadataKeys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataConfiguration)) {
            return false;
        }
        MetadataConfiguration other = (MetadataConfiguration) obj;
        return hasNonFilterableMetadataKeys() == other.hasNonFilterableMetadataKeys()
                && Objects.equals(nonFilterableMetadataKeys(), other.nonFilterableMetadataKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetadataConfiguration")
                .add("NonFilterableMetadataKeys", hasNonFilterableMetadataKeys() ? nonFilterableMetadataKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nonFilterableMetadataKeys":
            return Optional.ofNullable(clazz.cast(nonFilterableMetadataKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nonFilterableMetadataKeys", NON_FILTERABLE_METADATA_KEYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetadataConfiguration, T> g) {
        return obj -> g.apply((MetadataConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetadataConfiguration> {
        /**
         * <p>
         * Non-filterable metadata keys allow you to enrich vectors with additional context during storage and
         * retrieval. Unlike default metadata keys, these keys can’t be used as query filters. Non-filterable metadata
         * keys can be retrieved but can’t be searched, queried, or filtered. You can access non-filterable metadata
         * keys of your vectors after finding the vectors. For more information about non-filterable metadata keys, see
         * <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-vectors.html">Vectors</a> and <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-limitations.html">Limitations and
         * restrictions</a> in the <i>Amazon S3 User Guide</i>.
         * </p>
         * 
         * @param nonFilterableMetadataKeys
         *        Non-filterable metadata keys allow you to enrich vectors with additional context during storage and
         *        retrieval. Unlike default metadata keys, these keys can’t be used as query filters. Non-filterable
         *        metadata keys can be retrieved but can’t be searched, queried, or filtered. You can access
         *        non-filterable metadata keys of your vectors after finding the vectors. For more information about
         *        non-filterable metadata keys, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-vectors.html">Vectors</a> and
         *        <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-limitations.html">Limitations
         *        and restrictions</a> in the <i>Amazon S3 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonFilterableMetadataKeys(Collection<String> nonFilterableMetadataKeys);

        /**
         * <p>
         * Non-filterable metadata keys allow you to enrich vectors with additional context during storage and
         * retrieval. Unlike default metadata keys, these keys can’t be used as query filters. Non-filterable metadata
         * keys can be retrieved but can’t be searched, queried, or filtered. You can access non-filterable metadata
         * keys of your vectors after finding the vectors. For more information about non-filterable metadata keys, see
         * <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-vectors.html">Vectors</a> and <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-limitations.html">Limitations and
         * restrictions</a> in the <i>Amazon S3 User Guide</i>.
         * </p>
         * 
         * @param nonFilterableMetadataKeys
         *        Non-filterable metadata keys allow you to enrich vectors with additional context during storage and
         *        retrieval. Unlike default metadata keys, these keys can’t be used as query filters. Non-filterable
         *        metadata keys can be retrieved but can’t be searched, queried, or filtered. You can access
         *        non-filterable metadata keys of your vectors after finding the vectors. For more information about
         *        non-filterable metadata keys, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-vectors.html">Vectors</a> and
         *        <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-limitations.html">Limitations
         *        and restrictions</a> in the <i>Amazon S3 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonFilterableMetadataKeys(String... nonFilterableMetadataKeys);
    }

    static final class BuilderImpl implements Builder {
        private List<String> nonFilterableMetadataKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataConfiguration model) {
            nonFilterableMetadataKeys(model.nonFilterableMetadataKeys);
        }

        public final Collection<String> getNonFilterableMetadataKeys() {
            if (nonFilterableMetadataKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return nonFilterableMetadataKeys;
        }

        public final void setNonFilterableMetadataKeys(Collection<String> nonFilterableMetadataKeys) {
            this.nonFilterableMetadataKeys = NonFilterableMetadataKeysCopier.copy(nonFilterableMetadataKeys);
        }

        @Override
        public final Builder nonFilterableMetadataKeys(Collection<String> nonFilterableMetadataKeys) {
            this.nonFilterableMetadataKeys = NonFilterableMetadataKeysCopier.copy(nonFilterableMetadataKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nonFilterableMetadataKeys(String... nonFilterableMetadataKeys) {
            nonFilterableMetadataKeys(Arrays.asList(nonFilterableMetadataKeys));
            return this;
        }

        @Override
        public MetadataConfiguration build() {
            return new MetadataConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
