/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Amazon S3 vector buckets are a bucket type to store and search vectors with sub-second search times. They are
 * designed to provide dedicated API operations for you to interact with vectors to do similarity search. Within a
 * vector bucket, you use a vector index to organize and logically group your vector data. When you make a write or read
 * request, you direct it to a single vector index. You store your vector data as vectors. A vector contains a key (a
 * name that you assign), a multi-dimensional vector, and, optionally, metadata that describes a vector. The key
 * uniquely identifies the vector in a vector index.
 * </p>
 */
package software.amazon.awssdk.services.s3vectors;