/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.sagemaker.model.AddTagsRequest;
import software.amazon.awssdk.services.sagemaker.model.AddTagsResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateAlgorithmRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateAlgorithmResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateCodeRepositoryRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateCodeRepositoryResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateCompilationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateCompilationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateLabelingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateLabelingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlRequest;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateTransformJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateTransformJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteAlgorithmRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteAlgorithmResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteCodeRepositoryRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteCodeRepositoryResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteTagsRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteTagsResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeAlgorithmRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeAlgorithmResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeCodeRepositoryRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeCodeRepositoryResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeCompilationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeCompilationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeLabelingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeLabelingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeSubscribedWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeSubscribedWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.GetSearchSuggestionsRequest;
import software.amazon.awssdk.services.sagemaker.model.GetSearchSuggestionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackagesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackagesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTagsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTagsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTransformJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTransformJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListWorkteamsResponse;
import software.amazon.awssdk.services.sagemaker.model.RenderUiTemplateRequest;
import software.amazon.awssdk.services.sagemaker.model.RenderUiTemplateResponse;
import software.amazon.awssdk.services.sagemaker.model.ResourceInUseException;
import software.amazon.awssdk.services.sagemaker.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.sagemaker.model.ResourceNotFoundException;
import software.amazon.awssdk.services.sagemaker.model.SageMakerException;
import software.amazon.awssdk.services.sagemaker.model.SearchRequest;
import software.amazon.awssdk.services.sagemaker.model.SearchResponse;
import software.amazon.awssdk.services.sagemaker.model.StartNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.StartNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.StopCompilationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopCompilationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopLabelingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopLabelingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.StopNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.StopTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopTransformJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopTransformJobResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateCodeRepositoryRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateCodeRepositoryResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.paginators.ListCompilationJobsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListEndpointConfigsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListEndpointsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListHyperParameterTuningJobsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsForWorkteamIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstanceLifecycleConfigsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstancesIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListSubscribedWorkteamsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListTagsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsForHyperParameterTuningJobIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListTransformJobsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.ListWorkteamsIterable;
import software.amazon.awssdk.services.sagemaker.paginators.SearchIterable;

/**
 * Service client for accessing SageMaker. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Provides APIs for creating and managing Amazon SageMaker resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface SageMakerClient extends SdkClient {
    String SERVICE_NAME = "sagemaker";

    /**
     * Create a {@link SageMakerClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SageMakerClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SageMakerClient}.
     */
    static SageMakerClientBuilder builder() {
        return new DefaultSageMakerClientBuilder();
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified Amazon SageMaker resource. You can add tags to notebook
     * instances, training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams,
     * endpoint configurations, and endpoints.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information
     * about tags, see For more information, see <a
     * href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS Tagging Strategies</a>.
     * </p>
     * <note>
     * <p>
     * Tags that you add to a hyperparameter tuning job by calling this API are also added to any training jobs that the
     * hyperparameter tuning job launches after you call this API, but not to training jobs that the hyperparameter
     * tuning job launched before you called this API. To make sure that the tags associated with a hyperparameter
     * tuning job are also added to all training jobs that the hyperparameter tuning job launches, add the tags when you
     * first create the tuning job by specifying them in the <code>Tags</code> parameter of
     * <a>CreateHyperParameterTuningJob</a>
     * </p>
     * </note>
     *
     * @param addTagsRequest
     * @return Result of the AddTags operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.AddTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AddTags" target="_top">AWS API
     *      Documentation</a>
     */
    default AddTagsResponse addTags(AddTagsRequest addTagsRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified Amazon SageMaker resource. You can add tags to notebook
     * instances, training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams,
     * endpoint configurations, and endpoints.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information
     * about tags, see For more information, see <a
     * href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS Tagging Strategies</a>.
     * </p>
     * <note>
     * <p>
     * Tags that you add to a hyperparameter tuning job by calling this API are also added to any training jobs that the
     * hyperparameter tuning job launches after you call this API, but not to training jobs that the hyperparameter
     * tuning job launched before you called this API. To make sure that the tags associated with a hyperparameter
     * tuning job are also added to all training jobs that the hyperparameter tuning job launches, add the tags when you
     * first create the tuning job by specifying them in the <code>Tags</code> parameter of
     * <a>CreateHyperParameterTuningJob</a>
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsRequest.Builder} avoiding the need to create
     * one manually via {@link AddTagsRequest#builder()}
     * </p>
     *
     * @param addTagsRequest
     *        A {@link Consumer} that will call methods on {@link AddTagsInput.Builder} to create a request.
     * @return Result of the AddTags operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.AddTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AddTags" target="_top">AWS API
     *      Documentation</a>
     */
    default AddTagsResponse addTags(Consumer<AddTagsRequest.Builder> addTagsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return addTags(AddTagsRequest.builder().applyMutation(addTagsRequest).build());
    }

    /**
     * <p>
     * Create a machine learning algorithm that you can use in Amazon SageMaker and list in the AWS Marketplace.
     * </p>
     *
     * @param createAlgorithmRequest
     * @return Result of the CreateAlgorithm operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateAlgorithm
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAlgorithm" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAlgorithmResponse createAlgorithm(CreateAlgorithmRequest createAlgorithmRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a machine learning algorithm that you can use in Amazon SageMaker and list in the AWS Marketplace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAlgorithmRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAlgorithmRequest#builder()}
     * </p>
     *
     * @param createAlgorithmRequest
     *        A {@link Consumer} that will call methods on {@link CreateAlgorithmInput.Builder} to create a request.
     * @return Result of the CreateAlgorithm operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateAlgorithm
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAlgorithm" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAlgorithmResponse createAlgorithm(Consumer<CreateAlgorithmRequest.Builder> createAlgorithmRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return createAlgorithm(CreateAlgorithmRequest.builder().applyMutation(createAlgorithmRequest).build());
    }

    /**
     * <p>
     * Creates a Git repository as a resource in your Amazon SageMaker account. You can associate the repository with
     * notebook instances so that you can use Git source control for the notebooks you create. The Git repository is a
     * resource in your Amazon SageMaker account, so it can be associated with more than one notebook instance, and it
     * persists independently from the lifecycle of any notebook instances it is associated with.
     * </p>
     * <p>
     * The repository can be hosted either in <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other
     * Git repository.
     * </p>
     *
     * @param createCodeRepositoryRequest
     * @return Result of the CreateCodeRepository operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateCodeRepository
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCodeRepository" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateCodeRepositoryResponse createCodeRepository(CreateCodeRepositoryRequest createCodeRepositoryRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Git repository as a resource in your Amazon SageMaker account. You can associate the repository with
     * notebook instances so that you can use Git source control for the notebooks you create. The Git repository is a
     * resource in your Amazon SageMaker account, so it can be associated with more than one notebook instance, and it
     * persists independently from the lifecycle of any notebook instances it is associated with.
     * </p>
     * <p>
     * The repository can be hosted either in <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other
     * Git repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCodeRepositoryRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCodeRepositoryRequest#builder()}
     * </p>
     *
     * @param createCodeRepositoryRequest
     *        A {@link Consumer} that will call methods on {@link CreateCodeRepositoryInput.Builder} to create a
     *        request.
     * @return Result of the CreateCodeRepository operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateCodeRepository
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCodeRepository" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateCodeRepositoryResponse createCodeRepository(
            Consumer<CreateCodeRepositoryRequest.Builder> createCodeRepositoryRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return createCodeRepository(CreateCodeRepositoryRequest.builder().applyMutation(createCodeRepositoryRequest).build());
    }

    /**
     * <p>
     * Starts a model compilation job. After the model has been compiled, Amazon SageMaker saves the resulting model
     * artifacts to an Amazon Simple Storage Service (Amazon S3) bucket that you specify.
     * </p>
     * <p>
     * If you choose to host your model using Amazon SageMaker hosting services, you can use the resulting model
     * artifacts as part of the model. You can also use the artifacts with AWS IoT Greengrass. In that case, deploy them
     * as an ML resource.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A name for the compilation job
     * </p>
     * </li>
     * <li>
     * <p>
     * Information about the input model artifacts
     * </p>
     * </li>
     * <li>
     * <p>
     * The output location for the compiled model and the device (target) that the model runs on
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker assumes to perform the model compilation job</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also provide a <code>Tag</code> to track the model compilation job's resource use and costs. The response
     * body contains the <code>CompilationJobArn</code> for the compiled job.
     * </p>
     * <p>
     * To stop a model compilation job, use <a>StopCompilationJob</a>. To get information about a particular model
     * compilation job, use <a>DescribeCompilationJob</a>. To get information about multiple model compilation jobs, use
     * <a>ListCompilationJobs</a>.
     * </p>
     *
     * @param createCompilationJobRequest
     * @return Result of the CreateCompilationJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateCompilationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCompilationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateCompilationJobResponse createCompilationJob(CreateCompilationJobRequest createCompilationJobRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a model compilation job. After the model has been compiled, Amazon SageMaker saves the resulting model
     * artifacts to an Amazon Simple Storage Service (Amazon S3) bucket that you specify.
     * </p>
     * <p>
     * If you choose to host your model using Amazon SageMaker hosting services, you can use the resulting model
     * artifacts as part of the model. You can also use the artifacts with AWS IoT Greengrass. In that case, deploy them
     * as an ML resource.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A name for the compilation job
     * </p>
     * </li>
     * <li>
     * <p>
     * Information about the input model artifacts
     * </p>
     * </li>
     * <li>
     * <p>
     * The output location for the compiled model and the device (target) that the model runs on
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker assumes to perform the model compilation job</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also provide a <code>Tag</code> to track the model compilation job's resource use and costs. The response
     * body contains the <code>CompilationJobArn</code> for the compiled job.
     * </p>
     * <p>
     * To stop a model compilation job, use <a>StopCompilationJob</a>. To get information about a particular model
     * compilation job, use <a>DescribeCompilationJob</a>. To get information about multiple model compilation jobs, use
     * <a>ListCompilationJobs</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCompilationJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCompilationJobRequest#builder()}
     * </p>
     *
     * @param createCompilationJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateCompilationJobRequest.Builder} to create a
     *        request.
     * @return Result of the CreateCompilationJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateCompilationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCompilationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateCompilationJobResponse createCompilationJob(
            Consumer<CreateCompilationJobRequest.Builder> createCompilationJobRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createCompilationJob(CreateCompilationJobRequest.builder().applyMutation(createCompilationJobRequest).build());
    }

    /**
     * <p>
     * Creates an endpoint using the endpoint configuration specified in the request. Amazon SageMaker uses the endpoint
     * to provision resources and deploy models. You create the endpoint configuration with the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html">CreateEndpointConfig</a>
     * API.
     * </p>
     * <note>
     * <p>
     * Use this API only for hosting models using Amazon SageMaker hosting services.
     * </p>
     * <p>
     * You must not delete an <code>EndpointConfig</code> in use by an endpoint that is live or while the
     * <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. To
     * update an endpoint, you must create a new <code>EndpointConfig</code>.
     * </p>
     * </note>
     * <p>
     * The endpoint name must be unique within an AWS Region in your AWS account.
     * </p>
     * <p>
     * When it receives the request, Amazon SageMaker creates the endpoint, launches the resources (ML compute
     * instances), and deploys the model(s) on them.
     * </p>
     * <p>
     * When Amazon SageMaker receives the request, it sets the endpoint status to <code>Creating</code>. After it
     * creates the endpoint, it sets the status to <code>InService</code>. Amazon SageMaker can then process incoming
     * requests for inferences. To check the status of an endpoint, use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeEndpoint.html">DescribeEndpoint</a> API.
     * </p>
     * <p>
     * For an example, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ex1.html">Exercise 1: Using the
     * K-Means Algorithm Provided by Amazon SageMaker</a>.
     * </p>
     * <p>
     * If any of the models hosted at this endpoint get model data from an Amazon S3 location, Amazon SageMaker uses AWS
     * Security Token Service to download model artifacts from the S3 path you provided. AWS STS is activated in your
     * IAM user account by default. If you previously deactivated AWS STS for a region, you need to reactivate AWS STS
     * for that region. For more information, see <a
     * href="IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and Deactivating AWS STS i an AWS
     * Region</a> in the <i>AWS Identity and Access Management User Guide</i>.
     * </p>
     *
     * @param createEndpointRequest
     * @return Result of the CreateEndpoint operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateEndpointResponse createEndpoint(CreateEndpointRequest createEndpointRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an endpoint using the endpoint configuration specified in the request. Amazon SageMaker uses the endpoint
     * to provision resources and deploy models. You create the endpoint configuration with the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html">CreateEndpointConfig</a>
     * API.
     * </p>
     * <note>
     * <p>
     * Use this API only for hosting models using Amazon SageMaker hosting services.
     * </p>
     * <p>
     * You must not delete an <code>EndpointConfig</code> in use by an endpoint that is live or while the
     * <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. To
     * update an endpoint, you must create a new <code>EndpointConfig</code>.
     * </p>
     * </note>
     * <p>
     * The endpoint name must be unique within an AWS Region in your AWS account.
     * </p>
     * <p>
     * When it receives the request, Amazon SageMaker creates the endpoint, launches the resources (ML compute
     * instances), and deploys the model(s) on them.
     * </p>
     * <p>
     * When Amazon SageMaker receives the request, it sets the endpoint status to <code>Creating</code>. After it
     * creates the endpoint, it sets the status to <code>InService</code>. Amazon SageMaker can then process incoming
     * requests for inferences. To check the status of an endpoint, use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeEndpoint.html">DescribeEndpoint</a> API.
     * </p>
     * <p>
     * For an example, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ex1.html">Exercise 1: Using the
     * K-Means Algorithm Provided by Amazon SageMaker</a>.
     * </p>
     * <p>
     * If any of the models hosted at this endpoint get model data from an Amazon S3 location, Amazon SageMaker uses AWS
     * Security Token Service to download model artifacts from the S3 path you provided. AWS STS is activated in your
     * IAM user account by default. If you previously deactivated AWS STS for a region, you need to reactivate AWS STS
     * for that region. For more information, see <a
     * href="IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and Deactivating AWS STS i an AWS
     * Region</a> in the <i>AWS Identity and Access Management User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link CreateEndpointRequest#builder()}
     * </p>
     *
     * @param createEndpointRequest
     *        A {@link Consumer} that will call methods on {@link CreateEndpointInput.Builder} to create a request.
     * @return Result of the CreateEndpoint operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateEndpointResponse createEndpoint(Consumer<CreateEndpointRequest.Builder> createEndpointRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createEndpoint(CreateEndpointRequest.builder().applyMutation(createEndpointRequest).build());
    }

    /**
     * <p>
     * Creates an endpoint configuration that Amazon SageMaker hosting services uses to deploy models. In the
     * configuration, you identify one or more models, created using the <code>CreateModel</code> API, to deploy and the
     * resources that you want Amazon SageMaker to provision. Then you call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html">CreateEndpoint</a> API.
     * </p>
     * <note>
     * <p>
     * Use this API only if you want to use Amazon SageMaker hosting services to deploy models into production.
     * </p>
     * </note>
     * <p>
     * In the request, you define one or more <code>ProductionVariant</code>s, each of which identifies a model. Each
     * <code>ProductionVariant</code> parameter also describes the resources that you want Amazon SageMaker to
     * provision. This includes the number and type of ML compute instances to deploy.
     * </p>
     * <p>
     * If you are hosting multiple models, you also assign a <code>VariantWeight</code> to specify how much traffic you
     * want to allocate to each model. For example, suppose that you want to host two models, A and B, and you assign
     * traffic weight 2 for model A and 1 for model B. Amazon SageMaker distributes two-thirds of the traffic to Model
     * A, and one-third to model B.
     * </p>
     *
     * @param createEndpointConfigRequest
     * @return Result of the CreateEndpointConfig operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateEndpointConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpointConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateEndpointConfigResponse createEndpointConfig(CreateEndpointConfigRequest createEndpointConfigRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an endpoint configuration that Amazon SageMaker hosting services uses to deploy models. In the
     * configuration, you identify one or more models, created using the <code>CreateModel</code> API, to deploy and the
     * resources that you want Amazon SageMaker to provision. Then you call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html">CreateEndpoint</a> API.
     * </p>
     * <note>
     * <p>
     * Use this API only if you want to use Amazon SageMaker hosting services to deploy models into production.
     * </p>
     * </note>
     * <p>
     * In the request, you define one or more <code>ProductionVariant</code>s, each of which identifies a model. Each
     * <code>ProductionVariant</code> parameter also describes the resources that you want Amazon SageMaker to
     * provision. This includes the number and type of ML compute instances to deploy.
     * </p>
     * <p>
     * If you are hosting multiple models, you also assign a <code>VariantWeight</code> to specify how much traffic you
     * want to allocate to each model. For example, suppose that you want to host two models, A and B, and you assign
     * traffic weight 2 for model A and 1 for model B. Amazon SageMaker distributes two-thirds of the traffic to Model
     * A, and one-third to model B.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEndpointConfigRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEndpointConfigRequest#builder()}
     * </p>
     *
     * @param createEndpointConfigRequest
     *        A {@link Consumer} that will call methods on {@link CreateEndpointConfigInput.Builder} to create a
     *        request.
     * @return Result of the CreateEndpointConfig operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateEndpointConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpointConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateEndpointConfigResponse createEndpointConfig(
            Consumer<CreateEndpointConfigRequest.Builder> createEndpointConfigRequest) throws ResourceLimitExceededException,
            AwsServiceException, SdkClientException, SageMakerException {
        return createEndpointConfig(CreateEndpointConfigRequest.builder().applyMutation(createEndpointConfigRequest).build());
    }

    /**
     * <p>
     * Starts a hyperparameter tuning job. A hyperparameter tuning job finds the best version of a model by running many
     * training jobs on your dataset using the algorithm you choose and values for hyperparameters within ranges that
     * you specify. It then chooses the hyperparameter values that result in a model that performs the best, as measured
     * by an objective metric that you choose.
     * </p>
     *
     * @param createHyperParameterTuningJobRequest
     * @return Result of the CreateHyperParameterTuningJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateHyperParameterTuningJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateHyperParameterTuningJobResponse createHyperParameterTuningJob(
            CreateHyperParameterTuningJobRequest createHyperParameterTuningJobRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a hyperparameter tuning job. A hyperparameter tuning job finds the best version of a model by running many
     * training jobs on your dataset using the algorithm you choose and values for hyperparameters within ranges that
     * you specify. It then chooses the hyperparameter values that result in a model that performs the best, as measured
     * by an objective metric that you choose.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHyperParameterTuningJobRequest.Builder}
     * avoiding the need to create one manually via {@link CreateHyperParameterTuningJobRequest#builder()}
     * </p>
     *
     * @param createHyperParameterTuningJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateHyperParameterTuningJobRequest.Builder} to
     *        create a request.
     * @return Result of the CreateHyperParameterTuningJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateHyperParameterTuningJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateHyperParameterTuningJobResponse createHyperParameterTuningJob(
            Consumer<CreateHyperParameterTuningJobRequest.Builder> createHyperParameterTuningJobRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        return createHyperParameterTuningJob(CreateHyperParameterTuningJobRequest.builder()
                .applyMutation(createHyperParameterTuningJobRequest).build());
    }

    /**
     * <p>
     * Creates a job that uses workers to label the data objects in your input dataset. You can use the labeled data to
     * train machine learning models.
     * </p>
     * <p>
     * You can select your workforce from one of three providers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A private workforce that you create. It can include employees, contractors, and outside experts. Use a private
     * workforce when want the data to stay within your organization or when a specific set of skills is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * One or more vendors that you select from the AWS Marketplace. Vendors provide expertise in specific areas.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Amazon Mechanical Turk workforce. This is the largest workforce, but it should only be used for public data
     * or data that has been stripped of any personally identifiable information.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also use <i>automated data labeling</i> to reduce the number of data objects that need to be labeled by a
     * human. Automated data labeling uses <i>active learning</i> to determine if a data object can be labeled by
     * machine or if it needs to be sent to a human worker. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-automated-labeling.html">Using Automated Data
     * Labeling</a>.
     * </p>
     * <p>
     * The data objects to be labeled are contained in an Amazon S3 bucket. You create a <i>manifest file</i> that
     * describes the location of each object. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data.html">Using Input and Output Data</a>.
     * </p>
     * <p>
     * The output can be used as the manifest file for another labeling job or as training data for your machine
     * learning models.
     * </p>
     *
     * @param createLabelingJobRequest
     * @return Result of the CreateLabelingJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateLabelingJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateLabelingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateLabelingJobResponse createLabelingJob(CreateLabelingJobRequest createLabelingJobRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a job that uses workers to label the data objects in your input dataset. You can use the labeled data to
     * train machine learning models.
     * </p>
     * <p>
     * You can select your workforce from one of three providers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A private workforce that you create. It can include employees, contractors, and outside experts. Use a private
     * workforce when want the data to stay within your organization or when a specific set of skills is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * One or more vendors that you select from the AWS Marketplace. Vendors provide expertise in specific areas.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Amazon Mechanical Turk workforce. This is the largest workforce, but it should only be used for public data
     * or data that has been stripped of any personally identifiable information.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also use <i>automated data labeling</i> to reduce the number of data objects that need to be labeled by a
     * human. Automated data labeling uses <i>active learning</i> to determine if a data object can be labeled by
     * machine or if it needs to be sent to a human worker. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-automated-labeling.html">Using Automated Data
     * Labeling</a>.
     * </p>
     * <p>
     * The data objects to be labeled are contained in an Amazon S3 bucket. You create a <i>manifest file</i> that
     * describes the location of each object. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data.html">Using Input and Output Data</a>.
     * </p>
     * <p>
     * The output can be used as the manifest file for another labeling job or as training data for your machine
     * learning models.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLabelingJobRequest.Builder} avoiding the need
     * to create one manually via {@link CreateLabelingJobRequest#builder()}
     * </p>
     *
     * @param createLabelingJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateLabelingJobRequest.Builder} to create a request.
     * @return Result of the CreateLabelingJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateLabelingJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateLabelingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateLabelingJobResponse createLabelingJob(Consumer<CreateLabelingJobRequest.Builder> createLabelingJobRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        return createLabelingJob(CreateLabelingJobRequest.builder().applyMutation(createLabelingJobRequest).build());
    }

    /**
     * <p>
     * Creates a model in Amazon SageMaker. In the request, you name the model and describe a primary container. For the
     * primary container, you specify the docker image containing inference code, artifacts (from prior training), and
     * custom environment map that the inference code uses when you deploy the model for predictions.
     * </p>
     * <p>
     * Use this API to create a model if you want to use Amazon SageMaker hosting services or run a batch transform job.
     * </p>
     * <p>
     * To host your model, you create an endpoint configuration with the <code>CreateEndpointConfig</code> API, and then
     * create an endpoint with the <code>CreateEndpoint</code> API. Amazon SageMaker then deploys all of the containers
     * that you defined for the model in the hosting environment.
     * </p>
     * <p>
     * To run a batch transform using your model, you start a job with the <code>CreateTransformJob</code> API. Amazon
     * SageMaker uses your model and your dataset to get inferences which are then saved to a specified S3 location.
     * </p>
     * <p>
     * In the <code>CreateModel</code> request, you must define a container with the <code>PrimaryContainer</code>
     * parameter.
     * </p>
     * <p>
     * In the request, you also provide an IAM role that Amazon SageMaker can assume to access model artifacts and
     * docker image for deployment on ML compute hosting instances or for batch transform jobs. In addition, you also
     * use the IAM role to manage permissions the inference code needs. For example, if the inference code access any
     * other AWS resources, you grant necessary permissions via this role.
     * </p>
     *
     * @param createModelRequest
     * @return Result of the CreateModel operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateModelResponse createModel(CreateModelRequest createModelRequest) throws ResourceLimitExceededException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a model in Amazon SageMaker. In the request, you name the model and describe a primary container. For the
     * primary container, you specify the docker image containing inference code, artifacts (from prior training), and
     * custom environment map that the inference code uses when you deploy the model for predictions.
     * </p>
     * <p>
     * Use this API to create a model if you want to use Amazon SageMaker hosting services or run a batch transform job.
     * </p>
     * <p>
     * To host your model, you create an endpoint configuration with the <code>CreateEndpointConfig</code> API, and then
     * create an endpoint with the <code>CreateEndpoint</code> API. Amazon SageMaker then deploys all of the containers
     * that you defined for the model in the hosting environment.
     * </p>
     * <p>
     * To run a batch transform using your model, you start a job with the <code>CreateTransformJob</code> API. Amazon
     * SageMaker uses your model and your dataset to get inferences which are then saved to a specified S3 location.
     * </p>
     * <p>
     * In the <code>CreateModel</code> request, you must define a container with the <code>PrimaryContainer</code>
     * parameter.
     * </p>
     * <p>
     * In the request, you also provide an IAM role that Amazon SageMaker can assume to access model artifacts and
     * docker image for deployment on ML compute hosting instances or for batch transform jobs. In addition, you also
     * use the IAM role to manage permissions the inference code needs. For example, if the inference code access any
     * other AWS resources, you grant necessary permissions via this role.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateModelRequest#builder()}
     * </p>
     *
     * @param createModelRequest
     *        A {@link Consumer} that will call methods on {@link CreateModelInput.Builder} to create a request.
     * @return Result of the CreateModel operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateModelResponse createModel(Consumer<CreateModelRequest.Builder> createModelRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createModel(CreateModelRequest.builder().applyMutation(createModelRequest).build());
    }

    /**
     * <p>
     * Creates a model package that you can use to create Amazon SageMaker models or list on AWS Marketplace. Buyers can
     * subscribe to model packages listed on AWS Marketplace to create models in Amazon SageMaker.
     * </p>
     * <p>
     * To create a model package by specifying a Docker container that contains your inference code and the Amazon S3
     * location of your model artifacts, provide values for <code>InferenceSpecification</code>. To create a model from
     * an algorithm resource that you created or subscribed to in AWS Marketplace, provide a value for
     * <code>SourceAlgorithmSpecification</code>.
     * </p>
     *
     * @param createModelPackageRequest
     * @return Result of the CreateModelPackage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateModelPackage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateModelPackageResponse createModelPackage(CreateModelPackageRequest createModelPackageRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a model package that you can use to create Amazon SageMaker models or list on AWS Marketplace. Buyers can
     * subscribe to model packages listed on AWS Marketplace to create models in Amazon SageMaker.
     * </p>
     * <p>
     * To create a model package by specifying a Docker container that contains your inference code and the Amazon S3
     * location of your model artifacts, provide values for <code>InferenceSpecification</code>. To create a model from
     * an algorithm resource that you created or subscribed to in AWS Marketplace, provide a value for
     * <code>SourceAlgorithmSpecification</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelPackageRequest.Builder} avoiding the
     * need to create one manually via {@link CreateModelPackageRequest#builder()}
     * </p>
     *
     * @param createModelPackageRequest
     *        A {@link Consumer} that will call methods on {@link CreateModelPackageInput.Builder} to create a request.
     * @return Result of the CreateModelPackage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateModelPackage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateModelPackageResponse createModelPackage(Consumer<CreateModelPackageRequest.Builder> createModelPackageRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return createModelPackage(CreateModelPackageRequest.builder().applyMutation(createModelPackageRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon SageMaker notebook instance. A notebook instance is a machine learning (ML) compute instance
     * running on a Jupyter notebook.
     * </p>
     * <p>
     * In a <code>CreateNotebookInstance</code> request, specify the type of ML compute instance that you want to run.
     * Amazon SageMaker launches the instance, installs common libraries that you can use to explore datasets for model
     * training, and attaches an ML storage volume to the notebook instance.
     * </p>
     * <p>
     * Amazon SageMaker also provides a set of example notebooks. Each notebook demonstrates how to use Amazon SageMaker
     * with a specific algorithm or with a machine learning framework.
     * </p>
     * <p>
     * After receiving the request, Amazon SageMaker does the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Creates a network interface in the Amazon SageMaker VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Option) If you specified <code>SubnetId</code>, Amazon SageMaker creates a network interface in your own VPC,
     * which is inferred from the subnet ID that you provide in the input. When creating this network interface, Amazon
     * SageMaker attaches the security group that you specified in the request to the network interface that it creates
     * in your VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * Launches an EC2 instance of the type specified in the request in the Amazon SageMaker VPC. If you specified
     * <code>SubnetId</code> of your VPC, Amazon SageMaker specifies both network interfaces when launching this
     * instance. This enables inbound traffic from your own VPC to the notebook instance, assuming that the security
     * groups allow it.
     * </p>
     * </li>
     * </ol>
     * <p>
     * After creating the notebook instance, Amazon SageMaker returns its Amazon Resource Name (ARN). You can't change
     * the name of a notebook instance after you create it.
     * </p>
     * <p>
     * After Amazon SageMaker creates the notebook instance, you can connect to the Jupyter server and work in Jupyter
     * notebooks. For example, you can write code to explore a dataset that you can use for model training, train a
     * model, host models by creating Amazon SageMaker endpoints, and validate hosted models.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It
     * Works</a>.
     * </p>
     *
     * @param createNotebookInstanceRequest
     * @return Result of the CreateNotebookInstance operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateNotebookInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNotebookInstanceResponse createNotebookInstance(CreateNotebookInstanceRequest createNotebookInstanceRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon SageMaker notebook instance. A notebook instance is a machine learning (ML) compute instance
     * running on a Jupyter notebook.
     * </p>
     * <p>
     * In a <code>CreateNotebookInstance</code> request, specify the type of ML compute instance that you want to run.
     * Amazon SageMaker launches the instance, installs common libraries that you can use to explore datasets for model
     * training, and attaches an ML storage volume to the notebook instance.
     * </p>
     * <p>
     * Amazon SageMaker also provides a set of example notebooks. Each notebook demonstrates how to use Amazon SageMaker
     * with a specific algorithm or with a machine learning framework.
     * </p>
     * <p>
     * After receiving the request, Amazon SageMaker does the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Creates a network interface in the Amazon SageMaker VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Option) If you specified <code>SubnetId</code>, Amazon SageMaker creates a network interface in your own VPC,
     * which is inferred from the subnet ID that you provide in the input. When creating this network interface, Amazon
     * SageMaker attaches the security group that you specified in the request to the network interface that it creates
     * in your VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * Launches an EC2 instance of the type specified in the request in the Amazon SageMaker VPC. If you specified
     * <code>SubnetId</code> of your VPC, Amazon SageMaker specifies both network interfaces when launching this
     * instance. This enables inbound traffic from your own VPC to the notebook instance, assuming that the security
     * groups allow it.
     * </p>
     * </li>
     * </ol>
     * <p>
     * After creating the notebook instance, Amazon SageMaker returns its Amazon Resource Name (ARN). You can't change
     * the name of a notebook instance after you create it.
     * </p>
     * <p>
     * After Amazon SageMaker creates the notebook instance, you can connect to the Jupyter server and work in Jupyter
     * notebooks. For example, you can write code to explore a dataset that you can use for model training, train a
     * model, host models by creating Amazon SageMaker endpoints, and validate hosted models.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It
     * Works</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNotebookInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateNotebookInstanceRequest#builder()}
     * </p>
     *
     * @param createNotebookInstanceRequest
     *        A {@link Consumer} that will call methods on {@link CreateNotebookInstanceInput.Builder} to create a
     *        request.
     * @return Result of the CreateNotebookInstance operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateNotebookInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNotebookInstanceResponse createNotebookInstance(
            Consumer<CreateNotebookInstanceRequest.Builder> createNotebookInstanceRequest) throws ResourceLimitExceededException,
            AwsServiceException, SdkClientException, SageMakerException {
        return createNotebookInstance(CreateNotebookInstanceRequest.builder().applyMutation(createNotebookInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Creates a lifecycle configuration that you can associate with a notebook instance. A <i>lifecycle
     * configuration</i> is a collection of shell scripts that run when you create or start a notebook instance.
     * </p>
     * <p>
     * Each lifecycle configuration script has a limit of 16384 characters.
     * </p>
     * <p>
     * The value of the <code>&#36PATH</code> environment variable that is available to both scripts is
     * <code>/sbin:bin:/usr/sbin:/usr/bin</code>.
     * </p>
     * <p>
     * View CloudWatch Logs for notebook instance lifecycle configurations in log group
     * <code>/aws/sagemaker/NotebookInstances</code> in log stream
     * <code>[notebook-instance-name]/[LifecycleConfigHook]</code>.
     * </p>
     * <p>
     * Lifecycle configuration scripts cannot run for longer than 5 minutes. If a script runs for longer than 5 minutes,
     * it fails and the notebook instance is not created or started.
     * </p>
     * <p>
     * For information about notebook instance lifestyle configurations, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
     * Customize a Notebook Instance</a>.
     * </p>
     *
     * @param createNotebookInstanceLifecycleConfigRequest
     * @return Result of the CreateNotebookInstanceLifecycleConfig operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateNotebookInstanceLifecycleConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNotebookInstanceLifecycleConfigResponse createNotebookInstanceLifecycleConfig(
            CreateNotebookInstanceLifecycleConfigRequest createNotebookInstanceLifecycleConfigRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a lifecycle configuration that you can associate with a notebook instance. A <i>lifecycle
     * configuration</i> is a collection of shell scripts that run when you create or start a notebook instance.
     * </p>
     * <p>
     * Each lifecycle configuration script has a limit of 16384 characters.
     * </p>
     * <p>
     * The value of the <code>&#36PATH</code> environment variable that is available to both scripts is
     * <code>/sbin:bin:/usr/sbin:/usr/bin</code>.
     * </p>
     * <p>
     * View CloudWatch Logs for notebook instance lifecycle configurations in log group
     * <code>/aws/sagemaker/NotebookInstances</code> in log stream
     * <code>[notebook-instance-name]/[LifecycleConfigHook]</code>.
     * </p>
     * <p>
     * Lifecycle configuration scripts cannot run for longer than 5 minutes. If a script runs for longer than 5 minutes,
     * it fails and the notebook instance is not created or started.
     * </p>
     * <p>
     * For information about notebook instance lifestyle configurations, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
     * Customize a Notebook Instance</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateNotebookInstanceLifecycleConfigRequest.Builder} avoiding the need to create one manually via
     * {@link CreateNotebookInstanceLifecycleConfigRequest#builder()}
     * </p>
     *
     * @param createNotebookInstanceLifecycleConfigRequest
     *        A {@link Consumer} that will call methods on {@link CreateNotebookInstanceLifecycleConfigInput.Builder} to
     *        create a request.
     * @return Result of the CreateNotebookInstanceLifecycleConfig operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateNotebookInstanceLifecycleConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNotebookInstanceLifecycleConfigResponse createNotebookInstanceLifecycleConfig(
            Consumer<CreateNotebookInstanceLifecycleConfigRequest.Builder> createNotebookInstanceLifecycleConfigRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return createNotebookInstanceLifecycleConfig(CreateNotebookInstanceLifecycleConfigRequest.builder()
                .applyMutation(createNotebookInstanceLifecycleConfigRequest).build());
    }

    /**
     * <p>
     * Returns a URL that you can use to connect to the Jupyter server from a notebook instance. In the Amazon SageMaker
     * console, when you choose <code>Open</code> next to a notebook instance, Amazon SageMaker opens a new tab showing
     * the Jupyter server home page from the notebook instance. The console uses this API to get the URL and show the
     * page.
     * </p>
     * <p>
     * IAM authorization policies for this API are also enforced for every HTTP request and WebSocket frame that
     * attempts to connect to the notebook instance.For example, you can restrict access to this API and to the URL that
     * it returns to a list of IP addresses that you specify. Use the <code>NotIpAddress</code> condition operator and
     * the <code>aws:SourceIP</code> condition context key to specify the list of IP addresses that you want to have
     * access to the notebook instance. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-ip-filter.html">Limit Access to a Notebook Instance by
     * IP Address</a>.
     * </p>
     * <note>
     * <p>
     * The URL that you get from a call to is valid only for 5 minutes. If you try to use the URL after the 5-minute
     * limit expires, you are directed to the AWS console sign-in page.
     * </p>
     * </note>
     *
     * @param createPresignedNotebookInstanceUrlRequest
     * @return Result of the CreatePresignedNotebookInstanceUrl operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreatePresignedNotebookInstanceUrl
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedNotebookInstanceUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePresignedNotebookInstanceUrlResponse createPresignedNotebookInstanceUrl(
            CreatePresignedNotebookInstanceUrlRequest createPresignedNotebookInstanceUrlRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a URL that you can use to connect to the Jupyter server from a notebook instance. In the Amazon SageMaker
     * console, when you choose <code>Open</code> next to a notebook instance, Amazon SageMaker opens a new tab showing
     * the Jupyter server home page from the notebook instance. The console uses this API to get the URL and show the
     * page.
     * </p>
     * <p>
     * IAM authorization policies for this API are also enforced for every HTTP request and WebSocket frame that
     * attempts to connect to the notebook instance.For example, you can restrict access to this API and to the URL that
     * it returns to a list of IP addresses that you specify. Use the <code>NotIpAddress</code> condition operator and
     * the <code>aws:SourceIP</code> condition context key to specify the list of IP addresses that you want to have
     * access to the notebook instance. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-ip-filter.html">Limit Access to a Notebook Instance by
     * IP Address</a>.
     * </p>
     * <note>
     * <p>
     * The URL that you get from a call to is valid only for 5 minutes. If you try to use the URL after the 5-minute
     * limit expires, you are directed to the AWS console sign-in page.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePresignedNotebookInstanceUrlRequest.Builder}
     * avoiding the need to create one manually via {@link CreatePresignedNotebookInstanceUrlRequest#builder()}
     * </p>
     *
     * @param createPresignedNotebookInstanceUrlRequest
     *        A {@link Consumer} that will call methods on {@link CreatePresignedNotebookInstanceUrlInput.Builder} to
     *        create a request.
     * @return Result of the CreatePresignedNotebookInstanceUrl operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreatePresignedNotebookInstanceUrl
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedNotebookInstanceUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePresignedNotebookInstanceUrlResponse createPresignedNotebookInstanceUrl(
            Consumer<CreatePresignedNotebookInstanceUrlRequest.Builder> createPresignedNotebookInstanceUrlRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return createPresignedNotebookInstanceUrl(CreatePresignedNotebookInstanceUrlRequest.builder()
                .applyMutation(createPresignedNotebookInstanceUrlRequest).build());
    }

    /**
     * <p>
     * Starts a model training job. After training completes, Amazon SageMaker saves the resulting model artifacts to an
     * Amazon S3 location that you specify.
     * </p>
     * <p>
     * If you choose to host your model using Amazon SageMaker hosting services, you can use the resulting model
     * artifacts as part of the model. You can also use the artifacts in a machine learning service other than Amazon
     * SageMaker, provided that you know how to use them for inferences.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AlgorithmSpecification</code> - Identifies the training algorithm to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HyperParameters</code> - Specify these algorithm-specific parameters to enable the estimation of model
     * parameters during training. Hyperparameters can be tuned to optimize this learning process. For a list of
     * hyperparameters for each training algorithm provided by Amazon SageMaker, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InputDataConfig</code> - Describes the training dataset and the Amazon S3, EFS, or FSx location where it is
     * stored.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OutputDataConfig</code> - Identifies the Amazon S3 bucket where you want Amazon SageMaker to save the
     * results of model training.
     * </p>
     * <p/></li>
     * <li>
     * <p>
     * <code>ResourceConfig</code> - Identifies the resources, ML compute instances, and ML storage volumes to deploy
     * for model training. In distributed training, you specify more than one instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EnableManagedSpotTraining</code> - Optimize the cost of training machine learning models by up to 80% by
     * using Amazon EC2 Spot instances. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html">Managed Spot
     * Training</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RoleARN</code> - The Amazon Resource Number (ARN) that Amazon SageMaker assumes to perform tasks on your
     * behalf during model training. You must grant this role the necessary permissions so that Amazon SageMaker can
     * successfully complete model training.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>StoppingCondition</code> - To help cap training costs, use <code>MaxRuntimeInSeconds</code> to set a time
     * limit for training. Use <code>MaxWaitTimeInSeconds</code> to specify how long you are willing to to wait for a
     * managed spot training job to complete.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about Amazon SageMaker, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It Works</a>.
     * </p>
     *
     * @param createTrainingJobRequest
     * @return Result of the CreateTrainingJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateTrainingJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrainingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTrainingJobResponse createTrainingJob(CreateTrainingJobRequest createTrainingJobRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a model training job. After training completes, Amazon SageMaker saves the resulting model artifacts to an
     * Amazon S3 location that you specify.
     * </p>
     * <p>
     * If you choose to host your model using Amazon SageMaker hosting services, you can use the resulting model
     * artifacts as part of the model. You can also use the artifacts in a machine learning service other than Amazon
     * SageMaker, provided that you know how to use them for inferences.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AlgorithmSpecification</code> - Identifies the training algorithm to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HyperParameters</code> - Specify these algorithm-specific parameters to enable the estimation of model
     * parameters during training. Hyperparameters can be tuned to optimize this learning process. For a list of
     * hyperparameters for each training algorithm provided by Amazon SageMaker, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InputDataConfig</code> - Describes the training dataset and the Amazon S3, EFS, or FSx location where it is
     * stored.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OutputDataConfig</code> - Identifies the Amazon S3 bucket where you want Amazon SageMaker to save the
     * results of model training.
     * </p>
     * <p/></li>
     * <li>
     * <p>
     * <code>ResourceConfig</code> - Identifies the resources, ML compute instances, and ML storage volumes to deploy
     * for model training. In distributed training, you specify more than one instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EnableManagedSpotTraining</code> - Optimize the cost of training machine learning models by up to 80% by
     * using Amazon EC2 Spot instances. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html">Managed Spot
     * Training</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RoleARN</code> - The Amazon Resource Number (ARN) that Amazon SageMaker assumes to perform tasks on your
     * behalf during model training. You must grant this role the necessary permissions so that Amazon SageMaker can
     * successfully complete model training.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>StoppingCondition</code> - To help cap training costs, use <code>MaxRuntimeInSeconds</code> to set a time
     * limit for training. Use <code>MaxWaitTimeInSeconds</code> to specify how long you are willing to to wait for a
     * managed spot training job to complete.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about Amazon SageMaker, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It Works</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrainingJobRequest.Builder} avoiding the need
     * to create one manually via {@link CreateTrainingJobRequest#builder()}
     * </p>
     *
     * @param createTrainingJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateTrainingJobRequest.Builder} to create a request.
     * @return Result of the CreateTrainingJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateTrainingJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrainingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTrainingJobResponse createTrainingJob(Consumer<CreateTrainingJobRequest.Builder> createTrainingJobRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        return createTrainingJob(CreateTrainingJobRequest.builder().applyMutation(createTrainingJobRequest).build());
    }

    /**
     * <p>
     * Starts a transform job. A transform job uses a trained model to get inferences on a dataset and saves these
     * results to an Amazon S3 location that you specify.
     * </p>
     * <p>
     * To perform batch transformations, you create a transform job and use the data that you have readily available.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TransformJobName</code> - Identifies the transform job. The name must be unique within an AWS Region in an
     * AWS account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ModelName</code> - Identifies the model to use. <code>ModelName</code> must be the name of an existing
     * Amazon SageMaker model in the same AWS Region and AWS account. For information on creating a model, see
     * <a>CreateModel</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformInput</code> - Describes the dataset to be transformed and the Amazon S3 location where it is
     * stored.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformOutput</code> - Identifies the Amazon S3 location where you want Amazon SageMaker to save the
     * results from the transform job.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformResources</code> - Identifies the ML compute instances for the transform job.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about how batch transformation works, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html">Batch Transform</a>.
     * </p>
     *
     * @param createTransformJobRequest
     * @return Result of the CreateTransformJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateTransformJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTransformJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTransformJobResponse createTransformJob(CreateTransformJobRequest createTransformJobRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a transform job. A transform job uses a trained model to get inferences on a dataset and saves these
     * results to an Amazon S3 location that you specify.
     * </p>
     * <p>
     * To perform batch transformations, you create a transform job and use the data that you have readily available.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TransformJobName</code> - Identifies the transform job. The name must be unique within an AWS Region in an
     * AWS account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ModelName</code> - Identifies the model to use. <code>ModelName</code> must be the name of an existing
     * Amazon SageMaker model in the same AWS Region and AWS account. For information on creating a model, see
     * <a>CreateModel</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformInput</code> - Describes the dataset to be transformed and the Amazon S3 location where it is
     * stored.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformOutput</code> - Identifies the Amazon S3 location where you want Amazon SageMaker to save the
     * results from the transform job.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformResources</code> - Identifies the ML compute instances for the transform job.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about how batch transformation works, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html">Batch Transform</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTransformJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTransformJobRequest#builder()}
     * </p>
     *
     * @param createTransformJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateTransformJobRequest.Builder} to create a
     *        request.
     * @return Result of the CreateTransformJob operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateTransformJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTransformJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTransformJobResponse createTransformJob(Consumer<CreateTransformJobRequest.Builder> createTransformJobRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        return createTransformJob(CreateTransformJobRequest.builder().applyMutation(createTransformJobRequest).build());
    }

    /**
     * <p>
     * Creates a new work team for labeling your data. A work team is defined by one or more Amazon Cognito user pools.
     * You must first create the user pools before you can create a work team.
     * </p>
     * <p>
     * You cannot create more than 25 work teams in an account and region.
     * </p>
     *
     * @param createWorkteamRequest
     * @return Result of the CreateWorkteam operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateWorkteam
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateWorkteam" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateWorkteamResponse createWorkteam(CreateWorkteamRequest createWorkteamRequest) throws ResourceInUseException,
            ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new work team for labeling your data. A work team is defined by one or more Amazon Cognito user pools.
     * You must first create the user pools before you can create a work team.
     * </p>
     * <p>
     * You cannot create more than 25 work teams in an account and region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkteamRequest.Builder} avoiding the need to
     * create one manually via {@link CreateWorkteamRequest#builder()}
     * </p>
     *
     * @param createWorkteamRequest
     *        A {@link Consumer} that will call methods on {@link CreateWorkteamRequest.Builder} to create a request.
     * @return Result of the CreateWorkteam operation returned by the service.
     * @throws ResourceInUseException
     *         Resource being accessed is in use.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.CreateWorkteam
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateWorkteam" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateWorkteamResponse createWorkteam(Consumer<CreateWorkteamRequest.Builder> createWorkteamRequest)
            throws ResourceInUseException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            SageMakerException {
        return createWorkteam(CreateWorkteamRequest.builder().applyMutation(createWorkteamRequest).build());
    }

    /**
     * <p>
     * Removes the specified algorithm from your account.
     * </p>
     *
     * @param deleteAlgorithmRequest
     * @return Result of the DeleteAlgorithm operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteAlgorithm
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAlgorithm" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAlgorithmResponse deleteAlgorithm(DeleteAlgorithmRequest deleteAlgorithmRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified algorithm from your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAlgorithmRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAlgorithmRequest#builder()}
     * </p>
     *
     * @param deleteAlgorithmRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAlgorithmInput.Builder} to create a request.
     * @return Result of the DeleteAlgorithm operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteAlgorithm
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAlgorithm" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAlgorithmResponse deleteAlgorithm(Consumer<DeleteAlgorithmRequest.Builder> deleteAlgorithmRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return deleteAlgorithm(DeleteAlgorithmRequest.builder().applyMutation(deleteAlgorithmRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Git repository from your account.
     * </p>
     *
     * @param deleteCodeRepositoryRequest
     * @return Result of the DeleteCodeRepository operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteCodeRepository
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteCodeRepository" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteCodeRepositoryResponse deleteCodeRepository(DeleteCodeRepositoryRequest deleteCodeRepositoryRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Git repository from your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCodeRepositoryRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCodeRepositoryRequest#builder()}
     * </p>
     *
     * @param deleteCodeRepositoryRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCodeRepositoryInput.Builder} to create a
     *        request.
     * @return Result of the DeleteCodeRepository operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteCodeRepository
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteCodeRepository" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteCodeRepositoryResponse deleteCodeRepository(
            Consumer<DeleteCodeRepositoryRequest.Builder> deleteCodeRepositoryRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return deleteCodeRepository(DeleteCodeRepositoryRequest.builder().applyMutation(deleteCodeRepositoryRequest).build());
    }

    /**
     * <p>
     * Deletes an endpoint. Amazon SageMaker frees up all of the resources that were deployed when the endpoint was
     * created.
     * </p>
     * <p>
     * Amazon SageMaker retires any custom KMS key grants associated with the endpoint, meaning you don't need to use
     * the <a href="http://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html">RevokeGrant</a> API call.
     * </p>
     *
     * @param deleteEndpointRequest
     * @return Result of the DeleteEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteEndpointResponse deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an endpoint. Amazon SageMaker frees up all of the resources that were deployed when the endpoint was
     * created.
     * </p>
     * <p>
     * Amazon SageMaker retires any custom KMS key grants associated with the endpoint, meaning you don't need to use
     * the <a href="http://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html">RevokeGrant</a> API call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteEndpointRequest#builder()}
     * </p>
     *
     * @param deleteEndpointRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEndpointInput.Builder} to create a request.
     * @return Result of the DeleteEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteEndpointResponse deleteEndpoint(Consumer<DeleteEndpointRequest.Builder> deleteEndpointRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return deleteEndpoint(DeleteEndpointRequest.builder().applyMutation(deleteEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes an endpoint configuration. The <code>DeleteEndpointConfig</code> API deletes only the specified
     * configuration. It does not delete endpoints created using the configuration.
     * </p>
     *
     * @param deleteEndpointConfigRequest
     * @return Result of the DeleteEndpointConfig operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteEndpointConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpointConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEndpointConfigResponse deleteEndpointConfig(DeleteEndpointConfigRequest deleteEndpointConfigRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an endpoint configuration. The <code>DeleteEndpointConfig</code> API deletes only the specified
     * configuration. It does not delete endpoints created using the configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEndpointConfigRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEndpointConfigRequest#builder()}
     * </p>
     *
     * @param deleteEndpointConfigRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEndpointConfigInput.Builder} to create a
     *        request.
     * @return Result of the DeleteEndpointConfig operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteEndpointConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpointConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEndpointConfigResponse deleteEndpointConfig(
            Consumer<DeleteEndpointConfigRequest.Builder> deleteEndpointConfigRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return deleteEndpointConfig(DeleteEndpointConfigRequest.builder().applyMutation(deleteEndpointConfigRequest).build());
    }

    /**
     * <p>
     * Deletes a model. The <code>DeleteModel</code> API deletes only the model entry that was created in Amazon
     * SageMaker when you called the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateModel.html">CreateModel</a> API. It does not
     * delete model artifacts, inference code, or the IAM role that you specified when creating the model.
     * </p>
     *
     * @param deleteModelRequest
     * @return Result of the DeleteModel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteModelResponse deleteModel(DeleteModelRequest deleteModelRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a model. The <code>DeleteModel</code> API deletes only the model entry that was created in Amazon
     * SageMaker when you called the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateModel.html">CreateModel</a> API. It does not
     * delete model artifacts, inference code, or the IAM role that you specified when creating the model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteModelRequest#builder()}
     * </p>
     *
     * @param deleteModelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteModelInput.Builder} to create a request.
     * @return Result of the DeleteModel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteModelResponse deleteModel(Consumer<DeleteModelRequest.Builder> deleteModelRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return deleteModel(DeleteModelRequest.builder().applyMutation(deleteModelRequest).build());
    }

    /**
     * <p>
     * Deletes a model package.
     * </p>
     * <p>
     * A model package is used to create Amazon SageMaker models or list on AWS Marketplace. Buyers can subscribe to
     * model packages listed on AWS Marketplace to create models in Amazon SageMaker.
     * </p>
     *
     * @param deleteModelPackageRequest
     * @return Result of the DeleteModelPackage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModelPackage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteModelPackageResponse deleteModelPackage(DeleteModelPackageRequest deleteModelPackageRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a model package.
     * </p>
     * <p>
     * A model package is used to create Amazon SageMaker models or list on AWS Marketplace. Buyers can subscribe to
     * model packages listed on AWS Marketplace to create models in Amazon SageMaker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelPackageRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteModelPackageRequest#builder()}
     * </p>
     *
     * @param deleteModelPackageRequest
     *        A {@link Consumer} that will call methods on {@link DeleteModelPackageInput.Builder} to create a request.
     * @return Result of the DeleteModelPackage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteModelPackage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteModelPackageResponse deleteModelPackage(Consumer<DeleteModelPackageRequest.Builder> deleteModelPackageRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return deleteModelPackage(DeleteModelPackageRequest.builder().applyMutation(deleteModelPackageRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon SageMaker notebook instance. Before you can delete a notebook instance, you must call the
     * <code>StopNotebookInstance</code> API.
     * </p>
     * <important>
     * <p>
     * When you delete a notebook instance, you lose all of your data. Amazon SageMaker removes the ML compute instance,
     * and deletes the ML storage volume and the network interface associated with the notebook instance.
     * </p>
     * </important>
     *
     * @param deleteNotebookInstanceRequest
     * @return Result of the DeleteNotebookInstance operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteNotebookInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNotebookInstanceResponse deleteNotebookInstance(DeleteNotebookInstanceRequest deleteNotebookInstanceRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon SageMaker notebook instance. Before you can delete a notebook instance, you must call the
     * <code>StopNotebookInstance</code> API.
     * </p>
     * <important>
     * <p>
     * When you delete a notebook instance, you lose all of your data. Amazon SageMaker removes the ML compute instance,
     * and deletes the ML storage volume and the network interface associated with the notebook instance.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNotebookInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteNotebookInstanceRequest#builder()}
     * </p>
     *
     * @param deleteNotebookInstanceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNotebookInstanceInput.Builder} to create a
     *        request.
     * @return Result of the DeleteNotebookInstance operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteNotebookInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNotebookInstanceResponse deleteNotebookInstance(
            Consumer<DeleteNotebookInstanceRequest.Builder> deleteNotebookInstanceRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return deleteNotebookInstance(DeleteNotebookInstanceRequest.builder().applyMutation(deleteNotebookInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a notebook instance lifecycle configuration.
     * </p>
     *
     * @param deleteNotebookInstanceLifecycleConfigRequest
     * @return Result of the DeleteNotebookInstanceLifecycleConfig operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteNotebookInstanceLifecycleConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNotebookInstanceLifecycleConfigResponse deleteNotebookInstanceLifecycleConfig(
            DeleteNotebookInstanceLifecycleConfigRequest deleteNotebookInstanceLifecycleConfigRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a notebook instance lifecycle configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteNotebookInstanceLifecycleConfigRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteNotebookInstanceLifecycleConfigRequest#builder()}
     * </p>
     *
     * @param deleteNotebookInstanceLifecycleConfigRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNotebookInstanceLifecycleConfigInput.Builder} to
     *        create a request.
     * @return Result of the DeleteNotebookInstanceLifecycleConfig operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteNotebookInstanceLifecycleConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNotebookInstanceLifecycleConfigResponse deleteNotebookInstanceLifecycleConfig(
            Consumer<DeleteNotebookInstanceLifecycleConfigRequest.Builder> deleteNotebookInstanceLifecycleConfigRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return deleteNotebookInstanceLifecycleConfig(DeleteNotebookInstanceLifecycleConfigRequest.builder()
                .applyMutation(deleteNotebookInstanceLifecycleConfigRequest).build());
    }

    /**
     * <p>
     * Deletes the specified tags from an Amazon SageMaker resource.
     * </p>
     * <p>
     * To list a resource's tags, use the <code>ListTags</code> API.
     * </p>
     * <note>
     * <p>
     * When you call this API to delete tags from a hyperparameter tuning job, the deleted tags are not removed from
     * training jobs that the hyperparameter tuning job launched before you called this API.
     * </p>
     * </note>
     *
     * @param deleteTagsRequest
     * @return Result of the DeleteTags operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified tags from an Amazon SageMaker resource.
     * </p>
     * <p>
     * To list a resource's tags, use the <code>ListTags</code> API.
     * </p>
     * <note>
     * <p>
     * When you call this API to delete tags from a hyperparameter tuning job, the deleted tags are not removed from
     * training jobs that the hyperparameter tuning job launched before you called this API.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTagsRequest#builder()}
     * </p>
     *
     * @param deleteTagsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTagsInput.Builder} to create a request.
     * @return Result of the DeleteTags operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTagsResponse deleteTags(Consumer<DeleteTagsRequest.Builder> deleteTagsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return deleteTags(DeleteTagsRequest.builder().applyMutation(deleteTagsRequest).build());
    }

    /**
     * <p>
     * Deletes an existing work team. This operation can't be undone.
     * </p>
     *
     * @param deleteWorkteamRequest
     * @return Result of the DeleteWorkteam operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteWorkteam
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteWorkteam" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteWorkteamResponse deleteWorkteam(DeleteWorkteamRequest deleteWorkteamRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing work team. This operation can't be undone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkteamRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWorkteamRequest#builder()}
     * </p>
     *
     * @param deleteWorkteamRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWorkteamRequest.Builder} to create a request.
     * @return Result of the DeleteWorkteam operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DeleteWorkteam
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteWorkteam" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteWorkteamResponse deleteWorkteam(Consumer<DeleteWorkteamRequest.Builder> deleteWorkteamRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return deleteWorkteam(DeleteWorkteamRequest.builder().applyMutation(deleteWorkteamRequest).build());
    }

    /**
     * <p>
     * Returns a description of the specified algorithm that is in your account.
     * </p>
     *
     * @param describeAlgorithmRequest
     * @return Result of the DescribeAlgorithm operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeAlgorithm
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAlgorithm" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAlgorithmResponse describeAlgorithm(DescribeAlgorithmRequest describeAlgorithmRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of the specified algorithm that is in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAlgorithmRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeAlgorithmRequest#builder()}
     * </p>
     *
     * @param describeAlgorithmRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAlgorithmInput.Builder} to create a request.
     * @return Result of the DescribeAlgorithm operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeAlgorithm
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAlgorithm" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAlgorithmResponse describeAlgorithm(Consumer<DescribeAlgorithmRequest.Builder> describeAlgorithmRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return describeAlgorithm(DescribeAlgorithmRequest.builder().applyMutation(describeAlgorithmRequest).build());
    }

    /**
     * <p>
     * Gets details about the specified Git repository.
     * </p>
     *
     * @param describeCodeRepositoryRequest
     * @return Result of the DescribeCodeRepository operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeCodeRepository
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCodeRepository"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCodeRepositoryResponse describeCodeRepository(DescribeCodeRepositoryRequest describeCodeRepositoryRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about the specified Git repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCodeRepositoryRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCodeRepositoryRequest#builder()}
     * </p>
     *
     * @param describeCodeRepositoryRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCodeRepositoryInput.Builder} to create a
     *        request.
     * @return Result of the DescribeCodeRepository operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeCodeRepository
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCodeRepository"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCodeRepositoryResponse describeCodeRepository(
            Consumer<DescribeCodeRepositoryRequest.Builder> describeCodeRepositoryRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return describeCodeRepository(DescribeCodeRepositoryRequest.builder().applyMutation(describeCodeRepositoryRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about a model compilation job.
     * </p>
     * <p>
     * To create a model compilation job, use <a>CreateCompilationJob</a>. To get information about multiple model
     * compilation jobs, use <a>ListCompilationJobs</a>.
     * </p>
     *
     * @param describeCompilationJobRequest
     * @return Result of the DescribeCompilationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeCompilationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCompilationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCompilationJobResponse describeCompilationJob(DescribeCompilationJobRequest describeCompilationJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a model compilation job.
     * </p>
     * <p>
     * To create a model compilation job, use <a>CreateCompilationJob</a>. To get information about multiple model
     * compilation jobs, use <a>ListCompilationJobs</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCompilationJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCompilationJobRequest#builder()}
     * </p>
     *
     * @param describeCompilationJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCompilationJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeCompilationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeCompilationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCompilationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCompilationJobResponse describeCompilationJob(
            Consumer<DescribeCompilationJobRequest.Builder> describeCompilationJobRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return describeCompilationJob(DescribeCompilationJobRequest.builder().applyMutation(describeCompilationJobRequest)
                .build());
    }

    /**
     * <p>
     * Returns the description of an endpoint.
     * </p>
     *
     * @param describeEndpointRequest
     * @return Result of the DescribeEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointResponse describeEndpoint(DescribeEndpointRequest describeEndpointRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description of an endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeEndpointRequest#builder()}
     * </p>
     *
     * @param describeEndpointRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEndpointInput.Builder} to create a request.
     * @return Result of the DescribeEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointResponse describeEndpoint(Consumer<DescribeEndpointRequest.Builder> describeEndpointRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return describeEndpoint(DescribeEndpointRequest.builder().applyMutation(describeEndpointRequest).build());
    }

    /**
     * <p>
     * Returns the description of an endpoint configuration created using the <code>CreateEndpointConfig</code> API.
     * </p>
     *
     * @param describeEndpointConfigRequest
     * @return Result of the DescribeEndpointConfig operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeEndpointConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpointConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEndpointConfigResponse describeEndpointConfig(DescribeEndpointConfigRequest describeEndpointConfigRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description of an endpoint configuration created using the <code>CreateEndpointConfig</code> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointConfigRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEndpointConfigRequest#builder()}
     * </p>
     *
     * @param describeEndpointConfigRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEndpointConfigInput.Builder} to create a
     *        request.
     * @return Result of the DescribeEndpointConfig operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeEndpointConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpointConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEndpointConfigResponse describeEndpointConfig(
            Consumer<DescribeEndpointConfigRequest.Builder> describeEndpointConfigRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return describeEndpointConfig(DescribeEndpointConfigRequest.builder().applyMutation(describeEndpointConfigRequest)
                .build());
    }

    /**
     * <p>
     * Gets a description of a hyperparameter tuning job.
     * </p>
     *
     * @param describeHyperParameterTuningJobRequest
     * @return Result of the DescribeHyperParameterTuningJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeHyperParameterTuningJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHyperParameterTuningJobResponse describeHyperParameterTuningJob(
            DescribeHyperParameterTuningJobRequest describeHyperParameterTuningJobRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a description of a hyperparameter tuning job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHyperParameterTuningJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeHyperParameterTuningJobRequest#builder()}
     * </p>
     *
     * @param describeHyperParameterTuningJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeHyperParameterTuningJobRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeHyperParameterTuningJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeHyperParameterTuningJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHyperParameterTuningJobResponse describeHyperParameterTuningJob(
            Consumer<DescribeHyperParameterTuningJobRequest.Builder> describeHyperParameterTuningJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return describeHyperParameterTuningJob(DescribeHyperParameterTuningJobRequest.builder()
                .applyMutation(describeHyperParameterTuningJobRequest).build());
    }

    /**
     * <p>
     * Gets information about a labeling job.
     * </p>
     *
     * @param describeLabelingJobRequest
     * @return Result of the DescribeLabelingJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeLabelingJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeLabelingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeLabelingJobResponse describeLabelingJob(DescribeLabelingJobRequest describeLabelingJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a labeling job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLabelingJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLabelingJobRequest#builder()}
     * </p>
     *
     * @param describeLabelingJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeLabelingJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeLabelingJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeLabelingJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeLabelingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeLabelingJobResponse describeLabelingJob(
            Consumer<DescribeLabelingJobRequest.Builder> describeLabelingJobRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return describeLabelingJob(DescribeLabelingJobRequest.builder().applyMutation(describeLabelingJobRequest).build());
    }

    /**
     * <p>
     * Describes a model that you created using the <code>CreateModel</code> API.
     * </p>
     *
     * @param describeModelRequest
     * @return Result of the DescribeModel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModel" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeModelResponse describeModel(DescribeModelRequest describeModelRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a model that you created using the <code>CreateModel</code> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeModelRequest#builder()}
     * </p>
     *
     * @param describeModelRequest
     *        A {@link Consumer} that will call methods on {@link DescribeModelInput.Builder} to create a request.
     * @return Result of the DescribeModel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModel" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeModelResponse describeModel(Consumer<DescribeModelRequest.Builder> describeModelRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return describeModel(DescribeModelRequest.builder().applyMutation(describeModelRequest).build());
    }

    /**
     * <p>
     * Returns a description of the specified model package, which is used to create Amazon SageMaker models or list
     * them on AWS Marketplace.
     * </p>
     * <p>
     * To create models in Amazon SageMaker, buyers can subscribe to model packages listed on AWS Marketplace.
     * </p>
     *
     * @param describeModelPackageRequest
     * @return Result of the DescribeModelPackage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeModelPackage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeModelPackageResponse describeModelPackage(DescribeModelPackageRequest describeModelPackageRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of the specified model package, which is used to create Amazon SageMaker models or list
     * them on AWS Marketplace.
     * </p>
     * <p>
     * To create models in Amazon SageMaker, buyers can subscribe to model packages listed on AWS Marketplace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelPackageRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeModelPackageRequest#builder()}
     * </p>
     *
     * @param describeModelPackageRequest
     *        A {@link Consumer} that will call methods on {@link DescribeModelPackageInput.Builder} to create a
     *        request.
     * @return Result of the DescribeModelPackage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeModelPackage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeModelPackageResponse describeModelPackage(
            Consumer<DescribeModelPackageRequest.Builder> describeModelPackageRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return describeModelPackage(DescribeModelPackageRequest.builder().applyMutation(describeModelPackageRequest).build());
    }

    /**
     * <p>
     * Returns information about a notebook instance.
     * </p>
     *
     * @param describeNotebookInstanceRequest
     * @return Result of the DescribeNotebookInstance operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeNotebookInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotebookInstanceResponse describeNotebookInstance(
            DescribeNotebookInstanceRequest describeNotebookInstanceRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a notebook instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNotebookInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeNotebookInstanceRequest#builder()}
     * </p>
     *
     * @param describeNotebookInstanceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeNotebookInstanceInput.Builder} to create a
     *        request.
     * @return Result of the DescribeNotebookInstance operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeNotebookInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotebookInstanceResponse describeNotebookInstance(
            Consumer<DescribeNotebookInstanceRequest.Builder> describeNotebookInstanceRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return describeNotebookInstance(DescribeNotebookInstanceRequest.builder().applyMutation(describeNotebookInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Returns a description of a notebook instance lifecycle configuration.
     * </p>
     * <p>
     * For information about notebook instance lifestyle configurations, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
     * Customize a Notebook Instance</a>.
     * </p>
     *
     * @param describeNotebookInstanceLifecycleConfigRequest
     * @return Result of the DescribeNotebookInstanceLifecycleConfig operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeNotebookInstanceLifecycleConfig
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotebookInstanceLifecycleConfigResponse describeNotebookInstanceLifecycleConfig(
            DescribeNotebookInstanceLifecycleConfigRequest describeNotebookInstanceLifecycleConfigRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of a notebook instance lifecycle configuration.
     * </p>
     * <p>
     * For information about notebook instance lifestyle configurations, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
     * Customize a Notebook Instance</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeNotebookInstanceLifecycleConfigRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeNotebookInstanceLifecycleConfigRequest#builder()}
     * </p>
     *
     * @param describeNotebookInstanceLifecycleConfigRequest
     *        A {@link Consumer} that will call methods on {@link DescribeNotebookInstanceLifecycleConfigInput.Builder}
     *        to create a request.
     * @return Result of the DescribeNotebookInstanceLifecycleConfig operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeNotebookInstanceLifecycleConfig
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotebookInstanceLifecycleConfigResponse describeNotebookInstanceLifecycleConfig(
            Consumer<DescribeNotebookInstanceLifecycleConfigRequest.Builder> describeNotebookInstanceLifecycleConfigRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return describeNotebookInstanceLifecycleConfig(DescribeNotebookInstanceLifecycleConfigRequest.builder()
                .applyMutation(describeNotebookInstanceLifecycleConfigRequest).build());
    }

    /**
     * <p>
     * Gets information about a work team provided by a vendor. It returns details about the subscription with a vendor
     * in the AWS Marketplace.
     * </p>
     *
     * @param describeSubscribedWorkteamRequest
     * @return Result of the DescribeSubscribedWorkteam operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeSubscribedWorkteam
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeSubscribedWorkteam"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSubscribedWorkteamResponse describeSubscribedWorkteam(
            DescribeSubscribedWorkteamRequest describeSubscribedWorkteamRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a work team provided by a vendor. It returns details about the subscription with a vendor
     * in the AWS Marketplace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSubscribedWorkteamRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSubscribedWorkteamRequest#builder()}
     * </p>
     *
     * @param describeSubscribedWorkteamRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSubscribedWorkteamRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeSubscribedWorkteam operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeSubscribedWorkteam
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeSubscribedWorkteam"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSubscribedWorkteamResponse describeSubscribedWorkteam(
            Consumer<DescribeSubscribedWorkteamRequest.Builder> describeSubscribedWorkteamRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return describeSubscribedWorkteam(DescribeSubscribedWorkteamRequest.builder()
                .applyMutation(describeSubscribedWorkteamRequest).build());
    }

    /**
     * <p>
     * Returns information about a training job.
     * </p>
     *
     * @param describeTrainingJobRequest
     * @return Result of the DescribeTrainingJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeTrainingJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrainingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTrainingJobResponse describeTrainingJob(DescribeTrainingJobRequest describeTrainingJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a training job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrainingJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTrainingJobRequest#builder()}
     * </p>
     *
     * @param describeTrainingJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTrainingJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeTrainingJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeTrainingJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrainingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTrainingJobResponse describeTrainingJob(
            Consumer<DescribeTrainingJobRequest.Builder> describeTrainingJobRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return describeTrainingJob(DescribeTrainingJobRequest.builder().applyMutation(describeTrainingJobRequest).build());
    }

    /**
     * <p>
     * Returns information about a transform job.
     * </p>
     *
     * @param describeTransformJobRequest
     * @return Result of the DescribeTransformJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeTransformJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTransformJob" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTransformJobResponse describeTransformJob(DescribeTransformJobRequest describeTransformJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a transform job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTransformJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTransformJobRequest#builder()}
     * </p>
     *
     * @param describeTransformJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTransformJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeTransformJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeTransformJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTransformJob" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTransformJobResponse describeTransformJob(
            Consumer<DescribeTransformJobRequest.Builder> describeTransformJobRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        return describeTransformJob(DescribeTransformJobRequest.builder().applyMutation(describeTransformJobRequest).build());
    }

    /**
     * <p>
     * Gets information about a specific work team. You can see information such as the create date, the last updated
     * date, membership information, and the work team's Amazon Resource Name (ARN).
     * </p>
     *
     * @param describeWorkteamRequest
     * @return Result of the DescribeWorkteam operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeWorkteam
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeWorkteam" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeWorkteamResponse describeWorkteam(DescribeWorkteamRequest describeWorkteamRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specific work team. You can see information such as the create date, the last updated
     * date, membership information, and the work team's Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkteamRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeWorkteamRequest#builder()}
     * </p>
     *
     * @param describeWorkteamRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorkteamRequest.Builder} to create a request.
     * @return Result of the DescribeWorkteam operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.DescribeWorkteam
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeWorkteam" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeWorkteamResponse describeWorkteam(Consumer<DescribeWorkteamRequest.Builder> describeWorkteamRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return describeWorkteam(DescribeWorkteamRequest.builder().applyMutation(describeWorkteamRequest).build());
    }

    /**
     * <p>
     * An auto-complete API for the search functionality in the Amazon SageMaker console. It returns suggestions of
     * possible matches for the property name to use in <code>Search</code> queries. Provides suggestions for
     * <code>HyperParameters</code>, <code>Tags</code>, and <code>Metrics</code>.
     * </p>
     *
     * @param getSearchSuggestionsRequest
     * @return Result of the GetSearchSuggestions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.GetSearchSuggestions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetSearchSuggestions" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSearchSuggestionsResponse getSearchSuggestions(GetSearchSuggestionsRequest getSearchSuggestionsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * An auto-complete API for the search functionality in the Amazon SageMaker console. It returns suggestions of
     * possible matches for the property name to use in <code>Search</code> queries. Provides suggestions for
     * <code>HyperParameters</code>, <code>Tags</code>, and <code>Metrics</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSearchSuggestionsRequest.Builder} avoiding the
     * need to create one manually via {@link GetSearchSuggestionsRequest#builder()}
     * </p>
     *
     * @param getSearchSuggestionsRequest
     *        A {@link Consumer} that will call methods on {@link GetSearchSuggestionsRequest.Builder} to create a
     *        request.
     * @return Result of the GetSearchSuggestions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.GetSearchSuggestions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetSearchSuggestions" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSearchSuggestionsResponse getSearchSuggestions(
            Consumer<GetSearchSuggestionsRequest.Builder> getSearchSuggestionsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return getSearchSuggestions(GetSearchSuggestionsRequest.builder().applyMutation(getSearchSuggestionsRequest).build());
    }

    /**
     * <p>
     * Lists the machine learning algorithms that have been created.
     * </p>
     *
     * @return Result of the ListAlgorithms operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAlgorithms
     * @see #listAlgorithms(ListAlgorithmsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAlgorithms" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAlgorithmsResponse listAlgorithms() throws AwsServiceException, SdkClientException, SageMakerException {
        return listAlgorithms(ListAlgorithmsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the machine learning algorithms that have been created.
     * </p>
     *
     * @param listAlgorithmsRequest
     * @return Result of the ListAlgorithms operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAlgorithms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAlgorithms" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAlgorithmsResponse listAlgorithms(ListAlgorithmsRequest listAlgorithmsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the machine learning algorithms that have been created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAlgorithmsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAlgorithmsRequest#builder()}
     * </p>
     *
     * @param listAlgorithmsRequest
     *        A {@link Consumer} that will call methods on {@link ListAlgorithmsInput.Builder} to create a request.
     * @return Result of the ListAlgorithms operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListAlgorithms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAlgorithms" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAlgorithmsResponse listAlgorithms(Consumer<ListAlgorithmsRequest.Builder> listAlgorithmsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return listAlgorithms(ListAlgorithmsRequest.builder().applyMutation(listAlgorithmsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the Git repositories in your account.
     * </p>
     *
     * @return Result of the ListCodeRepositories operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListCodeRepositories
     * @see #listCodeRepositories(ListCodeRepositoriesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCodeRepositories" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCodeRepositoriesResponse listCodeRepositories() throws AwsServiceException, SdkClientException,
            SageMakerException {
        return listCodeRepositories(ListCodeRepositoriesRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the Git repositories in your account.
     * </p>
     *
     * @param listCodeRepositoriesRequest
     * @return Result of the ListCodeRepositories operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListCodeRepositories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCodeRepositories" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCodeRepositoriesResponse listCodeRepositories(ListCodeRepositoriesRequest listCodeRepositoriesRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the Git repositories in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCodeRepositoriesRequest.Builder} avoiding the
     * need to create one manually via {@link ListCodeRepositoriesRequest#builder()}
     * </p>
     *
     * @param listCodeRepositoriesRequest
     *        A {@link Consumer} that will call methods on {@link ListCodeRepositoriesInput.Builder} to create a
     *        request.
     * @return Result of the ListCodeRepositories operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListCodeRepositories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCodeRepositories" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCodeRepositoriesResponse listCodeRepositories(
            Consumer<ListCodeRepositoriesRequest.Builder> listCodeRepositoriesRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return listCodeRepositories(ListCodeRepositoriesRequest.builder().applyMutation(listCodeRepositoriesRequest).build());
    }

    /**
     * <p>
     * Lists model compilation jobs that satisfy various filters.
     * </p>
     * <p>
     * To create a model compilation job, use <a>CreateCompilationJob</a>. To get information about a particular model
     * compilation job you have created, use <a>DescribeCompilationJob</a>.
     * </p>
     *
     * @return Result of the ListCompilationJobs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListCompilationJobs
     * @see #listCompilationJobs(ListCompilationJobsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCompilationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCompilationJobsResponse listCompilationJobs() throws AwsServiceException, SdkClientException, SageMakerException {
        return listCompilationJobs(ListCompilationJobsRequest.builder().build());
    }

    /**
     * <p>
     * Lists model compilation jobs that satisfy various filters.
     * </p>
     * <p>
     * To create a model compilation job, use <a>CreateCompilationJob</a>. To get information about a particular model
     * compilation job you have created, use <a>DescribeCompilationJob</a>.
     * </p>
     *
     * @param listCompilationJobsRequest
     * @return Result of the ListCompilationJobs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListCompilationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCompilationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCompilationJobsResponse listCompilationJobs(ListCompilationJobsRequest listCompilationJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists model compilation jobs that satisfy various filters.
     * </p>
     * <p>
     * To create a model compilation job, use <a>CreateCompilationJob</a>. To get information about a particular model
     * compilation job you have created, use <a>DescribeCompilationJob</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCompilationJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCompilationJobsRequest#builder()}
     * </p>
     *
     * @param listCompilationJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListCompilationJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListCompilationJobs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListCompilationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCompilationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCompilationJobsResponse listCompilationJobs(
            Consumer<ListCompilationJobsRequest.Builder> listCompilationJobsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return listCompilationJobs(ListCompilationJobsRequest.builder().applyMutation(listCompilationJobsRequest).build());
    }

    /**
     * <p>
     * Lists model compilation jobs that satisfy various filters.
     * </p>
     * <p>
     * To create a model compilation job, use <a>CreateCompilationJob</a>. To get information about a particular model
     * compilation job you have created, use <a>DescribeCompilationJob</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCompilationJobs(software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListCompilationJobsIterable responses = client.listCompilationJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListCompilationJobsIterable responses = client
     *             .listCompilationJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListCompilationJobsIterable responses = client.listCompilationJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCompilationJobs(software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListCompilationJobs
     * @see #listCompilationJobsPaginator(ListCompilationJobsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCompilationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCompilationJobsIterable listCompilationJobsPaginator() throws AwsServiceException, SdkClientException,
            SageMakerException {
        return listCompilationJobsPaginator(ListCompilationJobsRequest.builder().build());
    }

    /**
     * <p>
     * Lists model compilation jobs that satisfy various filters.
     * </p>
     * <p>
     * To create a model compilation job, use <a>CreateCompilationJob</a>. To get information about a particular model
     * compilation job you have created, use <a>DescribeCompilationJob</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCompilationJobs(software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListCompilationJobsIterable responses = client.listCompilationJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListCompilationJobsIterable responses = client
     *             .listCompilationJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListCompilationJobsIterable responses = client.listCompilationJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCompilationJobs(software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCompilationJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListCompilationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCompilationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCompilationJobsIterable listCompilationJobsPaginator(ListCompilationJobsRequest listCompilationJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists model compilation jobs that satisfy various filters.
     * </p>
     * <p>
     * To create a model compilation job, use <a>CreateCompilationJob</a>. To get information about a particular model
     * compilation job you have created, use <a>DescribeCompilationJob</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCompilationJobs(software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListCompilationJobsIterable responses = client.listCompilationJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListCompilationJobsIterable responses = client
     *             .listCompilationJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListCompilationJobsIterable responses = client.listCompilationJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCompilationJobs(software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCompilationJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCompilationJobsRequest#builder()}
     * </p>
     *
     * @param listCompilationJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListCompilationJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListCompilationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCompilationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCompilationJobsIterable listCompilationJobsPaginator(
            Consumer<ListCompilationJobsRequest.Builder> listCompilationJobsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return listCompilationJobsPaginator(ListCompilationJobsRequest.builder().applyMutation(listCompilationJobsRequest)
                .build());
    }

    /**
     * <p>
     * Lists endpoint configurations.
     * </p>
     *
     * @return Result of the ListEndpointConfigs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListEndpointConfigs
     * @see #listEndpointConfigs(ListEndpointConfigsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpointConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEndpointConfigsResponse listEndpointConfigs() throws AwsServiceException, SdkClientException, SageMakerException {
        return listEndpointConfigs(ListEndpointConfigsRequest.builder().build());
    }

    /**
     * <p>
     * Lists endpoint configurations.
     * </p>
     *
     * @param listEndpointConfigsRequest
     * @return Result of the ListEndpointConfigs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListEndpointConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpointConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEndpointConfigsResponse listEndpointConfigs(ListEndpointConfigsRequest listEndpointConfigsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists endpoint configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEndpointConfigsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEndpointConfigsRequest#builder()}
     * </p>
     *
     * @param listEndpointConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListEndpointConfigsInput.Builder} to create a request.
     * @return Result of the ListEndpointConfigs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListEndpointConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpointConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEndpointConfigsResponse listEndpointConfigs(
            Consumer<ListEndpointConfigsRequest.Builder> listEndpointConfigsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return listEndpointConfigs(ListEndpointConfigsRequest.builder().applyMutation(listEndpointConfigsRequest).build());
    }

    /**
     * <p>
     * Lists endpoint configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEndpointConfigs(software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEndpointConfigsIterable responses = client.listEndpointConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListEndpointConfigsIterable responses = client
     *             .listEndpointConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEndpointConfigsIterable responses = client.listEndpointConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEndpointConfigs(software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListEndpointConfigs
     * @see #listEndpointConfigsPaginator(ListEndpointConfigsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpointConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEndpointConfigsIterable listEndpointConfigsPaginator() throws AwsServiceException, SdkClientException,
            SageMakerException {
        return listEndpointConfigsPaginator(ListEndpointConfigsRequest.builder().build());
    }

    /**
     * <p>
     * Lists endpoint configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEndpointConfigs(software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEndpointConfigsIterable responses = client.listEndpointConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListEndpointConfigsIterable responses = client
     *             .listEndpointConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEndpointConfigsIterable responses = client.listEndpointConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEndpointConfigs(software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEndpointConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListEndpointConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpointConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEndpointConfigsIterable listEndpointConfigsPaginator(ListEndpointConfigsRequest listEndpointConfigsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists endpoint configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEndpointConfigs(software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEndpointConfigsIterable responses = client.listEndpointConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListEndpointConfigsIterable responses = client
     *             .listEndpointConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEndpointConfigsIterable responses = client.listEndpointConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEndpointConfigs(software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEndpointConfigsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEndpointConfigsRequest#builder()}
     * </p>
     *
     * @param listEndpointConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListEndpointConfigsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListEndpointConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpointConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEndpointConfigsIterable listEndpointConfigsPaginator(
            Consumer<ListEndpointConfigsRequest.Builder> listEndpointConfigsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return listEndpointConfigsPaginator(ListEndpointConfigsRequest.builder().applyMutation(listEndpointConfigsRequest)
                .build());
    }

    /**
     * <p>
     * Lists endpoints.
     * </p>
     *
     * @return Result of the ListEndpoints operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListEndpoints
     * @see #listEndpoints(ListEndpointsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEndpointsResponse listEndpoints() throws AwsServiceException, SdkClientException, SageMakerException {
        return listEndpoints(ListEndpointsRequest.builder().build());
    }

    /**
     * <p>
     * Lists endpoints.
     * </p>
     *
     * @param listEndpointsRequest
     * @return Result of the ListEndpoints operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEndpointsResponse listEndpoints(ListEndpointsRequest listEndpointsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists endpoints.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEndpointsRequest.Builder} avoiding the need to
     * create one manually via {@link ListEndpointsRequest#builder()}
     * </p>
     *
     * @param listEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link ListEndpointsInput.Builder} to create a request.
     * @return Result of the ListEndpoints operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEndpointsResponse listEndpoints(Consumer<ListEndpointsRequest.Builder> listEndpointsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return listEndpoints(ListEndpointsRequest.builder().applyMutation(listEndpointsRequest).build());
    }

    /**
     * <p>
     * Lists endpoints.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listEndpoints(software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEndpointsIterable responses = client.listEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListEndpointsIterable responses = client.listEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEndpointsIterable responses = client.listEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEndpoints(software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListEndpoints
     * @see #listEndpointsPaginator(ListEndpointsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEndpointsIterable listEndpointsPaginator() throws AwsServiceException, SdkClientException, SageMakerException {
        return listEndpointsPaginator(ListEndpointsRequest.builder().build());
    }

    /**
     * <p>
     * Lists endpoints.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listEndpoints(software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEndpointsIterable responses = client.listEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListEndpointsIterable responses = client.listEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEndpointsIterable responses = client.listEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEndpoints(software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest)} operation.</b>
     * </p>
     *
     * @param listEndpointsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEndpointsIterable listEndpointsPaginator(ListEndpointsRequest listEndpointsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists endpoints.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listEndpoints(software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEndpointsIterable responses = client.listEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListEndpointsIterable responses = client.listEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListEndpointsIterable responses = client.listEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEndpoints(software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEndpointsRequest.Builder} avoiding the need to
     * create one manually via {@link ListEndpointsRequest#builder()}
     * </p>
     *
     * @param listEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link ListEndpointsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEndpointsIterable listEndpointsPaginator(Consumer<ListEndpointsRequest.Builder> listEndpointsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return listEndpointsPaginator(ListEndpointsRequest.builder().applyMutation(listEndpointsRequest).build());
    }

    /**
     * <p>
     * Gets a list of <a>HyperParameterTuningJobSummary</a> objects that describe the hyperparameter tuning jobs
     * launched in your account.
     * </p>
     *
     * @return Result of the ListHyperParameterTuningJobs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListHyperParameterTuningJobs
     * @see #listHyperParameterTuningJobs(ListHyperParameterTuningJobsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListHyperParameterTuningJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHyperParameterTuningJobsResponse listHyperParameterTuningJobs() throws AwsServiceException, SdkClientException,
            SageMakerException {
        return listHyperParameterTuningJobs(ListHyperParameterTuningJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of <a>HyperParameterTuningJobSummary</a> objects that describe the hyperparameter tuning jobs
     * launched in your account.
     * </p>
     *
     * @param listHyperParameterTuningJobsRequest
     * @return Result of the ListHyperParameterTuningJobs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListHyperParameterTuningJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListHyperParameterTuningJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHyperParameterTuningJobsResponse listHyperParameterTuningJobs(
            ListHyperParameterTuningJobsRequest listHyperParameterTuningJobsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of <a>HyperParameterTuningJobSummary</a> objects that describe the hyperparameter tuning jobs
     * launched in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHyperParameterTuningJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListHyperParameterTuningJobsRequest#builder()}
     * </p>
     *
     * @param listHyperParameterTuningJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListHyperParameterTuningJobsRequest.Builder} to create
     *        a request.
     * @return Result of the ListHyperParameterTuningJobs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListHyperParameterTuningJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListHyperParameterTuningJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHyperParameterTuningJobsResponse listHyperParameterTuningJobs(
            Consumer<ListHyperParameterTuningJobsRequest.Builder> listHyperParameterTuningJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return listHyperParameterTuningJobs(ListHyperParameterTuningJobsRequest.builder()
                .applyMutation(listHyperParameterTuningJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of <a>HyperParameterTuningJobSummary</a> objects that describe the hyperparameter tuning jobs
     * launched in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listHyperParameterTuningJobs(software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListHyperParameterTuningJobsIterable responses = client.listHyperParameterTuningJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListHyperParameterTuningJobsIterable responses = client
     *             .listHyperParameterTuningJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListHyperParameterTuningJobsIterable responses = client.listHyperParameterTuningJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHyperParameterTuningJobs(software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListHyperParameterTuningJobs
     * @see #listHyperParameterTuningJobsPaginator(ListHyperParameterTuningJobsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListHyperParameterTuningJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHyperParameterTuningJobsIterable listHyperParameterTuningJobsPaginator() throws AwsServiceException,
            SdkClientException, SageMakerException {
        return listHyperParameterTuningJobsPaginator(ListHyperParameterTuningJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of <a>HyperParameterTuningJobSummary</a> objects that describe the hyperparameter tuning jobs
     * launched in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listHyperParameterTuningJobs(software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListHyperParameterTuningJobsIterable responses = client.listHyperParameterTuningJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListHyperParameterTuningJobsIterable responses = client
     *             .listHyperParameterTuningJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListHyperParameterTuningJobsIterable responses = client.listHyperParameterTuningJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHyperParameterTuningJobs(software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listHyperParameterTuningJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListHyperParameterTuningJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListHyperParameterTuningJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHyperParameterTuningJobsIterable listHyperParameterTuningJobsPaginator(
            ListHyperParameterTuningJobsRequest listHyperParameterTuningJobsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of <a>HyperParameterTuningJobSummary</a> objects that describe the hyperparameter tuning jobs
     * launched in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listHyperParameterTuningJobs(software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListHyperParameterTuningJobsIterable responses = client.listHyperParameterTuningJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListHyperParameterTuningJobsIterable responses = client
     *             .listHyperParameterTuningJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListHyperParameterTuningJobsIterable responses = client.listHyperParameterTuningJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHyperParameterTuningJobs(software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHyperParameterTuningJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListHyperParameterTuningJobsRequest#builder()}
     * </p>
     *
     * @param listHyperParameterTuningJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListHyperParameterTuningJobsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListHyperParameterTuningJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListHyperParameterTuningJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHyperParameterTuningJobsIterable listHyperParameterTuningJobsPaginator(
            Consumer<ListHyperParameterTuningJobsRequest.Builder> listHyperParameterTuningJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return listHyperParameterTuningJobsPaginator(ListHyperParameterTuningJobsRequest.builder()
                .applyMutation(listHyperParameterTuningJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of labeling jobs.
     * </p>
     *
     * @return Result of the ListLabelingJobs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListLabelingJobs
     * @see #listLabelingJobs(ListLabelingJobsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLabelingJobsResponse listLabelingJobs() throws AwsServiceException, SdkClientException, SageMakerException {
        return listLabelingJobs(ListLabelingJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of labeling jobs.
     * </p>
     *
     * @param listLabelingJobsRequest
     * @return Result of the ListLabelingJobs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListLabelingJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLabelingJobsResponse listLabelingJobs(ListLabelingJobsRequest listLabelingJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of labeling jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLabelingJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLabelingJobsRequest#builder()}
     * </p>
     *
     * @param listLabelingJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListLabelingJobsRequest.Builder} to create a request.
     * @return Result of the ListLabelingJobs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListLabelingJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLabelingJobsResponse listLabelingJobs(Consumer<ListLabelingJobsRequest.Builder> listLabelingJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return listLabelingJobs(ListLabelingJobsRequest.builder().applyMutation(listLabelingJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of labeling jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLabelingJobs(software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsIterable responses = client.listLabelingJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsIterable responses = client
     *             .listLabelingJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsIterable responses = client.listLabelingJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLabelingJobs(software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListLabelingJobs
     * @see #listLabelingJobsPaginator(ListLabelingJobsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLabelingJobsIterable listLabelingJobsPaginator() throws AwsServiceException, SdkClientException,
            SageMakerException {
        return listLabelingJobsPaginator(ListLabelingJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of labeling jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLabelingJobs(software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsIterable responses = client.listLabelingJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsIterable responses = client
     *             .listLabelingJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsIterable responses = client.listLabelingJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLabelingJobs(software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsRequest)} operation.</b>
     * </p>
     *
     * @param listLabelingJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListLabelingJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLabelingJobsIterable listLabelingJobsPaginator(ListLabelingJobsRequest listLabelingJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of labeling jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLabelingJobs(software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsIterable responses = client.listLabelingJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsIterable responses = client
     *             .listLabelingJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsIterable responses = client.listLabelingJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLabelingJobs(software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLabelingJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLabelingJobsRequest#builder()}
     * </p>
     *
     * @param listLabelingJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListLabelingJobsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListLabelingJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLabelingJobsIterable listLabelingJobsPaginator(Consumer<ListLabelingJobsRequest.Builder> listLabelingJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return listLabelingJobsPaginator(ListLabelingJobsRequest.builder().applyMutation(listLabelingJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of labeling jobs assigned to a specified work team.
     * </p>
     *
     * @param listLabelingJobsForWorkteamRequest
     * @return Result of the ListLabelingJobsForWorkteam operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListLabelingJobsForWorkteam
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobsForWorkteam"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLabelingJobsForWorkteamResponse listLabelingJobsForWorkteam(
            ListLabelingJobsForWorkteamRequest listLabelingJobsForWorkteamRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of labeling jobs assigned to a specified work team.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLabelingJobsForWorkteamRequest.Builder}
     * avoiding the need to create one manually via {@link ListLabelingJobsForWorkteamRequest#builder()}
     * </p>
     *
     * @param listLabelingJobsForWorkteamRequest
     *        A {@link Consumer} that will call methods on {@link ListLabelingJobsForWorkteamRequest.Builder} to create
     *        a request.
     * @return Result of the ListLabelingJobsForWorkteam operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListLabelingJobsForWorkteam
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobsForWorkteam"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLabelingJobsForWorkteamResponse listLabelingJobsForWorkteam(
            Consumer<ListLabelingJobsForWorkteamRequest.Builder> listLabelingJobsForWorkteamRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return listLabelingJobsForWorkteam(ListLabelingJobsForWorkteamRequest.builder()
                .applyMutation(listLabelingJobsForWorkteamRequest).build());
    }

    /**
     * <p>
     * Gets a list of labeling jobs assigned to a specified work team.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLabelingJobsForWorkteam(software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsForWorkteamIterable responses = client.listLabelingJobsForWorkteamPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsForWorkteamIterable responses = client
     *             .listLabelingJobsForWorkteamPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsForWorkteamIterable responses = client.listLabelingJobsForWorkteamPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLabelingJobsForWorkteam(software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLabelingJobsForWorkteamRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListLabelingJobsForWorkteam
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobsForWorkteam"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLabelingJobsForWorkteamIterable listLabelingJobsForWorkteamPaginator(
            ListLabelingJobsForWorkteamRequest listLabelingJobsForWorkteamRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of labeling jobs assigned to a specified work team.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLabelingJobsForWorkteam(software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsForWorkteamIterable responses = client.listLabelingJobsForWorkteamPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsForWorkteamIterable responses = client
     *             .listLabelingJobsForWorkteamPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsForWorkteamIterable responses = client.listLabelingJobsForWorkteamPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLabelingJobsForWorkteam(software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLabelingJobsForWorkteamRequest.Builder}
     * avoiding the need to create one manually via {@link ListLabelingJobsForWorkteamRequest#builder()}
     * </p>
     *
     * @param listLabelingJobsForWorkteamRequest
     *        A {@link Consumer} that will call methods on {@link ListLabelingJobsForWorkteamRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListLabelingJobsForWorkteam
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobsForWorkteam"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLabelingJobsForWorkteamIterable listLabelingJobsForWorkteamPaginator(
            Consumer<ListLabelingJobsForWorkteamRequest.Builder> listLabelingJobsForWorkteamRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return listLabelingJobsForWorkteamPaginator(ListLabelingJobsForWorkteamRequest.builder()
                .applyMutation(listLabelingJobsForWorkteamRequest).build());
    }

    /**
     * <p>
     * Lists the model packages that have been created.
     * </p>
     *
     * @return Result of the ListModelPackages operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListModelPackages
     * @see #listModelPackages(ListModelPackagesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListModelPackagesResponse listModelPackages() throws AwsServiceException, SdkClientException, SageMakerException {
        return listModelPackages(ListModelPackagesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the model packages that have been created.
     * </p>
     *
     * @param listModelPackagesRequest
     * @return Result of the ListModelPackages operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListModelPackages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListModelPackagesResponse listModelPackages(ListModelPackagesRequest listModelPackagesRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the model packages that have been created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelPackagesRequest.Builder} avoiding the need
     * to create one manually via {@link ListModelPackagesRequest#builder()}
     * </p>
     *
     * @param listModelPackagesRequest
     *        A {@link Consumer} that will call methods on {@link ListModelPackagesInput.Builder} to create a request.
     * @return Result of the ListModelPackages operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListModelPackages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListModelPackagesResponse listModelPackages(Consumer<ListModelPackagesRequest.Builder> listModelPackagesRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return listModelPackages(ListModelPackagesRequest.builder().applyMutation(listModelPackagesRequest).build());
    }

    /**
     * <p>
     * Lists models created with the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateModel.html">CreateModel</a> API.
     * </p>
     *
     * @return Result of the ListModels operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListModels
     * @see #listModels(ListModelsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListModelsResponse listModels() throws AwsServiceException, SdkClientException, SageMakerException {
        return listModels(ListModelsRequest.builder().build());
    }

    /**
     * <p>
     * Lists models created with the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateModel.html">CreateModel</a> API.
     * </p>
     *
     * @param listModelsRequest
     * @return Result of the ListModels operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListModels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListModelsResponse listModels(ListModelsRequest listModelsRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists models created with the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateModel.html">CreateModel</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListModelsRequest#builder()}
     * </p>
     *
     * @param listModelsRequest
     *        A {@link Consumer} that will call methods on {@link ListModelsInput.Builder} to create a request.
     * @return Result of the ListModels operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListModels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListModelsResponse listModels(Consumer<ListModelsRequest.Builder> listModelsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return listModels(ListModelsRequest.builder().applyMutation(listModelsRequest).build());
    }

    /**
     * <p>
     * Lists models created with the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateModel.html">CreateModel</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listModels(software.amazon.awssdk.services.sagemaker.model.ListModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelsIterable responses = client.listModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListModelsIterable responses = client.listModelsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelsIterable responses = client.listModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModels(software.amazon.awssdk.services.sagemaker.model.ListModelsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListModels
     * @see #listModelsPaginator(ListModelsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListModelsIterable listModelsPaginator() throws AwsServiceException, SdkClientException, SageMakerException {
        return listModelsPaginator(ListModelsRequest.builder().build());
    }

    /**
     * <p>
     * Lists models created with the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateModel.html">CreateModel</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listModels(software.amazon.awssdk.services.sagemaker.model.ListModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelsIterable responses = client.listModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListModelsIterable responses = client.listModelsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelsIterable responses = client.listModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModels(software.amazon.awssdk.services.sagemaker.model.ListModelsRequest)} operation.</b>
     * </p>
     *
     * @param listModelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListModels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListModelsIterable listModelsPaginator(ListModelsRequest listModelsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists models created with the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateModel.html">CreateModel</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listModels(software.amazon.awssdk.services.sagemaker.model.ListModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelsIterable responses = client.listModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListModelsIterable responses = client.listModelsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListModelsIterable responses = client.listModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listModels(software.amazon.awssdk.services.sagemaker.model.ListModelsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListModelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListModelsRequest#builder()}
     * </p>
     *
     * @param listModelsRequest
     *        A {@link Consumer} that will call methods on {@link ListModelsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListModels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListModelsIterable listModelsPaginator(Consumer<ListModelsRequest.Builder> listModelsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return listModelsPaginator(ListModelsRequest.builder().applyMutation(listModelsRequest).build());
    }

    /**
     * <p>
     * Lists notebook instance lifestyle configurations created with the <a>CreateNotebookInstanceLifecycleConfig</a>
     * API.
     * </p>
     *
     * @return Result of the ListNotebookInstanceLifecycleConfigs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListNotebookInstanceLifecycleConfigs
     * @see #listNotebookInstanceLifecycleConfigs(ListNotebookInstanceLifecycleConfigsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstanceLifecycleConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotebookInstanceLifecycleConfigsResponse listNotebookInstanceLifecycleConfigs() throws AwsServiceException,
            SdkClientException, SageMakerException {
        return listNotebookInstanceLifecycleConfigs(ListNotebookInstanceLifecycleConfigsRequest.builder().build());
    }

    /**
     * <p>
     * Lists notebook instance lifestyle configurations created with the <a>CreateNotebookInstanceLifecycleConfig</a>
     * API.
     * </p>
     *
     * @param listNotebookInstanceLifecycleConfigsRequest
     * @return Result of the ListNotebookInstanceLifecycleConfigs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListNotebookInstanceLifecycleConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstanceLifecycleConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotebookInstanceLifecycleConfigsResponse listNotebookInstanceLifecycleConfigs(
            ListNotebookInstanceLifecycleConfigsRequest listNotebookInstanceLifecycleConfigsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists notebook instance lifestyle configurations created with the <a>CreateNotebookInstanceLifecycleConfig</a>
     * API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListNotebookInstanceLifecycleConfigsRequest.Builder} avoiding the need to create one manually via
     * {@link ListNotebookInstanceLifecycleConfigsRequest#builder()}
     * </p>
     *
     * @param listNotebookInstanceLifecycleConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListNotebookInstanceLifecycleConfigsInput.Builder} to
     *        create a request.
     * @return Result of the ListNotebookInstanceLifecycleConfigs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListNotebookInstanceLifecycleConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstanceLifecycleConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotebookInstanceLifecycleConfigsResponse listNotebookInstanceLifecycleConfigs(
            Consumer<ListNotebookInstanceLifecycleConfigsRequest.Builder> listNotebookInstanceLifecycleConfigsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return listNotebookInstanceLifecycleConfigs(ListNotebookInstanceLifecycleConfigsRequest.builder()
                .applyMutation(listNotebookInstanceLifecycleConfigsRequest).build());
    }

    /**
     * <p>
     * Lists notebook instance lifestyle configurations created with the <a>CreateNotebookInstanceLifecycleConfig</a>
     * API.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNotebookInstanceLifecycleConfigs(software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstanceLifecycleConfigsIterable responses = client.listNotebookInstanceLifecycleConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstanceLifecycleConfigsIterable responses = client
     *             .listNotebookInstanceLifecycleConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstanceLifecycleConfigsIterable responses = client.listNotebookInstanceLifecycleConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotebookInstanceLifecycleConfigs(software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListNotebookInstanceLifecycleConfigs
     * @see #listNotebookInstanceLifecycleConfigsPaginator(ListNotebookInstanceLifecycleConfigsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstanceLifecycleConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotebookInstanceLifecycleConfigsIterable listNotebookInstanceLifecycleConfigsPaginator()
            throws AwsServiceException, SdkClientException, SageMakerException {
        return listNotebookInstanceLifecycleConfigsPaginator(ListNotebookInstanceLifecycleConfigsRequest.builder().build());
    }

    /**
     * <p>
     * Lists notebook instance lifestyle configurations created with the <a>CreateNotebookInstanceLifecycleConfig</a>
     * API.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNotebookInstanceLifecycleConfigs(software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstanceLifecycleConfigsIterable responses = client.listNotebookInstanceLifecycleConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstanceLifecycleConfigsIterable responses = client
     *             .listNotebookInstanceLifecycleConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstanceLifecycleConfigsIterable responses = client.listNotebookInstanceLifecycleConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotebookInstanceLifecycleConfigs(software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNotebookInstanceLifecycleConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListNotebookInstanceLifecycleConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstanceLifecycleConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotebookInstanceLifecycleConfigsIterable listNotebookInstanceLifecycleConfigsPaginator(
            ListNotebookInstanceLifecycleConfigsRequest listNotebookInstanceLifecycleConfigsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists notebook instance lifestyle configurations created with the <a>CreateNotebookInstanceLifecycleConfig</a>
     * API.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNotebookInstanceLifecycleConfigs(software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstanceLifecycleConfigsIterable responses = client.listNotebookInstanceLifecycleConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstanceLifecycleConfigsIterable responses = client
     *             .listNotebookInstanceLifecycleConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstanceLifecycleConfigsIterable responses = client.listNotebookInstanceLifecycleConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotebookInstanceLifecycleConfigs(software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListNotebookInstanceLifecycleConfigsRequest.Builder} avoiding the need to create one manually via
     * {@link ListNotebookInstanceLifecycleConfigsRequest#builder()}
     * </p>
     *
     * @param listNotebookInstanceLifecycleConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListNotebookInstanceLifecycleConfigsInput.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListNotebookInstanceLifecycleConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstanceLifecycleConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotebookInstanceLifecycleConfigsIterable listNotebookInstanceLifecycleConfigsPaginator(
            Consumer<ListNotebookInstanceLifecycleConfigsRequest.Builder> listNotebookInstanceLifecycleConfigsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return listNotebookInstanceLifecycleConfigsPaginator(ListNotebookInstanceLifecycleConfigsRequest.builder()
                .applyMutation(listNotebookInstanceLifecycleConfigsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the Amazon SageMaker notebook instances in the requester's account in an AWS Region.
     * </p>
     *
     * @return Result of the ListNotebookInstances operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListNotebookInstances
     * @see #listNotebookInstances(ListNotebookInstancesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotebookInstancesResponse listNotebookInstances() throws AwsServiceException, SdkClientException,
            SageMakerException {
        return listNotebookInstances(ListNotebookInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of the Amazon SageMaker notebook instances in the requester's account in an AWS Region.
     * </p>
     *
     * @param listNotebookInstancesRequest
     * @return Result of the ListNotebookInstances operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListNotebookInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotebookInstancesResponse listNotebookInstances(ListNotebookInstancesRequest listNotebookInstancesRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the Amazon SageMaker notebook instances in the requester's account in an AWS Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotebookInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListNotebookInstancesRequest#builder()}
     * </p>
     *
     * @param listNotebookInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListNotebookInstancesInput.Builder} to create a
     *        request.
     * @return Result of the ListNotebookInstances operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListNotebookInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotebookInstancesResponse listNotebookInstances(
            Consumer<ListNotebookInstancesRequest.Builder> listNotebookInstancesRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return listNotebookInstances(ListNotebookInstancesRequest.builder().applyMutation(listNotebookInstancesRequest).build());
    }

    /**
     * <p>
     * Returns a list of the Amazon SageMaker notebook instances in the requester's account in an AWS Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNotebookInstances(software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstancesIterable responses = client.listNotebookInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstancesIterable responses = client
     *             .listNotebookInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstancesIterable responses = client.listNotebookInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotebookInstances(software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListNotebookInstances
     * @see #listNotebookInstancesPaginator(ListNotebookInstancesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotebookInstancesIterable listNotebookInstancesPaginator() throws AwsServiceException, SdkClientException,
            SageMakerException {
        return listNotebookInstancesPaginator(ListNotebookInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of the Amazon SageMaker notebook instances in the requester's account in an AWS Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNotebookInstances(software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstancesIterable responses = client.listNotebookInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstancesIterable responses = client
     *             .listNotebookInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstancesIterable responses = client.listNotebookInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotebookInstances(software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNotebookInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListNotebookInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotebookInstancesIterable listNotebookInstancesPaginator(ListNotebookInstancesRequest listNotebookInstancesRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the Amazon SageMaker notebook instances in the requester's account in an AWS Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNotebookInstances(software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstancesIterable responses = client.listNotebookInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstancesIterable responses = client
     *             .listNotebookInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstancesIterable responses = client.listNotebookInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotebookInstances(software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotebookInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListNotebookInstancesRequest#builder()}
     * </p>
     *
     * @param listNotebookInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListNotebookInstancesInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListNotebookInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotebookInstancesIterable listNotebookInstancesPaginator(
            Consumer<ListNotebookInstancesRequest.Builder> listNotebookInstancesRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return listNotebookInstancesPaginator(ListNotebookInstancesRequest.builder().applyMutation(listNotebookInstancesRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of the work teams that you are subscribed to in the AWS Marketplace. The list may be empty if no work
     * team satisfies the filter specified in the <code>NameContains</code> parameter.
     * </p>
     *
     * @return Result of the ListSubscribedWorkteams operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListSubscribedWorkteams
     * @see #listSubscribedWorkteams(ListSubscribedWorkteamsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListSubscribedWorkteams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscribedWorkteamsResponse listSubscribedWorkteams() throws AwsServiceException, SdkClientException,
            SageMakerException {
        return listSubscribedWorkteams(ListSubscribedWorkteamsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the work teams that you are subscribed to in the AWS Marketplace. The list may be empty if no work
     * team satisfies the filter specified in the <code>NameContains</code> parameter.
     * </p>
     *
     * @param listSubscribedWorkteamsRequest
     * @return Result of the ListSubscribedWorkteams operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListSubscribedWorkteams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListSubscribedWorkteams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscribedWorkteamsResponse listSubscribedWorkteams(ListSubscribedWorkteamsRequest listSubscribedWorkteamsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the work teams that you are subscribed to in the AWS Marketplace. The list may be empty if no work
     * team satisfies the filter specified in the <code>NameContains</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscribedWorkteamsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSubscribedWorkteamsRequest#builder()}
     * </p>
     *
     * @param listSubscribedWorkteamsRequest
     *        A {@link Consumer} that will call methods on {@link ListSubscribedWorkteamsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSubscribedWorkteams operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListSubscribedWorkteams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListSubscribedWorkteams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscribedWorkteamsResponse listSubscribedWorkteams(
            Consumer<ListSubscribedWorkteamsRequest.Builder> listSubscribedWorkteamsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return listSubscribedWorkteams(ListSubscribedWorkteamsRequest.builder().applyMutation(listSubscribedWorkteamsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of the work teams that you are subscribed to in the AWS Marketplace. The list may be empty if no work
     * team satisfies the filter specified in the <code>NameContains</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSubscribedWorkteams(software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListSubscribedWorkteamsIterable responses = client.listSubscribedWorkteamsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListSubscribedWorkteamsIterable responses = client
     *             .listSubscribedWorkteamsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListSubscribedWorkteamsIterable responses = client.listSubscribedWorkteamsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscribedWorkteams(software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListSubscribedWorkteams
     * @see #listSubscribedWorkteamsPaginator(ListSubscribedWorkteamsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListSubscribedWorkteams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscribedWorkteamsIterable listSubscribedWorkteamsPaginator() throws AwsServiceException, SdkClientException,
            SageMakerException {
        return listSubscribedWorkteamsPaginator(ListSubscribedWorkteamsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of the work teams that you are subscribed to in the AWS Marketplace. The list may be empty if no work
     * team satisfies the filter specified in the <code>NameContains</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSubscribedWorkteams(software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListSubscribedWorkteamsIterable responses = client.listSubscribedWorkteamsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListSubscribedWorkteamsIterable responses = client
     *             .listSubscribedWorkteamsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListSubscribedWorkteamsIterable responses = client.listSubscribedWorkteamsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscribedWorkteams(software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSubscribedWorkteamsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListSubscribedWorkteams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListSubscribedWorkteams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscribedWorkteamsIterable listSubscribedWorkteamsPaginator(
            ListSubscribedWorkteamsRequest listSubscribedWorkteamsRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the work teams that you are subscribed to in the AWS Marketplace. The list may be empty if no work
     * team satisfies the filter specified in the <code>NameContains</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSubscribedWorkteams(software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListSubscribedWorkteamsIterable responses = client.listSubscribedWorkteamsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListSubscribedWorkteamsIterable responses = client
     *             .listSubscribedWorkteamsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListSubscribedWorkteamsIterable responses = client.listSubscribedWorkteamsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscribedWorkteams(software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscribedWorkteamsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSubscribedWorkteamsRequest#builder()}
     * </p>
     *
     * @param listSubscribedWorkteamsRequest
     *        A {@link Consumer} that will call methods on {@link ListSubscribedWorkteamsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListSubscribedWorkteams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListSubscribedWorkteams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSubscribedWorkteamsIterable listSubscribedWorkteamsPaginator(
            Consumer<ListSubscribedWorkteamsRequest.Builder> listSubscribedWorkteamsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return listSubscribedWorkteamsPaginator(ListSubscribedWorkteamsRequest.builder()
                .applyMutation(listSubscribedWorkteamsRequest).build());
    }

    /**
     * <p>
     * Returns the tags for the specified Amazon SageMaker resource.
     * </p>
     *
     * @param listTagsRequest
     * @return Result of the ListTags operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the tags for the specified Amazon SageMaker resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsInput.Builder} to create a request.
     * @return Result of the ListTags operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsResponse listTags(Consumer<ListTagsRequest.Builder> listTagsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return listTags(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Returns the tags for the specified Amazon SageMaker resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTags(software.amazon.awssdk.services.sagemaker.model.ListTagsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTags(software.amazon.awssdk.services.sagemaker.model.ListTagsRequest)} operation.</b>
     * </p>
     *
     * @param listTagsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsIterable listTagsPaginator(ListTagsRequest listTagsRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the tags for the specified Amazon SageMaker resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTags(software.amazon.awssdk.services.sagemaker.model.ListTagsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTags(software.amazon.awssdk.services.sagemaker.model.ListTagsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsIterable listTagsPaginator(Consumer<ListTagsRequest.Builder> listTagsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return listTagsPaginator(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Lists training jobs.
     * </p>
     *
     * @return Result of the ListTrainingJobs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTrainingJobs
     * @see #listTrainingJobs(ListTrainingJobsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrainingJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTrainingJobsResponse listTrainingJobs() throws AwsServiceException, SdkClientException, SageMakerException {
        return listTrainingJobs(ListTrainingJobsRequest.builder().build());
    }

    /**
     * <p>
     * Lists training jobs.
     * </p>
     *
     * @param listTrainingJobsRequest
     * @return Result of the ListTrainingJobs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTrainingJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrainingJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTrainingJobsResponse listTrainingJobs(ListTrainingJobsRequest listTrainingJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists training jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrainingJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTrainingJobsRequest#builder()}
     * </p>
     *
     * @param listTrainingJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListTrainingJobsRequest.Builder} to create a request.
     * @return Result of the ListTrainingJobs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTrainingJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrainingJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTrainingJobsResponse listTrainingJobs(Consumer<ListTrainingJobsRequest.Builder> listTrainingJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return listTrainingJobs(ListTrainingJobsRequest.builder().applyMutation(listTrainingJobsRequest).build());
    }

    /**
     * <p>
     * Lists training jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTrainingJobs(software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsIterable responses = client.listTrainingJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsIterable responses = client
     *             .listTrainingJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsIterable responses = client.listTrainingJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrainingJobs(software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTrainingJobs
     * @see #listTrainingJobsPaginator(ListTrainingJobsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrainingJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTrainingJobsIterable listTrainingJobsPaginator() throws AwsServiceException, SdkClientException,
            SageMakerException {
        return listTrainingJobsPaginator(ListTrainingJobsRequest.builder().build());
    }

    /**
     * <p>
     * Lists training jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTrainingJobs(software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsIterable responses = client.listTrainingJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsIterable responses = client
     *             .listTrainingJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsIterable responses = client.listTrainingJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrainingJobs(software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsRequest)} operation.</b>
     * </p>
     *
     * @param listTrainingJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTrainingJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrainingJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTrainingJobsIterable listTrainingJobsPaginator(ListTrainingJobsRequest listTrainingJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists training jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTrainingJobs(software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsIterable responses = client.listTrainingJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsIterable responses = client
     *             .listTrainingJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsIterable responses = client.listTrainingJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrainingJobs(software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrainingJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTrainingJobsRequest#builder()}
     * </p>
     *
     * @param listTrainingJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListTrainingJobsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTrainingJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrainingJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTrainingJobsIterable listTrainingJobsPaginator(Consumer<ListTrainingJobsRequest.Builder> listTrainingJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return listTrainingJobsPaginator(ListTrainingJobsRequest.builder().applyMutation(listTrainingJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of <a>TrainingJobSummary</a> objects that describe the training jobs that a hyperparameter tuning job
     * launched.
     * </p>
     *
     * @param listTrainingJobsForHyperParameterTuningJobRequest
     * @return Result of the ListTrainingJobsForHyperParameterTuningJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTrainingJobsForHyperParameterTuningJob
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrainingJobsForHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainingJobsForHyperParameterTuningJobResponse listTrainingJobsForHyperParameterTuningJob(
            ListTrainingJobsForHyperParameterTuningJobRequest listTrainingJobsForHyperParameterTuningJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of <a>TrainingJobSummary</a> objects that describe the training jobs that a hyperparameter tuning job
     * launched.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListTrainingJobsForHyperParameterTuningJobRequest.Builder} avoiding the need to create one manually via
     * {@link ListTrainingJobsForHyperParameterTuningJobRequest#builder()}
     * </p>
     *
     * @param listTrainingJobsForHyperParameterTuningJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListTrainingJobsForHyperParameterTuningJobRequest.Builder} to create a request.
     * @return Result of the ListTrainingJobsForHyperParameterTuningJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTrainingJobsForHyperParameterTuningJob
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrainingJobsForHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainingJobsForHyperParameterTuningJobResponse listTrainingJobsForHyperParameterTuningJob(
            Consumer<ListTrainingJobsForHyperParameterTuningJobRequest.Builder> listTrainingJobsForHyperParameterTuningJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return listTrainingJobsForHyperParameterTuningJob(ListTrainingJobsForHyperParameterTuningJobRequest.builder()
                .applyMutation(listTrainingJobsForHyperParameterTuningJobRequest).build());
    }

    /**
     * <p>
     * Gets a list of <a>TrainingJobSummary</a> objects that describe the training jobs that a hyperparameter tuning job
     * launched.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTrainingJobsForHyperParameterTuningJob(software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsForHyperParameterTuningJobIterable responses = client.listTrainingJobsForHyperParameterTuningJobPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsForHyperParameterTuningJobIterable responses = client
     *             .listTrainingJobsForHyperParameterTuningJobPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsForHyperParameterTuningJobIterable responses = client.listTrainingJobsForHyperParameterTuningJobPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrainingJobsForHyperParameterTuningJob(software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTrainingJobsForHyperParameterTuningJobRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTrainingJobsForHyperParameterTuningJob
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrainingJobsForHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainingJobsForHyperParameterTuningJobIterable listTrainingJobsForHyperParameterTuningJobPaginator(
            ListTrainingJobsForHyperParameterTuningJobRequest listTrainingJobsForHyperParameterTuningJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of <a>TrainingJobSummary</a> objects that describe the training jobs that a hyperparameter tuning job
     * launched.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTrainingJobsForHyperParameterTuningJob(software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsForHyperParameterTuningJobIterable responses = client.listTrainingJobsForHyperParameterTuningJobPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsForHyperParameterTuningJobIterable responses = client
     *             .listTrainingJobsForHyperParameterTuningJobPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsForHyperParameterTuningJobIterable responses = client.listTrainingJobsForHyperParameterTuningJobPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrainingJobsForHyperParameterTuningJob(software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListTrainingJobsForHyperParameterTuningJobRequest.Builder} avoiding the need to create one manually via
     * {@link ListTrainingJobsForHyperParameterTuningJobRequest#builder()}
     * </p>
     *
     * @param listTrainingJobsForHyperParameterTuningJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListTrainingJobsForHyperParameterTuningJobRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTrainingJobsForHyperParameterTuningJob
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrainingJobsForHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainingJobsForHyperParameterTuningJobIterable listTrainingJobsForHyperParameterTuningJobPaginator(
            Consumer<ListTrainingJobsForHyperParameterTuningJobRequest.Builder> listTrainingJobsForHyperParameterTuningJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return listTrainingJobsForHyperParameterTuningJobPaginator(ListTrainingJobsForHyperParameterTuningJobRequest.builder()
                .applyMutation(listTrainingJobsForHyperParameterTuningJobRequest).build());
    }

    /**
     * <p>
     * Lists transform jobs.
     * </p>
     *
     * @return Result of the ListTransformJobs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTransformJobs
     * @see #listTransformJobs(ListTransformJobsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTransformJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTransformJobsResponse listTransformJobs() throws AwsServiceException, SdkClientException, SageMakerException {
        return listTransformJobs(ListTransformJobsRequest.builder().build());
    }

    /**
     * <p>
     * Lists transform jobs.
     * </p>
     *
     * @param listTransformJobsRequest
     * @return Result of the ListTransformJobs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTransformJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTransformJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTransformJobsResponse listTransformJobs(ListTransformJobsRequest listTransformJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists transform jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTransformJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTransformJobsRequest#builder()}
     * </p>
     *
     * @param listTransformJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListTransformJobsRequest.Builder} to create a request.
     * @return Result of the ListTransformJobs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTransformJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTransformJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTransformJobsResponse listTransformJobs(Consumer<ListTransformJobsRequest.Builder> listTransformJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return listTransformJobs(ListTransformJobsRequest.builder().applyMutation(listTransformJobsRequest).build());
    }

    /**
     * <p>
     * Lists transform jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTransformJobs(software.amazon.awssdk.services.sagemaker.model.ListTransformJobsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTransformJobsIterable responses = client.listTransformJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListTransformJobsIterable responses = client
     *             .listTransformJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListTransformJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTransformJobsIterable responses = client.listTransformJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTransformJobs(software.amazon.awssdk.services.sagemaker.model.ListTransformJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTransformJobs
     * @see #listTransformJobsPaginator(ListTransformJobsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTransformJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTransformJobsIterable listTransformJobsPaginator() throws AwsServiceException, SdkClientException,
            SageMakerException {
        return listTransformJobsPaginator(ListTransformJobsRequest.builder().build());
    }

    /**
     * <p>
     * Lists transform jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTransformJobs(software.amazon.awssdk.services.sagemaker.model.ListTransformJobsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTransformJobsIterable responses = client.listTransformJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListTransformJobsIterable responses = client
     *             .listTransformJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListTransformJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTransformJobsIterable responses = client.listTransformJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTransformJobs(software.amazon.awssdk.services.sagemaker.model.ListTransformJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTransformJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTransformJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTransformJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTransformJobsIterable listTransformJobsPaginator(ListTransformJobsRequest listTransformJobsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists transform jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTransformJobs(software.amazon.awssdk.services.sagemaker.model.ListTransformJobsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTransformJobsIterable responses = client.listTransformJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListTransformJobsIterable responses = client
     *             .listTransformJobsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListTransformJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListTransformJobsIterable responses = client.listTransformJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTransformJobs(software.amazon.awssdk.services.sagemaker.model.ListTransformJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTransformJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTransformJobsRequest#builder()}
     * </p>
     *
     * @param listTransformJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListTransformJobsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListTransformJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTransformJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTransformJobsIterable listTransformJobsPaginator(
            Consumer<ListTransformJobsRequest.Builder> listTransformJobsRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        return listTransformJobsPaginator(ListTransformJobsRequest.builder().applyMutation(listTransformJobsRequest).build());
    }

    /**
     * <p>
     * Gets a list of work teams that you have defined in a region. The list may be empty if no work team satisfies the
     * filter specified in the <code>NameContains</code> parameter.
     * </p>
     *
     * @return Result of the ListWorkteams operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListWorkteams
     * @see #listWorkteams(ListWorkteamsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListWorkteams" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkteamsResponse listWorkteams() throws AwsServiceException, SdkClientException, SageMakerException {
        return listWorkteams(ListWorkteamsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of work teams that you have defined in a region. The list may be empty if no work team satisfies the
     * filter specified in the <code>NameContains</code> parameter.
     * </p>
     *
     * @param listWorkteamsRequest
     * @return Result of the ListWorkteams operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListWorkteams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListWorkteams" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkteamsResponse listWorkteams(ListWorkteamsRequest listWorkteamsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of work teams that you have defined in a region. The list may be empty if no work team satisfies the
     * filter specified in the <code>NameContains</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkteamsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkteamsRequest#builder()}
     * </p>
     *
     * @param listWorkteamsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkteamsRequest.Builder} to create a request.
     * @return Result of the ListWorkteams operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListWorkteams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListWorkteams" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkteamsResponse listWorkteams(Consumer<ListWorkteamsRequest.Builder> listWorkteamsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return listWorkteams(ListWorkteamsRequest.builder().applyMutation(listWorkteamsRequest).build());
    }

    /**
     * <p>
     * Gets a list of work teams that you have defined in a region. The list may be empty if no work team satisfies the
     * filter specified in the <code>NameContains</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listWorkteams(software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListWorkteamsIterable responses = client.listWorkteamsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListWorkteamsIterable responses = client.listWorkteamsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListWorkteamsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListWorkteamsIterable responses = client.listWorkteamsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkteams(software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListWorkteams
     * @see #listWorkteamsPaginator(ListWorkteamsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListWorkteams" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkteamsIterable listWorkteamsPaginator() throws AwsServiceException, SdkClientException, SageMakerException {
        return listWorkteamsPaginator(ListWorkteamsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of work teams that you have defined in a region. The list may be empty if no work team satisfies the
     * filter specified in the <code>NameContains</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listWorkteams(software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListWorkteamsIterable responses = client.listWorkteamsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListWorkteamsIterable responses = client.listWorkteamsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListWorkteamsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListWorkteamsIterable responses = client.listWorkteamsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkteams(software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest)} operation.</b>
     * </p>
     *
     * @param listWorkteamsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListWorkteams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListWorkteams" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkteamsIterable listWorkteamsPaginator(ListWorkteamsRequest listWorkteamsRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of work teams that you have defined in a region. The list may be empty if no work team satisfies the
     * filter specified in the <code>NameContains</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listWorkteams(software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListWorkteamsIterable responses = client.listWorkteamsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.ListWorkteamsIterable responses = client.listWorkteamsPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.ListWorkteamsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.ListWorkteamsIterable responses = client.listWorkteamsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkteams(software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkteamsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkteamsRequest#builder()}
     * </p>
     *
     * @param listWorkteamsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkteamsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.ListWorkteams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListWorkteams" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkteamsIterable listWorkteamsPaginator(Consumer<ListWorkteamsRequest.Builder> listWorkteamsRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return listWorkteamsPaginator(ListWorkteamsRequest.builder().applyMutation(listWorkteamsRequest).build());
    }

    /**
     * <p>
     * Renders the UI template so that you can preview the worker's experience.
     * </p>
     *
     * @param renderUiTemplateRequest
     * @return Result of the RenderUiTemplate operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.RenderUiTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/RenderUiTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default RenderUiTemplateResponse renderUiTemplate(RenderUiTemplateRequest renderUiTemplateRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Renders the UI template so that you can preview the worker's experience.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RenderUiTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link RenderUiTemplateRequest#builder()}
     * </p>
     *
     * @param renderUiTemplateRequest
     *        A {@link Consumer} that will call methods on {@link RenderUiTemplateRequest.Builder} to create a request.
     * @return Result of the RenderUiTemplate operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.RenderUiTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/RenderUiTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default RenderUiTemplateResponse renderUiTemplate(Consumer<RenderUiTemplateRequest.Builder> renderUiTemplateRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        return renderUiTemplate(RenderUiTemplateRequest.builder().applyMutation(renderUiTemplateRequest).build());
    }

    /**
     * <p>
     * Finds Amazon SageMaker resources that match a search query. Matching resource objects are returned as a list of
     * <code>SearchResult</code> objects in the response. You can sort the search results by any resource property in a
     * ascending or descending order.
     * </p>
     * <p>
     * You can query against the following value types: numerical, text, Booleans, and timestamps.
     * </p>
     *
     * @param searchRequest
     * @return Result of the Search operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.Search
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/Search" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchResponse search(SearchRequest searchRequest) throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Finds Amazon SageMaker resources that match a search query. Matching resource objects are returned as a list of
     * <code>SearchResult</code> objects in the response. You can sort the search results by any resource property in a
     * ascending or descending order.
     * </p>
     * <p>
     * You can query against the following value types: numerical, text, Booleans, and timestamps.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchRequest.Builder} avoiding the need to create
     * one manually via {@link SearchRequest#builder()}
     * </p>
     *
     * @param searchRequest
     *        A {@link Consumer} that will call methods on {@link SearchRequest.Builder} to create a request.
     * @return Result of the Search operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.Search
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/Search" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchResponse search(Consumer<SearchRequest.Builder> searchRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        return search(SearchRequest.builder().applyMutation(searchRequest).build());
    }

    /**
     * <p>
     * Finds Amazon SageMaker resources that match a search query. Matching resource objects are returned as a list of
     * <code>SearchResult</code> objects in the response. You can sort the search results by any resource property in a
     * ascending or descending order.
     * </p>
     * <p>
     * You can query against the following value types: numerical, text, Booleans, and timestamps.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #search(software.amazon.awssdk.services.sagemaker.model.SearchRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.SearchIterable responses = client.searchPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.SearchIterable responses = client.searchPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.SearchResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.SearchIterable responses = client.searchPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #search(software.amazon.awssdk.services.sagemaker.model.SearchRequest)} operation.</b>
     * </p>
     *
     * @param searchRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.Search
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/Search" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchIterable searchPaginator(SearchRequest searchRequest) throws AwsServiceException, SdkClientException,
            SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Finds Amazon SageMaker resources that match a search query. Matching resource objects are returned as a list of
     * <code>SearchResult</code> objects in the response. You can sort the search results by any resource property in a
     * ascending or descending order.
     * </p>
     * <p>
     * You can query against the following value types: numerical, text, Booleans, and timestamps.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #search(software.amazon.awssdk.services.sagemaker.model.SearchRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.SearchIterable responses = client.searchPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.sagemaker.paginators.SearchIterable responses = client.searchPaginator(request);
     *     for (software.amazon.awssdk.services.sagemaker.model.SearchResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.SearchIterable responses = client.searchPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #search(software.amazon.awssdk.services.sagemaker.model.SearchRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchRequest.Builder} avoiding the need to create
     * one manually via {@link SearchRequest#builder()}
     * </p>
     *
     * @param searchRequest
     *        A {@link Consumer} that will call methods on {@link SearchRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.Search
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/Search" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchIterable searchPaginator(Consumer<SearchRequest.Builder> searchRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return searchPaginator(SearchRequest.builder().applyMutation(searchRequest).build());
    }

    /**
     * <p>
     * Launches an ML compute instance with the latest version of the libraries and attaches your ML storage volume.
     * After configuring the notebook instance, Amazon SageMaker sets the notebook instance status to
     * <code>InService</code>. A notebook instance's status must be <code>InService</code> before you can connect to
     * your Jupyter notebook.
     * </p>
     *
     * @param startNotebookInstanceRequest
     * @return Result of the StartNotebookInstance operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.StartNotebookInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StartNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default StartNotebookInstanceResponse startNotebookInstance(StartNotebookInstanceRequest startNotebookInstanceRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Launches an ML compute instance with the latest version of the libraries and attaches your ML storage volume.
     * After configuring the notebook instance, Amazon SageMaker sets the notebook instance status to
     * <code>InService</code>. A notebook instance's status must be <code>InService</code> before you can connect to
     * your Jupyter notebook.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartNotebookInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link StartNotebookInstanceRequest#builder()}
     * </p>
     *
     * @param startNotebookInstanceRequest
     *        A {@link Consumer} that will call methods on {@link StartNotebookInstanceInput.Builder} to create a
     *        request.
     * @return Result of the StartNotebookInstance operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.StartNotebookInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StartNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default StartNotebookInstanceResponse startNotebookInstance(
            Consumer<StartNotebookInstanceRequest.Builder> startNotebookInstanceRequest) throws ResourceLimitExceededException,
            AwsServiceException, SdkClientException, SageMakerException {
        return startNotebookInstance(StartNotebookInstanceRequest.builder().applyMutation(startNotebookInstanceRequest).build());
    }

    /**
     * <p>
     * Stops a model compilation job.
     * </p>
     * <p>
     * To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal. This gracefully shuts the job down. If
     * the job hasn't stopped, it sends the SIGKILL signal.
     * </p>
     * <p>
     * When it receives a <code>StopCompilationJob</code> request, Amazon SageMaker changes the
     * <a>CompilationJobSummary&#36CompilationJobStatus</a> of the job to <code>Stopping</code>. After Amazon SageMaker
     * stops the job, it sets the <a>CompilationJobSummary&#36CompilationJobStatus</a> to <code>Stopped</code>.
     * </p>
     *
     * @param stopCompilationJobRequest
     * @return Result of the StopCompilationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.StopCompilationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopCompilationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default StopCompilationJobResponse stopCompilationJob(StopCompilationJobRequest stopCompilationJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a model compilation job.
     * </p>
     * <p>
     * To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal. This gracefully shuts the job down. If
     * the job hasn't stopped, it sends the SIGKILL signal.
     * </p>
     * <p>
     * When it receives a <code>StopCompilationJob</code> request, Amazon SageMaker changes the
     * <a>CompilationJobSummary&#36CompilationJobStatus</a> of the job to <code>Stopping</code>. After Amazon SageMaker
     * stops the job, it sets the <a>CompilationJobSummary&#36CompilationJobStatus</a> to <code>Stopped</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopCompilationJobRequest.Builder} avoiding the
     * need to create one manually via {@link StopCompilationJobRequest#builder()}
     * </p>
     *
     * @param stopCompilationJobRequest
     *        A {@link Consumer} that will call methods on {@link StopCompilationJobRequest.Builder} to create a
     *        request.
     * @return Result of the StopCompilationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.StopCompilationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopCompilationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default StopCompilationJobResponse stopCompilationJob(Consumer<StopCompilationJobRequest.Builder> stopCompilationJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return stopCompilationJob(StopCompilationJobRequest.builder().applyMutation(stopCompilationJobRequest).build());
    }

    /**
     * <p>
     * Stops a running hyperparameter tuning job and all running training jobs that the tuning job launched.
     * </p>
     * <p>
     * All model artifacts output from the training jobs are stored in Amazon Simple Storage Service (Amazon S3). All
     * data that the training jobs write to Amazon CloudWatch Logs are still available in CloudWatch. After the tuning
     * job moves to the <code>Stopped</code> state, it releases all reserved resources for the tuning job.
     * </p>
     *
     * @param stopHyperParameterTuningJobRequest
     * @return Result of the StopHyperParameterTuningJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.StopHyperParameterTuningJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopHyperParameterTuningJobResponse stopHyperParameterTuningJob(
            StopHyperParameterTuningJobRequest stopHyperParameterTuningJobRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a running hyperparameter tuning job and all running training jobs that the tuning job launched.
     * </p>
     * <p>
     * All model artifacts output from the training jobs are stored in Amazon Simple Storage Service (Amazon S3). All
     * data that the training jobs write to Amazon CloudWatch Logs are still available in CloudWatch. After the tuning
     * job moves to the <code>Stopped</code> state, it releases all reserved resources for the tuning job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopHyperParameterTuningJobRequest.Builder}
     * avoiding the need to create one manually via {@link StopHyperParameterTuningJobRequest#builder()}
     * </p>
     *
     * @param stopHyperParameterTuningJobRequest
     *        A {@link Consumer} that will call methods on {@link StopHyperParameterTuningJobRequest.Builder} to create
     *        a request.
     * @return Result of the StopHyperParameterTuningJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.StopHyperParameterTuningJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopHyperParameterTuningJobResponse stopHyperParameterTuningJob(
            Consumer<StopHyperParameterTuningJobRequest.Builder> stopHyperParameterTuningJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return stopHyperParameterTuningJob(StopHyperParameterTuningJobRequest.builder()
                .applyMutation(stopHyperParameterTuningJobRequest).build());
    }

    /**
     * <p>
     * Stops a running labeling job. A job that is stopped cannot be restarted. Any results obtained before the job is
     * stopped are placed in the Amazon S3 output bucket.
     * </p>
     *
     * @param stopLabelingJobRequest
     * @return Result of the StopLabelingJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.StopLabelingJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopLabelingJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StopLabelingJobResponse stopLabelingJob(StopLabelingJobRequest stopLabelingJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a running labeling job. A job that is stopped cannot be restarted. Any results obtained before the job is
     * stopped are placed in the Amazon S3 output bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopLabelingJobRequest.Builder} avoiding the need
     * to create one manually via {@link StopLabelingJobRequest#builder()}
     * </p>
     *
     * @param stopLabelingJobRequest
     *        A {@link Consumer} that will call methods on {@link StopLabelingJobRequest.Builder} to create a request.
     * @return Result of the StopLabelingJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.StopLabelingJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopLabelingJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StopLabelingJobResponse stopLabelingJob(Consumer<StopLabelingJobRequest.Builder> stopLabelingJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return stopLabelingJob(StopLabelingJobRequest.builder().applyMutation(stopLabelingJobRequest).build());
    }

    /**
     * <p>
     * Terminates the ML compute instance. Before terminating the instance, Amazon SageMaker disconnects the ML storage
     * volume from it. Amazon SageMaker preserves the ML storage volume. Amazon SageMaker stops charging you for the ML
     * compute instance when you call <code>StopNotebookInstance</code>.
     * </p>
     * <p>
     * To access data on the ML storage volume for a notebook instance that has been terminated, call the
     * <code>StartNotebookInstance</code> API. <code>StartNotebookInstance</code> launches another ML compute instance,
     * configures it, and attaches the preserved ML storage volume so you can continue your work.
     * </p>
     *
     * @param stopNotebookInstanceRequest
     * @return Result of the StopNotebookInstance operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.StopNotebookInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopNotebookInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default StopNotebookInstanceResponse stopNotebookInstance(StopNotebookInstanceRequest stopNotebookInstanceRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Terminates the ML compute instance. Before terminating the instance, Amazon SageMaker disconnects the ML storage
     * volume from it. Amazon SageMaker preserves the ML storage volume. Amazon SageMaker stops charging you for the ML
     * compute instance when you call <code>StopNotebookInstance</code>.
     * </p>
     * <p>
     * To access data on the ML storage volume for a notebook instance that has been terminated, call the
     * <code>StartNotebookInstance</code> API. <code>StartNotebookInstance</code> launches another ML compute instance,
     * configures it, and attaches the preserved ML storage volume so you can continue your work.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopNotebookInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link StopNotebookInstanceRequest#builder()}
     * </p>
     *
     * @param stopNotebookInstanceRequest
     *        A {@link Consumer} that will call methods on {@link StopNotebookInstanceInput.Builder} to create a
     *        request.
     * @return Result of the StopNotebookInstance operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.StopNotebookInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopNotebookInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default StopNotebookInstanceResponse stopNotebookInstance(
            Consumer<StopNotebookInstanceRequest.Builder> stopNotebookInstanceRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return stopNotebookInstance(StopNotebookInstanceRequest.builder().applyMutation(stopNotebookInstanceRequest).build());
    }

    /**
     * <p>
     * Stops a training job. To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which
     * delays job termination for 120 seconds. Algorithms might use this 120-second window to save the model artifacts,
     * so the results of the training is not lost.
     * </p>
     * <p>
     * When it receives a <code>StopTrainingJob</code> request, Amazon SageMaker changes the status of the job to
     * <code>Stopping</code>. After Amazon SageMaker stops the job, it sets the status to <code>Stopped</code>.
     * </p>
     *
     * @param stopTrainingJobRequest
     * @return Result of the StopTrainingJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.StopTrainingJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopTrainingJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StopTrainingJobResponse stopTrainingJob(StopTrainingJobRequest stopTrainingJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a training job. To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which
     * delays job termination for 120 seconds. Algorithms might use this 120-second window to save the model artifacts,
     * so the results of the training is not lost.
     * </p>
     * <p>
     * When it receives a <code>StopTrainingJob</code> request, Amazon SageMaker changes the status of the job to
     * <code>Stopping</code>. After Amazon SageMaker stops the job, it sets the status to <code>Stopped</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopTrainingJobRequest.Builder} avoiding the need
     * to create one manually via {@link StopTrainingJobRequest#builder()}
     * </p>
     *
     * @param stopTrainingJobRequest
     *        A {@link Consumer} that will call methods on {@link StopTrainingJobRequest.Builder} to create a request.
     * @return Result of the StopTrainingJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.StopTrainingJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopTrainingJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StopTrainingJobResponse stopTrainingJob(Consumer<StopTrainingJobRequest.Builder> stopTrainingJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return stopTrainingJob(StopTrainingJobRequest.builder().applyMutation(stopTrainingJobRequest).build());
    }

    /**
     * <p>
     * Stops a transform job.
     * </p>
     * <p>
     * When Amazon SageMaker receives a <code>StopTransformJob</code> request, the status of the job changes to
     * <code>Stopping</code>. After Amazon SageMaker stops the job, the status is set to <code>Stopped</code>. When you
     * stop a transform job before it is completed, Amazon SageMaker doesn't store the job's output in Amazon S3.
     * </p>
     *
     * @param stopTransformJobRequest
     * @return Result of the StopTransformJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.StopTransformJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopTransformJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StopTransformJobResponse stopTransformJob(StopTransformJobRequest stopTransformJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a transform job.
     * </p>
     * <p>
     * When Amazon SageMaker receives a <code>StopTransformJob</code> request, the status of the job changes to
     * <code>Stopping</code>. After Amazon SageMaker stops the job, the status is set to <code>Stopped</code>. When you
     * stop a transform job before it is completed, Amazon SageMaker doesn't store the job's output in Amazon S3.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopTransformJobRequest.Builder} avoiding the need
     * to create one manually via {@link StopTransformJobRequest#builder()}
     * </p>
     *
     * @param stopTransformJobRequest
     *        A {@link Consumer} that will call methods on {@link StopTransformJobRequest.Builder} to create a request.
     * @return Result of the StopTransformJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource being access is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.StopTransformJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopTransformJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StopTransformJobResponse stopTransformJob(Consumer<StopTransformJobRequest.Builder> stopTransformJobRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, SageMakerException {
        return stopTransformJob(StopTransformJobRequest.builder().applyMutation(stopTransformJobRequest).build());
    }

    /**
     * <p>
     * Updates the specified Git repository with the specified values.
     * </p>
     *
     * @param updateCodeRepositoryRequest
     * @return Result of the UpdateCodeRepository operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.UpdateCodeRepository
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateCodeRepository" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateCodeRepositoryResponse updateCodeRepository(UpdateCodeRepositoryRequest updateCodeRepositoryRequest)
            throws AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified Git repository with the specified values.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCodeRepositoryRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateCodeRepositoryRequest#builder()}
     * </p>
     *
     * @param updateCodeRepositoryRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCodeRepositoryInput.Builder} to create a
     *        request.
     * @return Result of the UpdateCodeRepository operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.UpdateCodeRepository
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateCodeRepository" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateCodeRepositoryResponse updateCodeRepository(
            Consumer<UpdateCodeRepositoryRequest.Builder> updateCodeRepositoryRequest) throws AwsServiceException,
            SdkClientException, SageMakerException {
        return updateCodeRepository(UpdateCodeRepositoryRequest.builder().applyMutation(updateCodeRepositoryRequest).build());
    }

    /**
     * <p>
     * Deploys the new <code>EndpointConfig</code> specified in the request, switches to using newly created endpoint,
     * and then deletes resources provisioned for the endpoint using the previous <code>EndpointConfig</code> (there is
     * no availability loss).
     * </p>
     * <p>
     * When Amazon SageMaker receives the request, it sets the endpoint status to <code>Updating</code>. After updating
     * the endpoint, it sets the status to <code>InService</code>. To check the status of an endpoint, use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeEndpoint.html">DescribeEndpoint</a> API.
     * </p>
     * <note>
     * <p>
     * You must not delete an <code>EndpointConfig</code> in use by an endpoint that is live or while the
     * <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. To
     * update an endpoint, you must create a new <code>EndpointConfig</code>.
     * </p>
     * </note>
     *
     * @param updateEndpointRequest
     * @return Result of the UpdateEndpoint operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.UpdateEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateEndpointResponse updateEndpoint(UpdateEndpointRequest updateEndpointRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deploys the new <code>EndpointConfig</code> specified in the request, switches to using newly created endpoint,
     * and then deletes resources provisioned for the endpoint using the previous <code>EndpointConfig</code> (there is
     * no availability loss).
     * </p>
     * <p>
     * When Amazon SageMaker receives the request, it sets the endpoint status to <code>Updating</code>. After updating
     * the endpoint, it sets the status to <code>InService</code>. To check the status of an endpoint, use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeEndpoint.html">DescribeEndpoint</a> API.
     * </p>
     * <note>
     * <p>
     * You must not delete an <code>EndpointConfig</code> in use by an endpoint that is live or while the
     * <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. To
     * update an endpoint, you must create a new <code>EndpointConfig</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateEndpointRequest#builder()}
     * </p>
     *
     * @param updateEndpointRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEndpointInput.Builder} to create a request.
     * @return Result of the UpdateEndpoint operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.UpdateEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateEndpointResponse updateEndpoint(Consumer<UpdateEndpointRequest.Builder> updateEndpointRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return updateEndpoint(UpdateEndpointRequest.builder().applyMutation(updateEndpointRequest).build());
    }

    /**
     * <p>
     * Updates variant weight of one or more variants associated with an existing endpoint, or capacity of one variant
     * associated with an existing endpoint. When it receives the request, Amazon SageMaker sets the endpoint status to
     * <code>Updating</code>. After updating the endpoint, it sets the status to <code>InService</code>. To check the
     * status of an endpoint, use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeEndpoint.html">DescribeEndpoint</a> API.
     * </p>
     *
     * @param updateEndpointWeightsAndCapacitiesRequest
     * @return Result of the UpdateEndpointWeightsAndCapacities operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.UpdateEndpointWeightsAndCapacities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateEndpointWeightsAndCapacities"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEndpointWeightsAndCapacitiesResponse updateEndpointWeightsAndCapacities(
            UpdateEndpointWeightsAndCapacitiesRequest updateEndpointWeightsAndCapacitiesRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates variant weight of one or more variants associated with an existing endpoint, or capacity of one variant
     * associated with an existing endpoint. When it receives the request, Amazon SageMaker sets the endpoint status to
     * <code>Updating</code>. After updating the endpoint, it sets the status to <code>InService</code>. To check the
     * status of an endpoint, use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeEndpoint.html">DescribeEndpoint</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEndpointWeightsAndCapacitiesRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateEndpointWeightsAndCapacitiesRequest#builder()}
     * </p>
     *
     * @param updateEndpointWeightsAndCapacitiesRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEndpointWeightsAndCapacitiesInput.Builder} to
     *        create a request.
     * @return Result of the UpdateEndpointWeightsAndCapacities operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.UpdateEndpointWeightsAndCapacities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateEndpointWeightsAndCapacities"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEndpointWeightsAndCapacitiesResponse updateEndpointWeightsAndCapacities(
            Consumer<UpdateEndpointWeightsAndCapacitiesRequest.Builder> updateEndpointWeightsAndCapacitiesRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return updateEndpointWeightsAndCapacities(UpdateEndpointWeightsAndCapacitiesRequest.builder()
                .applyMutation(updateEndpointWeightsAndCapacitiesRequest).build());
    }

    /**
     * <p>
     * Updates a notebook instance. NotebookInstance updates include upgrading or downgrading the ML compute instance
     * used for your notebook instance to accommodate changes in your workload requirements.
     * </p>
     *
     * @param updateNotebookInstanceRequest
     * @return Result of the UpdateNotebookInstance operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.UpdateNotebookInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateNotebookInstanceResponse updateNotebookInstance(UpdateNotebookInstanceRequest updateNotebookInstanceRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a notebook instance. NotebookInstance updates include upgrading or downgrading the ML compute instance
     * used for your notebook instance to accommodate changes in your workload requirements.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNotebookInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateNotebookInstanceRequest#builder()}
     * </p>
     *
     * @param updateNotebookInstanceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateNotebookInstanceInput.Builder} to create a
     *        request.
     * @return Result of the UpdateNotebookInstance operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.UpdateNotebookInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateNotebookInstanceResponse updateNotebookInstance(
            Consumer<UpdateNotebookInstanceRequest.Builder> updateNotebookInstanceRequest) throws ResourceLimitExceededException,
            AwsServiceException, SdkClientException, SageMakerException {
        return updateNotebookInstance(UpdateNotebookInstanceRequest.builder().applyMutation(updateNotebookInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Updates a notebook instance lifecycle configuration created with the <a>CreateNotebookInstanceLifecycleConfig</a>
     * API.
     * </p>
     *
     * @param updateNotebookInstanceLifecycleConfigRequest
     * @return Result of the UpdateNotebookInstanceLifecycleConfig operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.UpdateNotebookInstanceLifecycleConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateNotebookInstanceLifecycleConfigResponse updateNotebookInstanceLifecycleConfig(
            UpdateNotebookInstanceLifecycleConfigRequest updateNotebookInstanceLifecycleConfigRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a notebook instance lifecycle configuration created with the <a>CreateNotebookInstanceLifecycleConfig</a>
     * API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateNotebookInstanceLifecycleConfigRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateNotebookInstanceLifecycleConfigRequest#builder()}
     * </p>
     *
     * @param updateNotebookInstanceLifecycleConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateNotebookInstanceLifecycleConfigInput.Builder} to
     *        create a request.
     * @return Result of the UpdateNotebookInstanceLifecycleConfig operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.UpdateNotebookInstanceLifecycleConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateNotebookInstanceLifecycleConfigResponse updateNotebookInstanceLifecycleConfig(
            Consumer<UpdateNotebookInstanceLifecycleConfigRequest.Builder> updateNotebookInstanceLifecycleConfigRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return updateNotebookInstanceLifecycleConfig(UpdateNotebookInstanceLifecycleConfigRequest.builder()
                .applyMutation(updateNotebookInstanceLifecycleConfigRequest).build());
    }

    /**
     * <p>
     * Updates an existing work team with new member definitions or description.
     * </p>
     *
     * @param updateWorkteamRequest
     * @return Result of the UpdateWorkteam operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.UpdateWorkteam
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateWorkteam" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateWorkteamResponse updateWorkteam(UpdateWorkteamRequest updateWorkteamRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing work team with new member definitions or description.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkteamRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateWorkteamRequest#builder()}
     * </p>
     *
     * @param updateWorkteamRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWorkteamRequest.Builder} to create a request.
     * @return Result of the UpdateWorkteam operation returned by the service.
     * @throws ResourceLimitExceededException
     *         You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs
     *         created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SageMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SageMakerClient.UpdateWorkteam
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateWorkteam" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateWorkteamResponse updateWorkteam(Consumer<UpdateWorkteamRequest.Builder> updateWorkteamRequest)
            throws ResourceLimitExceededException, AwsServiceException, SdkClientException, SageMakerException {
        return updateWorkteam(UpdateWorkteamRequest.builder().applyMutation(updateWorkteamRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("api.sagemaker");
    }
}
