/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the output location for managed spot training checkpoint data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckpointConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CheckpointConfig.Builder, CheckpointConfig> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CheckpointConfig::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()).build();

    private static final SdkField<String> LOCAL_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CheckpointConfig::localPath)).setter(setter(Builder::localPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(S3_URI_FIELD, LOCAL_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3Uri;

    private final String localPath;

    private CheckpointConfig(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.localPath = builder.localPath;
    }

    /**
     * <p>
     * Identifies the S3 path where you want Amazon SageMaker to store checkpoints. For example,
     * <code>s3://bucket-name/key-name-prefix</code>.
     * </p>
     * 
     * @return Identifies the S3 path where you want Amazon SageMaker to store checkpoints. For example,
     *         <code>s3://bucket-name/key-name-prefix</code>.
     */
    public String s3Uri() {
        return s3Uri;
    }

    /**
     * <p>
     * (Optional) The local directory where checkpoints are written. The default directory is
     * <code>/opt/ml/checkpoints/</code>.
     * </p>
     * 
     * @return (Optional) The local directory where checkpoints are written. The default directory is
     *         <code>/opt/ml/checkpoints/</code>.
     */
    public String localPath() {
        return localPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(localPath());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckpointConfig)) {
            return false;
        }
        CheckpointConfig other = (CheckpointConfig) obj;
        return Objects.equals(s3Uri(), other.s3Uri()) && Objects.equals(localPath(), other.localPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CheckpointConfig").add("S3Uri", s3Uri()).add("LocalPath", localPath()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "LocalPath":
            return Optional.ofNullable(clazz.cast(localPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CheckpointConfig, T> g) {
        return obj -> g.apply((CheckpointConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CheckpointConfig> {
        /**
         * <p>
         * Identifies the S3 path where you want Amazon SageMaker to store checkpoints. For example,
         * <code>s3://bucket-name/key-name-prefix</code>.
         * </p>
         * 
         * @param s3Uri
         *        Identifies the S3 path where you want Amazon SageMaker to store checkpoints. For example,
         *        <code>s3://bucket-name/key-name-prefix</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * (Optional) The local directory where checkpoints are written. The default directory is
         * <code>/opt/ml/checkpoints/</code>.
         * </p>
         * 
         * @param localPath
         *        (Optional) The local directory where checkpoints are written. The default directory is
         *        <code>/opt/ml/checkpoints/</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localPath(String localPath);
    }

    static final class BuilderImpl implements Builder {
        private String s3Uri;

        private String localPath;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckpointConfig model) {
            s3Uri(model.s3Uri);
            localPath(model.localPath);
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        public final String getLocalPath() {
            return localPath;
        }

        @Override
        public final Builder localPath(String localPath) {
            this.localPath = localPath;
            return this;
        }

        public final void setLocalPath(String localPath) {
            this.localPath = localPath;
        }

        @Override
        public CheckpointConfig build() {
            return new CheckpointConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
