/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies a Amazon Cognito user group. A user group can be used in on or more work teams.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CognitoMemberDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<CognitoMemberDefinition.Builder, CognitoMemberDefinition> {
    private static final SdkField<String> USER_POOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CognitoMemberDefinition::userPool)).setter(setter(Builder::userPool))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPool").build()).build();

    private static final SdkField<String> USER_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CognitoMemberDefinition::userGroup)).setter(setter(Builder::userGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroup").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CognitoMemberDefinition::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_FIELD,
            USER_GROUP_FIELD, CLIENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userPool;

    private final String userGroup;

    private final String clientId;

    private CognitoMemberDefinition(BuilderImpl builder) {
        this.userPool = builder.userPool;
        this.userGroup = builder.userGroup;
        this.clientId = builder.clientId;
    }

    /**
     * <p>
     * An identifier for a user pool. The user pool must be in the same region as the service that you are calling.
     * </p>
     * 
     * @return An identifier for a user pool. The user pool must be in the same region as the service that you are
     *         calling.
     */
    public String userPool() {
        return userPool;
    }

    /**
     * <p>
     * An identifier for a user group.
     * </p>
     * 
     * @return An identifier for a user group.
     */
    public String userGroup() {
        return userGroup;
    }

    /**
     * <p>
     * An identifier for an application client. You must create the app client ID using Amazon Cognito.
     * </p>
     * 
     * @return An identifier for an application client. You must create the app client ID using Amazon Cognito.
     */
    public String clientId() {
        return clientId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userPool());
        hashCode = 31 * hashCode + Objects.hashCode(userGroup());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CognitoMemberDefinition)) {
            return false;
        }
        CognitoMemberDefinition other = (CognitoMemberDefinition) obj;
        return Objects.equals(userPool(), other.userPool()) && Objects.equals(userGroup(), other.userGroup())
                && Objects.equals(clientId(), other.clientId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CognitoMemberDefinition").add("UserPool", userPool()).add("UserGroup", userGroup())
                .add("ClientId", clientId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPool":
            return Optional.ofNullable(clazz.cast(userPool()));
        case "UserGroup":
            return Optional.ofNullable(clazz.cast(userGroup()));
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CognitoMemberDefinition, T> g) {
        return obj -> g.apply((CognitoMemberDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CognitoMemberDefinition> {
        /**
         * <p>
         * An identifier for a user pool. The user pool must be in the same region as the service that you are calling.
         * </p>
         * 
         * @param userPool
         *        An identifier for a user pool. The user pool must be in the same region as the service that you are
         *        calling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPool(String userPool);

        /**
         * <p>
         * An identifier for a user group.
         * </p>
         * 
         * @param userGroup
         *        An identifier for a user group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroup(String userGroup);

        /**
         * <p>
         * An identifier for an application client. You must create the app client ID using Amazon Cognito.
         * </p>
         * 
         * @param clientId
         *        An identifier for an application client. You must create the app client ID using Amazon Cognito.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);
    }

    static final class BuilderImpl implements Builder {
        private String userPool;

        private String userGroup;

        private String clientId;

        private BuilderImpl() {
        }

        private BuilderImpl(CognitoMemberDefinition model) {
            userPool(model.userPool);
            userGroup(model.userGroup);
            clientId(model.clientId);
        }

        public final String getUserPool() {
            return userPool;
        }

        @Override
        public final Builder userPool(String userPool) {
            this.userPool = userPool;
            return this;
        }

        public final void setUserPool(String userPool) {
            this.userPool = userPool;
        }

        public final String getUserGroup() {
            return userGroup;
        }

        @Override
        public final Builder userGroup(String userGroup) {
            this.userGroup = userGroup;
            return this;
        }

        public final void setUserGroup(String userGroup) {
            this.userGroup = userGroup;
        }

        public final String getClientId() {
            return clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public CognitoMemberDefinition build() {
            return new CognitoMemberDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
