/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the container, as part of model definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerDefinition.Builder, ContainerDefinition> {
    private static final SdkField<String> CONTAINER_HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ContainerDefinition::containerHostname)).setter(setter(Builder::containerHostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerHostname").build()).build();

    private static final SdkField<String> IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ContainerDefinition::image)).setter(setter(Builder::image))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ContainerDefinition::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final SdkField<String> MODEL_DATA_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ContainerDefinition::modelDataUrl)).setter(setter(Builder::modelDataUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDataUrl").build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(ContainerDefinition::environment))
            .setter(setter(Builder::environment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> MODEL_PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ContainerDefinition::modelPackageName)).setter(setter(Builder::modelPackageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_HOSTNAME_FIELD,
            IMAGE_FIELD, MODE_FIELD, MODEL_DATA_URL_FIELD, ENVIRONMENT_FIELD, MODEL_PACKAGE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String containerHostname;

    private final String image;

    private final String mode;

    private final String modelDataUrl;

    private final Map<String, String> environment;

    private final String modelPackageName;

    private ContainerDefinition(BuilderImpl builder) {
        this.containerHostname = builder.containerHostname;
        this.image = builder.image;
        this.mode = builder.mode;
        this.modelDataUrl = builder.modelDataUrl;
        this.environment = builder.environment;
        this.modelPackageName = builder.modelPackageName;
    }

    /**
     * <p>
     * This parameter is ignored for models that contain only a <code>PrimaryContainer</code>.
     * </p>
     * <p>
     * When a <code>ContainerDefinition</code> is part of an inference pipeline, the value of ths parameter uniquely
     * identifies the container for the purposes of logging and metrics. For information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/inference-pipeline-logs-metrics.html">Use Logs and Metrics
     * to Monitor an Inference Pipeline</a>. If you don't specify a value for this parameter for a
     * <code>ContainerDefinition</code> that is part of an inference pipeline, a unique name is automatically assigned
     * based on the position of the <code>ContainerDefinition</code> in the pipeline. If you specify a value for the
     * <code>ContainerHostName</code> for any <code>ContainerDefinition</code> that is part of an inference pipeline,
     * you must specify a value for the <code>ContainerHostName</code> parameter of every
     * <code>ContainerDefinition</code> in that pipeline.
     * </p>
     * 
     * @return This parameter is ignored for models that contain only a <code>PrimaryContainer</code>.</p>
     *         <p>
     *         When a <code>ContainerDefinition</code> is part of an inference pipeline, the value of ths parameter
     *         uniquely identifies the container for the purposes of logging and metrics. For information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/inference-pipeline-logs-metrics.html">Use Logs and
     *         Metrics to Monitor an Inference Pipeline</a>. If you don't specify a value for this parameter for a
     *         <code>ContainerDefinition</code> that is part of an inference pipeline, a unique name is automatically
     *         assigned based on the position of the <code>ContainerDefinition</code> in the pipeline. If you specify a
     *         value for the <code>ContainerHostName</code> for any <code>ContainerDefinition</code> that is part of an
     *         inference pipeline, you must specify a value for the <code>ContainerHostName</code> parameter of every
     *         <code>ContainerDefinition</code> in that pipeline.
     */
    public String containerHostname() {
        return containerHostname;
    }

    /**
     * <p>
     * The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored. If you are using your own
     * custom algorithm instead of an algorithm provided by Amazon SageMaker, the inference code must meet Amazon
     * SageMaker requirements. Amazon SageMaker supports both <code>registry/repository[:tag]</code> and
     * <code>registry/repository[@digest]</code> image path formats. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon
     * SageMaker</a>
     * </p>
     * 
     * @return The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored. If you are using your
     *         own custom algorithm instead of an algorithm provided by Amazon SageMaker, the inference code must meet
     *         Amazon SageMaker requirements. Amazon SageMaker supports both <code>registry/repository[:tag]</code> and
     *         <code>registry/repository[@digest]</code> image path formats. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms
     *         with Amazon SageMaker</a>
     */
    public String image() {
        return image;
    }

    /**
     * <p>
     * Specifies whether the container hosts a single model or multiple models.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ContainerMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Specifies whether the container hosts a single model or multiple models.
     * @see ContainerMode
     */
    public ContainerMode mode() {
        return ContainerMode.fromValue(mode);
    }

    /**
     * <p>
     * Specifies whether the container hosts a single model or multiple models.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ContainerMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Specifies whether the container hosts a single model or multiple models.
     * @see ContainerMode
     */
    public String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * The S3 path where the model artifacts, which result from model training, are stored. This path must point to a
     * single gzip compressed tar archive (.tar.gz suffix). The S3 path is required for Amazon SageMaker built-in
     * algorithms, but not if you use your own algorithms. For more information on built-in algorithms, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html">Common
     * Parameters</a>.
     * </p>
     * <p>
     * If you provide a value for this parameter, Amazon SageMaker uses AWS Security Token Service to download model
     * artifacts from the S3 path you provide. AWS STS is activated in your IAM user account by default. If you
     * previously deactivated AWS STS for a region, you need to reactivate AWS STS for that region. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
     * Deactivating AWS STS in an AWS Region</a> in the <i>AWS Identity and Access Management User Guide</i>.
     * </p>
     * <important>
     * <p>
     * If you use a built-in algorithm to create a model, Amazon SageMaker requires that you provide a S3 path to the
     * model artifacts in <code>ModelDataUrl</code>.
     * </p>
     * </important>
     * 
     * @return The S3 path where the model artifacts, which result from model training, are stored. This path must point
     *         to a single gzip compressed tar archive (.tar.gz suffix). The S3 path is required for Amazon SageMaker
     *         built-in algorithms, but not if you use your own algorithms. For more information on built-in algorithms,
     *         see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html">Common
     *         Parameters</a>. </p>
     *         <p>
     *         If you provide a value for this parameter, Amazon SageMaker uses AWS Security Token Service to download
     *         model artifacts from the S3 path you provide. AWS STS is activated in your IAM user account by default.
     *         If you previously deactivated AWS STS for a region, you need to reactivate AWS STS for that region. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html"
     *         >Activating and Deactivating AWS STS in an AWS Region</a> in the <i>AWS Identity and Access Management
     *         User Guide</i>.
     *         </p>
     *         <important>
     *         <p>
     *         If you use a built-in algorithm to create a model, Amazon SageMaker requires that you provide a S3 path
     *         to the model artifacts in <code>ModelDataUrl</code>.
     *         </p>
     */
    public String modelDataUrl() {
        return modelDataUrl;
    }

    /**
     * <p>
     * The environment variables to set in the Docker container. Each key and value in the <code>Environment</code>
     * string to string map can have length of up to 1024. We support up to 16 entries in the map.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The environment variables to set in the Docker container. Each key and value in the
     *         <code>Environment</code> string to string map can have length of up to 1024. We support up to 16 entries
     *         in the map.
     */
    public Map<String, String> environment() {
        return environment;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the model package to use to create the model.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the model package to use to create the model.
     */
    public String modelPackageName() {
        return modelPackageName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containerHostname());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modelDataUrl());
        hashCode = 31 * hashCode + Objects.hashCode(environment());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerDefinition)) {
            return false;
        }
        ContainerDefinition other = (ContainerDefinition) obj;
        return Objects.equals(containerHostname(), other.containerHostname()) && Objects.equals(image(), other.image())
                && Objects.equals(modeAsString(), other.modeAsString()) && Objects.equals(modelDataUrl(), other.modelDataUrl())
                && Objects.equals(environment(), other.environment())
                && Objects.equals(modelPackageName(), other.modelPackageName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ContainerDefinition").add("ContainerHostname", containerHostname()).add("Image", image())
                .add("Mode", modeAsString()).add("ModelDataUrl", modelDataUrl()).add("Environment", environment())
                .add("ModelPackageName", modelPackageName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerHostname":
            return Optional.ofNullable(clazz.cast(containerHostname()));
        case "Image":
            return Optional.ofNullable(clazz.cast(image()));
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "ModelDataUrl":
            return Optional.ofNullable(clazz.cast(modelDataUrl()));
        case "Environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "ModelPackageName":
            return Optional.ofNullable(clazz.cast(modelPackageName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerDefinition, T> g) {
        return obj -> g.apply((ContainerDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerDefinition> {
        /**
         * <p>
         * This parameter is ignored for models that contain only a <code>PrimaryContainer</code>.
         * </p>
         * <p>
         * When a <code>ContainerDefinition</code> is part of an inference pipeline, the value of ths parameter uniquely
         * identifies the container for the purposes of logging and metrics. For information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/inference-pipeline-logs-metrics.html">Use Logs and
         * Metrics to Monitor an Inference Pipeline</a>. If you don't specify a value for this parameter for a
         * <code>ContainerDefinition</code> that is part of an inference pipeline, a unique name is automatically
         * assigned based on the position of the <code>ContainerDefinition</code> in the pipeline. If you specify a
         * value for the <code>ContainerHostName</code> for any <code>ContainerDefinition</code> that is part of an
         * inference pipeline, you must specify a value for the <code>ContainerHostName</code> parameter of every
         * <code>ContainerDefinition</code> in that pipeline.
         * </p>
         * 
         * @param containerHostname
         *        This parameter is ignored for models that contain only a <code>PrimaryContainer</code>.</p>
         *        <p>
         *        When a <code>ContainerDefinition</code> is part of an inference pipeline, the value of ths parameter
         *        uniquely identifies the container for the purposes of logging and metrics. For information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/inference-pipeline-logs-metrics.html">Use Logs
         *        and Metrics to Monitor an Inference Pipeline</a>. If you don't specify a value for this parameter for
         *        a <code>ContainerDefinition</code> that is part of an inference pipeline, a unique name is
         *        automatically assigned based on the position of the <code>ContainerDefinition</code> in the pipeline.
         *        If you specify a value for the <code>ContainerHostName</code> for any <code>ContainerDefinition</code>
         *        that is part of an inference pipeline, you must specify a value for the <code>ContainerHostName</code>
         *        parameter of every <code>ContainerDefinition</code> in that pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerHostname(String containerHostname);

        /**
         * <p>
         * The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored. If you are using your own
         * custom algorithm instead of an algorithm provided by Amazon SageMaker, the inference code must meet Amazon
         * SageMaker requirements. Amazon SageMaker supports both <code>registry/repository[:tag]</code> and
         * <code>registry/repository[@digest]</code> image path formats. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with
         * Amazon SageMaker</a>
         * </p>
         * 
         * @param image
         *        The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored. If you are using
         *        your own custom algorithm instead of an algorithm provided by Amazon SageMaker, the inference code
         *        must meet Amazon SageMaker requirements. Amazon SageMaker supports both
         *        <code>registry/repository[:tag]</code> and <code>registry/repository[@digest]</code> image path
         *        formats. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms
         *        with Amazon SageMaker</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(String image);

        /**
         * <p>
         * Specifies whether the container hosts a single model or multiple models.
         * </p>
         * 
         * @param mode
         *        Specifies whether the container hosts a single model or multiple models.
         * @see ContainerMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * Specifies whether the container hosts a single model or multiple models.
         * </p>
         * 
         * @param mode
         *        Specifies whether the container hosts a single model or multiple models.
         * @see ContainerMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerMode
         */
        Builder mode(ContainerMode mode);

        /**
         * <p>
         * The S3 path where the model artifacts, which result from model training, are stored. This path must point to
         * a single gzip compressed tar archive (.tar.gz suffix). The S3 path is required for Amazon SageMaker built-in
         * algorithms, but not if you use your own algorithms. For more information on built-in algorithms, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html">Common
         * Parameters</a>.
         * </p>
         * <p>
         * If you provide a value for this parameter, Amazon SageMaker uses AWS Security Token Service to download model
         * artifacts from the S3 path you provide. AWS STS is activated in your IAM user account by default. If you
         * previously deactivated AWS STS for a region, you need to reactivate AWS STS for that region. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating
         * and Deactivating AWS STS in an AWS Region</a> in the <i>AWS Identity and Access Management User Guide</i>.
         * </p>
         * <important>
         * <p>
         * If you use a built-in algorithm to create a model, Amazon SageMaker requires that you provide a S3 path to
         * the model artifacts in <code>ModelDataUrl</code>.
         * </p>
         * </important>
         * 
         * @param modelDataUrl
         *        The S3 path where the model artifacts, which result from model training, are stored. This path must
         *        point to a single gzip compressed tar archive (.tar.gz suffix). The S3 path is required for Amazon
         *        SageMaker built-in algorithms, but not if you use your own algorithms. For more information on
         *        built-in algorithms, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html"
         *        >Common Parameters</a>. </p>
         *        <p>
         *        If you provide a value for this parameter, Amazon SageMaker uses AWS Security Token Service to
         *        download model artifacts from the S3 path you provide. AWS STS is activated in your IAM user account
         *        by default. If you previously deactivated AWS STS for a region, you need to reactivate AWS STS for
         *        that region. For more information, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html"
         *        >Activating and Deactivating AWS STS in an AWS Region</a> in the <i>AWS Identity and Access Management
         *        User Guide</i>.
         *        </p>
         *        <important>
         *        <p>
         *        If you use a built-in algorithm to create a model, Amazon SageMaker requires that you provide a S3
         *        path to the model artifacts in <code>ModelDataUrl</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelDataUrl(String modelDataUrl);

        /**
         * <p>
         * The environment variables to set in the Docker container. Each key and value in the <code>Environment</code>
         * string to string map can have length of up to 1024. We support up to 16 entries in the map.
         * </p>
         * 
         * @param environment
         *        The environment variables to set in the Docker container. Each key and value in the
         *        <code>Environment</code> string to string map can have length of up to 1024. We support up to 16
         *        entries in the map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Map<String, String> environment);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the model package to use to create the model.
         * </p>
         * 
         * @param modelPackageName
         *        The name or Amazon Resource Name (ARN) of the model package to use to create the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageName(String modelPackageName);
    }

    static final class BuilderImpl implements Builder {
        private String containerHostname;

        private String image;

        private String mode;

        private String modelDataUrl;

        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();

        private String modelPackageName;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerDefinition model) {
            containerHostname(model.containerHostname);
            image(model.image);
            mode(model.mode);
            modelDataUrl(model.modelDataUrl);
            environment(model.environment);
            modelPackageName(model.modelPackageName);
        }

        public final String getContainerHostname() {
            return containerHostname;
        }

        @Override
        public final Builder containerHostname(String containerHostname) {
            this.containerHostname = containerHostname;
            return this;
        }

        public final void setContainerHostname(String containerHostname) {
            this.containerHostname = containerHostname;
        }

        public final String getImage() {
            return image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        public final String getModeAsString() {
            return mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ContainerMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        public final String getModelDataUrl() {
            return modelDataUrl;
        }

        @Override
        public final Builder modelDataUrl(String modelDataUrl) {
            this.modelDataUrl = modelDataUrl;
            return this;
        }

        public final void setModelDataUrl(String modelDataUrl) {
            this.modelDataUrl = modelDataUrl;
        }

        public final Map<String, String> getEnvironment() {
            return environment;
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = EnvironmentMapCopier.copy(environment);
            return this;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = EnvironmentMapCopier.copy(environment);
        }

        public final String getModelPackageName() {
            return modelPackageName;
        }

        @Override
        public final Builder modelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
            return this;
        }

        public final void setModelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
        }

        @Override
        public ContainerDefinition build() {
            return new ContainerDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
