/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeHyperParameterTuningJobResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeHyperParameterTuningJobResponse.Builder, DescribeHyperParameterTuningJobResponse> {
    private static final SdkField<String> HYPER_PARAMETER_TUNING_JOB_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeHyperParameterTuningJobResponse::hyperParameterTuningJobName))
            .setter(setter(Builder::hyperParameterTuningJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningJobName")
                    .build()).build();

    private static final SdkField<String> HYPER_PARAMETER_TUNING_JOB_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeHyperParameterTuningJobResponse::hyperParameterTuningJobArn))
            .setter(setter(Builder::hyperParameterTuningJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningJobArn").build())
            .build();

    private static final SdkField<HyperParameterTuningJobConfig> HYPER_PARAMETER_TUNING_JOB_CONFIG_FIELD = SdkField
            .<HyperParameterTuningJobConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeHyperParameterTuningJobResponse::hyperParameterTuningJobConfig))
            .setter(setter(Builder::hyperParameterTuningJobConfig))
            .constructor(HyperParameterTuningJobConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningJobConfig")
                    .build()).build();

    private static final SdkField<HyperParameterTrainingJobDefinition> TRAINING_JOB_DEFINITION_FIELD = SdkField
            .<HyperParameterTrainingJobDefinition> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeHyperParameterTuningJobResponse::trainingJobDefinition))
            .setter(setter(Builder::trainingJobDefinition)).constructor(HyperParameterTrainingJobDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobDefinition").build())
            .build();

    private static final SdkField<String> HYPER_PARAMETER_TUNING_JOB_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeHyperParameterTuningJobResponse::hyperParameterTuningJobStatusAsString))
            .setter(setter(Builder::hyperParameterTuningJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningJobStatus")
                    .build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeHyperParameterTuningJobResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> HYPER_PARAMETER_TUNING_END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeHyperParameterTuningJobResponse::hyperParameterTuningEndTime))
            .setter(setter(Builder::hyperParameterTuningEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningEndTime")
                    .build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeHyperParameterTuningJobResponse::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<TrainingJobStatusCounters> TRAINING_JOB_STATUS_COUNTERS_FIELD = SdkField
            .<TrainingJobStatusCounters> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeHyperParameterTuningJobResponse::trainingJobStatusCounters))
            .setter(setter(Builder::trainingJobStatusCounters)).constructor(TrainingJobStatusCounters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobStatusCounters").build())
            .build();

    private static final SdkField<ObjectiveStatusCounters> OBJECTIVE_STATUS_COUNTERS_FIELD = SdkField
            .<ObjectiveStatusCounters> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeHyperParameterTuningJobResponse::objectiveStatusCounters))
            .setter(setter(Builder::objectiveStatusCounters)).constructor(ObjectiveStatusCounters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectiveStatusCounters").build())
            .build();

    private static final SdkField<HyperParameterTrainingJobSummary> BEST_TRAINING_JOB_FIELD = SdkField
            .<HyperParameterTrainingJobSummary> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeHyperParameterTuningJobResponse::bestTrainingJob)).setter(setter(Builder::bestTrainingJob))
            .constructor(HyperParameterTrainingJobSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BestTrainingJob").build()).build();

    private static final SdkField<HyperParameterTrainingJobSummary> OVERALL_BEST_TRAINING_JOB_FIELD = SdkField
            .<HyperParameterTrainingJobSummary> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeHyperParameterTuningJobResponse::overallBestTrainingJob))
            .setter(setter(Builder::overallBestTrainingJob)).constructor(HyperParameterTrainingJobSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverallBestTrainingJob").build())
            .build();

    private static final SdkField<HyperParameterTuningJobWarmStartConfig> WARM_START_CONFIG_FIELD = SdkField
            .<HyperParameterTuningJobWarmStartConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeHyperParameterTuningJobResponse::warmStartConfig)).setter(setter(Builder::warmStartConfig))
            .constructor(HyperParameterTuningJobWarmStartConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmStartConfig").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeHyperParameterTuningJobResponse::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            HYPER_PARAMETER_TUNING_JOB_NAME_FIELD, HYPER_PARAMETER_TUNING_JOB_ARN_FIELD, HYPER_PARAMETER_TUNING_JOB_CONFIG_FIELD,
            TRAINING_JOB_DEFINITION_FIELD, HYPER_PARAMETER_TUNING_JOB_STATUS_FIELD, CREATION_TIME_FIELD,
            HYPER_PARAMETER_TUNING_END_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, TRAINING_JOB_STATUS_COUNTERS_FIELD,
            OBJECTIVE_STATUS_COUNTERS_FIELD, BEST_TRAINING_JOB_FIELD, OVERALL_BEST_TRAINING_JOB_FIELD, WARM_START_CONFIG_FIELD,
            FAILURE_REASON_FIELD));

    private final String hyperParameterTuningJobName;

    private final String hyperParameterTuningJobArn;

    private final HyperParameterTuningJobConfig hyperParameterTuningJobConfig;

    private final HyperParameterTrainingJobDefinition trainingJobDefinition;

    private final String hyperParameterTuningJobStatus;

    private final Instant creationTime;

    private final Instant hyperParameterTuningEndTime;

    private final Instant lastModifiedTime;

    private final TrainingJobStatusCounters trainingJobStatusCounters;

    private final ObjectiveStatusCounters objectiveStatusCounters;

    private final HyperParameterTrainingJobSummary bestTrainingJob;

    private final HyperParameterTrainingJobSummary overallBestTrainingJob;

    private final HyperParameterTuningJobWarmStartConfig warmStartConfig;

    private final String failureReason;

    private DescribeHyperParameterTuningJobResponse(BuilderImpl builder) {
        super(builder);
        this.hyperParameterTuningJobName = builder.hyperParameterTuningJobName;
        this.hyperParameterTuningJobArn = builder.hyperParameterTuningJobArn;
        this.hyperParameterTuningJobConfig = builder.hyperParameterTuningJobConfig;
        this.trainingJobDefinition = builder.trainingJobDefinition;
        this.hyperParameterTuningJobStatus = builder.hyperParameterTuningJobStatus;
        this.creationTime = builder.creationTime;
        this.hyperParameterTuningEndTime = builder.hyperParameterTuningEndTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.trainingJobStatusCounters = builder.trainingJobStatusCounters;
        this.objectiveStatusCounters = builder.objectiveStatusCounters;
        this.bestTrainingJob = builder.bestTrainingJob;
        this.overallBestTrainingJob = builder.overallBestTrainingJob;
        this.warmStartConfig = builder.warmStartConfig;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The name of the tuning job.
     * </p>
     * 
     * @return The name of the tuning job.
     */
    public String hyperParameterTuningJobName() {
        return hyperParameterTuningJobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the tuning job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the tuning job.
     */
    public String hyperParameterTuningJobArn() {
        return hyperParameterTuningJobArn;
    }

    /**
     * <p>
     * The <a>HyperParameterTuningJobConfig</a> object that specifies the configuration of the tuning job.
     * </p>
     * 
     * @return The <a>HyperParameterTuningJobConfig</a> object that specifies the configuration of the tuning job.
     */
    public HyperParameterTuningJobConfig hyperParameterTuningJobConfig() {
        return hyperParameterTuningJobConfig;
    }

    /**
     * <p>
     * The <a>HyperParameterTrainingJobDefinition</a> object that specifies the definition of the training jobs that
     * this tuning job launches.
     * </p>
     * 
     * @return The <a>HyperParameterTrainingJobDefinition</a> object that specifies the definition of the training jobs
     *         that this tuning job launches.
     */
    public HyperParameterTrainingJobDefinition trainingJobDefinition() {
        return trainingJobDefinition;
    }

    /**
     * <p>
     * The status of the tuning job: InProgress, Completed, Failed, Stopping, or Stopped.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #hyperParameterTuningJobStatus} will return {@link HyperParameterTuningJobStatus#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #hyperParameterTuningJobStatusAsString}.
     * </p>
     * 
     * @return The status of the tuning job: InProgress, Completed, Failed, Stopping, or Stopped.
     * @see HyperParameterTuningJobStatus
     */
    public HyperParameterTuningJobStatus hyperParameterTuningJobStatus() {
        return HyperParameterTuningJobStatus.fromValue(hyperParameterTuningJobStatus);
    }

    /**
     * <p>
     * The status of the tuning job: InProgress, Completed, Failed, Stopping, or Stopped.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #hyperParameterTuningJobStatus} will return {@link HyperParameterTuningJobStatus#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #hyperParameterTuningJobStatusAsString}.
     * </p>
     * 
     * @return The status of the tuning job: InProgress, Completed, Failed, Stopping, or Stopped.
     * @see HyperParameterTuningJobStatus
     */
    public String hyperParameterTuningJobStatusAsString() {
        return hyperParameterTuningJobStatus;
    }

    /**
     * <p>
     * The date and time that the tuning job started.
     * </p>
     * 
     * @return The date and time that the tuning job started.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time that the tuning job ended.
     * </p>
     * 
     * @return The date and time that the tuning job ended.
     */
    public Instant hyperParameterTuningEndTime() {
        return hyperParameterTuningEndTime;
    }

    /**
     * <p>
     * The date and time that the status of the tuning job was modified.
     * </p>
     * 
     * @return The date and time that the status of the tuning job was modified.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The <a>TrainingJobStatusCounters</a> object that specifies the number of training jobs, categorized by status,
     * that this tuning job launched.
     * </p>
     * 
     * @return The <a>TrainingJobStatusCounters</a> object that specifies the number of training jobs, categorized by
     *         status, that this tuning job launched.
     */
    public TrainingJobStatusCounters trainingJobStatusCounters() {
        return trainingJobStatusCounters;
    }

    /**
     * <p>
     * The <a>ObjectiveStatusCounters</a> object that specifies the number of training jobs, categorized by the status
     * of their final objective metric, that this tuning job launched.
     * </p>
     * 
     * @return The <a>ObjectiveStatusCounters</a> object that specifies the number of training jobs, categorized by the
     *         status of their final objective metric, that this tuning job launched.
     */
    public ObjectiveStatusCounters objectiveStatusCounters() {
        return objectiveStatusCounters;
    }

    /**
     * <p>
     * A <a>TrainingJobSummary</a> object that describes the training job that completed with the best current
     * <a>HyperParameterTuningJobObjective</a>.
     * </p>
     * 
     * @return A <a>TrainingJobSummary</a> object that describes the training job that completed with the best current
     *         <a>HyperParameterTuningJobObjective</a>.
     */
    public HyperParameterTrainingJobSummary bestTrainingJob() {
        return bestTrainingJob;
    }

    /**
     * <p>
     * If the hyperparameter tuning job is an warm start tuning job with a <code>WarmStartType</code> of
     * <code>IDENTICAL_DATA_AND_ALGORITHM</code>, this is the <a>TrainingJobSummary</a> for the training job with the
     * best objective metric value of all training jobs launched by this tuning job and all parent jobs specified for
     * the warm start tuning job.
     * </p>
     * 
     * @return If the hyperparameter tuning job is an warm start tuning job with a <code>WarmStartType</code> of
     *         <code>IDENTICAL_DATA_AND_ALGORITHM</code>, this is the <a>TrainingJobSummary</a> for the training job
     *         with the best objective metric value of all training jobs launched by this tuning job and all parent jobs
     *         specified for the warm start tuning job.
     */
    public HyperParameterTrainingJobSummary overallBestTrainingJob() {
        return overallBestTrainingJob;
    }

    /**
     * <p>
     * The configuration for starting the hyperparameter parameter tuning job using one or more previous tuning jobs as
     * a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to
     * search over in the new tuning job.
     * </p>
     * 
     * @return The configuration for starting the hyperparameter parameter tuning job using one or more previous tuning
     *         jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of
     *         hyperparameters to search over in the new tuning job.
     */
    public HyperParameterTuningJobWarmStartConfig warmStartConfig() {
        return warmStartConfig;
    }

    /**
     * <p>
     * If the tuning job failed, the reason it failed.
     * </p>
     * 
     * @return If the tuning job failed, the reason it failed.
     */
    public String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hyperParameterTuningJobName());
        hashCode = 31 * hashCode + Objects.hashCode(hyperParameterTuningJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(hyperParameterTuningJobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(trainingJobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(hyperParameterTuningJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(hyperParameterTuningEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(trainingJobStatusCounters());
        hashCode = 31 * hashCode + Objects.hashCode(objectiveStatusCounters());
        hashCode = 31 * hashCode + Objects.hashCode(bestTrainingJob());
        hashCode = 31 * hashCode + Objects.hashCode(overallBestTrainingJob());
        hashCode = 31 * hashCode + Objects.hashCode(warmStartConfig());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHyperParameterTuningJobResponse)) {
            return false;
        }
        DescribeHyperParameterTuningJobResponse other = (DescribeHyperParameterTuningJobResponse) obj;
        return Objects.equals(hyperParameterTuningJobName(), other.hyperParameterTuningJobName())
                && Objects.equals(hyperParameterTuningJobArn(), other.hyperParameterTuningJobArn())
                && Objects.equals(hyperParameterTuningJobConfig(), other.hyperParameterTuningJobConfig())
                && Objects.equals(trainingJobDefinition(), other.trainingJobDefinition())
                && Objects.equals(hyperParameterTuningJobStatusAsString(), other.hyperParameterTuningJobStatusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(hyperParameterTuningEndTime(), other.hyperParameterTuningEndTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(trainingJobStatusCounters(), other.trainingJobStatusCounters())
                && Objects.equals(objectiveStatusCounters(), other.objectiveStatusCounters())
                && Objects.equals(bestTrainingJob(), other.bestTrainingJob())
                && Objects.equals(overallBestTrainingJob(), other.overallBestTrainingJob())
                && Objects.equals(warmStartConfig(), other.warmStartConfig())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeHyperParameterTuningJobResponse")
                .add("HyperParameterTuningJobName", hyperParameterTuningJobName())
                .add("HyperParameterTuningJobArn", hyperParameterTuningJobArn())
                .add("HyperParameterTuningJobConfig", hyperParameterTuningJobConfig())
                .add("TrainingJobDefinition", trainingJobDefinition())
                .add("HyperParameterTuningJobStatus", hyperParameterTuningJobStatusAsString())
                .add("CreationTime", creationTime()).add("HyperParameterTuningEndTime", hyperParameterTuningEndTime())
                .add("LastModifiedTime", lastModifiedTime()).add("TrainingJobStatusCounters", trainingJobStatusCounters())
                .add("ObjectiveStatusCounters", objectiveStatusCounters()).add("BestTrainingJob", bestTrainingJob())
                .add("OverallBestTrainingJob", overallBestTrainingJob()).add("WarmStartConfig", warmStartConfig())
                .add("FailureReason", failureReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HyperParameterTuningJobName":
            return Optional.ofNullable(clazz.cast(hyperParameterTuningJobName()));
        case "HyperParameterTuningJobArn":
            return Optional.ofNullable(clazz.cast(hyperParameterTuningJobArn()));
        case "HyperParameterTuningJobConfig":
            return Optional.ofNullable(clazz.cast(hyperParameterTuningJobConfig()));
        case "TrainingJobDefinition":
            return Optional.ofNullable(clazz.cast(trainingJobDefinition()));
        case "HyperParameterTuningJobStatus":
            return Optional.ofNullable(clazz.cast(hyperParameterTuningJobStatusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "HyperParameterTuningEndTime":
            return Optional.ofNullable(clazz.cast(hyperParameterTuningEndTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "TrainingJobStatusCounters":
            return Optional.ofNullable(clazz.cast(trainingJobStatusCounters()));
        case "ObjectiveStatusCounters":
            return Optional.ofNullable(clazz.cast(objectiveStatusCounters()));
        case "BestTrainingJob":
            return Optional.ofNullable(clazz.cast(bestTrainingJob()));
        case "OverallBestTrainingJob":
            return Optional.ofNullable(clazz.cast(overallBestTrainingJob()));
        case "WarmStartConfig":
            return Optional.ofNullable(clazz.cast(warmStartConfig()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHyperParameterTuningJobResponse, T> g) {
        return obj -> g.apply((DescribeHyperParameterTuningJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeHyperParameterTuningJobResponse> {
        /**
         * <p>
         * The name of the tuning job.
         * </p>
         * 
         * @param hyperParameterTuningJobName
         *        The name of the tuning job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameterTuningJobName(String hyperParameterTuningJobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the tuning job.
         * </p>
         * 
         * @param hyperParameterTuningJobArn
         *        The Amazon Resource Name (ARN) of the tuning job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameterTuningJobArn(String hyperParameterTuningJobArn);

        /**
         * <p>
         * The <a>HyperParameterTuningJobConfig</a> object that specifies the configuration of the tuning job.
         * </p>
         * 
         * @param hyperParameterTuningJobConfig
         *        The <a>HyperParameterTuningJobConfig</a> object that specifies the configuration of the tuning job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameterTuningJobConfig(HyperParameterTuningJobConfig hyperParameterTuningJobConfig);

        /**
         * <p>
         * The <a>HyperParameterTuningJobConfig</a> object that specifies the configuration of the tuning job.
         * </p>
         * This is a convenience that creates an instance of the {@link HyperParameterTuningJobConfig.Builder} avoiding
         * the need to create one manually via {@link HyperParameterTuningJobConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link HyperParameterTuningJobConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #hyperParameterTuningJobConfig(HyperParameterTuningJobConfig)}
         * .
         * 
         * @param hyperParameterTuningJobConfig
         *        a consumer that will call methods on {@link HyperParameterTuningJobConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hyperParameterTuningJobConfig(HyperParameterTuningJobConfig)
         */
        default Builder hyperParameterTuningJobConfig(
                Consumer<HyperParameterTuningJobConfig.Builder> hyperParameterTuningJobConfig) {
            return hyperParameterTuningJobConfig(HyperParameterTuningJobConfig.builder()
                    .applyMutation(hyperParameterTuningJobConfig).build());
        }

        /**
         * <p>
         * The <a>HyperParameterTrainingJobDefinition</a> object that specifies the definition of the training jobs that
         * this tuning job launches.
         * </p>
         * 
         * @param trainingJobDefinition
         *        The <a>HyperParameterTrainingJobDefinition</a> object that specifies the definition of the training
         *        jobs that this tuning job launches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJobDefinition(HyperParameterTrainingJobDefinition trainingJobDefinition);

        /**
         * <p>
         * The <a>HyperParameterTrainingJobDefinition</a> object that specifies the definition of the training jobs that
         * this tuning job launches.
         * </p>
         * This is a convenience that creates an instance of the {@link HyperParameterTrainingJobDefinition.Builder}
         * avoiding the need to create one manually via {@link HyperParameterTrainingJobDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link HyperParameterTrainingJobDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #trainingJobDefinition(HyperParameterTrainingJobDefinition)}.
         * 
         * @param trainingJobDefinition
         *        a consumer that will call methods on {@link HyperParameterTrainingJobDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingJobDefinition(HyperParameterTrainingJobDefinition)
         */
        default Builder trainingJobDefinition(Consumer<HyperParameterTrainingJobDefinition.Builder> trainingJobDefinition) {
            return trainingJobDefinition(HyperParameterTrainingJobDefinition.builder().applyMutation(trainingJobDefinition)
                    .build());
        }

        /**
         * <p>
         * The status of the tuning job: InProgress, Completed, Failed, Stopping, or Stopped.
         * </p>
         * 
         * @param hyperParameterTuningJobStatus
         *        The status of the tuning job: InProgress, Completed, Failed, Stopping, or Stopped.
         * @see HyperParameterTuningJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HyperParameterTuningJobStatus
         */
        Builder hyperParameterTuningJobStatus(String hyperParameterTuningJobStatus);

        /**
         * <p>
         * The status of the tuning job: InProgress, Completed, Failed, Stopping, or Stopped.
         * </p>
         * 
         * @param hyperParameterTuningJobStatus
         *        The status of the tuning job: InProgress, Completed, Failed, Stopping, or Stopped.
         * @see HyperParameterTuningJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HyperParameterTuningJobStatus
         */
        Builder hyperParameterTuningJobStatus(HyperParameterTuningJobStatus hyperParameterTuningJobStatus);

        /**
         * <p>
         * The date and time that the tuning job started.
         * </p>
         * 
         * @param creationTime
         *        The date and time that the tuning job started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The date and time that the tuning job ended.
         * </p>
         * 
         * @param hyperParameterTuningEndTime
         *        The date and time that the tuning job ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameterTuningEndTime(Instant hyperParameterTuningEndTime);

        /**
         * <p>
         * The date and time that the status of the tuning job was modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time that the status of the tuning job was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The <a>TrainingJobStatusCounters</a> object that specifies the number of training jobs, categorized by
         * status, that this tuning job launched.
         * </p>
         * 
         * @param trainingJobStatusCounters
         *        The <a>TrainingJobStatusCounters</a> object that specifies the number of training jobs, categorized by
         *        status, that this tuning job launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJobStatusCounters(TrainingJobStatusCounters trainingJobStatusCounters);

        /**
         * <p>
         * The <a>TrainingJobStatusCounters</a> object that specifies the number of training jobs, categorized by
         * status, that this tuning job launched.
         * </p>
         * This is a convenience that creates an instance of the {@link TrainingJobStatusCounters.Builder} avoiding the
         * need to create one manually via {@link TrainingJobStatusCounters#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrainingJobStatusCounters.Builder#build()} is called immediately
         * and its result is passed to {@link #trainingJobStatusCounters(TrainingJobStatusCounters)}.
         * 
         * @param trainingJobStatusCounters
         *        a consumer that will call methods on {@link TrainingJobStatusCounters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingJobStatusCounters(TrainingJobStatusCounters)
         */
        default Builder trainingJobStatusCounters(Consumer<TrainingJobStatusCounters.Builder> trainingJobStatusCounters) {
            return trainingJobStatusCounters(TrainingJobStatusCounters.builder().applyMutation(trainingJobStatusCounters).build());
        }

        /**
         * <p>
         * The <a>ObjectiveStatusCounters</a> object that specifies the number of training jobs, categorized by the
         * status of their final objective metric, that this tuning job launched.
         * </p>
         * 
         * @param objectiveStatusCounters
         *        The <a>ObjectiveStatusCounters</a> object that specifies the number of training jobs, categorized by
         *        the status of their final objective metric, that this tuning job launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectiveStatusCounters(ObjectiveStatusCounters objectiveStatusCounters);

        /**
         * <p>
         * The <a>ObjectiveStatusCounters</a> object that specifies the number of training jobs, categorized by the
         * status of their final objective metric, that this tuning job launched.
         * </p>
         * This is a convenience that creates an instance of the {@link ObjectiveStatusCounters.Builder} avoiding the
         * need to create one manually via {@link ObjectiveStatusCounters#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectiveStatusCounters.Builder#build()} is called immediately
         * and its result is passed to {@link #objectiveStatusCounters(ObjectiveStatusCounters)}.
         * 
         * @param objectiveStatusCounters
         *        a consumer that will call methods on {@link ObjectiveStatusCounters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectiveStatusCounters(ObjectiveStatusCounters)
         */
        default Builder objectiveStatusCounters(Consumer<ObjectiveStatusCounters.Builder> objectiveStatusCounters) {
            return objectiveStatusCounters(ObjectiveStatusCounters.builder().applyMutation(objectiveStatusCounters).build());
        }

        /**
         * <p>
         * A <a>TrainingJobSummary</a> object that describes the training job that completed with the best current
         * <a>HyperParameterTuningJobObjective</a>.
         * </p>
         * 
         * @param bestTrainingJob
         *        A <a>TrainingJobSummary</a> object that describes the training job that completed with the best
         *        current <a>HyperParameterTuningJobObjective</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bestTrainingJob(HyperParameterTrainingJobSummary bestTrainingJob);

        /**
         * <p>
         * A <a>TrainingJobSummary</a> object that describes the training job that completed with the best current
         * <a>HyperParameterTuningJobObjective</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link HyperParameterTrainingJobSummary.Builder}
         * avoiding the need to create one manually via {@link HyperParameterTrainingJobSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link HyperParameterTrainingJobSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #bestTrainingJob(HyperParameterTrainingJobSummary)}.
         * 
         * @param bestTrainingJob
         *        a consumer that will call methods on {@link HyperParameterTrainingJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bestTrainingJob(HyperParameterTrainingJobSummary)
         */
        default Builder bestTrainingJob(Consumer<HyperParameterTrainingJobSummary.Builder> bestTrainingJob) {
            return bestTrainingJob(HyperParameterTrainingJobSummary.builder().applyMutation(bestTrainingJob).build());
        }

        /**
         * <p>
         * If the hyperparameter tuning job is an warm start tuning job with a <code>WarmStartType</code> of
         * <code>IDENTICAL_DATA_AND_ALGORITHM</code>, this is the <a>TrainingJobSummary</a> for the training job with
         * the best objective metric value of all training jobs launched by this tuning job and all parent jobs
         * specified for the warm start tuning job.
         * </p>
         * 
         * @param overallBestTrainingJob
         *        If the hyperparameter tuning job is an warm start tuning job with a <code>WarmStartType</code> of
         *        <code>IDENTICAL_DATA_AND_ALGORITHM</code>, this is the <a>TrainingJobSummary</a> for the training job
         *        with the best objective metric value of all training jobs launched by this tuning job and all parent
         *        jobs specified for the warm start tuning job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overallBestTrainingJob(HyperParameterTrainingJobSummary overallBestTrainingJob);

        /**
         * <p>
         * If the hyperparameter tuning job is an warm start tuning job with a <code>WarmStartType</code> of
         * <code>IDENTICAL_DATA_AND_ALGORITHM</code>, this is the <a>TrainingJobSummary</a> for the training job with
         * the best objective metric value of all training jobs launched by this tuning job and all parent jobs
         * specified for the warm start tuning job.
         * </p>
         * This is a convenience that creates an instance of the {@link HyperParameterTrainingJobSummary.Builder}
         * avoiding the need to create one manually via {@link HyperParameterTrainingJobSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link HyperParameterTrainingJobSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #overallBestTrainingJob(HyperParameterTrainingJobSummary)}.
         * 
         * @param overallBestTrainingJob
         *        a consumer that will call methods on {@link HyperParameterTrainingJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overallBestTrainingJob(HyperParameterTrainingJobSummary)
         */
        default Builder overallBestTrainingJob(Consumer<HyperParameterTrainingJobSummary.Builder> overallBestTrainingJob) {
            return overallBestTrainingJob(HyperParameterTrainingJobSummary.builder().applyMutation(overallBestTrainingJob)
                    .build());
        }

        /**
         * <p>
         * The configuration for starting the hyperparameter parameter tuning job using one or more previous tuning jobs
         * as a starting point. The results of previous tuning jobs are used to inform which combinations of
         * hyperparameters to search over in the new tuning job.
         * </p>
         * 
         * @param warmStartConfig
         *        The configuration for starting the hyperparameter parameter tuning job using one or more previous
         *        tuning jobs as a starting point. The results of previous tuning jobs are used to inform which
         *        combinations of hyperparameters to search over in the new tuning job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warmStartConfig(HyperParameterTuningJobWarmStartConfig warmStartConfig);

        /**
         * <p>
         * The configuration for starting the hyperparameter parameter tuning job using one or more previous tuning jobs
         * as a starting point. The results of previous tuning jobs are used to inform which combinations of
         * hyperparameters to search over in the new tuning job.
         * </p>
         * This is a convenience that creates an instance of the {@link HyperParameterTuningJobWarmStartConfig.Builder}
         * avoiding the need to create one manually via {@link HyperParameterTuningJobWarmStartConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link HyperParameterTuningJobWarmStartConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #warmStartConfig(HyperParameterTuningJobWarmStartConfig)}.
         * 
         * @param warmStartConfig
         *        a consumer that will call methods on {@link HyperParameterTuningJobWarmStartConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #warmStartConfig(HyperParameterTuningJobWarmStartConfig)
         */
        default Builder warmStartConfig(Consumer<HyperParameterTuningJobWarmStartConfig.Builder> warmStartConfig) {
            return warmStartConfig(HyperParameterTuningJobWarmStartConfig.builder().applyMutation(warmStartConfig).build());
        }

        /**
         * <p>
         * If the tuning job failed, the reason it failed.
         * </p>
         * 
         * @param failureReason
         *        If the tuning job failed, the reason it failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String hyperParameterTuningJobName;

        private String hyperParameterTuningJobArn;

        private HyperParameterTuningJobConfig hyperParameterTuningJobConfig;

        private HyperParameterTrainingJobDefinition trainingJobDefinition;

        private String hyperParameterTuningJobStatus;

        private Instant creationTime;

        private Instant hyperParameterTuningEndTime;

        private Instant lastModifiedTime;

        private TrainingJobStatusCounters trainingJobStatusCounters;

        private ObjectiveStatusCounters objectiveStatusCounters;

        private HyperParameterTrainingJobSummary bestTrainingJob;

        private HyperParameterTrainingJobSummary overallBestTrainingJob;

        private HyperParameterTuningJobWarmStartConfig warmStartConfig;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHyperParameterTuningJobResponse model) {
            super(model);
            hyperParameterTuningJobName(model.hyperParameterTuningJobName);
            hyperParameterTuningJobArn(model.hyperParameterTuningJobArn);
            hyperParameterTuningJobConfig(model.hyperParameterTuningJobConfig);
            trainingJobDefinition(model.trainingJobDefinition);
            hyperParameterTuningJobStatus(model.hyperParameterTuningJobStatus);
            creationTime(model.creationTime);
            hyperParameterTuningEndTime(model.hyperParameterTuningEndTime);
            lastModifiedTime(model.lastModifiedTime);
            trainingJobStatusCounters(model.trainingJobStatusCounters);
            objectiveStatusCounters(model.objectiveStatusCounters);
            bestTrainingJob(model.bestTrainingJob);
            overallBestTrainingJob(model.overallBestTrainingJob);
            warmStartConfig(model.warmStartConfig);
            failureReason(model.failureReason);
        }

        public final String getHyperParameterTuningJobName() {
            return hyperParameterTuningJobName;
        }

        @Override
        public final Builder hyperParameterTuningJobName(String hyperParameterTuningJobName) {
            this.hyperParameterTuningJobName = hyperParameterTuningJobName;
            return this;
        }

        public final void setHyperParameterTuningJobName(String hyperParameterTuningJobName) {
            this.hyperParameterTuningJobName = hyperParameterTuningJobName;
        }

        public final String getHyperParameterTuningJobArn() {
            return hyperParameterTuningJobArn;
        }

        @Override
        public final Builder hyperParameterTuningJobArn(String hyperParameterTuningJobArn) {
            this.hyperParameterTuningJobArn = hyperParameterTuningJobArn;
            return this;
        }

        public final void setHyperParameterTuningJobArn(String hyperParameterTuningJobArn) {
            this.hyperParameterTuningJobArn = hyperParameterTuningJobArn;
        }

        public final HyperParameterTuningJobConfig.Builder getHyperParameterTuningJobConfig() {
            return hyperParameterTuningJobConfig != null ? hyperParameterTuningJobConfig.toBuilder() : null;
        }

        @Override
        public final Builder hyperParameterTuningJobConfig(HyperParameterTuningJobConfig hyperParameterTuningJobConfig) {
            this.hyperParameterTuningJobConfig = hyperParameterTuningJobConfig;
            return this;
        }

        public final void setHyperParameterTuningJobConfig(HyperParameterTuningJobConfig.BuilderImpl hyperParameterTuningJobConfig) {
            this.hyperParameterTuningJobConfig = hyperParameterTuningJobConfig != null ? hyperParameterTuningJobConfig.build()
                    : null;
        }

        public final HyperParameterTrainingJobDefinition.Builder getTrainingJobDefinition() {
            return trainingJobDefinition != null ? trainingJobDefinition.toBuilder() : null;
        }

        @Override
        public final Builder trainingJobDefinition(HyperParameterTrainingJobDefinition trainingJobDefinition) {
            this.trainingJobDefinition = trainingJobDefinition;
            return this;
        }

        public final void setTrainingJobDefinition(HyperParameterTrainingJobDefinition.BuilderImpl trainingJobDefinition) {
            this.trainingJobDefinition = trainingJobDefinition != null ? trainingJobDefinition.build() : null;
        }

        public final String getHyperParameterTuningJobStatusAsString() {
            return hyperParameterTuningJobStatus;
        }

        @Override
        public final Builder hyperParameterTuningJobStatus(String hyperParameterTuningJobStatus) {
            this.hyperParameterTuningJobStatus = hyperParameterTuningJobStatus;
            return this;
        }

        @Override
        public final Builder hyperParameterTuningJobStatus(HyperParameterTuningJobStatus hyperParameterTuningJobStatus) {
            this.hyperParameterTuningJobStatus(hyperParameterTuningJobStatus == null ? null : hyperParameterTuningJobStatus
                    .toString());
            return this;
        }

        public final void setHyperParameterTuningJobStatus(String hyperParameterTuningJobStatus) {
            this.hyperParameterTuningJobStatus = hyperParameterTuningJobStatus;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getHyperParameterTuningEndTime() {
            return hyperParameterTuningEndTime;
        }

        @Override
        public final Builder hyperParameterTuningEndTime(Instant hyperParameterTuningEndTime) {
            this.hyperParameterTuningEndTime = hyperParameterTuningEndTime;
            return this;
        }

        public final void setHyperParameterTuningEndTime(Instant hyperParameterTuningEndTime) {
            this.hyperParameterTuningEndTime = hyperParameterTuningEndTime;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final TrainingJobStatusCounters.Builder getTrainingJobStatusCounters() {
            return trainingJobStatusCounters != null ? trainingJobStatusCounters.toBuilder() : null;
        }

        @Override
        public final Builder trainingJobStatusCounters(TrainingJobStatusCounters trainingJobStatusCounters) {
            this.trainingJobStatusCounters = trainingJobStatusCounters;
            return this;
        }

        public final void setTrainingJobStatusCounters(TrainingJobStatusCounters.BuilderImpl trainingJobStatusCounters) {
            this.trainingJobStatusCounters = trainingJobStatusCounters != null ? trainingJobStatusCounters.build() : null;
        }

        public final ObjectiveStatusCounters.Builder getObjectiveStatusCounters() {
            return objectiveStatusCounters != null ? objectiveStatusCounters.toBuilder() : null;
        }

        @Override
        public final Builder objectiveStatusCounters(ObjectiveStatusCounters objectiveStatusCounters) {
            this.objectiveStatusCounters = objectiveStatusCounters;
            return this;
        }

        public final void setObjectiveStatusCounters(ObjectiveStatusCounters.BuilderImpl objectiveStatusCounters) {
            this.objectiveStatusCounters = objectiveStatusCounters != null ? objectiveStatusCounters.build() : null;
        }

        public final HyperParameterTrainingJobSummary.Builder getBestTrainingJob() {
            return bestTrainingJob != null ? bestTrainingJob.toBuilder() : null;
        }

        @Override
        public final Builder bestTrainingJob(HyperParameterTrainingJobSummary bestTrainingJob) {
            this.bestTrainingJob = bestTrainingJob;
            return this;
        }

        public final void setBestTrainingJob(HyperParameterTrainingJobSummary.BuilderImpl bestTrainingJob) {
            this.bestTrainingJob = bestTrainingJob != null ? bestTrainingJob.build() : null;
        }

        public final HyperParameterTrainingJobSummary.Builder getOverallBestTrainingJob() {
            return overallBestTrainingJob != null ? overallBestTrainingJob.toBuilder() : null;
        }

        @Override
        public final Builder overallBestTrainingJob(HyperParameterTrainingJobSummary overallBestTrainingJob) {
            this.overallBestTrainingJob = overallBestTrainingJob;
            return this;
        }

        public final void setOverallBestTrainingJob(HyperParameterTrainingJobSummary.BuilderImpl overallBestTrainingJob) {
            this.overallBestTrainingJob = overallBestTrainingJob != null ? overallBestTrainingJob.build() : null;
        }

        public final HyperParameterTuningJobWarmStartConfig.Builder getWarmStartConfig() {
            return warmStartConfig != null ? warmStartConfig.toBuilder() : null;
        }

        @Override
        public final Builder warmStartConfig(HyperParameterTuningJobWarmStartConfig warmStartConfig) {
            this.warmStartConfig = warmStartConfig;
            return this;
        }

        public final void setWarmStartConfig(HyperParameterTuningJobWarmStartConfig.BuilderImpl warmStartConfig) {
            this.warmStartConfig = warmStartConfig != null ? warmStartConfig.build() : null;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public DescribeHyperParameterTuningJobResponse build() {
            return new DescribeHyperParameterTuningJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
