/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a file system data source for a channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileSystemDataSource implements SdkPojo, Serializable,
        ToCopyableBuilder<FileSystemDataSource.Builder, FileSystemDataSource> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FileSystemDataSource::fileSystemId)).setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()).build();

    private static final SdkField<String> FILE_SYSTEM_ACCESS_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FileSystemDataSource::fileSystemAccessModeAsString)).setter(setter(Builder::fileSystemAccessMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAccessMode").build())
            .build();

    private static final SdkField<String> FILE_SYSTEM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FileSystemDataSource::fileSystemTypeAsString)).setter(setter(Builder::fileSystemType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemType").build()).build();

    private static final SdkField<String> DIRECTORY_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FileSystemDataSource::directoryPath)).setter(setter(Builder::directoryPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD,
            FILE_SYSTEM_ACCESS_MODE_FIELD, FILE_SYSTEM_TYPE_FIELD, DIRECTORY_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fileSystemId;

    private final String fileSystemAccessMode;

    private final String fileSystemType;

    private final String directoryPath;

    private FileSystemDataSource(BuilderImpl builder) {
        this.fileSystemId = builder.fileSystemId;
        this.fileSystemAccessMode = builder.fileSystemAccessMode;
        this.fileSystemType = builder.fileSystemType;
        this.directoryPath = builder.directoryPath;
    }

    /**
     * <p>
     * The file system id.
     * </p>
     * 
     * @return The file system id.
     */
    public String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * The access mode of the mount of the directory associated with the channel. A directory can be mounted either in
     * <code>ro</code> (read-only) or <code>rw</code> (read-write) mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #fileSystemAccessMode} will return {@link FileSystemAccessMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #fileSystemAccessModeAsString}.
     * </p>
     * 
     * @return The access mode of the mount of the directory associated with the channel. A directory can be mounted
     *         either in <code>ro</code> (read-only) or <code>rw</code> (read-write) mode.
     * @see FileSystemAccessMode
     */
    public FileSystemAccessMode fileSystemAccessMode() {
        return FileSystemAccessMode.fromValue(fileSystemAccessMode);
    }

    /**
     * <p>
     * The access mode of the mount of the directory associated with the channel. A directory can be mounted either in
     * <code>ro</code> (read-only) or <code>rw</code> (read-write) mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #fileSystemAccessMode} will return {@link FileSystemAccessMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #fileSystemAccessModeAsString}.
     * </p>
     * 
     * @return The access mode of the mount of the directory associated with the channel. A directory can be mounted
     *         either in <code>ro</code> (read-only) or <code>rw</code> (read-write) mode.
     * @see FileSystemAccessMode
     */
    public String fileSystemAccessModeAsString() {
        return fileSystemAccessMode;
    }

    /**
     * <p>
     * The file system type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileSystemType}
     * will return {@link FileSystemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fileSystemTypeAsString}.
     * </p>
     * 
     * @return The file system type.
     * @see FileSystemType
     */
    public FileSystemType fileSystemType() {
        return FileSystemType.fromValue(fileSystemType);
    }

    /**
     * <p>
     * The file system type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileSystemType}
     * will return {@link FileSystemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fileSystemTypeAsString}.
     * </p>
     * 
     * @return The file system type.
     * @see FileSystemType
     */
    public String fileSystemTypeAsString() {
        return fileSystemType;
    }

    /**
     * <p>
     * The full path to the directory to associate with the channel.
     * </p>
     * 
     * @return The full path to the directory to associate with the channel.
     */
    public String directoryPath() {
        return directoryPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemAccessModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(directoryPath());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSystemDataSource)) {
            return false;
        }
        FileSystemDataSource other = (FileSystemDataSource) obj;
        return Objects.equals(fileSystemId(), other.fileSystemId())
                && Objects.equals(fileSystemAccessModeAsString(), other.fileSystemAccessModeAsString())
                && Objects.equals(fileSystemTypeAsString(), other.fileSystemTypeAsString())
                && Objects.equals(directoryPath(), other.directoryPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FileSystemDataSource").add("FileSystemId", fileSystemId())
                .add("FileSystemAccessMode", fileSystemAccessModeAsString()).add("FileSystemType", fileSystemTypeAsString())
                .add("DirectoryPath", directoryPath()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "FileSystemAccessMode":
            return Optional.ofNullable(clazz.cast(fileSystemAccessModeAsString()));
        case "FileSystemType":
            return Optional.ofNullable(clazz.cast(fileSystemTypeAsString()));
        case "DirectoryPath":
            return Optional.ofNullable(clazz.cast(directoryPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileSystemDataSource, T> g) {
        return obj -> g.apply((FileSystemDataSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileSystemDataSource> {
        /**
         * <p>
         * The file system id.
         * </p>
         * 
         * @param fileSystemId
         *        The file system id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * The access mode of the mount of the directory associated with the channel. A directory can be mounted either
         * in <code>ro</code> (read-only) or <code>rw</code> (read-write) mode.
         * </p>
         * 
         * @param fileSystemAccessMode
         *        The access mode of the mount of the directory associated with the channel. A directory can be mounted
         *        either in <code>ro</code> (read-only) or <code>rw</code> (read-write) mode.
         * @see FileSystemAccessMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileSystemAccessMode
         */
        Builder fileSystemAccessMode(String fileSystemAccessMode);

        /**
         * <p>
         * The access mode of the mount of the directory associated with the channel. A directory can be mounted either
         * in <code>ro</code> (read-only) or <code>rw</code> (read-write) mode.
         * </p>
         * 
         * @param fileSystemAccessMode
         *        The access mode of the mount of the directory associated with the channel. A directory can be mounted
         *        either in <code>ro</code> (read-only) or <code>rw</code> (read-write) mode.
         * @see FileSystemAccessMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileSystemAccessMode
         */
        Builder fileSystemAccessMode(FileSystemAccessMode fileSystemAccessMode);

        /**
         * <p>
         * The file system type.
         * </p>
         * 
         * @param fileSystemType
         *        The file system type.
         * @see FileSystemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileSystemType
         */
        Builder fileSystemType(String fileSystemType);

        /**
         * <p>
         * The file system type.
         * </p>
         * 
         * @param fileSystemType
         *        The file system type.
         * @see FileSystemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileSystemType
         */
        Builder fileSystemType(FileSystemType fileSystemType);

        /**
         * <p>
         * The full path to the directory to associate with the channel.
         * </p>
         * 
         * @param directoryPath
         *        The full path to the directory to associate with the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryPath(String directoryPath);
    }

    static final class BuilderImpl implements Builder {
        private String fileSystemId;

        private String fileSystemAccessMode;

        private String fileSystemType;

        private String directoryPath;

        private BuilderImpl() {
        }

        private BuilderImpl(FileSystemDataSource model) {
            fileSystemId(model.fileSystemId);
            fileSystemAccessMode(model.fileSystemAccessMode);
            fileSystemType(model.fileSystemType);
            directoryPath(model.directoryPath);
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final String getFileSystemAccessModeAsString() {
            return fileSystemAccessMode;
        }

        @Override
        public final Builder fileSystemAccessMode(String fileSystemAccessMode) {
            this.fileSystemAccessMode = fileSystemAccessMode;
            return this;
        }

        @Override
        public final Builder fileSystemAccessMode(FileSystemAccessMode fileSystemAccessMode) {
            this.fileSystemAccessMode(fileSystemAccessMode == null ? null : fileSystemAccessMode.toString());
            return this;
        }

        public final void setFileSystemAccessMode(String fileSystemAccessMode) {
            this.fileSystemAccessMode = fileSystemAccessMode;
        }

        public final String getFileSystemTypeAsString() {
            return fileSystemType;
        }

        @Override
        public final Builder fileSystemType(String fileSystemType) {
            this.fileSystemType = fileSystemType;
            return this;
        }

        @Override
        public final Builder fileSystemType(FileSystemType fileSystemType) {
            this.fileSystemType(fileSystemType == null ? null : fileSystemType.toString());
            return this;
        }

        public final void setFileSystemType(String fileSystemType) {
            this.fileSystemType = fileSystemType;
        }

        public final String getDirectoryPath() {
            return directoryPath;
        }

        @Override
        public final Builder directoryPath(String directoryPath) {
            this.directoryPath = directoryPath;
            return this;
        }

        public final void setDirectoryPath(String directoryPath) {
            this.directoryPath = directoryPath;
        }

        @Override
        public FileSystemDataSource build() {
            return new FileSystemDataSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
