/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information required for human workers to complete a labeling task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HumanTaskConfig implements SdkPojo, Serializable, ToCopyableBuilder<HumanTaskConfig.Builder, HumanTaskConfig> {
    private static final SdkField<String> WORKTEAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HumanTaskConfig::workteamArn)).setter(setter(Builder::workteamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkteamArn").build()).build();

    private static final SdkField<UiConfig> UI_CONFIG_FIELD = SdkField.<UiConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(HumanTaskConfig::uiConfig)).setter(setter(Builder::uiConfig)).constructor(UiConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UiConfig").build()).build();

    private static final SdkField<String> PRE_HUMAN_TASK_LAMBDA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HumanTaskConfig::preHumanTaskLambdaArn)).setter(setter(Builder::preHumanTaskLambdaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreHumanTaskLambdaArn").build())
            .build();

    private static final SdkField<List<String>> TASK_KEYWORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(HumanTaskConfig::taskKeywords))
            .setter(setter(Builder::taskKeywords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskKeywords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TASK_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HumanTaskConfig::taskTitle)).setter(setter(Builder::taskTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskTitle").build()).build();

    private static final SdkField<String> TASK_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HumanTaskConfig::taskDescription)).setter(setter(Builder::taskDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskDescription").build()).build();

    private static final SdkField<Integer> NUMBER_OF_HUMAN_WORKERS_PER_DATA_OBJECT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HumanTaskConfig::numberOfHumanWorkersPerDataObject))
            .setter(setter(Builder::numberOfHumanWorkersPerDataObject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfHumanWorkersPerDataObject")
                    .build()).build();

    private static final SdkField<Integer> TASK_TIME_LIMIT_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HumanTaskConfig::taskTimeLimitInSeconds)).setter(setter(Builder::taskTimeLimitInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskTimeLimitInSeconds").build())
            .build();

    private static final SdkField<Integer> TASK_AVAILABILITY_LIFETIME_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HumanTaskConfig::taskAvailabilityLifetimeInSeconds))
            .setter(setter(Builder::taskAvailabilityLifetimeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskAvailabilityLifetimeInSeconds")
                    .build()).build();

    private static final SdkField<Integer> MAX_CONCURRENT_TASK_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HumanTaskConfig::maxConcurrentTaskCount)).setter(setter(Builder::maxConcurrentTaskCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrentTaskCount").build())
            .build();

    private static final SdkField<AnnotationConsolidationConfig> ANNOTATION_CONSOLIDATION_CONFIG_FIELD = SdkField
            .<AnnotationConsolidationConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(HumanTaskConfig::annotationConsolidationConfig))
            .setter(setter(Builder::annotationConsolidationConfig))
            .constructor(AnnotationConsolidationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnnotationConsolidationConfig")
                    .build()).build();

    private static final SdkField<PublicWorkforceTaskPrice> PUBLIC_WORKFORCE_TASK_PRICE_FIELD = SdkField
            .<PublicWorkforceTaskPrice> builder(MarshallingType.SDK_POJO)
            .getter(getter(HumanTaskConfig::publicWorkforceTaskPrice)).setter(setter(Builder::publicWorkforceTaskPrice))
            .constructor(PublicWorkforceTaskPrice::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicWorkforceTaskPrice").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKTEAM_ARN_FIELD,
            UI_CONFIG_FIELD, PRE_HUMAN_TASK_LAMBDA_ARN_FIELD, TASK_KEYWORDS_FIELD, TASK_TITLE_FIELD, TASK_DESCRIPTION_FIELD,
            NUMBER_OF_HUMAN_WORKERS_PER_DATA_OBJECT_FIELD, TASK_TIME_LIMIT_IN_SECONDS_FIELD,
            TASK_AVAILABILITY_LIFETIME_IN_SECONDS_FIELD, MAX_CONCURRENT_TASK_COUNT_FIELD, ANNOTATION_CONSOLIDATION_CONFIG_FIELD,
            PUBLIC_WORKFORCE_TASK_PRICE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String workteamArn;

    private final UiConfig uiConfig;

    private final String preHumanTaskLambdaArn;

    private final List<String> taskKeywords;

    private final String taskTitle;

    private final String taskDescription;

    private final Integer numberOfHumanWorkersPerDataObject;

    private final Integer taskTimeLimitInSeconds;

    private final Integer taskAvailabilityLifetimeInSeconds;

    private final Integer maxConcurrentTaskCount;

    private final AnnotationConsolidationConfig annotationConsolidationConfig;

    private final PublicWorkforceTaskPrice publicWorkforceTaskPrice;

    private HumanTaskConfig(BuilderImpl builder) {
        this.workteamArn = builder.workteamArn;
        this.uiConfig = builder.uiConfig;
        this.preHumanTaskLambdaArn = builder.preHumanTaskLambdaArn;
        this.taskKeywords = builder.taskKeywords;
        this.taskTitle = builder.taskTitle;
        this.taskDescription = builder.taskDescription;
        this.numberOfHumanWorkersPerDataObject = builder.numberOfHumanWorkersPerDataObject;
        this.taskTimeLimitInSeconds = builder.taskTimeLimitInSeconds;
        this.taskAvailabilityLifetimeInSeconds = builder.taskAvailabilityLifetimeInSeconds;
        this.maxConcurrentTaskCount = builder.maxConcurrentTaskCount;
        this.annotationConsolidationConfig = builder.annotationConsolidationConfig;
        this.publicWorkforceTaskPrice = builder.publicWorkforceTaskPrice;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the work team assigned to complete the tasks.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the work team assigned to complete the tasks.
     */
    public String workteamArn() {
        return workteamArn;
    }

    /**
     * <p>
     * Information about the user interface that workers use to complete the labeling task.
     * </p>
     * 
     * @return Information about the user interface that workers use to complete the labeling task.
     */
    public UiConfig uiConfig() {
        return uiConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a Lambda function that is run before a data object is sent to a human worker.
     * Use this function to provide input to a custom labeling job.
     * </p>
     * <p>
     * For the built-in bounding box, image classification, semantic segmentation, and text classification task types,
     * Amazon SageMaker Ground Truth provides the following Lambda functions:
     * </p>
     * <p>
     * <b>US East (Northern Virginia) (us-east-1):</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-BoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-SemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-NamedEntityRecognition</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>US East (Ohio) (us-east-2):</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-BoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-SemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-NamedEntityRecognition</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>US West (Oregon) (us-west-2):</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-BoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-SemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-NamedEntityRecognition</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Canada (Central) (ca-central-1):</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:awslambda:ca-central-1:918755190332:function:PRE-BoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:awslambda:ca-central-1:918755190332:function:PRE-ImageMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:awslambda:ca-central-1:918755190332:function:PRE-SemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:awslambda:ca-central-1:918755190332:function:PRE-TextMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:awslambda:ca-central-1:918755190332:function:PRE-NamedEntityRecognition</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>EU (Ireland) (eu-west-1):</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-BoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-SemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-NamedEntityRecognition</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>EU (London) (eu-west-2):</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:awslambda:eu-west-2:487402164563:function:PRE-BoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:awslambda:eu-west-2:487402164563:function:PRE-ImageMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:awslambda:eu-west-2:487402164563:function:PRE-SemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:awslambda:eu-west-2:487402164563:function:PRE-TextMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:awslambda:eu-west-2:487402164563:function:PRE-NamedEntityRecognition</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>EU Frankfurt (eu-central-1):</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:awslambda:eu-central-1:203001061592:function:PRE-BoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:awslambda:eu-central-1:203001061592:function:PRE-ImageMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:awslambda:eu-central-1:203001061592:function:PRE-SemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:awslambda:eu-central-1:203001061592:function:PRE-TextMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:awslambda:eu-central-1:203001061592:function:PRE-NamedEntityRecognition</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Asia Pacific (Tokyo) (ap-northeast-1):</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-BoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-SemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-NamedEntityRecognition</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Asia Pacific (Seoul) (ap-northeast-2):</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:awslambda:ap-northeast-2:845288260483:function:PRE-BoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:awslambda:ap-northeast-2:845288260483:function:PRE-ImageMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:awslambda:ap-northeast-2:845288260483:function:PRE-SemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:awslambda:ap-northeast-2:845288260483:function:PRE-TextMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:awslambda:ap-northeast-2:845288260483:function:PRE-NamedEntityRecognition</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Asia Pacific (Mumbai) (ap-south-1):</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:awslambda:ap-south-1:565803892007:function:PRE-BoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:awslambda:ap-south-1:565803892007:function:PRE-ImageMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:awslambda:ap-south-1:565803892007:function:PRE-SemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:awslambda:ap-south-1:565803892007:function:PRE-TextMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:awslambda:ap-south-1:565803892007:function:PRE-NamedEntityRecognition</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Asia Pacific (Singapore) (ap-southeast-1):</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:awslambda:ap-southeast-1:377565633583:function:PRE-BoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:awslambda:ap-southeast-1:377565633583:function:PRE-ImageMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:awslambda:ap-southeast-1:377565633583:function:PRE-SemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:awslambda:ap-southeast-1:377565633583:function:PRE-TextMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:awslambda:ap-southeast-1:377565633583:function:PRE-NamedEntityRecognition</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Asia Pacific (Sydney) (ap-southeast-2):</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-BoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-SemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-NamedEntityRecognition</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) of a Lambda function that is run before a data object is sent to a human
     *         worker. Use this function to provide input to a custom labeling job.</p>
     *         <p>
     *         For the built-in bounding box, image classification, semantic segmentation, and text classification task
     *         types, Amazon SageMaker Ground Truth provides the following Lambda functions:
     *         </p>
     *         <p>
     *         <b>US East (Northern Virginia) (us-east-1):</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-BoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-SemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-NamedEntityRecognition</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>US East (Ohio) (us-east-2):</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-BoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-SemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-NamedEntityRecognition</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>US West (Oregon) (us-west-2):</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-BoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-SemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-NamedEntityRecognition</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Canada (Central) (ca-central-1):</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:ca-central-1:918755190332:function:PRE-BoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:ca-central-1:918755190332:function:PRE-ImageMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:ca-central-1:918755190332:function:PRE-SemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:ca-central-1:918755190332:function:PRE-TextMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:ca-central-1:918755190332:function:PRE-NamedEntityRecognition</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>EU (Ireland) (eu-west-1):</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-BoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-SemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-NamedEntityRecognition</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>EU (London) (eu-west-2):</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:eu-west-2:487402164563:function:PRE-BoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:eu-west-2:487402164563:function:PRE-ImageMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:eu-west-2:487402164563:function:PRE-SemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:eu-west-2:487402164563:function:PRE-TextMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:eu-west-2:487402164563:function:PRE-NamedEntityRecognition</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>EU Frankfurt (eu-central-1):</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:eu-central-1:203001061592:function:PRE-BoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:eu-central-1:203001061592:function:PRE-ImageMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:eu-central-1:203001061592:function:PRE-SemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:eu-central-1:203001061592:function:PRE-TextMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:eu-central-1:203001061592:function:PRE-NamedEntityRecognition</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Asia Pacific (Tokyo) (ap-northeast-1):</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-BoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-SemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-NamedEntityRecognition</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Asia Pacific (Seoul) (ap-northeast-2):</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:ap-northeast-2:845288260483:function:PRE-BoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:ap-northeast-2:845288260483:function:PRE-ImageMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:ap-northeast-2:845288260483:function:PRE-SemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:ap-northeast-2:845288260483:function:PRE-TextMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:ap-northeast-2:845288260483:function:PRE-NamedEntityRecognition</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Asia Pacific (Mumbai) (ap-south-1):</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:ap-south-1:565803892007:function:PRE-BoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:ap-south-1:565803892007:function:PRE-ImageMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:ap-south-1:565803892007:function:PRE-SemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:ap-south-1:565803892007:function:PRE-TextMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:ap-south-1:565803892007:function:PRE-NamedEntityRecognition</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Asia Pacific (Singapore) (ap-southeast-1):</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:ap-southeast-1:377565633583:function:PRE-BoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:ap-southeast-1:377565633583:function:PRE-ImageMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:ap-southeast-1:377565633583:function:PRE-SemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:ap-southeast-1:377565633583:function:PRE-TextMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:awslambda:ap-southeast-1:377565633583:function:PRE-NamedEntityRecognition</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Asia Pacific (Sydney) (ap-southeast-2):</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-BoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-SemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-NamedEntityRecognition</code>
     *         </p>
     *         </li>
     */
    public String preHumanTaskLambdaArn() {
        return preHumanTaskLambdaArn;
    }

    /**
     * <p>
     * Keywords used to describe the task so that workers on Amazon Mechanical Turk can discover the task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Keywords used to describe the task so that workers on Amazon Mechanical Turk can discover the task.
     */
    public List<String> taskKeywords() {
        return taskKeywords;
    }

    /**
     * <p>
     * A title for the task for your human workers.
     * </p>
     * 
     * @return A title for the task for your human workers.
     */
    public String taskTitle() {
        return taskTitle;
    }

    /**
     * <p>
     * A description of the task for your human workers.
     * </p>
     * 
     * @return A description of the task for your human workers.
     */
    public String taskDescription() {
        return taskDescription;
    }

    /**
     * <p>
     * The number of human workers that will label an object.
     * </p>
     * 
     * @return The number of human workers that will label an object.
     */
    public Integer numberOfHumanWorkersPerDataObject() {
        return numberOfHumanWorkersPerDataObject;
    }

    /**
     * <p>
     * The amount of time that a worker has to complete a task.
     * </p>
     * 
     * @return The amount of time that a worker has to complete a task.
     */
    public Integer taskTimeLimitInSeconds() {
        return taskTimeLimitInSeconds;
    }

    /**
     * <p>
     * The length of time that a task remains available for labeling by human workers. <b>If you choose the Amazon
     * Mechanical Turk workforce, the maximum is 12 hours (43200)</b>. For private and vendor workforces, the maximum is
     * as listed.
     * </p>
     * 
     * @return The length of time that a task remains available for labeling by human workers. <b>If you choose the
     *         Amazon Mechanical Turk workforce, the maximum is 12 hours (43200)</b>. For private and vendor workforces,
     *         the maximum is as listed.
     */
    public Integer taskAvailabilityLifetimeInSeconds() {
        return taskAvailabilityLifetimeInSeconds;
    }

    /**
     * <p>
     * Defines the maximum number of data objects that can be labeled by human workers at the same time. Each object may
     * have more than one worker at one time.
     * </p>
     * 
     * @return Defines the maximum number of data objects that can be labeled by human workers at the same time. Each
     *         object may have more than one worker at one time.
     */
    public Integer maxConcurrentTaskCount() {
        return maxConcurrentTaskCount;
    }

    /**
     * <p>
     * Configures how labels are consolidated across human workers.
     * </p>
     * 
     * @return Configures how labels are consolidated across human workers.
     */
    public AnnotationConsolidationConfig annotationConsolidationConfig() {
        return annotationConsolidationConfig;
    }

    /**
     * <p>
     * The price that you pay for each task performed by an Amazon Mechanical Turk worker.
     * </p>
     * 
     * @return The price that you pay for each task performed by an Amazon Mechanical Turk worker.
     */
    public PublicWorkforceTaskPrice publicWorkforceTaskPrice() {
        return publicWorkforceTaskPrice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workteamArn());
        hashCode = 31 * hashCode + Objects.hashCode(uiConfig());
        hashCode = 31 * hashCode + Objects.hashCode(preHumanTaskLambdaArn());
        hashCode = 31 * hashCode + Objects.hashCode(taskKeywords());
        hashCode = 31 * hashCode + Objects.hashCode(taskTitle());
        hashCode = 31 * hashCode + Objects.hashCode(taskDescription());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfHumanWorkersPerDataObject());
        hashCode = 31 * hashCode + Objects.hashCode(taskTimeLimitInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(taskAvailabilityLifetimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrentTaskCount());
        hashCode = 31 * hashCode + Objects.hashCode(annotationConsolidationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(publicWorkforceTaskPrice());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanTaskConfig)) {
            return false;
        }
        HumanTaskConfig other = (HumanTaskConfig) obj;
        return Objects.equals(workteamArn(), other.workteamArn()) && Objects.equals(uiConfig(), other.uiConfig())
                && Objects.equals(preHumanTaskLambdaArn(), other.preHumanTaskLambdaArn())
                && Objects.equals(taskKeywords(), other.taskKeywords()) && Objects.equals(taskTitle(), other.taskTitle())
                && Objects.equals(taskDescription(), other.taskDescription())
                && Objects.equals(numberOfHumanWorkersPerDataObject(), other.numberOfHumanWorkersPerDataObject())
                && Objects.equals(taskTimeLimitInSeconds(), other.taskTimeLimitInSeconds())
                && Objects.equals(taskAvailabilityLifetimeInSeconds(), other.taskAvailabilityLifetimeInSeconds())
                && Objects.equals(maxConcurrentTaskCount(), other.maxConcurrentTaskCount())
                && Objects.equals(annotationConsolidationConfig(), other.annotationConsolidationConfig())
                && Objects.equals(publicWorkforceTaskPrice(), other.publicWorkforceTaskPrice());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HumanTaskConfig").add("WorkteamArn", workteamArn()).add("UiConfig", uiConfig())
                .add("PreHumanTaskLambdaArn", preHumanTaskLambdaArn()).add("TaskKeywords", taskKeywords())
                .add("TaskTitle", taskTitle()).add("TaskDescription", taskDescription())
                .add("NumberOfHumanWorkersPerDataObject", numberOfHumanWorkersPerDataObject())
                .add("TaskTimeLimitInSeconds", taskTimeLimitInSeconds())
                .add("TaskAvailabilityLifetimeInSeconds", taskAvailabilityLifetimeInSeconds())
                .add("MaxConcurrentTaskCount", maxConcurrentTaskCount())
                .add("AnnotationConsolidationConfig", annotationConsolidationConfig())
                .add("PublicWorkforceTaskPrice", publicWorkforceTaskPrice()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkteamArn":
            return Optional.ofNullable(clazz.cast(workteamArn()));
        case "UiConfig":
            return Optional.ofNullable(clazz.cast(uiConfig()));
        case "PreHumanTaskLambdaArn":
            return Optional.ofNullable(clazz.cast(preHumanTaskLambdaArn()));
        case "TaskKeywords":
            return Optional.ofNullable(clazz.cast(taskKeywords()));
        case "TaskTitle":
            return Optional.ofNullable(clazz.cast(taskTitle()));
        case "TaskDescription":
            return Optional.ofNullable(clazz.cast(taskDescription()));
        case "NumberOfHumanWorkersPerDataObject":
            return Optional.ofNullable(clazz.cast(numberOfHumanWorkersPerDataObject()));
        case "TaskTimeLimitInSeconds":
            return Optional.ofNullable(clazz.cast(taskTimeLimitInSeconds()));
        case "TaskAvailabilityLifetimeInSeconds":
            return Optional.ofNullable(clazz.cast(taskAvailabilityLifetimeInSeconds()));
        case "MaxConcurrentTaskCount":
            return Optional.ofNullable(clazz.cast(maxConcurrentTaskCount()));
        case "AnnotationConsolidationConfig":
            return Optional.ofNullable(clazz.cast(annotationConsolidationConfig()));
        case "PublicWorkforceTaskPrice":
            return Optional.ofNullable(clazz.cast(publicWorkforceTaskPrice()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HumanTaskConfig, T> g) {
        return obj -> g.apply((HumanTaskConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HumanTaskConfig> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the work team assigned to complete the tasks.
         * </p>
         * 
         * @param workteamArn
         *        The Amazon Resource Name (ARN) of the work team assigned to complete the tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workteamArn(String workteamArn);

        /**
         * <p>
         * Information about the user interface that workers use to complete the labeling task.
         * </p>
         * 
         * @param uiConfig
         *        Information about the user interface that workers use to complete the labeling task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uiConfig(UiConfig uiConfig);

        /**
         * <p>
         * Information about the user interface that workers use to complete the labeling task.
         * </p>
         * This is a convenience that creates an instance of the {@link UiConfig.Builder} avoiding the need to create
         * one manually via {@link UiConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link UiConfig.Builder#build()} is called immediately and its result is
         * passed to {@link #uiConfig(UiConfig)}.
         * 
         * @param uiConfig
         *        a consumer that will call methods on {@link UiConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uiConfig(UiConfig)
         */
        default Builder uiConfig(Consumer<UiConfig.Builder> uiConfig) {
            return uiConfig(UiConfig.builder().applyMutation(uiConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a Lambda function that is run before a data object is sent to a human
         * worker. Use this function to provide input to a custom labeling job.
         * </p>
         * <p>
         * For the built-in bounding box, image classification, semantic segmentation, and text classification task
         * types, Amazon SageMaker Ground Truth provides the following Lambda functions:
         * </p>
         * <p>
         * <b>US East (Northern Virginia) (us-east-1):</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-BoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-SemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-NamedEntityRecognition</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>US East (Ohio) (us-east-2):</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-BoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-SemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-NamedEntityRecognition</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>US West (Oregon) (us-west-2):</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-BoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-SemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-NamedEntityRecognition</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Canada (Central) (ca-central-1):</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:awslambda:ca-central-1:918755190332:function:PRE-BoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:awslambda:ca-central-1:918755190332:function:PRE-ImageMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:awslambda:ca-central-1:918755190332:function:PRE-SemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:awslambda:ca-central-1:918755190332:function:PRE-TextMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:awslambda:ca-central-1:918755190332:function:PRE-NamedEntityRecognition</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>EU (Ireland) (eu-west-1):</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-BoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-SemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-NamedEntityRecognition</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>EU (London) (eu-west-2):</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:awslambda:eu-west-2:487402164563:function:PRE-BoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:awslambda:eu-west-2:487402164563:function:PRE-ImageMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:awslambda:eu-west-2:487402164563:function:PRE-SemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:awslambda:eu-west-2:487402164563:function:PRE-TextMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:awslambda:eu-west-2:487402164563:function:PRE-NamedEntityRecognition</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>EU Frankfurt (eu-central-1):</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:awslambda:eu-central-1:203001061592:function:PRE-BoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:awslambda:eu-central-1:203001061592:function:PRE-ImageMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:awslambda:eu-central-1:203001061592:function:PRE-SemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:awslambda:eu-central-1:203001061592:function:PRE-TextMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:awslambda:eu-central-1:203001061592:function:PRE-NamedEntityRecognition</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Asia Pacific (Tokyo) (ap-northeast-1):</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-BoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-SemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-NamedEntityRecognition</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Asia Pacific (Seoul) (ap-northeast-2):</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:awslambda:ap-northeast-2:845288260483:function:PRE-BoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:awslambda:ap-northeast-2:845288260483:function:PRE-ImageMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:awslambda:ap-northeast-2:845288260483:function:PRE-SemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:awslambda:ap-northeast-2:845288260483:function:PRE-TextMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:awslambda:ap-northeast-2:845288260483:function:PRE-NamedEntityRecognition</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Asia Pacific (Mumbai) (ap-south-1):</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:awslambda:ap-south-1:565803892007:function:PRE-BoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:awslambda:ap-south-1:565803892007:function:PRE-ImageMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:awslambda:ap-south-1:565803892007:function:PRE-SemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:awslambda:ap-south-1:565803892007:function:PRE-TextMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:awslambda:ap-south-1:565803892007:function:PRE-NamedEntityRecognition</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Asia Pacific (Singapore) (ap-southeast-1):</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:awslambda:ap-southeast-1:377565633583:function:PRE-BoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:awslambda:ap-southeast-1:377565633583:function:PRE-ImageMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:awslambda:ap-southeast-1:377565633583:function:PRE-SemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:awslambda:ap-southeast-1:377565633583:function:PRE-TextMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:awslambda:ap-southeast-1:377565633583:function:PRE-NamedEntityRecognition</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Asia Pacific (Sydney) (ap-southeast-2):</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-BoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-SemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-NamedEntityRecognition</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param preHumanTaskLambdaArn
         *        The Amazon Resource Name (ARN) of a Lambda function that is run before a data object is sent to a
         *        human worker. Use this function to provide input to a custom labeling job.</p>
         *        <p>
         *        For the built-in bounding box, image classification, semantic segmentation, and text classification
         *        task types, Amazon SageMaker Ground Truth provides the following Lambda functions:
         *        </p>
         *        <p>
         *        <b>US East (Northern Virginia) (us-east-1):</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-BoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-SemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-NamedEntityRecognition</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>US East (Ohio) (us-east-2):</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-BoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-SemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-NamedEntityRecognition</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>US West (Oregon) (us-west-2):</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-BoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-SemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-NamedEntityRecognition</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Canada (Central) (ca-central-1):</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:ca-central-1:918755190332:function:PRE-BoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:ca-central-1:918755190332:function:PRE-ImageMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:ca-central-1:918755190332:function:PRE-SemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:ca-central-1:918755190332:function:PRE-TextMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:ca-central-1:918755190332:function:PRE-NamedEntityRecognition</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>EU (Ireland) (eu-west-1):</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-BoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-SemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-NamedEntityRecognition</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>EU (London) (eu-west-2):</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:eu-west-2:487402164563:function:PRE-BoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:eu-west-2:487402164563:function:PRE-ImageMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:eu-west-2:487402164563:function:PRE-SemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:eu-west-2:487402164563:function:PRE-TextMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:eu-west-2:487402164563:function:PRE-NamedEntityRecognition</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>EU Frankfurt (eu-central-1):</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:eu-central-1:203001061592:function:PRE-BoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:eu-central-1:203001061592:function:PRE-ImageMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:eu-central-1:203001061592:function:PRE-SemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:eu-central-1:203001061592:function:PRE-TextMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:eu-central-1:203001061592:function:PRE-NamedEntityRecognition</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Asia Pacific (Tokyo) (ap-northeast-1):</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-BoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-SemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-NamedEntityRecognition</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Asia Pacific (Seoul) (ap-northeast-2):</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:ap-northeast-2:845288260483:function:PRE-BoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:ap-northeast-2:845288260483:function:PRE-ImageMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:ap-northeast-2:845288260483:function:PRE-SemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:ap-northeast-2:845288260483:function:PRE-TextMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:ap-northeast-2:845288260483:function:PRE-NamedEntityRecognition</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Asia Pacific (Mumbai) (ap-south-1):</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:ap-south-1:565803892007:function:PRE-BoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:ap-south-1:565803892007:function:PRE-ImageMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:ap-south-1:565803892007:function:PRE-SemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:ap-south-1:565803892007:function:PRE-TextMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:ap-south-1:565803892007:function:PRE-NamedEntityRecognition</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Asia Pacific (Singapore) (ap-southeast-1):</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:ap-southeast-1:377565633583:function:PRE-BoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:ap-southeast-1:377565633583:function:PRE-ImageMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:ap-southeast-1:377565633583:function:PRE-SemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:ap-southeast-1:377565633583:function:PRE-TextMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:awslambda:ap-southeast-1:377565633583:function:PRE-NamedEntityRecognition</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Asia Pacific (Sydney) (ap-southeast-2):</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-BoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-SemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-NamedEntityRecognition</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preHumanTaskLambdaArn(String preHumanTaskLambdaArn);

        /**
         * <p>
         * Keywords used to describe the task so that workers on Amazon Mechanical Turk can discover the task.
         * </p>
         * 
         * @param taskKeywords
         *        Keywords used to describe the task so that workers on Amazon Mechanical Turk can discover the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskKeywords(Collection<String> taskKeywords);

        /**
         * <p>
         * Keywords used to describe the task so that workers on Amazon Mechanical Turk can discover the task.
         * </p>
         * 
         * @param taskKeywords
         *        Keywords used to describe the task so that workers on Amazon Mechanical Turk can discover the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskKeywords(String... taskKeywords);

        /**
         * <p>
         * A title for the task for your human workers.
         * </p>
         * 
         * @param taskTitle
         *        A title for the task for your human workers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskTitle(String taskTitle);

        /**
         * <p>
         * A description of the task for your human workers.
         * </p>
         * 
         * @param taskDescription
         *        A description of the task for your human workers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskDescription(String taskDescription);

        /**
         * <p>
         * The number of human workers that will label an object.
         * </p>
         * 
         * @param numberOfHumanWorkersPerDataObject
         *        The number of human workers that will label an object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfHumanWorkersPerDataObject(Integer numberOfHumanWorkersPerDataObject);

        /**
         * <p>
         * The amount of time that a worker has to complete a task.
         * </p>
         * 
         * @param taskTimeLimitInSeconds
         *        The amount of time that a worker has to complete a task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskTimeLimitInSeconds(Integer taskTimeLimitInSeconds);

        /**
         * <p>
         * The length of time that a task remains available for labeling by human workers. <b>If you choose the Amazon
         * Mechanical Turk workforce, the maximum is 12 hours (43200)</b>. For private and vendor workforces, the
         * maximum is as listed.
         * </p>
         * 
         * @param taskAvailabilityLifetimeInSeconds
         *        The length of time that a task remains available for labeling by human workers. <b>If you choose the
         *        Amazon Mechanical Turk workforce, the maximum is 12 hours (43200)</b>. For private and vendor
         *        workforces, the maximum is as listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskAvailabilityLifetimeInSeconds(Integer taskAvailabilityLifetimeInSeconds);

        /**
         * <p>
         * Defines the maximum number of data objects that can be labeled by human workers at the same time. Each object
         * may have more than one worker at one time.
         * </p>
         * 
         * @param maxConcurrentTaskCount
         *        Defines the maximum number of data objects that can be labeled by human workers at the same time. Each
         *        object may have more than one worker at one time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrentTaskCount(Integer maxConcurrentTaskCount);

        /**
         * <p>
         * Configures how labels are consolidated across human workers.
         * </p>
         * 
         * @param annotationConsolidationConfig
         *        Configures how labels are consolidated across human workers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotationConsolidationConfig(AnnotationConsolidationConfig annotationConsolidationConfig);

        /**
         * <p>
         * Configures how labels are consolidated across human workers.
         * </p>
         * This is a convenience that creates an instance of the {@link AnnotationConsolidationConfig.Builder} avoiding
         * the need to create one manually via {@link AnnotationConsolidationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnnotationConsolidationConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #annotationConsolidationConfig(AnnotationConsolidationConfig)}
         * .
         * 
         * @param annotationConsolidationConfig
         *        a consumer that will call methods on {@link AnnotationConsolidationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #annotationConsolidationConfig(AnnotationConsolidationConfig)
         */
        default Builder annotationConsolidationConfig(
                Consumer<AnnotationConsolidationConfig.Builder> annotationConsolidationConfig) {
            return annotationConsolidationConfig(AnnotationConsolidationConfig.builder()
                    .applyMutation(annotationConsolidationConfig).build());
        }

        /**
         * <p>
         * The price that you pay for each task performed by an Amazon Mechanical Turk worker.
         * </p>
         * 
         * @param publicWorkforceTaskPrice
         *        The price that you pay for each task performed by an Amazon Mechanical Turk worker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicWorkforceTaskPrice(PublicWorkforceTaskPrice publicWorkforceTaskPrice);

        /**
         * <p>
         * The price that you pay for each task performed by an Amazon Mechanical Turk worker.
         * </p>
         * This is a convenience that creates an instance of the {@link PublicWorkforceTaskPrice.Builder} avoiding the
         * need to create one manually via {@link PublicWorkforceTaskPrice#builder()}.
         *
         * When the {@link Consumer} completes, {@link PublicWorkforceTaskPrice.Builder#build()} is called immediately
         * and its result is passed to {@link #publicWorkforceTaskPrice(PublicWorkforceTaskPrice)}.
         * 
         * @param publicWorkforceTaskPrice
         *        a consumer that will call methods on {@link PublicWorkforceTaskPrice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publicWorkforceTaskPrice(PublicWorkforceTaskPrice)
         */
        default Builder publicWorkforceTaskPrice(Consumer<PublicWorkforceTaskPrice.Builder> publicWorkforceTaskPrice) {
            return publicWorkforceTaskPrice(PublicWorkforceTaskPrice.builder().applyMutation(publicWorkforceTaskPrice).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String workteamArn;

        private UiConfig uiConfig;

        private String preHumanTaskLambdaArn;

        private List<String> taskKeywords = DefaultSdkAutoConstructList.getInstance();

        private String taskTitle;

        private String taskDescription;

        private Integer numberOfHumanWorkersPerDataObject;

        private Integer taskTimeLimitInSeconds;

        private Integer taskAvailabilityLifetimeInSeconds;

        private Integer maxConcurrentTaskCount;

        private AnnotationConsolidationConfig annotationConsolidationConfig;

        private PublicWorkforceTaskPrice publicWorkforceTaskPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(HumanTaskConfig model) {
            workteamArn(model.workteamArn);
            uiConfig(model.uiConfig);
            preHumanTaskLambdaArn(model.preHumanTaskLambdaArn);
            taskKeywords(model.taskKeywords);
            taskTitle(model.taskTitle);
            taskDescription(model.taskDescription);
            numberOfHumanWorkersPerDataObject(model.numberOfHumanWorkersPerDataObject);
            taskTimeLimitInSeconds(model.taskTimeLimitInSeconds);
            taskAvailabilityLifetimeInSeconds(model.taskAvailabilityLifetimeInSeconds);
            maxConcurrentTaskCount(model.maxConcurrentTaskCount);
            annotationConsolidationConfig(model.annotationConsolidationConfig);
            publicWorkforceTaskPrice(model.publicWorkforceTaskPrice);
        }

        public final String getWorkteamArn() {
            return workteamArn;
        }

        @Override
        public final Builder workteamArn(String workteamArn) {
            this.workteamArn = workteamArn;
            return this;
        }

        public final void setWorkteamArn(String workteamArn) {
            this.workteamArn = workteamArn;
        }

        public final UiConfig.Builder getUiConfig() {
            return uiConfig != null ? uiConfig.toBuilder() : null;
        }

        @Override
        public final Builder uiConfig(UiConfig uiConfig) {
            this.uiConfig = uiConfig;
            return this;
        }

        public final void setUiConfig(UiConfig.BuilderImpl uiConfig) {
            this.uiConfig = uiConfig != null ? uiConfig.build() : null;
        }

        public final String getPreHumanTaskLambdaArn() {
            return preHumanTaskLambdaArn;
        }

        @Override
        public final Builder preHumanTaskLambdaArn(String preHumanTaskLambdaArn) {
            this.preHumanTaskLambdaArn = preHumanTaskLambdaArn;
            return this;
        }

        public final void setPreHumanTaskLambdaArn(String preHumanTaskLambdaArn) {
            this.preHumanTaskLambdaArn = preHumanTaskLambdaArn;
        }

        public final Collection<String> getTaskKeywords() {
            return taskKeywords;
        }

        @Override
        public final Builder taskKeywords(Collection<String> taskKeywords) {
            this.taskKeywords = TaskKeywordsCopier.copy(taskKeywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskKeywords(String... taskKeywords) {
            taskKeywords(Arrays.asList(taskKeywords));
            return this;
        }

        public final void setTaskKeywords(Collection<String> taskKeywords) {
            this.taskKeywords = TaskKeywordsCopier.copy(taskKeywords);
        }

        public final String getTaskTitle() {
            return taskTitle;
        }

        @Override
        public final Builder taskTitle(String taskTitle) {
            this.taskTitle = taskTitle;
            return this;
        }

        public final void setTaskTitle(String taskTitle) {
            this.taskTitle = taskTitle;
        }

        public final String getTaskDescription() {
            return taskDescription;
        }

        @Override
        public final Builder taskDescription(String taskDescription) {
            this.taskDescription = taskDescription;
            return this;
        }

        public final void setTaskDescription(String taskDescription) {
            this.taskDescription = taskDescription;
        }

        public final Integer getNumberOfHumanWorkersPerDataObject() {
            return numberOfHumanWorkersPerDataObject;
        }

        @Override
        public final Builder numberOfHumanWorkersPerDataObject(Integer numberOfHumanWorkersPerDataObject) {
            this.numberOfHumanWorkersPerDataObject = numberOfHumanWorkersPerDataObject;
            return this;
        }

        public final void setNumberOfHumanWorkersPerDataObject(Integer numberOfHumanWorkersPerDataObject) {
            this.numberOfHumanWorkersPerDataObject = numberOfHumanWorkersPerDataObject;
        }

        public final Integer getTaskTimeLimitInSeconds() {
            return taskTimeLimitInSeconds;
        }

        @Override
        public final Builder taskTimeLimitInSeconds(Integer taskTimeLimitInSeconds) {
            this.taskTimeLimitInSeconds = taskTimeLimitInSeconds;
            return this;
        }

        public final void setTaskTimeLimitInSeconds(Integer taskTimeLimitInSeconds) {
            this.taskTimeLimitInSeconds = taskTimeLimitInSeconds;
        }

        public final Integer getTaskAvailabilityLifetimeInSeconds() {
            return taskAvailabilityLifetimeInSeconds;
        }

        @Override
        public final Builder taskAvailabilityLifetimeInSeconds(Integer taskAvailabilityLifetimeInSeconds) {
            this.taskAvailabilityLifetimeInSeconds = taskAvailabilityLifetimeInSeconds;
            return this;
        }

        public final void setTaskAvailabilityLifetimeInSeconds(Integer taskAvailabilityLifetimeInSeconds) {
            this.taskAvailabilityLifetimeInSeconds = taskAvailabilityLifetimeInSeconds;
        }

        public final Integer getMaxConcurrentTaskCount() {
            return maxConcurrentTaskCount;
        }

        @Override
        public final Builder maxConcurrentTaskCount(Integer maxConcurrentTaskCount) {
            this.maxConcurrentTaskCount = maxConcurrentTaskCount;
            return this;
        }

        public final void setMaxConcurrentTaskCount(Integer maxConcurrentTaskCount) {
            this.maxConcurrentTaskCount = maxConcurrentTaskCount;
        }

        public final AnnotationConsolidationConfig.Builder getAnnotationConsolidationConfig() {
            return annotationConsolidationConfig != null ? annotationConsolidationConfig.toBuilder() : null;
        }

        @Override
        public final Builder annotationConsolidationConfig(AnnotationConsolidationConfig annotationConsolidationConfig) {
            this.annotationConsolidationConfig = annotationConsolidationConfig;
            return this;
        }

        public final void setAnnotationConsolidationConfig(AnnotationConsolidationConfig.BuilderImpl annotationConsolidationConfig) {
            this.annotationConsolidationConfig = annotationConsolidationConfig != null ? annotationConsolidationConfig.build()
                    : null;
        }

        public final PublicWorkforceTaskPrice.Builder getPublicWorkforceTaskPrice() {
            return publicWorkforceTaskPrice != null ? publicWorkforceTaskPrice.toBuilder() : null;
        }

        @Override
        public final Builder publicWorkforceTaskPrice(PublicWorkforceTaskPrice publicWorkforceTaskPrice) {
            this.publicWorkforceTaskPrice = publicWorkforceTaskPrice;
            return this;
        }

        public final void setPublicWorkforceTaskPrice(PublicWorkforceTaskPrice.BuilderImpl publicWorkforceTaskPrice) {
            this.publicWorkforceTaskPrice = publicWorkforceTaskPrice != null ? publicWorkforceTaskPrice.build() : null;
        }

        @Override
        public HumanTaskConfig build() {
            return new HumanTaskConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
